/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mtr.BlockEntityTypes;
import mtr.block.BlockTrainSensorBase;
import mtr.mappings.BlockEntityMapper;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class BlockTrainAnnouncer
extends BlockTrainSensorBase {
    @Override
    public BlockEntityMapper createBlockEntity(class_2338 pos, class_2680 state) {
        return new TileEntityTrainAnnouncer(pos, state);
    }

    public static class TileEntityTrainAnnouncer
    extends BlockTrainSensorBase.TileEntityTrainSensorBase {
        private String message = "";
        private class_2960 soundId;
        private final Map<class_1657, Long> lastAnnouncedMillis = new HashMap<class_1657, Long>();
        private static final int ANNOUNCE_COOL_DOWN_MILLIS = 20000;
        private static final String KEY_MESSAGE = "message";
        private static final String KEY_SOUND_ID = "sound_id";

        public TileEntityTrainAnnouncer(class_2338 pos, class_2680 state) {
            super(BlockEntityTypes.TRAIN_ANNOUNCER_TILE_ENTITY.get(), pos, state);
        }

        @Override
        public void readCompoundTag(class_2487 compoundTag) {
            this.message = compoundTag.method_10558(KEY_MESSAGE);
            String soundIdString = compoundTag.method_10558(KEY_SOUND_ID);
            this.soundId = soundIdString.isEmpty() ? null : new class_2960(soundIdString);
            super.readCompoundTag(compoundTag);
        }

        @Override
        public void writeCompoundTag(class_2487 compoundTag) {
            compoundTag.method_10582(KEY_MESSAGE, this.message);
            compoundTag.method_10582(KEY_SOUND_ID, this.getSoundIdString());
            super.writeCompoundTag(compoundTag);
        }

        @Override
        public void setData(Set<Long> filterRouteIds, boolean stoppedOnly, boolean movingOnly, int number, String ... strings) {
            if (strings.length >= 2) {
                this.message = strings[0];
                String soundIdString = strings[1];
                this.soundId = soundIdString.isEmpty() ? null : new class_2960(soundIdString);
            }
            this.setData(filterRouteIds, stoppedOnly, movingOnly);
        }

        public String getMessage() {
            return this.message;
        }

        public String getSoundIdString() {
            return this.soundId == null ? "" : this.soundId.toString();
        }

        public void announce(class_1657 player) {
            long currentMillis = System.currentTimeMillis();
            if (!(player == null || this.lastAnnouncedMillis.containsKey(player) && currentMillis - this.lastAnnouncedMillis.get(player) < 20000L)) {
                this.lastAnnouncedMillis.put(player, System.currentTimeMillis());
                PacketTrainDataGuiServer.announceS2C((class_3222)player, this.message, this.soundId);
            }
        }
    }
}

