/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mtr.BlockEntityTypes;
import mtr.block.BlockTrainPoweredSensorBase;
import mtr.block.BlockTrainSensorBase;
import mtr.block.IBlock;
import mtr.data.RailwayData;
import mtr.data.ScheduleEntry;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.TickableMapper;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;

public class BlockTrainScheduleSensor
extends BlockTrainPoweredSensorBase {
    @Override
    public BlockEntityMapper createBlockEntity(class_2338 pos, class_2680 state) {
        return new TileEntityTrainScheduleSensor(pos, state);
    }

    @Override
    public <T extends BlockEntityMapper> void tick(class_1937 world, class_2338 pos, T blockEntity) {
        TileEntityTrainScheduleSensor.tick(world, pos, blockEntity);
    }

    @Override
    public class_2591<? extends BlockEntityMapper> getType() {
        return BlockEntityTypes.TRAIN_SCHEDULE_SENSOR_TILE_ENTITY.get();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{POWERED});
    }

    public static class TileEntityTrainScheduleSensor
    extends BlockTrainSensorBase.TileEntityTrainSensorBase
    implements TickableMapper {
        private int seconds = 10;
        private static final String KEY_SECONDS = "seconds";

        public TileEntityTrainScheduleSensor(class_2338 pos, class_2680 state) {
            super(BlockEntityTypes.TRAIN_SCHEDULE_SENSOR_TILE_ENTITY.get(), pos, state);
        }

        @Override
        public void tick() {
            if (this.field_11863 != null) {
                TileEntityTrainScheduleSensor.tick(this.field_11863, this.field_11867, this);
            }
        }

        @Override
        public void readCompoundTag(class_2487 compoundTag) {
            this.seconds = compoundTag.method_10550(KEY_SECONDS);
            super.readCompoundTag(compoundTag);
        }

        @Override
        public void writeCompoundTag(class_2487 compoundTag) {
            compoundTag.method_10569(KEY_SECONDS, this.seconds);
            super.writeCompoundTag(compoundTag);
        }

        @Override
        public void setData(Set<Long> filterRouteIds, boolean stoppedOnly, boolean movingOnly, int number, String ... strings) {
            this.seconds = number;
            this.setData(filterRouteIds, stoppedOnly, movingOnly);
        }

        public int getSeconds() {
            return this.seconds;
        }

        public static <T extends BlockEntityMapper> void tick(class_1937 world, class_2338 pos, T blockEntity) {
            if (world != null && !world.field_9236) {
                boolean isActive;
                class_2680 state = world.method_8320(pos);
                class_2248 block = state.method_26204();
                boolean bl = isActive = (Integer)IBlock.getStatePropertySafe(state, BlockTrainPoweredSensorBase.POWERED) > 1 && world.method_8397().method_8674(pos, (Object)block);
                if (isActive || !(block instanceof BlockTrainScheduleSensor) || !(blockEntity instanceof TileEntityTrainScheduleSensor)) {
                    return;
                }
                RailwayData railwayData = RailwayData.getInstance(world);
                if (railwayData == null) {
                    return;
                }
                long platformId = RailwayData.getClosePlatformId(railwayData.platforms, railwayData.dataCache, pos, 4, 4, 0);
                if (platformId == 0L) {
                    return;
                }
                List<ScheduleEntry> schedules = railwayData.getSchedulesAtPlatform(platformId);
                if (schedules == null) {
                    return;
                }
                ArrayList scheduleList = new ArrayList();
                schedules.forEach(scheduleEntry -> {
                    if (((TileEntityTrainScheduleSensor)blockEntity).matchesFilter(scheduleEntry.routeId, -1.0f)) {
                        scheduleList.add(scheduleEntry);
                    }
                });
                if (!scheduleList.isEmpty()) {
                    Collections.sort(scheduleList);
                    if ((((ScheduleEntry)scheduleList.get((int)0)).arrivalMillis - System.currentTimeMillis()) / 1000L == (long)((TileEntityTrainScheduleSensor)blockEntity).seconds) {
                        ((BlockTrainScheduleSensor)block).power(world, state, pos);
                    }
                }
            }
        }
    }
}

