/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mtr.block.IBlock;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.BlockMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public abstract class BlockTrainSensorBase
extends BlockMapper
implements EntityBlockMapper {
    public BlockTrainSensorBase() {
        super(class_4970.class_2251.method_9630((class_4970)class_2246.field_10360));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof TileEntityTrainSensorBase) {
                ((TileEntityTrainSensorBase)entity).syncData();
                PacketTrainDataGuiServer.openTrainSensorScreenS2C((class_3222)player, pos);
            }
        });
    }

    public static boolean matchesFilter(class_1937 world, class_2338 pos, long routeId, float speed) {
        class_2586 entity = world.method_8321(pos);
        return entity instanceof TileEntityTrainSensorBase && ((TileEntityTrainSensorBase)entity).matchesFilter(routeId, speed);
    }

    public static abstract class TileEntityTrainSensorBase
    extends BlockEntityClientSerializableMapper {
        private boolean stoppedOnly;
        private boolean movingOnly;
        private final Set<Long> filterRouteIds = new HashSet<Long>();
        private static final String KEY_ROUTE_IDS = "route_ids";
        private static final String KEY_STOPPED_ONLY = "stopped_only";
        private static final String KEY_MOVING_ONLY = "moving_only";

        public TileEntityTrainSensorBase(class_2591<?> type, class_2338 pos, class_2680 state) {
            super(type, pos, state);
        }

        @Override
        public void readCompoundTag(class_2487 compoundTag) {
            long[] routeIdsArray;
            for (long routeId : routeIdsArray = compoundTag.method_10565(KEY_ROUTE_IDS)) {
                this.filterRouteIds.add(routeId);
            }
            this.stoppedOnly = compoundTag.method_10577(KEY_STOPPED_ONLY);
            this.movingOnly = compoundTag.method_10577(KEY_MOVING_ONLY);
        }

        @Override
        public void writeCompoundTag(class_2487 compoundTag) {
            compoundTag.method_10538(KEY_ROUTE_IDS, new ArrayList<Long>(this.filterRouteIds));
            compoundTag.method_10556(KEY_STOPPED_ONLY, this.stoppedOnly);
            compoundTag.method_10556(KEY_MOVING_ONLY, this.movingOnly);
        }

        public boolean matchesFilter(long routeId, float speed) {
            if (!this.filterRouteIds.isEmpty() && !this.filterRouteIds.contains(routeId)) {
                return false;
            }
            return speed < 0.0f || !this.stoppedOnly && !this.movingOnly || this.stoppedOnly && speed == 0.0f || this.movingOnly && speed > 0.0f;
        }

        public Set<Long> getRouteIds() {
            return this.filterRouteIds;
        }

        public boolean getStoppedOnly() {
            return this.stoppedOnly;
        }

        public boolean getMovingOnly() {
            return this.movingOnly;
        }

        protected void setData(Set<Long> filterRouteIds, boolean stoppedOnly, boolean movingOnly) {
            this.filterRouteIds.clear();
            this.filterRouteIds.addAll(filterRouteIds);
            this.stoppedOnly = stoppedOnly;
            this.movingOnly = movingOnly;
            this.method_5431();
            this.syncData();
        }

        public abstract void setData(Set<Long> var1, boolean var2, boolean var3, int var4, String ... var5);
    }
}

