/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.function.Consumer;
import mtr.Items;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3542;

public interface IBlock {
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    public static final class_2754<EnumThird> THIRD = class_2754.method_11850((String)"third", EnumThird.class);
    public static final class_2754<EnumSide> SIDE_EXTENDED = class_2754.method_11850((String)"side", EnumSide.class);
    public static final class_2754<EnumSide> SIDE = class_2754.method_11848((String)"side", EnumSide.class, side -> side != EnumSide.MIDDLE && side != EnumSide.SINGLE);

    default public <T extends Comparable<T>> void propagate(class_1937 world, class_2338 pos, class_2350 direction, class_2769<T> property, int maxBlocksAway) {
        Object originalPropertyValue = IBlock.getStatePropertySafe((class_1922)world, pos, property);
        this.propagate(world, pos, direction, (class_2338 offsetPos) -> world.method_8501(offsetPos, (class_2680)world.method_8320(offsetPos).method_11657(property, originalPropertyValue)), maxBlocksAway);
    }

    default public void propagate(class_1937 world, class_2338 pos, class_2350 direction, Consumer<class_2338> callback, int maxBlocksAway) {
        for (int i = 1; i <= maxBlocksAway; ++i) {
            class_2338 offsetPos = pos.method_10079(direction, i);
            if (this != world.method_8320(offsetPos).method_26204()) continue;
            callback.accept(offsetPos);
            this.propagate(world, offsetPos, direction, callback, maxBlocksAway);
            return;
        }
    }

    public static class_1269 checkHoldingBrush(class_1937 world, class_1657 player, Runnable callbackBrush, Runnable callbackNoBrush) {
        return IBlock.checkHoldingItem(world, player, item -> callbackBrush.run(), callbackNoBrush, Items.BRUSH.get());
    }

    public static class_1269 checkHoldingItem(class_1937 world, class_1657 player, Consumer<class_1792> callbackItem, Runnable callbackNoItem, class_1792 ... items) {
        class_1792 holdingItem = null;
        for (class_1792 item : items) {
            if (!player.method_24518(item)) continue;
            holdingItem = item;
            break;
        }
        if (holdingItem != null) {
            if (!world.field_9236) {
                callbackItem.accept(holdingItem);
            }
            return class_1269.field_5812;
        }
        if (callbackNoItem == null) {
            return class_1269.field_5814;
        }
        if (!world.field_9236) {
            callbackNoItem.run();
            return class_1269.field_21466;
        }
        return class_1269.field_5812;
    }

    public static class_1269 checkHoldingBrush(class_1937 world, class_1657 player, Runnable callbackBrush) {
        return IBlock.checkHoldingBrush(world, player, callbackBrush, null);
    }

    public static class_265 getVoxelShapeByDirection(double x1, double y1, double z1, double x2, double y2, double z2, class_2350 facing) {
        switch (facing) {
            case field_11043: {
                return class_2248.method_9541((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            }
            case field_11034: {
                return class_2248.method_9541((double)(16.0 - z2), (double)y1, (double)x1, (double)(16.0 - z1), (double)y2, (double)x2);
            }
            case field_11035: {
                return class_2248.method_9541((double)(16.0 - x2), (double)y1, (double)(16.0 - z2), (double)(16.0 - x1), (double)y2, (double)(16.0 - z1));
            }
            case field_11039: {
                return class_2248.method_9541((double)z1, (double)y1, (double)(16.0 - x2), (double)z2, (double)y2, (double)(16.0 - x1));
            }
        }
        return class_259.method_1077();
    }

    public static boolean isReplaceable(class_1750 ctx, class_2350 direction, int totalLength) {
        for (int i = 0; i < totalLength; ++i) {
            if (ctx.method_8045().method_8320(ctx.method_8037().method_10079(direction, i)).method_26166(ctx)) continue;
            return false;
        }
        return true;
    }

    public static void onBreakCreative(class_1937 world, class_1657 player, class_2338 pos) {
        if (!world.field_9236 && (player == null || player.method_7337())) {
            world.method_8652(pos, class_2246.field_10124.method_9564(), 35);
            class_2680 state = world.method_8320(pos);
            world.method_8444(player, 2001, pos, class_2248.method_9507((class_2680)state));
        }
    }

    public static class_2350 getSideDirection(class_2680 state) {
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe(state, class_2383.field_11177);
        return IBlock.getStatePropertySafe(state, SIDE) == EnumSide.LEFT ? facing.method_10170() : facing.method_10160();
    }

    public static <T extends Comparable<T>> T getStatePropertySafe(class_1922 world, class_2338 pos, class_2769<T> property) {
        return IBlock.getStatePropertySafe(world.method_8320(pos), property);
    }

    public static <T extends Comparable<T>> T getStatePropertySafe(class_2680 state, class_2769<T> property) {
        Comparable defaultProperty = (Comparable)property.method_11898().toArray()[0];
        try {
            return (T)(state.method_28498(property) ? state.method_11654(property) : defaultProperty);
        }
        catch (Exception exception) {
            return (T)defaultProperty;
        }
    }

    public static enum EnumSide implements class_3542
    {
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle"),
        SINGLE("single");

        private final String name;

        private EnumSide(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }

    public static enum EnumThird implements class_3542
    {
        LOWER("lower"),
        MIDDLE("middle"),
        UPPER("upper");

        private final String name;

        private EnumThird(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

