/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.mojang.text2speech.Narrator;
import java.util.ArrayList;
import mtr.client.Config;
import mtr.data.IGui;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import net.minecraft.class_765;

public interface IDrawing {
    public static void drawStringWithFont(class_4587 matrices, class_327 textRenderer, class_4597.class_4598 immediate, String text, float x, float y, int light) {
        IDrawing.drawStringWithFont(matrices, textRenderer, immediate, text, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, x, y, -1.0f, -1.0f, 1.0f, -1, true, light, null);
    }

    public static void drawStringWithFont(class_4587 matrices, class_327 textRenderer, class_4597.class_4598 immediate, String text, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, float x, float y, float maxWidth, float maxHeight, float scale, int textColor, boolean shadow, int light, DrawingCallback drawingCallback) {
        IDrawing.drawStringWithFont(matrices, textRenderer, immediate, text, horizontalAlignment, verticalAlignment, horizontalAlignment, x, y, maxWidth, maxHeight, scale, textColor, shadow, light, drawingCallback);
    }

    public static void drawStringWithFont(class_4587 matrices, class_327 textRenderer, class_4597.class_4598 immediate, String text, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, IGui.HorizontalAlignment xAlignment, float x, float y, float maxWidth, float maxHeight, float scale, int textColor, boolean shadow, int light, DrawingCallback drawingCallback) {
        IDrawing.drawStringWithFont(matrices, textRenderer, immediate, text, horizontalAlignment, verticalAlignment, xAlignment, x, y, maxWidth, maxHeight, scale, textColor, textColor, 2.0f, shadow, light, drawingCallback);
    }

    public static void drawStringWithFont(class_4587 matrices, class_327 textRenderer, class_4597.class_4598 immediate, String text, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, IGui.HorizontalAlignment xAlignment, float x, float y, float maxWidth, float maxHeight, float scale, int textColorCjk, int textColor, float fontSizeRatio, boolean shadow, int light, DrawingCallback drawingCallback) {
        float scaleX;
        float totalWidthScaled;
        boolean isCJK;
        class_2583 style;
        class_2583 class_25832 = style = Config.useMTRFont() ? class_2583.field_24360.method_27704(new class_2960("mtr", "mtr")) : class_2583.field_24360;
        while (text.contains("||")) {
            text = text.replace("||", "|");
        }
        String[] stringSplit = text.split("\\|");
        ArrayList<Boolean> isCJKList = new ArrayList<Boolean>();
        ArrayList<class_5481> orderedTexts = new ArrayList<class_5481>();
        int totalHeight = 0;
        int totalWidth = 0;
        for (String stringSplitPart : stringSplit) {
            isCJK = IGui.isCjk(stringSplitPart);
            isCJKList.add(isCJK);
            class_5481 orderedText = Text.literal(stringSplitPart).method_10862(style).method_30937();
            orderedTexts.add(orderedText);
            totalHeight = (int)((float)totalHeight + 10.0f * (isCJK ? fontSizeRatio : 1.0f));
            int width = (int)Math.ceil((float)textRenderer.method_30880(orderedText) * (isCJK ? fontSizeRatio : 1.0f));
            if (width <= totalWidth) continue;
            totalWidth = width;
        }
        if (maxHeight >= 0.0f && (float)totalHeight / scale > maxHeight) {
            scale = (float)totalHeight / maxHeight;
        }
        matrices.method_22903();
        if (maxWidth >= 0.0f && (float)totalWidth > maxWidth * scale) {
            totalWidthScaled = maxWidth * scale;
            scaleX = (float)totalWidth / maxWidth;
        } else {
            totalWidthScaled = totalWidth;
            scaleX = scale;
        }
        matrices.method_22905(1.0f / scaleX, 1.0f / scale, 1.0f / scale);
        float offset = verticalAlignment.getOffset(y * scale, totalHeight);
        for (int i = 0; i < orderedTexts.size(); ++i) {
            float extraScale;
            isCJK = (Boolean)isCJKList.get(i);
            float f = extraScale = isCJK ? fontSizeRatio : 1.0f;
            if (isCJK) {
                matrices.method_22903();
                matrices.method_22905(extraScale, extraScale, 1.0f);
            }
            float xOffset = horizontalAlignment.getOffset(xAlignment.getOffset(x * scaleX, totalWidth), (float)textRenderer.method_30880((class_5481)orderedTexts.get(i)) * extraScale - (float)totalWidth);
            float shade = light == 0xF000F0 ? 1.0f : Math.min((float)class_765.method_24186((int)light) / 16.0f * 0.1f + 0.7f, 1.0f);
            int a = (isCJK ? textColorCjk : textColor) >> 24 & 0xFF;
            int r = (int)((float)((isCJK ? textColorCjk : textColor) >> 16 & 0xFF) * shade);
            int g = (int)((float)((isCJK ? textColorCjk : textColor) >> 8 & 0xFF) * shade);
            int b = (int)((float)((isCJK ? textColorCjk : textColor) & 0xFF) * shade);
            if (immediate != null) {
                UtilitiesClient.drawInBatch(textRenderer, (class_5481)orderedTexts.get(i), xOffset / extraScale, offset / extraScale, (a << 24) + (r << 16) + (g << 8) + b, shadow, matrices.method_23760().method_23761(), (class_4597)immediate, 0, light);
            }
            if (isCJK) {
                matrices.method_22909();
            }
            offset += 10.0f * extraScale;
        }
        matrices.method_22909();
        if (drawingCallback != null) {
            float x1 = xAlignment.getOffset(x, totalWidthScaled / scale);
            float y1 = verticalAlignment.getOffset(y, (float)totalHeight / scale);
            drawingCallback.drawingCallback(x1, y1, x1 + totalWidthScaled / scale, y1 + (float)totalHeight / scale);
        }
    }

    public static void drawLine(class_4587 matrices, class_4597 vertexConsumers, float x1, float y1, float z1, float x2, float y2, float z2, int r, int g, int b) {
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23594());
        class_4587.class_4665 pose = matrices.method_23760();
        vertexConsumer.method_22918(pose.method_23761(), x1, y1, z1).method_1336(r, g, b, 255).method_23763(pose.method_23762(), 0.0f, 1.0f, 0.0f).method_1344();
        vertexConsumer.method_22918(pose.method_23761(), x2, y2, z2).method_1336(r, g, b, 255).method_23763(pose.method_23762(), 0.0f, 1.0f, 0.0f).method_1344();
    }

    public static void drawRectangle(class_4588 vertexConsumer, double x1, double y1, double x2, double y2, int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        if (a == 0) {
            return;
        }
        vertexConsumer.method_22912(x1, y1, 0.0).method_1336(r, g, b, a).method_1344();
        vertexConsumer.method_22912(x1, y2, 0.0).method_1336(r, g, b, a).method_1344();
        vertexConsumer.method_22912(x2, y2, 0.0).method_1336(r, g, b, a).method_1344();
        vertexConsumer.method_22912(x2, y1, 0.0).method_1336(r, g, b, a).method_1344();
    }

    public static void drawTexture(class_4587 matrices, class_4588 vertexConsumer, float x1, float y1, float z1, float x2, float y2, float z2, class_2350 facing, int color, int light) {
        IDrawing.drawTexture(matrices, vertexConsumer, x1, y1, z1, x2, y2, z2, 0.0f, 0.0f, 1.0f, 1.0f, facing, color, light);
    }

    public static void drawTexture(class_4587 matrices, class_4588 vertexConsumer, float x, float y, float width, float height, class_2350 facing, int light) {
        IDrawing.drawTexture(matrices, vertexConsumer, x, y, 0.0f, x + width, y + height, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facing, -1, light);
    }

    public static void drawTexture(class_4587 matrices, class_4588 vertexConsumer, float x, float y, float width, float height, float u1, float v1, float u2, float v2, class_2350 facing, int color, int light) {
        IDrawing.drawTexture(matrices, vertexConsumer, x, y, 0.0f, x + width, y + height, 0.0f, u1, v1, u2, v2, facing, color, light);
    }

    public static void drawTexture(class_4587 matrices, class_4588 vertexConsumer, float x1, float y1, float z1, float x2, float y2, float z2, float u1, float v1, float u2, float v2, class_2350 facing, int color, int light) {
        IDrawing.drawTexture(matrices, vertexConsumer, x1, y2, z1, x2, y2, z2, x2, y1, z2, x1, y1, z1, u1, v1, u2, v2, facing, color, light);
    }

    public static void drawTexture(class_4587 matrices, class_4588 vertexConsumer, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float u1, float v1, float u2, float v2, class_2350 facing, int color, int light) {
        class_2382 vec3i = facing.method_10163();
        class_4587.class_4665 pose = matrices.method_23760();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        if (a == 0) {
            return;
        }
        vertexConsumer.method_22918(pose.method_23761(), x1, y1, z1).method_1336(r, g, b, a).method_22913(u1, v2).method_22922(class_4608.field_21444).method_22916(light).method_23763(pose.method_23762(), (float)vec3i.method_10263(), (float)vec3i.method_10264(), (float)vec3i.method_10260()).method_1344();
        vertexConsumer.method_22918(pose.method_23761(), x2, y2, z2).method_1336(r, g, b, a).method_22913(u2, v2).method_22922(class_4608.field_21444).method_22916(light).method_23763(pose.method_23762(), (float)vec3i.method_10263(), (float)vec3i.method_10264(), (float)vec3i.method_10260()).method_1344();
        vertexConsumer.method_22918(pose.method_23761(), x3, y3, z3).method_1336(r, g, b, a).method_22913(u2, v1).method_22922(class_4608.field_21444).method_22916(light).method_23763(pose.method_23762(), (float)vec3i.method_10263(), (float)vec3i.method_10264(), (float)vec3i.method_10260()).method_1344();
        vertexConsumer.method_22918(pose.method_23761(), x4, y4, z4).method_1336(r, g, b, a).method_22913(u1, v1).method_22922(class_4608.field_21444).method_22916(light).method_23763(pose.method_23762(), (float)vec3i.method_10263(), (float)vec3i.method_10264(), (float)vec3i.method_10260()).method_1344();
    }

    public static void setPositionAndWidth(class_339 widget, int x, int y, int widgetWidth) {
        UtilitiesClient.setWidgetX(widget, x);
        UtilitiesClient.setWidgetY(widget, y);
        widget.method_25358(class_3532.method_15340((int)widgetWidth, (int)0, (int)(380 - (widget instanceof WidgetBetterTextField ? 4 : 0))));
    }

    public static void narrateOrAnnounce(String message) {
        String newMessage = IGui.formatStationName(message).replace("  ", " ");
        if (!newMessage.isEmpty()) {
            class_746 player;
            if (Config.useTTSAnnouncements()) {
                Narrator.getNarrator().say(newMessage, true);
            }
            if (Config.showAnnouncementMessages() && (player = class_310.method_1551().field_1724) != null) {
                player.method_7353((class_2561)Text.literal(newMessage), false);
            }
        }
    }

    @FunctionalInterface
    public static interface DrawingCallback {
        public void drawingCallback(float var1, float var2, float var3, float var4);
    }
}

