/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import mtr.MTRClient;
import mtr.client.ClientCache;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.render.MoreRenderLayers;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class ScrollingText
implements IGui {
    private float ticksOffset;
    private ClientCache.DynamicResource dynamicResource;
    private class_4588 vertexConsumer;
    private final float availableWidth;
    private final float availableHeight;
    private final int scrollSpeed;
    private final boolean isFullPixel;

    public ScrollingText(float availableWidth, float availableHeight, int scrollSpeed, boolean isFullPixel) {
        this.availableWidth = availableWidth;
        this.availableHeight = availableHeight;
        this.scrollSpeed = scrollSpeed;
        this.isFullPixel = isFullPixel;
    }

    public void changeImage(ClientCache.DynamicResource dynamicResource) {
        if (this.dynamicResource != dynamicResource) {
            this.dynamicResource = dynamicResource;
            this.ticksOffset = MTRClient.getGameTick();
        }
    }

    public void setVertexConsumer(class_4597 vertexConsumers) {
        this.vertexConsumer = this.dynamicResource == null ? null : vertexConsumers.getBuffer(MoreRenderLayers.getLight(this.dynamicResource.resourceLocation, true));
    }

    public void scrollText(class_4587 matrices) {
        if (this.vertexConsumer != null) {
            int pixelScale = this.isFullPixel ? 1 : 4;
            float scale = this.availableHeight / (float)this.dynamicResource.height;
            int widthSteps = (int)Math.floor(this.availableWidth / scale / (float)pixelScale);
            int imageSteps = this.dynamicResource.width / pixelScale;
            int totalSteps = widthSteps + imageSteps;
            int step = Math.round((MTRClient.getGameTick() - this.ticksOffset) * (float)this.scrollSpeed) % totalSteps;
            float width = Math.min(Math.min(this.availableWidth, (float)this.dynamicResource.width * scale), Math.min((float)(step * pixelScale) * scale, (float)((totalSteps - step) * pixelScale) * scale));
            IDrawing.drawTexture(matrices, this.vertexConsumer, (float)Math.max(widthSteps - step, 0) * scale * (float)pixelScale, 0.0f, width, this.availableHeight, Math.max((float)(step - widthSteps) / (float)imageSteps, 0.0f), 0.0f, Math.min((float)step / (float)imageSteps, 1.0f), 1.0f, class_2350.field_11036, -1, 0xF000F0);
        }
    }
}

