/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import mtr.data.AreaBase;
import mtr.data.Depot;
import mtr.data.LiftServer;
import mtr.data.NameColorDataBase;
import mtr.data.Platform;
import mtr.data.RailwayDataRouteFinderModule;
import mtr.data.Route;
import mtr.data.SavedRailBase;
import mtr.data.Siding;
import mtr.data.Station;
import net.minecraft.class_2338;

public class DataCache {
    private long lastRefreshedTime;
    public final Map<Long, Station> stationIdMap = new HashMap<Long, Station>();
    public final Map<Long, Platform> platformIdMap = new HashMap<Long, Platform>();
    public final Map<Long, Siding> sidingIdMap = new HashMap<Long, Siding>();
    public final Map<Long, Route> routeIdMap = new HashMap<Long, Route>();
    public final Map<Long, Depot> depotIdMap = new HashMap<Long, Depot>();
    public final Map<Long, LiftServer> liftsServerIdMap = new HashMap<Long, LiftServer>();
    public final Map<Long, Station> platformIdToStation = new HashMap<Long, Station>();
    public final Map<Long, Depot> sidingIdToDepot = new HashMap<Long, Depot>();
    public final Map<Long, Depot> routeIdToOneDepot = new HashMap<Long, Depot>();
    public final Map<Station, Set<Station>> stationIdToConnectingStations = new HashMap<Station, Set<Station>>();
    public final Map<class_2338, Station> blockPosToStation = new HashMap<class_2338, Station>();
    public final Long2LongOpenHashMap blockPosToPlatformId = new Long2LongOpenHashMap();
    public final Long2ObjectOpenHashMap<Long2ObjectOpenHashMap<RailwayDataRouteFinderModule.ConnectionDetails>> platformConnections = new Long2ObjectOpenHashMap();
    protected final Set<Station> stations;
    protected final Set<Platform> platforms;
    protected final Set<Siding> sidings;
    protected final Set<Route> routes;
    protected final Set<Depot> depots;
    private final Set<LiftServer> liftsServer;

    public DataCache(Set<Station> stations, Set<Platform> platforms, Set<Siding> sidings, Set<Route> routes, Set<Depot> depots, Set<LiftServer> lifts) {
        this.stations = stations;
        this.platforms = platforms;
        this.sidings = sidings;
        this.routes = routes;
        this.depots = depots;
        this.liftsServer = lifts;
    }

    public final void sync() {
        try {
            DataCache.mapIds(this.stationIdMap, this.stations);
            DataCache.mapIds(this.platformIdMap, this.platforms);
            DataCache.mapIds(this.sidingIdMap, this.sidings);
            DataCache.mapIds(this.routeIdMap, this.routes);
            DataCache.mapIds(this.depotIdMap, this.depots);
            DataCache.mapIds(this.liftsServerIdMap, this.liftsServer);
            this.routeIdToOneDepot.clear();
            this.routes.forEach(route -> route.platformIds.removeIf(platformId -> !this.platformIdMap.containsKey(platformId.platformId)));
            this.depots.forEach(depot -> {
                depot.routeIds.removeIf(routeId -> this.routeIdMap.get(routeId) == null);
                depot.routeIds.forEach(routeId -> this.routeIdToOneDepot.put((Long)routeId, (Depot)depot));
            });
            this.platformConnections.clear();
            this.routes.forEach(route -> {
                Depot depot = this.routeIdToOneDepot.get(route.id);
                if (depot != null) {
                    for (int i = 1; i < route.platformIds.size(); ++i) {
                        float duration;
                        long prevPlatformId = route.platformIds.get((int)(i - 1)).platformId;
                        long thisPlatformId = route.platformIds.get((int)i).platformId;
                        Platform prevPlatform = this.platformIdMap.get(prevPlatformId);
                        Platform thisPlatform = this.platformIdMap.get(thisPlatformId);
                        if (prevPlatform == null || thisPlatform == null || !((duration = DataCache.tryGet(depot.platformTimes, prevPlatformId, thisPlatformId, Float.valueOf(0.0f)).floatValue()) > 0.0f)) continue;
                        long thisPlatformPosLong = thisPlatform.getMidPos().method_10063();
                        DataCache.put(this.platformConnections, prevPlatform.getMidPos().method_10063(), thisPlatformPosLong, oldValue -> {
                            int newValue = Math.round(duration);
                            if (oldValue == null) {
                                RailwayDataRouteFinderModule.ConnectionDetails connectionDetails = new RailwayDataRouteFinderModule.ConnectionDetails(prevPlatform);
                                connectionDetails.addDurationInfo(route.id, newValue);
                                return connectionDetails;
                            }
                            oldValue.addDurationInfo(route.id, newValue);
                            return oldValue;
                        });
                        if (i != route.platformIds.size() - 1 || this.platformConnections.containsKey(thisPlatformPosLong)) continue;
                        this.platformConnections.put(thisPlatformPosLong, (Object)new Long2ObjectOpenHashMap());
                    }
                }
            });
            this.stationIdToConnectingStations.clear();
            this.stations.forEach(station1 -> {
                this.stationIdToConnectingStations.put((Station)station1, new HashSet());
                this.stations.forEach(station2 -> {
                    if (station1 != station2 && station1.intersecting((AreaBase)station2)) {
                        this.stationIdToConnectingStations.get(station1).add((Station)station2);
                    }
                });
            });
            DataCache.mapSavedRailIdToStation(this.platformIdToStation, this.platforms, this.stations);
            DataCache.mapSavedRailIdToStation(this.sidingIdToDepot, this.sidings, this.depots);
            this.blockPosToPlatformId.clear();
            this.blockPosToStation.clear();
            this.syncAdditional();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lastRefreshedTime = System.currentTimeMillis();
    }

    public boolean needsRefresh(long cachedRefreshTime) {
        return this.lastRefreshedTime > cachedRefreshTime;
    }

    protected void syncAdditional() {
    }

    public static <T, U> U tryGet(Map<T, Map<T, U>> map, T key1, T key2, U defaultValue) {
        U result = DataCache.tryGet(map, key1, key2);
        return result == null ? defaultValue : result;
    }

    public static <T, U> U tryGet(Map<T, Map<T, U>> map, T key1, T key2) {
        Map<T, U> innerMap = map.get(key1);
        if (innerMap == null) {
            return null;
        }
        return innerMap.get(key2);
    }

    public static <U> U tryGet(Long2ObjectOpenHashMap<Long2ObjectOpenHashMap<U>> map, long key1, long key2) {
        Long2ObjectOpenHashMap innerMap = (Long2ObjectOpenHashMap)map.get(key1);
        if (innerMap == null) {
            return null;
        }
        return (U)innerMap.get(key2);
    }

    public static int tryGet2(Long2ObjectOpenHashMap<Long2IntOpenHashMap> map, long key1, long key2, int defaultValue) {
        Long2IntOpenHashMap innerMap = (Long2IntOpenHashMap)map.get(key1);
        if (innerMap == null) {
            return defaultValue;
        }
        return innerMap.getOrDefault(key2, defaultValue);
    }

    public static <U> void put(Long2ObjectOpenHashMap<Long2ObjectOpenHashMap<U>> map, long key1, long key2, Function<U, U> putValue) {
        Long2ObjectOpenHashMap newInnerMap;
        Long2ObjectOpenHashMap innerMap = (Long2ObjectOpenHashMap)map.get(key1);
        if (innerMap == null) {
            newInnerMap = new Long2ObjectOpenHashMap();
            map.put(key1, (Object)newInnerMap);
        } else {
            newInnerMap = innerMap;
        }
        newInnerMap.put(key2, putValue.apply(newInnerMap.get(key2)));
    }

    public static void put2(Long2ObjectOpenHashMap<Long2IntOpenHashMap> map, long key1, long key2, Function<Integer, Integer> putValue) {
        Long2IntOpenHashMap newInnerMap;
        Long2IntOpenHashMap innerMap = (Long2IntOpenHashMap)map.get(key1);
        if (innerMap == null) {
            newInnerMap = new Long2IntOpenHashMap();
            map.put(key1, (Object)newInnerMap);
        } else {
            newInnerMap = innerMap;
        }
        newInnerMap.put(key2, putValue.apply(newInnerMap.get(key2)).intValue());
    }

    protected static <U extends NameColorDataBase> void mapIds(Map<Long, U> map, Set<U> source) {
        map.clear();
        source.forEach(data -> map.put(data.id, data));
    }

    private static <U extends SavedRailBase, V extends AreaBase> void mapSavedRailIdToStation(Map<Long, V> map, Set<U> savedRails, Set<V> areas) {
        map.clear();
        savedRails.forEach(savedRail -> {
            class_2338 pos = savedRail.getMidPos();
            for (AreaBase area : areas) {
                if (!area.isTransportMode(savedRail.transportMode) || !area.inArea(pos.method_10263(), pos.method_10260())) continue;
                map.put(savedRail.id, area);
                break;
            }
        });
    }
}

