/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import mtr.data.AreaBase;
import mtr.data.DataCache;
import mtr.data.IReducedSaveData;
import mtr.data.MessagePackHelper;
import mtr.data.Platform;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.SavedRailBase;
import mtr.data.Siding;
import mtr.data.TrainServer;
import mtr.data.TransportMode;
import mtr.packet.PacketTrainDataGuiServer;
import mtr.path.PathData;
import mtr.path.PathFinder;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.server.MinecraftServer;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;

public class Depot
extends AreaBase
implements IReducedSaveData {
    public int clientPathGenerationSuccessfulSegments;
    public long lastDeployedMillis;
    public boolean useRealTime;
    public boolean repeatInfinitely;
    public int cruisingAltitude = 256;
    private int deployIndex;
    private int departureOffset;
    private boolean isDirty = true;
    public final List<Long> routeIds = new ArrayList<Long>();
    public final Map<Long, Map<Long, Float>> platformTimes = new HashMap<Long, Map<Long, Float>>();
    public final List<Integer> departures = new ArrayList<Integer>();
    public final List<Integer> tempDepartures = new ArrayList<Integer>();
    private final int[] frequencies = new int[24];
    private final Map<Long, TrainServer> deployableSidings = new HashMap<Long, TrainServer>();
    public static final int HOURS_IN_DAY = 24;
    public static final int TRAIN_FREQUENCY_MULTIPLIER = 4;
    public static final int TICKS_PER_HOUR = 1000;
    public static final int MILLIS_PER_TICK = 50;
    public static final int MILLISECONDS_PER_DAY = 86400000;
    public static final int DEFAULT_CRUISING_ALTITUDE = 256;
    private static final int TICKS_PER_DAY = 24000;
    private static final int CONTINUOUS_MOVEMENT_FREQUENCY = 8000;
    private static final int THRESHOLD_ABOVE_MAX_BUILD_HEIGHT = 64;
    private static final String KEY_ROUTE_IDS = "route_ids";
    private static final String KEY_USE_REAL_TIME = "use_real_time";
    private static final String KEY_FREQUENCIES = "frequencies";
    private static final String KEY_DEPARTURES = "departures";
    private static final String KEY_LAST_DEPLOYED = "last_deployed";
    private static final String KEY_DEPLOY_INDEX = "deploy_index";
    private static final String KEY_REPEAT_INFINITELY = "repeat_infinitely";
    private static final String KEY_CRUISING_ALTITUDE = "cruising_altitude";

    public Depot(TransportMode transportMode) {
        super(transportMode);
    }

    public Depot(long id, TransportMode transportMode) {
        super(id, transportMode);
    }

    public Depot(Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        messagePackHelper.iterateArrayValue(KEY_ROUTE_IDS, routeId -> this.routeIds.add(routeId.asIntegerValue().asLong()));
        this.useRealTime = messagePackHelper.getBoolean(KEY_USE_REAL_TIME);
        try {
            ArrayValue frequenciesArray = map.get(KEY_FREQUENCIES).asArrayValue();
            for (int i = 0; i < 24; ++i) {
                this.frequencies[i] = frequenciesArray.get(i).asIntegerValue().asInt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        messagePackHelper.iterateArrayValue(KEY_DEPARTURES, departure -> this.departures.add(departure.asIntegerValue().asInt()));
        this.deployIndex = messagePackHelper.getInt(KEY_DEPLOY_INDEX);
        this.repeatInfinitely = messagePackHelper.getBoolean(KEY_REPEAT_INFINITELY);
        this.cruisingAltitude = messagePackHelper.getInt(KEY_CRUISING_ALTITUDE);
        this.lastDeployedMillis = System.currentTimeMillis() - messagePackHelper.getLong(KEY_LAST_DEPLOYED);
    }

    @Deprecated
    public Depot(class_2487 compoundTag) {
        super(compoundTag);
        long[] routeIdsArray;
        for (long routeId : routeIdsArray = compoundTag.method_10565(KEY_ROUTE_IDS)) {
            this.routeIds.add(routeId);
        }
        for (int i = 0; i < 24; ++i) {
            this.frequencies[i] = compoundTag.method_10550(KEY_FREQUENCIES + i);
        }
        this.lastDeployedMillis = System.currentTimeMillis() - compoundTag.method_10537(KEY_LAST_DEPLOYED);
        this.deployIndex = compoundTag.method_10550(KEY_DEPLOY_INDEX);
        this.repeatInfinitely = compoundTag.method_10577(KEY_REPEAT_INFINITELY);
        this.cruisingAltitude = compoundTag.method_10550(KEY_CRUISING_ALTITUDE);
    }

    public Depot(class_2540 packet) {
        super(packet);
        int i;
        int routeIdCount = packet.readInt();
        for (i = 0; i < routeIdCount; ++i) {
            this.routeIds.add(packet.readLong());
        }
        this.useRealTime = packet.readBoolean();
        for (i = 0; i < 24; ++i) {
            this.frequencies[i] = packet.readInt();
        }
        int departuresCount = packet.readInt();
        for (int i2 = 0; i2 < departuresCount; ++i2) {
            this.departures.add(packet.readInt());
        }
        this.lastDeployedMillis = packet.readLong();
        this.deployIndex = packet.readInt();
        this.repeatInfinitely = packet.readBoolean();
        this.cruisingAltitude = packet.readInt();
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        this.toReducedMessagePack(messagePacker);
        messagePacker.packString(KEY_DEPLOY_INDEX).packInt(this.deployIndex);
        messagePacker.packString(KEY_LAST_DEPLOYED).packLong(System.currentTimeMillis() - this.lastDeployedMillis);
    }

    @Override
    public void toReducedMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_ROUTE_IDS).packArrayHeader(this.routeIds.size());
        for (long routeId : this.routeIds) {
            messagePacker.packLong(routeId);
        }
        messagePacker.packString(KEY_USE_REAL_TIME).packBoolean(this.useRealTime);
        messagePacker.packString(KEY_REPEAT_INFINITELY).packBoolean(this.repeatInfinitely);
        messagePacker.packString(KEY_CRUISING_ALTITUDE).packInt(this.cruisingAltitude);
        messagePacker.packString(KEY_FREQUENCIES).packArrayHeader(24);
        for (int i = 0; i < 24; ++i) {
            messagePacker.packInt(this.frequencies[i]);
        }
        messagePacker.packString(KEY_DEPARTURES).packArrayHeader(this.departures.size());
        for (int departure : this.departures) {
            messagePacker.packInt(departure);
        }
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 7;
    }

    @Override
    public int reducedMessagePackLength() {
        return this.messagePackLength() - 2;
    }

    @Override
    public void writePacket(class_2540 packet) {
        super.writePacket(packet);
        packet.writeInt(this.routeIds.size());
        this.routeIds.forEach(arg_0 -> ((class_2540)packet).writeLong(arg_0));
        packet.writeBoolean(this.useRealTime);
        for (int frequency : this.frequencies) {
            packet.writeInt(frequency);
        }
        packet.writeInt(this.departures.size());
        this.departures.forEach(arg_0 -> ((class_2540)packet).writeInt(arg_0));
        packet.writeLong(this.lastDeployedMillis);
        packet.writeInt(this.deployIndex);
        packet.writeBoolean(this.repeatInfinitely);
        packet.writeInt(this.cruisingAltitude);
    }

    @Override
    protected boolean hasTransportMode() {
        return true;
    }

    @Override
    public void update(String key, class_2540 packet) {
        if (KEY_FREQUENCIES.equals(key)) {
            this.name = packet.method_10800(Short.MAX_VALUE);
            this.color = packet.readInt();
            this.useRealTime = packet.readBoolean();
            for (int i = 0; i < 24; ++i) {
                this.frequencies[i] = packet.readInt();
            }
            this.departures.clear();
            int departuresCount = packet.readInt();
            for (int i = 0; i < departuresCount; ++i) {
                this.departures.add(packet.readInt());
            }
            this.routeIds.clear();
            int routeIdCount = packet.readInt();
            for (int i = 0; i < routeIdCount; ++i) {
                this.routeIds.add(packet.readLong());
            }
            this.repeatInfinitely = packet.readBoolean();
            this.cruisingAltitude = packet.readInt();
        } else {
            super.update(key, packet);
        }
        this.isDirty = true;
    }

    public int getFrequency(int index) {
        if (index >= 0 && index < this.frequencies.length) {
            return this.frequencies[index];
        }
        return 0;
    }

    public void setFrequency(int newFrequency, int index) {
        if (index >= 0 && index < this.frequencies.length) {
            this.frequencies[index] = newFrequency;
        }
        this.isDirty = true;
    }

    public void setData(Consumer<class_2540> sendPacket) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.method_10814(this.transportMode.toString());
        packet.method_10814(KEY_FREQUENCIES);
        packet.method_10814(this.name);
        packet.writeInt(this.color);
        packet.writeBoolean(this.useRealTime);
        for (int frequency : this.frequencies) {
            packet.writeInt(frequency);
        }
        this.departures.replaceAll(departure -> departure % 86400000);
        this.departures.removeIf(departure -> departure % 1000 != 0);
        this.departures.sort(Integer::compareTo);
        packet.writeInt(this.departures.size());
        this.departures.forEach(arg_0 -> ((class_2540)packet).writeInt(arg_0));
        packet.writeInt(this.routeIds.size());
        this.routeIds.forEach(arg_0 -> ((class_2540)packet).writeLong(arg_0));
        packet.writeBoolean(this.repeatInfinitely);
        packet.writeInt(this.cruisingAltitude);
        sendPacket.accept(packet);
    }

    public void generateMainRoute(MinecraftServer minecraftServer, class_1937 world, DataCache dataCache, Map<class_2338, Map<class_2338, Rail>> rails, Set<Siding> sidings, Consumer<Thread> callback) {
        ArrayList platformsInRoute = new ArrayList();
        this.routeIds.forEach(routeId -> {
            Route route = dataCache.routeIdMap.get(routeId);
            if (route != null) {
                route.platformIds.forEach(platformId -> {
                    Platform platform = dataCache.platformIdMap.get(platformId.platformId);
                    if (platform != null && (platformsInRoute.isEmpty() || platform.id != ((SavedRailBase)platformsInRoute.get((int)(platformsInRoute.size() - 1))).id)) {
                        platformsInRoute.add(platform);
                    }
                });
            }
        });
        boolean useFastSpeed = this.cruisingAltitude >= world.method_31600() + 64;
        Thread thread = new Thread(() -> {
            try {
                ArrayList<PathData> tempPath = new ArrayList<PathData>();
                int successfulSegmentsMain = PathFinder.findPath(tempPath, rails, platformsInRoute, 1, this.cruisingAltitude, useFastSpeed);
                int[] successfulSegments = new int[]{Integer.MAX_VALUE};
                sidings.forEach(siding -> {
                    SavedRailBase lastPlatform;
                    SavedRailBase firstPlatform;
                    int result;
                    class_2338 sidingMidPos = siding.getMidPos();
                    if (siding.isTransportMode(this.transportMode) && this.inArea(sidingMidPos.method_10263(), sidingMidPos.method_10260()) && (result = siding.generateRoute(minecraftServer, tempPath, successfulSegmentsMain, rails, firstPlatform = platformsInRoute.isEmpty() ? null : (SavedRailBase)platformsInRoute.get(0), lastPlatform = platformsInRoute.isEmpty() ? null : (SavedRailBase)platformsInRoute.get(platformsInRoute.size() - 1), this.repeatInfinitely, this.cruisingAltitude, useFastSpeed)) < successfulSegments[0]) {
                        successfulSegments[0] = result;
                    }
                });
                PacketTrainDataGuiServer.generatePathS2C(world, this.id, successfulSegments[0]);
                System.out.println("Finished path generation" + (String)(this.name.isEmpty() ? "" : " for " + this.name));
            }
            catch (Exception e) {
                e.printStackTrace();
                PacketTrainDataGuiServer.generatePathS2C(world, this.id, 0);
                System.out.println("Failed to generate path" + (String)(this.name.isEmpty() ? "" : " for " + this.name));
            }
        });
        callback.accept(thread);
        thread.start();
    }

    public void requestDeploy(long sidingId, TrainServer train) {
        this.deployableSidings.put(sidingId, train);
    }

    public void deployTrain(RailwayData railwayData, class_1937 world) {
        if (this.isDirty) {
            this.generateTempDepartures(world);
        }
        if (!this.deployableSidings.isEmpty() && this.getMillisUntilDeploy(1) == 0) {
            List sidingsInDepot = railwayData.sidings.stream().filter(siding -> {
                class_2338 sidingPos = siding.getMidPos();
                return siding.isTransportMode(this.transportMode) && this.inArea(sidingPos.method_10263(), sidingPos.method_10260());
            }).sorted().collect(Collectors.toList());
            int sidingsInDepotSize = sidingsInDepot.size();
            for (int i = this.deployIndex; i < this.deployIndex + sidingsInDepotSize; ++i) {
                TrainServer train = this.deployableSidings.get(((Siding)sidingsInDepot.get((int)(i % sidingsInDepotSize))).id);
                if (train == null) continue;
                this.lastDeployedMillis = System.currentTimeMillis();
                ++this.deployIndex;
                if (this.deployIndex >= sidingsInDepotSize) {
                    this.deployIndex = 0;
                }
                train.deployTrain();
                break;
            }
        }
        this.departureOffset = 0;
        this.deployableSidings.clear();
    }

    public int getNextDepartureMillis() {
        ++this.departureOffset;
        int millisUntilDeploy = this.getMillisUntilDeploy(this.departureOffset);
        return millisUntilDeploy >= 0 ? millisUntilDeploy : -1;
    }

    public int getMillisUntilDeploy(int offset) {
        return this.getMillisUntilDeploy(offset, 0);
    }

    public int getMillisUntilDeploy(int offset, int currentTimeOffset) {
        long millis = (System.currentTimeMillis() + (long)currentTimeOffset) % 86400000L;
        for (int i = 0; i < this.tempDepartures.size(); ++i) {
            long thisDeparture = this.tempDepartures.get(i).intValue();
            long nextDeparture = Depot.wrapTime(this.tempDepartures.get((i + 1) % this.tempDepartures.size()).intValue(), thisDeparture);
            long newMillis = Depot.wrapTime(millis, thisDeparture);
            if (newMillis <= thisDeparture || newMillis > nextDeparture) continue;
            if (offset > 1) {
                if (offset > this.tempDepartures.size()) continue;
                return (int)(Depot.wrapTime(this.tempDepartures.get((i + offset) % this.tempDepartures.size()).intValue(), millis) - millis);
            }
            return Depot.wrapTime(this.lastDeployedMillis + (long)currentTimeOffset, newMillis) - 86400000L >= thisDeparture ? (int)(nextDeparture - newMillis) : 0;
        }
        return -1;
    }

    public void generateTempDepartures(class_1937 world) {
        this.tempDepartures.clear();
        if (this.useRealTime && !this.transportMode.continuousMovement) {
            this.tempDepartures.addAll(this.departures);
        } else if (world != null) {
            int millisOffset = 0;
            while (millisOffset < 86400000) {
                int tempFrequency = this.getFrequency(Depot.getHour(world, millisOffset));
                if (tempFrequency == 0 && !this.transportMode.continuousMovement) {
                    millisOffset = (int)(Math.floor((float)millisOffset / 50.0f / 1000.0f) + 1.0) * 1000 * 50;
                    continue;
                }
                this.tempDepartures.add((int)((this.lastDeployedMillis + (long)millisOffset) % 86400000L));
                millisOffset += this.transportMode.continuousMovement ? 8000 : 200000 / tempFrequency;
            }
            this.tempDepartures.sort(Integer::compareTo);
        }
        this.isDirty = false;
    }

    private static int getHour(class_1937 world, int offsetMillis) {
        return (int)Depot.wrapTime((float)world.method_8532() + (float)offsetMillis / 50.0f) / 1000;
    }

    private static float wrapTime(float time) {
        return (time + 6000.0f + 24000.0f) % 24000.0f;
    }

    private static long wrapTime(long time, long mustBeGreaterThan) {
        long newTime;
        for (newTime = time % 86400000L; newTime <= mustBeGreaterThan; newTime += 86400000L) {
        }
        return newTime;
    }
}

