/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mtr.block.IBlock;
import mtr.data.DataCache;
import mtr.data.IPIDSRenderChild;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.mappings.BlockEntityClientSerializableMapper;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public interface IPIDS
extends IBlock {

    public static abstract class TileEntityPIDS
    extends BlockEntityClientSerializableMapper
    implements IPIDSRenderChild {
        private long cachedRefreshTime;
        private long cachedPlatformId;
        public final String[] messages = new String[this.getMaxArrivals() * this.getLinesPerArrival()];
        private final boolean[] hideArrival = new boolean[this.getMaxArrivals()];
        private final Set<Long> platformIds = new HashSet<Long>();
        private int displayPage = 0;
        private static final String KEY_MESSAGE = "message";
        private static final String KEY_HIDE_ARRIVAL = "hide_arrival";
        private static final String KEY_PLATFORM_IDS = "platform_ids";
        private static final String KEY_DISPLAY_PAGE = "display_page";

        public TileEntityPIDS(class_2591<?> type, class_2338 pos, class_2680 state) {
            super(type, pos, state);
        }

        @Override
        public void readCompoundTag(class_2487 compoundTag) {
            long[] platformIdsArray;
            int i;
            for (i = 0; i < this.getMaxArrivals() * this.getLinesPerArrival(); ++i) {
                this.messages[i] = compoundTag.method_10558(KEY_MESSAGE + i);
            }
            for (i = 0; i < this.getMaxArrivals(); ++i) {
                this.hideArrival[i] = compoundTag.method_10577(KEY_HIDE_ARRIVAL + i);
            }
            this.platformIds.clear();
            for (long platformId : platformIdsArray = compoundTag.method_10565(KEY_PLATFORM_IDS)) {
                this.platformIds.add(platformId);
            }
            this.displayPage = compoundTag.method_10550(KEY_DISPLAY_PAGE);
        }

        @Override
        public void writeCompoundTag(class_2487 compoundTag) {
            int i;
            for (i = 0; i < this.getMaxArrivals() * this.getLinesPerArrival(); ++i) {
                compoundTag.method_10582(KEY_MESSAGE + i, this.messages[i] == null ? "" : this.messages[i]);
            }
            for (i = 0; i < this.getMaxArrivals(); ++i) {
                compoundTag.method_10556(KEY_HIDE_ARRIVAL + i, this.hideArrival[i]);
            }
            compoundTag.method_10538(KEY_PLATFORM_IDS, new ArrayList<Long>(this.platformIds));
            compoundTag.method_10569(KEY_DISPLAY_PAGE, this.displayPage);
        }

        public class_238 getRenderBoundingBox() {
            return new class_238(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }

        public void setData(String[] messages, boolean[] hideArrival, Set<Long> platformIds, int displayPage) {
            System.arraycopy(messages, 0, this.messages, 0, Math.min(messages.length, this.messages.length));
            System.arraycopy(hideArrival, 0, this.hideArrival, 0, Math.min(hideArrival.length, this.hideArrival.length));
            this.platformIds.clear();
            this.platformIds.addAll(platformIds);
            this.displayPage = displayPage;
            this.method_5431();
            this.syncData();
        }

        public long getPlatformId(Set<Platform> platforms, DataCache dataCache) {
            if (dataCache.needsRefresh(this.cachedRefreshTime)) {
                this.cachedPlatformId = RailwayData.getClosePlatformId(platforms, dataCache, this.method_11016());
                this.cachedRefreshTime = System.currentTimeMillis();
            }
            return this.cachedPlatformId;
        }

        @Override
        public int getDisplayPage() {
            return this.displayPage;
        }

        public Set<Long> getPlatformIds() {
            return this.platformIds;
        }

        public String getMessage(int index) {
            if (index >= 0 && index < this.getMaxArrivals() * this.getLinesPerArrival()) {
                if (this.messages[index] == null) {
                    this.messages[index] = "";
                }
                return this.messages[index];
            }
            return "";
        }

        public boolean getHideArrival(int index) {
            if (index >= 0 && index < this.getMaxArrivals()) {
                return this.hideArrival[index];
            }
            return false;
        }

        public abstract int getMaxArrivals();

        public abstract int getLinesPerArrival();
    }
}

