/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mtr.block.BlockLiftTrackFloor;
import mtr.block.BlockPSDAPGDoorBase;
import mtr.block.IBlock;
import mtr.data.EnumHelper;
import mtr.data.LiftInstructions;
import mtr.data.MessagePackHelper;
import mtr.data.NameColorDataBase;
import mtr.data.RailwayData;
import mtr.mappings.Utilities;
import mtr.packet.IPacket;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public abstract class Lift
extends NameColorDataBase
implements IPacket {
    public int liftHeight;
    public int liftWidth;
    public int liftDepth;
    public int liftOffsetX;
    public int liftOffsetY;
    public int liftOffsetZ;
    public boolean isDoubleSided;
    public LiftStyle liftStyle;
    public class_2350 facing;
    protected double currentPositionX;
    protected double currentPositionY;
    protected double currentPositionZ;
    protected LiftDirection liftDirection = LiftDirection.NONE;
    protected double speed;
    protected boolean doorOpen = true;
    protected float doorValue;
    protected boolean frontCanOpen;
    protected boolean backCanOpen;
    public final LiftInstructions liftInstructions;
    protected final List<class_2338> floors = new ArrayList<class_2338>();
    protected final Set<UUID> ridingEntities = new HashSet<UUID>();
    public static final int DOOR_MAX = 24;
    protected static final String KEY_LIFT_UPDATE = "lift_update";
    private static final String KEY_LIFT_HEIGHT = "lift_height";
    private static final String KEY_LIFT_WIDTH = "lift_width";
    private static final String KEY_LIFT_DEPTH = "lift_depth";
    private static final String KEY_LIFT_OFFSET_X = "lift_offset_x";
    private static final String KEY_LIFT_OFFSET_Y = "lift_offset_y";
    private static final String KEY_LIFT_OFFSET_Z = "lift_offset_z";
    private static final String KEY_IS_DOUBLE_SIDED = "is_double_sided";
    private static final String KEY_LIFT_STYLE = "lift_style";
    private static final String KEY_FACING = "facing";
    private static final String KEY_CURRENT_POSITION_X = "current_position_x";
    private static final String KEY_CURRENT_POSITION_Y = "current_position_y";
    private static final String KEY_CURRENT_POSITION_Z = "current_position_z";
    private static final String KEY_RIDING_ENTITIES = "riding_entities";
    private static final String KEY_FLOORS = "floors";

    public Lift(class_2338 pos, class_2350 facing) {
        this.liftHeight = 4;
        this.liftWidth = 2;
        this.liftDepth = 2;
        this.liftOffsetX = 0;
        this.liftOffsetY = 0;
        this.liftOffsetZ = 0;
        this.isDoubleSided = false;
        this.liftStyle = LiftStyle.TRANSPARENT;
        this.facing = facing;
        this.currentPositionX = pos.method_10263();
        this.currentPositionY = pos.method_10264();
        this.currentPositionZ = pos.method_10260();
        this.liftInstructions = new LiftInstructions();
    }

    public Lift(Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.liftHeight = messagePackHelper.getInt(KEY_LIFT_HEIGHT);
        this.liftWidth = messagePackHelper.getInt(KEY_LIFT_WIDTH);
        this.liftDepth = messagePackHelper.getInt(KEY_LIFT_DEPTH);
        this.liftOffsetX = messagePackHelper.getInt(KEY_LIFT_OFFSET_X);
        this.liftOffsetY = messagePackHelper.getInt(KEY_LIFT_OFFSET_Y);
        this.liftOffsetZ = messagePackHelper.getInt(KEY_LIFT_OFFSET_Z);
        this.isDoubleSided = messagePackHelper.getBoolean(KEY_IS_DOUBLE_SIDED);
        this.liftStyle = EnumHelper.valueOf(LiftStyle.TRANSPARENT, messagePackHelper.getString(KEY_LIFT_STYLE));
        this.facing = class_2350.method_10150((double)messagePackHelper.getInt(KEY_FACING));
        this.currentPositionX = messagePackHelper.getDouble(KEY_CURRENT_POSITION_X);
        this.currentPositionY = messagePackHelper.getDouble(KEY_CURRENT_POSITION_Y);
        this.currentPositionZ = messagePackHelper.getDouble(KEY_CURRENT_POSITION_Z);
        messagePackHelper.iterateArrayValue(KEY_RIDING_ENTITIES, value -> this.ridingEntities.add(UUID.fromString(value.asStringValue().asString())));
        messagePackHelper.iterateArrayValue(KEY_FLOORS, entry -> this.floors.add(class_2338.method_10092((long)entry.asIntegerValue().toLong())));
        this.liftInstructions = new LiftInstructions();
        this.doorOpen = true;
        this.doorValue = 0.0f;
    }

    public Lift(class_2540 packet) {
        super(packet);
        this.liftHeight = packet.readInt();
        this.liftWidth = packet.readInt();
        this.liftDepth = packet.readInt();
        this.liftOffsetX = packet.readInt();
        this.liftOffsetY = packet.readInt();
        this.liftOffsetZ = packet.readInt();
        this.isDoubleSided = packet.readBoolean();
        this.liftStyle = EnumHelper.valueOf(LiftStyle.TRANSPARENT, packet.method_10800(Short.MAX_VALUE));
        this.facing = class_2350.method_10150((double)packet.readInt());
        this.currentPositionX = packet.readDouble();
        this.currentPositionY = packet.readDouble();
        this.currentPositionZ = packet.readDouble();
        this.liftDirection = EnumHelper.valueOf(LiftDirection.NONE, packet.method_10800(Short.MAX_VALUE));
        this.speed = packet.readDouble();
        this.doorOpen = packet.readBoolean();
        this.doorValue = packet.readFloat();
        int ridingEntitiesCount = packet.readInt();
        for (int i = 0; i < ridingEntitiesCount; ++i) {
            this.ridingEntities.add(packet.method_10790());
        }
        int floorCount = packet.readInt();
        for (int i = 0; i < floorCount; ++i) {
            this.floors.add(packet.method_10811());
        }
        this.liftInstructions = new LiftInstructions(packet);
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_LIFT_HEIGHT).packInt(this.liftHeight);
        messagePacker.packString(KEY_LIFT_WIDTH).packInt(this.liftWidth);
        messagePacker.packString(KEY_LIFT_DEPTH).packInt(this.liftDepth);
        messagePacker.packString(KEY_LIFT_OFFSET_X).packInt(this.liftOffsetX);
        messagePacker.packString(KEY_LIFT_OFFSET_Y).packInt(this.liftOffsetY);
        messagePacker.packString(KEY_LIFT_OFFSET_Z).packInt(this.liftOffsetZ);
        messagePacker.packString(KEY_IS_DOUBLE_SIDED).packBoolean(this.isDoubleSided);
        messagePacker.packString(KEY_LIFT_STYLE).packString(this.liftStyle.toString());
        messagePacker.packString(KEY_FACING).packInt(Math.round(this.facing.method_10144()));
        class_2338 closestFloor = this.getCurrentFloorBlockPos();
        messagePacker.packString(KEY_CURRENT_POSITION_X).packDouble(closestFloor.method_10263());
        messagePacker.packString(KEY_CURRENT_POSITION_Y).packDouble(closestFloor.method_10264());
        messagePacker.packString(KEY_CURRENT_POSITION_Z).packDouble(closestFloor.method_10260());
        messagePacker.packString(KEY_RIDING_ENTITIES).packArrayHeader(this.ridingEntities.size());
        for (UUID uuid : this.ridingEntities) {
            messagePacker.packString(uuid.toString());
        }
        messagePacker.packString(KEY_FLOORS).packArrayHeader(this.floors.size());
        for (class_2338 floor : this.floors) {
            messagePacker.packLong(floor.method_10063());
        }
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 14;
    }

    @Override
    public void writePacket(class_2540 packet) {
        super.writePacket(packet);
        packet.writeInt(this.liftHeight);
        packet.writeInt(this.liftWidth);
        packet.writeInt(this.liftDepth);
        packet.writeInt(this.liftOffsetX);
        packet.writeInt(this.liftOffsetY);
        packet.writeInt(this.liftOffsetZ);
        packet.writeBoolean(this.isDoubleSided);
        packet.method_10814(this.liftStyle.toString());
        packet.writeInt(Math.round(this.facing.method_10144()));
        packet.writeDouble(this.currentPositionX);
        packet.writeDouble(this.currentPositionY);
        packet.writeDouble(this.currentPositionZ);
        packet.method_10814(this.liftDirection.toString());
        packet.writeDouble(this.speed);
        packet.writeBoolean(this.doorOpen);
        packet.writeFloat(this.doorValue);
        packet.writeInt(this.ridingEntities.size());
        this.ridingEntities.forEach(arg_0 -> ((class_2540)packet).method_10797(arg_0));
        packet.writeInt(this.floors.size());
        this.floors.forEach(arg_0 -> ((class_2540)packet).method_10807(arg_0));
        this.liftInstructions.writePacket(packet);
    }

    @Override
    public void update(String key, class_2540 packet) {
        if (KEY_LIFT_UPDATE.equals(key)) {
            this.liftHeight = packet.readInt();
            this.liftWidth = packet.readInt();
            this.liftDepth = packet.readInt();
            this.liftOffsetX = packet.readInt();
            this.liftOffsetY = packet.readInt();
            this.liftOffsetZ = packet.readInt();
            this.isDoubleSided = packet.readBoolean();
            this.liftStyle = EnumHelper.valueOf(LiftStyle.TRANSPARENT, packet.method_10800(Short.MAX_VALUE));
            this.facing = class_2350.method_10150((double)packet.readInt());
        } else {
            super.update(key, packet);
        }
    }

    @Override
    protected boolean hasTransportMode() {
        return false;
    }

    public void setFloors(List<class_2338> floors) {
        this.floors.clear();
        this.floors.addAll(floors);
    }

    public boolean hasFloor(class_2338 pos) {
        return this.floors.contains(pos);
    }

    public double getPositionX() {
        return this.currentPositionX;
    }

    public double getPositionY() {
        return this.currentPositionY;
    }

    public double getPositionZ() {
        return this.currentPositionZ;
    }

    public LiftDirection getLiftDirection() {
        return this.liftDirection;
    }

    public void hasUpDownButtonForFloor(int checkFloor, boolean[] hasButton) {
        this.floors.forEach(floor -> {
            if (floor.method_10264() > checkFloor) {
                hasButton[0] = true;
            }
            if (floor.method_10264() < checkFloor) {
                hasButton[1] = true;
            }
        });
    }

    public void pressButton(int floor) {
        boolean movingUp = this.liftDirection == LiftDirection.UP;
        this.liftInstructions.addInstruction((int)(movingUp ? Math.floor(this.currentPositionY) : Math.ceil(this.currentPositionY)), movingUp, floor);
    }

    public class_2338 getCurrentFloorBlockPos() {
        double distance = Double.MAX_VALUE;
        class_2338 closestFloor = null;
        for (class_2338 floor : this.floors) {
            double difference = Math.abs(this.currentPositionY - (double)floor.method_10264());
            if (difference < distance) {
                distance = difference;
                closestFloor = floor;
                continue;
            }
            return closestFloor;
        }
        return closestFloor;
    }

    public boolean isInvalidLift(class_1937 world) {
        if (this.floors.isEmpty()) {
            return true;
        }
        for (class_2338 checkFloor : this.floors) {
            if (!RailwayData.chunkLoaded(world, checkFloor) || world.method_8320(checkFloor).method_26204() instanceof BlockLiftTrackFloor) continue;
            return true;
        }
        return false;
    }

    protected void tick(class_1937 world, float ticksElapsed) {
        if (this.liftInstructions.hasInstructions() && this.doorValue == 48.0f) {
            this.doorOpen = false;
            this.liftInstructions.getTargetFloor(targetFloor -> {
                this.liftDirection = (double)targetFloor.intValue() > this.currentPositionY ? LiftDirection.UP : LiftDirection.DOWN;
            });
        } else if (!this.liftInstructions.hasInstructions()) {
            this.liftDirection = LiftDirection.NONE;
        }
        if (!this.doorOpen && this.doorValue == 0.0f) {
            this.liftInstructions.getTargetFloor(targetFloor -> {
                double stoppingDistance = Math.abs((double)targetFloor.intValue() - this.currentPositionY);
                LiftDirection liftDirection = stoppingDistance < (double)0.01f ? LiftDirection.NONE : (this.liftDirection = (double)targetFloor.intValue() > this.currentPositionY ? LiftDirection.UP : LiftDirection.DOWN);
                if (this.liftDirection == LiftDirection.NONE) {
                    class_2586 blockEntity;
                    this.speed = 0.0;
                    this.doorOpen = true;
                    this.currentPositionY = targetFloor.intValue();
                    this.liftInstructions.arrived();
                    if (!world.field_9236 && (blockEntity = world.method_8321(this.getBlockPos())) instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor && ((BlockLiftTrackFloor.TileEntityLiftTrackFloor)blockEntity).getShouldDing()) {
                        world.method_8396(null, this.getBlockPos(), Utilities.unwrapSoundEvent((class_6880.class_6883<class_3414>)class_3417.field_14622), class_3419.field_15245, 16.0f, 2.0f);
                    }
                } else {
                    this.speed = stoppingDistance < 0.5 * this.speed * this.speed / (double)0.01f ? Math.max(this.speed - 0.5 * this.speed * this.speed / stoppingDistance * (double)ticksElapsed, (double)0.01f) : Math.min(this.speed + (double)(0.01f * ticksElapsed), 1.0);
                    this.currentPositionY += this.speed * (double)this.liftDirection.speedMultiplier * (double)ticksElapsed;
                }
            });
        } else {
            if (!this.doorOpen && this.doorValue > 0.0f || this.doorOpen && this.doorValue < 48.0f) {
                this.doorValue = this.doorOpen ? Math.min(this.doorValue + ticksElapsed, 48.0f) : Math.max(this.doorValue - ticksElapsed, 0.0f);
            }
            this.frontCanOpen = this.checkDoor(world, true);
            if (this.isDoubleSided) {
                this.backCanOpen = this.checkDoor(world, false);
            }
        }
    }

    protected float getYaw() {
        return (float)Math.toRadians(-this.facing.method_10170().method_10144());
    }

    private class_2338 getBlockPos() {
        return RailwayData.newBlockPos(this.currentPositionX, this.currentPositionY, this.currentPositionZ);
    }

    private boolean checkDoor(class_1937 world, boolean front) {
        class_2350 directionClockwise = this.facing.method_10170();
        int sign = front ? 1 : -1;
        boolean hasDoor = false;
        for (int i = -1; i <= 1; ++i) {
            class_2338 checkPos = RailwayData.newBlockPos(this.currentPositionX + (double)((float)this.liftOffsetX / 2.0f) - (double)(this.facing.method_10148() * sign) * ((double)((float)this.liftDepth / 2.0f) + 0.5) + (double)(directionClockwise.method_10148() * i), this.currentPositionY + (double)this.liftOffsetY, this.currentPositionZ + (double)((float)this.liftOffsetZ / 2.0f) - (double)(this.facing.method_10165() * sign) * ((double)((float)this.liftDepth / 2.0f) + 0.5) + (double)(directionClockwise.method_10165() * i));
            if (world.method_8604(this.currentPositionX, this.currentPositionY, this.currentPositionZ, 32.0, entity -> true) == null || !RailwayData.chunkLoaded(world, checkPos) || !RailwayData.chunkLoaded(world, checkPos.method_10084())) continue;
            class_2586 entity1 = world.method_8321(checkPos);
            class_2586 entity2 = world.method_8321(checkPos.method_10084());
            if (!(entity1 instanceof BlockPSDAPGDoorBase.TileEntityPSDAPGDoorBase) || !(entity2 instanceof BlockPSDAPGDoorBase.TileEntityPSDAPGDoorBase) || !((Boolean)IBlock.getStatePropertySafe((class_1922)world, checkPos, BlockPSDAPGDoorBase.UNLOCKED)).booleanValue() || !((Boolean)IBlock.getStatePropertySafe((class_1922)world, checkPos.method_10084(), BlockPSDAPGDoorBase.UNLOCKED)).booleanValue()) continue;
            if (!world.field_9236) {
                ((BlockPSDAPGDoorBase.TileEntityPSDAPGDoorBase)entity1).setOpen(Math.min(Math.round(this.doorValue), 24));
                ((BlockPSDAPGDoorBase.TileEntityPSDAPGDoorBase)entity2).setOpen(Math.min(Math.round(this.doorValue), 24));
            }
            hasDoor = true;
        }
        return hasDoor;
    }

    public static enum LiftDirection {
        NONE(0),
        UP(1),
        DOWN(-1);

        private final int speedMultiplier;

        private LiftDirection(int speedMultiplier) {
            this.speedMultiplier = speedMultiplier;
        }
    }

    public static enum LiftStyle {
        TRANSPARENT,
        OPAQUE;

    }
}

