/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.util.UUID;
import java.util.function.Consumer;
import mtr.KeyMappings;
import mtr.data.Lift;
import mtr.data.VehicleRidingClient;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import mtr.screen.LiftSelectionScreen;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class LiftClient
extends Lift {
    private final VehicleRidingClient vehicleRidingClient;

    public LiftClient(class_2540 packet) {
        super(packet);
        this.vehicleRidingClient = new VehicleRidingClient(this.ridingEntities, PACKET_UPDATE_LIFT_PASSENGER_POSITION);
    }

    public void tickClient(class_1937 world, RenderLift renderLift, float ticksElapsed) {
        this.tick(world, ticksElapsed);
        this.vehicleRidingClient.begin();
        if (ticksElapsed > 0.0f) {
            this.vehicleRidingClient.movePlayer(uuid -> {
                this.vehicleRidingClient.setOffsets((UUID)uuid, this.currentPositionX + (double)((float)this.liftOffsetX / 2.0f), this.currentPositionY + (double)this.liftOffsetY, this.currentPositionZ + (double)((float)this.liftOffsetZ / 2.0f), this.getYaw(), 0.0f, this.liftWidth - 1, this.liftDepth - 1, this.frontCanOpen, this.backCanOpen, false, false, 0.0f, 0.0f, this.speed > 0.0, this.doorValue == 0.0f, () -> {});
                this.vehicleRidingClient.moveSelf(this.id, (UUID)uuid, this.liftWidth - 1, this.liftDepth - 1, this.getYaw(), 0, 1, this.frontCanOpen, this.backCanOpen, true, ticksElapsed);
            });
        }
        this.vehicleRidingClient.end();
        class_243 offset = this.vehicleRidingClient.renderPlayerAndGetOffset();
        double newX = this.currentPositionX + (double)((float)this.liftOffsetX / 2.0f) - offset.field_1352;
        double newY = this.currentPositionY + (double)this.liftOffsetY - offset.field_1351;
        double newZ = this.currentPositionZ + (double)((float)this.liftOffsetZ / 2.0f) - offset.field_1350;
        renderLift.renderLift(newX, newY, newZ, this.frontCanOpen ? Math.min(this.doorValue / 24.0f, 1.0f) : 0.0f, this.backCanOpen ? Math.min(this.doorValue / 24.0f, 1.0f) : 0.0f);
        class_310 minecraftClient = class_310.method_1551();
        class_746 player = minecraftClient.field_1724;
        if (player != null && this.ridingEntities.contains(player.method_5667())) {
            if (KeyMappings.LIFT_MENU.method_1434() && !(minecraftClient.field_1755 instanceof LiftSelectionScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new LiftSelectionScreen(this));
            }
            if (RenderTrains.showShiftProgressBar()) {
                player.method_7353((class_2561)Text.translatable("gui.mtr.press_to_select_floor", KeyMappings.LIFT_MENU.method_16007()), true);
            }
        }
    }

    public void copyFromLift(LiftClient lift) {
        this.liftHeight = lift.liftHeight;
        this.liftWidth = lift.liftWidth;
        this.liftDepth = lift.liftDepth;
        this.liftOffsetX = lift.liftOffsetX;
        this.liftOffsetY = lift.liftOffsetY;
        this.liftOffsetZ = lift.liftOffsetZ;
        this.isDoubleSided = lift.isDoubleSided;
        this.liftStyle = lift.liftStyle;
        this.facing = lift.facing;
        this.currentPositionX = lift.currentPositionX;
        this.currentPositionY = lift.currentPositionY;
        this.currentPositionZ = lift.currentPositionZ;
        this.liftDirection = lift.liftDirection;
        this.speed = lift.speed;
        this.doorOpen = lift.doorOpen;
        this.doorValue = lift.doorValue;
        this.frontCanOpen = lift.frontCanOpen;
        this.backCanOpen = lift.backCanOpen;
        this.ridingEntities.clear();
        this.ridingEntities.addAll(lift.ridingEntities);
        this.floors.clear();
        this.floors.addAll(lift.floors);
        this.liftInstructions.copyFrom(lift.liftInstructions);
    }

    public void setExtraData(Consumer<class_2540> sendPacket) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.method_10814(this.transportMode.toString());
        packet.method_10814("lift_update");
        packet.writeInt(this.liftHeight);
        packet.writeInt(this.liftWidth);
        packet.writeInt(this.liftDepth);
        packet.writeInt(this.liftOffsetX);
        packet.writeInt(this.liftOffsetY);
        packet.writeInt(this.liftOffsetZ);
        packet.writeBoolean(this.isDoubleSided);
        packet.method_10814(this.liftStyle.toString());
        packet.writeInt(Math.round(this.facing.method_10144()));
        sendPacket.accept(packet);
    }

    public void startRidingClient(UUID uuid, float percentageX, float percentageZ) {
        this.vehicleRidingClient.startRiding(uuid, percentageX, percentageZ);
    }

    public void updateRiderPercentages(UUID uuid, float percentageX, float percentageZ) {
        this.vehicleRidingClient.updateRiderPercentages(uuid, percentageX, percentageZ);
    }

    public void iterateFloors(Consumer<class_2338> consumer) {
        this.floors.forEach(consumer);
    }

    public class_243 getViewOffset() {
        return this.vehicleRidingClient.getViewOffset();
    }

    @FunctionalInterface
    public static interface RenderLift {
        public void renderLift(double var1, double var3, double var5, float var7, float var8);
    }
}

