/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import mtr.data.EnumHelper;
import mtr.data.MessagePackHelper;
import mtr.data.SerializedDataBase;
import mtr.data.TransportMode;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public abstract class NameColorDataBase
extends SerializedDataBase
implements Comparable<NameColorDataBase> {
    public final long id;
    public final TransportMode transportMode;
    public String name;
    public int color;
    private static final String KEY_ID = "id";
    private static final String KEY_TRANSPORT_MODE = "transport_mode";
    private static final String KEY_NAME = "name";
    private static final String KEY_COLOR = "color";

    public NameColorDataBase() {
        this(0L);
    }

    public NameColorDataBase(long id) {
        this(id, TransportMode.TRAIN);
    }

    public NameColorDataBase(TransportMode transportMode) {
        this(0L, transportMode);
    }

    public NameColorDataBase(long id, TransportMode transportMode) {
        this.id = id == 0L ? new Random().nextLong() : id;
        this.transportMode = transportMode;
        this.name = "";
    }

    public NameColorDataBase(Map<String, Value> map) {
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.id = messagePackHelper.getLong(KEY_ID);
        this.transportMode = EnumHelper.valueOf(TransportMode.TRAIN, messagePackHelper.getString(KEY_TRANSPORT_MODE));
        this.name = messagePackHelper.getString(KEY_NAME);
        this.color = messagePackHelper.getInt(KEY_COLOR);
    }

    @Deprecated
    public NameColorDataBase(class_2487 compoundTag) {
        this.id = compoundTag.method_10537(KEY_ID);
        this.transportMode = EnumHelper.valueOf(TransportMode.TRAIN, compoundTag.method_10558(KEY_TRANSPORT_MODE));
        this.name = compoundTag.method_10558(KEY_NAME);
        this.color = compoundTag.method_10550(KEY_COLOR);
    }

    public NameColorDataBase(class_2540 packet) {
        this.id = packet.readLong();
        this.transportMode = EnumHelper.valueOf(TransportMode.TRAIN, packet.method_10800(Short.MAX_VALUE));
        this.name = packet.method_10800(Short.MAX_VALUE).replace(" |", "|").replace("| ", "|");
        this.color = packet.readInt();
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        messagePacker.packString(KEY_ID).packLong(this.id);
        messagePacker.packString(KEY_TRANSPORT_MODE).packString(this.transportMode.toString());
        messagePacker.packString(KEY_NAME).packString(this.name);
        messagePacker.packString(KEY_COLOR).packInt(this.color);
    }

    @Override
    public int messagePackLength() {
        return 4;
    }

    @Override
    public void writePacket(class_2540 packet) {
        packet.writeLong(this.id);
        packet.method_10814(this.transportMode.toString());
        packet.method_10814(this.name);
        packet.writeInt(this.color);
    }

    public void update(String key, class_2540 packet) {
        if (key.equals(KEY_NAME)) {
            this.name = packet.method_10800(Short.MAX_VALUE);
            this.color = packet.readInt();
        }
    }

    public void setNameColor(Consumer<class_2540> sendPacket) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.method_10814(this.transportMode.toString());
        packet.method_10814(KEY_NAME);
        packet.method_10814(this.name);
        packet.writeInt(this.color);
        if (sendPacket != null) {
            sendPacket.accept(packet);
        }
    }

    public final boolean isTransportMode(TransportMode transportMode) {
        return !this.hasTransportMode() || this.transportMode == transportMode;
    }

    protected abstract boolean hasTransportMode();

    @Override
    public int compareTo(NameColorDataBase compare) {
        return (this.name.toLowerCase(Locale.ENGLISH) + this.color).compareTo((compare.name + compare.color).toLowerCase(Locale.ENGLISH));
    }
}

