/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import mtr.block.BlockNode;
import mtr.data.EnumHelper;
import mtr.data.MessagePackHelper;
import mtr.data.RailAngle;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.SerializedDataBase;
import mtr.data.TransportMode;
import mtr.mappings.Text;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public class Rail
extends SerializedDataBase {
    public final RailType railType;
    public final TransportMode transportMode;
    public final RailAngle facingStart;
    public final RailAngle facingEnd;
    private final double h1;
    private final double k1;
    private final double r1;
    private final double tStart1;
    private final double tEnd1;
    private final double h2;
    private final double k2;
    private final double r2;
    private final double tStart2;
    private final double tEnd2;
    private final int yStart;
    private final int yEnd;
    private final boolean reverseT1;
    private final boolean isStraight1;
    private final boolean reverseT2;
    private final boolean isStraight2;
    private static final double ACCEPT_THRESHOLD = 1.0E-4;
    private static final int MIN_RADIUS = 2;
    private static final int CABLE_CURVATURE_SCALE = 1000;
    private static final int MAX_CABLE_DIP = 8;
    private static final String KEY_H_1 = "h_1";
    private static final String KEY_K_1 = "k_1";
    private static final String KEY_H_2 = "h_2";
    private static final String KEY_K_2 = "k_2";
    private static final String KEY_R_1 = "r_1";
    private static final String KEY_R_2 = "r_2";
    private static final String KEY_T_START_1 = "t_start_1";
    private static final String KEY_T_END_1 = "t_end_1";
    private static final String KEY_T_START_2 = "t_start_2";
    private static final String KEY_T_END_2 = "t_end_2";
    private static final String KEY_Y_START = "y_start";
    private static final String KEY_Y_END = "y_end";
    private static final String KEY_REVERSE_T_1 = "reverse_t_1";
    private static final String KEY_IS_STRAIGHT_1 = "is_straight_1";
    private static final String KEY_REVERSE_T_2 = "reverse_t_2";
    private static final String KEY_IS_STRAIGHT_2 = "is_straight_2";
    private static final String KEY_RAIL_TYPE = "rail_type";
    private static final String KEY_TRANSPORT_MODE = "transport_mode";

    public Rail(class_2338 posStart, RailAngle facingStart, class_2338 posEnd, RailAngle facingEnd, RailType railType, TransportMode transportMode) {
        this.facingStart = facingStart;
        this.facingEnd = facingEnd;
        this.railType = railType;
        this.transportMode = transportMode;
        this.yStart = posStart.method_10264();
        this.yEnd = posEnd.method_10264();
        int xStart = posStart.method_10263();
        int zStart = posStart.method_10260();
        int xEnd = posEnd.method_10263();
        int zEnd = posEnd.method_10260();
        class_243 vecDifference = new class_243((double)(posEnd.method_10263() - posStart.method_10263()), 0.0, (double)(posEnd.method_10260() - posStart.method_10260()));
        class_243 vecDifferenceRotated = vecDifference.method_1024((float)facingStart.angleRadians);
        double deltaForward = vecDifferenceRotated.field_1350;
        double deltaSide = vecDifferenceRotated.field_1352;
        if (facingStart.isParallel(facingEnd)) {
            if (Math.abs(deltaForward) < 1.0E-4) {
                this.h1 = facingStart.cos;
                this.k1 = facingStart.sin;
                if (Math.abs(this.h1) >= 0.5 && Math.abs(this.k1) >= 0.5) {
                    this.r1 = (this.h1 * (double)zStart - this.k1 * (double)xStart) / this.h1 / this.h1;
                    this.tStart1 = (double)xStart / this.h1;
                    this.tEnd1 = (double)xEnd / this.h1;
                } else {
                    double div = facingStart.add((RailAngle)facingStart).cos;
                    this.r1 = (this.h1 * (double)zStart - this.k1 * (double)xStart) / div;
                    this.tStart1 = (this.h1 * (double)xStart - this.k1 * (double)zStart) / div;
                    this.tEnd1 = (this.h1 * (double)xEnd - this.k1 * (double)zEnd) / div;
                }
                this.r2 = 0.0;
                this.k2 = 0.0;
                this.h2 = 0.0;
                this.reverseT1 = this.tStart1 > this.tEnd1;
                this.reverseT2 = false;
                this.isStraight2 = true;
                this.isStraight1 = true;
                this.tEnd2 = 0.0;
                this.tStart2 = 0.0;
            } else if (Math.abs(deltaSide) > 1.0E-4) {
                double radius = (deltaForward * deltaForward + deltaSide * deltaSide) / (4.0 * deltaForward);
                this.r1 = this.r2 = Math.abs(radius);
                this.h1 = (double)xStart - radius * facingStart.sin;
                this.k1 = (double)zStart + radius * facingStart.cos;
                this.h2 = (double)xEnd - radius * facingEnd.sin;
                this.k2 = (double)zEnd + radius * facingEnd.cos;
                this.reverseT1 = deltaForward < 0.0 != deltaSide < 0.0;
                this.reverseT2 = !this.reverseT1;
                this.tStart1 = Rail.getTBounds(xStart, this.h1, zStart, this.k1, this.r1);
                this.tEnd1 = Rail.getTBounds((double)xStart + vecDifference.field_1352 / 2.0, this.h1, (double)zStart + vecDifference.field_1350 / 2.0, this.k1, this.r1, this.tStart1, this.reverseT1);
                this.tStart2 = Rail.getTBounds((double)xStart + vecDifference.field_1352 / 2.0, this.h2, (double)zStart + vecDifference.field_1350 / 2.0, this.k2, this.r2);
                this.tEnd2 = Rail.getTBounds(xEnd, this.h2, zEnd, this.k2, this.r2, this.tStart2, this.reverseT2);
                this.isStraight2 = false;
                this.isStraight1 = false;
            } else {
                this.r2 = 0.0;
                this.r1 = 0.0;
                this.k2 = 0.0;
                this.h2 = 0.0;
                this.k1 = 0.0;
                this.h1 = 0.0;
                this.tEnd2 = 0.0;
                this.tEnd1 = 0.0;
                this.tStart2 = 0.0;
                this.tStart1 = 0.0;
                this.reverseT1 = false;
                this.reverseT2 = false;
                this.isStraight2 = true;
                this.isStraight1 = true;
            }
        } else {
            RailAngle newFacingStart = vecDifferenceRotated.field_1352 < -1.0E-4 ? facingStart.getOpposite() : facingStart;
            RailAngle newFacingEnd = facingEnd.cos * vecDifference.field_1352 + facingEnd.sin * vecDifference.field_1350 < -1.0E-4 ? facingEnd.getOpposite() : facingEnd;
            double angleForward = Math.atan2(deltaForward, deltaSide);
            RailAngle railAngleDifference = newFacingEnd.sub(newFacingStart);
            double angleDifference = railAngleDifference.angleRadians;
            if (Math.signum(angleForward) == Math.signum(angleDifference)) {
                double absAngleForward = Math.abs(angleForward);
                if (absAngleForward - Math.abs(angleDifference / 2.0) < 1.0E-4) {
                    double offsetSide = Math.abs(deltaForward / railAngleDifference.halfTan);
                    double remainingSide = deltaSide - offsetSide;
                    double deltaXEnd = (double)xStart + remainingSide * newFacingStart.cos;
                    double deltaZEnd = (double)zStart + remainingSide * newFacingStart.sin;
                    this.h1 = newFacingStart.cos;
                    this.k1 = newFacingStart.sin;
                    if (Math.abs(this.h1) >= 0.5 && Math.abs(this.k1) >= 0.5) {
                        this.r1 = (this.h1 * (double)zStart - this.k1 * (double)xStart) / this.h1 / this.h1;
                        this.tStart1 = (double)xStart / this.h1;
                        this.tEnd1 = deltaXEnd / this.h1;
                    } else {
                        double div = newFacingStart.add((RailAngle)newFacingStart).cos;
                        this.r1 = (this.h1 * (double)zStart - this.k1 * (double)xStart) / div;
                        this.tStart1 = (this.h1 * (double)xStart - this.k1 * (double)zStart) / div;
                        this.tEnd1 = (this.h1 * deltaXEnd - this.k1 * deltaZEnd) / div;
                    }
                    this.isStraight1 = true;
                    this.reverseT1 = this.tStart1 > this.tEnd1;
                    double radius = deltaForward / (1.0 - railAngleDifference.cos);
                    this.r2 = Math.abs(radius);
                    this.h2 = deltaXEnd - radius * newFacingStart.sin;
                    this.k2 = deltaZEnd + radius * newFacingStart.cos;
                    this.reverseT2 = deltaForward < 0.0;
                    this.tStart2 = Rail.getTBounds(deltaXEnd, this.h2, deltaZEnd, this.k2, this.r2);
                    this.tEnd2 = Rail.getTBounds(xEnd, this.h2, zEnd, this.k2, this.r2, this.tStart2, this.reverseT2);
                    this.isStraight2 = false;
                } else if (absAngleForward - Math.abs(angleDifference) < 1.0E-4) {
                    double crossSide = deltaForward / railAngleDifference.tan;
                    double remainingSide = (deltaSide - crossSide) * (1.0 + railAngleDifference.cos);
                    double remainingForward = (deltaSide - crossSide) * railAngleDifference.sin;
                    double deltaXEnd = (double)xStart + remainingSide * newFacingStart.cos - remainingForward * newFacingStart.sin;
                    double deltaZEnd = (double)zStart + remainingSide * newFacingStart.sin + remainingForward * newFacingStart.cos;
                    double radius = (deltaSide - deltaForward / railAngleDifference.tan) / railAngleDifference.halfTan;
                    this.r1 = Math.abs(radius);
                    this.h1 = (double)xStart - radius * newFacingStart.sin;
                    this.k1 = (double)zStart + radius * newFacingStart.cos;
                    this.isStraight1 = false;
                    this.reverseT1 = deltaForward < 0.0;
                    this.tStart1 = Rail.getTBounds(xStart, this.h1, zStart, this.k1, this.r1);
                    this.tEnd1 = Rail.getTBounds(deltaXEnd, this.h1, deltaZEnd, this.k1, this.r1, this.tStart1, this.reverseT1);
                    this.h2 = newFacingEnd.cos;
                    this.k2 = newFacingEnd.sin;
                    if (Math.abs(this.h2) >= 0.5 && Math.abs(this.k2) >= 0.5) {
                        this.r2 = (this.h2 * deltaZEnd - this.k2 * deltaXEnd) / this.h2 / this.h2;
                        this.tStart2 = deltaXEnd / this.h2;
                        this.tEnd2 = (double)xEnd / this.h2;
                    } else {
                        double div = newFacingEnd.add((RailAngle)newFacingEnd).cos;
                        this.r2 = (this.h2 * deltaZEnd - this.k2 * deltaXEnd) / div;
                        this.tStart2 = (this.h2 * deltaXEnd - this.k2 * deltaZEnd) / div;
                        this.tEnd2 = (this.h2 * (double)xEnd - this.k2 * (double)zEnd) / div;
                    }
                    this.isStraight2 = true;
                    this.reverseT2 = this.tStart2 > this.tEnd2;
                } else {
                    this.r2 = 0.0;
                    this.r1 = 0.0;
                    this.k2 = 0.0;
                    this.h2 = 0.0;
                    this.k1 = 0.0;
                    this.h1 = 0.0;
                    this.tEnd2 = 0.0;
                    this.tEnd1 = 0.0;
                    this.tStart2 = 0.0;
                    this.tStart1 = 0.0;
                    this.reverseT1 = false;
                    this.reverseT2 = false;
                    this.isStraight2 = true;
                    this.isStraight1 = true;
                }
            } else {
                this.r2 = 0.0;
                this.r1 = 0.0;
                this.k2 = 0.0;
                this.h2 = 0.0;
                this.k1 = 0.0;
                this.h1 = 0.0;
                this.tEnd2 = 0.0;
                this.tEnd1 = 0.0;
                this.tStart2 = 0.0;
                this.tStart1 = 0.0;
                this.reverseT1 = false;
                this.reverseT2 = false;
                this.isStraight2 = true;
                this.isStraight1 = true;
            }
        }
    }

    public Rail(Map<String, Value> map) {
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.h1 = messagePackHelper.getDouble(KEY_H_1);
        this.k1 = messagePackHelper.getDouble(KEY_K_1);
        this.h2 = messagePackHelper.getDouble(KEY_H_2);
        this.k2 = messagePackHelper.getDouble(KEY_K_2);
        this.r1 = messagePackHelper.getDouble(KEY_R_1);
        this.r2 = messagePackHelper.getDouble(KEY_R_2);
        this.tStart1 = messagePackHelper.getDouble(KEY_T_START_1);
        this.tEnd1 = messagePackHelper.getDouble(KEY_T_END_1);
        this.tStart2 = messagePackHelper.getDouble(KEY_T_START_2);
        this.tEnd2 = messagePackHelper.getDouble(KEY_T_END_2);
        this.yStart = messagePackHelper.getInt(KEY_Y_START);
        this.yEnd = messagePackHelper.getInt(KEY_Y_END);
        this.reverseT1 = messagePackHelper.getBoolean(KEY_REVERSE_T_1);
        this.isStraight1 = messagePackHelper.getBoolean(KEY_IS_STRAIGHT_1);
        this.reverseT2 = messagePackHelper.getBoolean(KEY_REVERSE_T_2);
        this.isStraight2 = messagePackHelper.getBoolean(KEY_IS_STRAIGHT_2);
        this.railType = EnumHelper.valueOf(RailType.IRON, messagePackHelper.getString(KEY_RAIL_TYPE));
        this.transportMode = EnumHelper.valueOf(TransportMode.TRAIN, messagePackHelper.getString(KEY_TRANSPORT_MODE));
        this.facingStart = this.getRailAngle(false);
        this.facingEnd = this.getRailAngle(true);
    }

    @Deprecated
    public Rail(class_2487 compoundTag) {
        this.h1 = compoundTag.method_10574(KEY_H_1);
        this.k1 = compoundTag.method_10574(KEY_K_1);
        this.h2 = compoundTag.method_10574(KEY_H_2);
        this.k2 = compoundTag.method_10574(KEY_K_2);
        this.r1 = compoundTag.method_10574(KEY_R_1);
        this.r2 = compoundTag.method_10574(KEY_R_2);
        this.tStart1 = compoundTag.method_10574(KEY_T_START_1);
        this.tEnd1 = compoundTag.method_10574(KEY_T_END_1);
        this.tStart2 = compoundTag.method_10574(KEY_T_START_2);
        this.tEnd2 = compoundTag.method_10574(KEY_T_END_2);
        this.yStart = compoundTag.method_10550(KEY_Y_START);
        this.yEnd = compoundTag.method_10550(KEY_Y_END);
        this.reverseT1 = compoundTag.method_10577(KEY_REVERSE_T_1);
        this.isStraight1 = compoundTag.method_10577(KEY_IS_STRAIGHT_1);
        this.reverseT2 = compoundTag.method_10577(KEY_REVERSE_T_2);
        this.isStraight2 = compoundTag.method_10577(KEY_IS_STRAIGHT_2);
        this.railType = EnumHelper.valueOf(RailType.IRON, compoundTag.method_10558(KEY_RAIL_TYPE));
        this.transportMode = EnumHelper.valueOf(TransportMode.TRAIN, compoundTag.method_10558(KEY_TRANSPORT_MODE));
        this.facingStart = this.getRailAngle(false);
        this.facingEnd = this.getRailAngle(true);
    }

    public Rail(class_2540 packet) {
        this.h1 = packet.readDouble();
        this.k1 = packet.readDouble();
        this.h2 = packet.readDouble();
        this.k2 = packet.readDouble();
        this.r1 = packet.readDouble();
        this.r2 = packet.readDouble();
        this.tStart1 = packet.readDouble();
        this.tEnd1 = packet.readDouble();
        this.tStart2 = packet.readDouble();
        this.tEnd2 = packet.readDouble();
        this.yStart = packet.readInt();
        this.yEnd = packet.readInt();
        this.reverseT1 = packet.readBoolean();
        this.isStraight1 = packet.readBoolean();
        this.reverseT2 = packet.readBoolean();
        this.isStraight2 = packet.readBoolean();
        this.railType = EnumHelper.valueOf(RailType.IRON, packet.method_10800(Short.MAX_VALUE));
        this.transportMode = EnumHelper.valueOf(TransportMode.TRAIN, packet.method_10800(Short.MAX_VALUE));
        this.facingStart = this.getRailAngle(false);
        this.facingEnd = this.getRailAngle(true);
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        messagePacker.packString(KEY_H_1).packDouble(this.h1);
        messagePacker.packString(KEY_K_1).packDouble(this.k1);
        messagePacker.packString(KEY_H_2).packDouble(this.h2);
        messagePacker.packString(KEY_K_2).packDouble(this.k2);
        messagePacker.packString(KEY_R_1).packDouble(this.r1);
        messagePacker.packString(KEY_R_2).packDouble(this.r2);
        messagePacker.packString(KEY_T_START_1).packDouble(this.tStart1);
        messagePacker.packString(KEY_T_END_1).packDouble(this.tEnd1);
        messagePacker.packString(KEY_T_START_2).packDouble(this.tStart2);
        messagePacker.packString(KEY_T_END_2).packDouble(this.tEnd2);
        messagePacker.packString(KEY_Y_START).packInt(this.yStart);
        messagePacker.packString(KEY_Y_END).packInt(this.yEnd);
        messagePacker.packString(KEY_REVERSE_T_1).packBoolean(this.reverseT1);
        messagePacker.packString(KEY_IS_STRAIGHT_1).packBoolean(this.isStraight1);
        messagePacker.packString(KEY_REVERSE_T_2).packBoolean(this.reverseT2);
        messagePacker.packString(KEY_IS_STRAIGHT_2).packBoolean(this.isStraight2);
        messagePacker.packString(KEY_RAIL_TYPE).packString(this.railType.toString());
        messagePacker.packString(KEY_TRANSPORT_MODE).packString(this.transportMode.toString());
    }

    @Override
    public int messagePackLength() {
        return 18;
    }

    @Override
    public void writePacket(class_2540 packet) {
        packet.writeDouble(this.h1);
        packet.writeDouble(this.k1);
        packet.writeDouble(this.h2);
        packet.writeDouble(this.k2);
        packet.writeDouble(this.r1);
        packet.writeDouble(this.r2);
        packet.writeDouble(this.tStart1);
        packet.writeDouble(this.tEnd1);
        packet.writeDouble(this.tStart2);
        packet.writeDouble(this.tEnd2);
        packet.writeInt(this.yStart);
        packet.writeInt(this.yEnd);
        packet.writeBoolean(this.reverseT1);
        packet.writeBoolean(this.isStraight1);
        packet.writeBoolean(this.reverseT2);
        packet.writeBoolean(this.isStraight2);
        packet.method_10814(this.railType.toString());
        packet.method_10814(this.transportMode.toString());
    }

    public class_243 getPosition(double rawValue) {
        double count1 = Math.abs(this.tEnd1 - this.tStart1);
        double count2 = Math.abs(this.tEnd2 - this.tStart2);
        double value = class_3532.method_15350((double)rawValue, (double)0.0, (double)(count1 + count2));
        double y = this.getPositionY(value);
        if (value <= count1) {
            return Rail.getPositionXZ(this.h1, this.k1, this.r1, (double)(this.reverseT1 ? -1 : 1) * value + this.tStart1, 0.0, this.isStraight1).method_1031(0.0, y, 0.0);
        }
        return Rail.getPositionXZ(this.h2, this.k2, this.r2, (double)(this.reverseT2 ? -1 : 1) * (value - count1) + this.tStart2, 0.0, this.isStraight2).method_1031(0.0, y, 0.0);
    }

    public double getLength() {
        return Math.abs(this.tEnd2 - this.tStart2) + Math.abs(this.tEnd1 - this.tStart1);
    }

    public void render(RenderRail callback, float offsetRadius1, float offsetRadius2) {
        this.renderSegment(this.h1, this.k1, this.r1, this.tStart1, this.tEnd1, 0.0, offsetRadius1, offsetRadius2, this.reverseT1, this.isStraight1, callback);
        this.renderSegment(this.h2, this.k2, this.r2, this.tStart2, this.tEnd2, Math.abs(this.tEnd1 - this.tStart1), offsetRadius1, offsetRadius2, this.reverseT2, this.isStraight2, callback);
    }

    public boolean goodRadius() {
        return (this.isStraight1 || this.r1 > 1.9999) && (this.isStraight2 || this.r2 > 1.9999);
    }

    public boolean isValid() {
        return (this.h1 != 0.0 || this.k1 != 0.0 || this.h2 != 0.0 || this.k2 != 0.0 || this.r1 != 0.0 || this.r2 != 0.0 || this.tStart1 != 0.0 || this.tStart2 != 0.0 || this.tEnd1 != 0.0 || this.tEnd2 != 0.0) && this.facingStart == this.getRailAngle(false) && this.facingEnd == this.getRailAngle(true);
    }

    private double getPositionY(double value) {
        double offsetValue;
        double yInitial;
        double yChange;
        double length = this.getLength();
        if (this.railType.railSlopeStyle == RailType.RailSlopeStyle.CABLE) {
            if (value < 0.5) {
                return this.yStart;
            }
            if (value > length - 0.5) {
                return this.yEnd;
            }
            double offsetValue2 = value - 0.5;
            double offsetLength = length - 1.0;
            double posY = (double)this.yStart + (double)(this.yEnd - this.yStart) * offsetValue2 / offsetLength;
            double dip = offsetLength * offsetLength / 4.0 / 1000.0;
            return posY + (dip > 8.0 ? 8.0 / dip : 1.0) * (offsetValue2 - offsetLength) * offsetValue2 / 1000.0;
        }
        double intercept = length / 2.0;
        if (value < intercept) {
            yChange = (double)(this.yEnd - this.yStart) / 2.0;
            yInitial = this.yStart;
            offsetValue = value;
        } else {
            yChange = (double)(this.yStart - this.yEnd) / 2.0;
            yInitial = this.yEnd;
            offsetValue = length - value;
        }
        return yChange * offsetValue * offsetValue / (intercept * intercept) + yInitial;
    }

    private static class_243 getPositionXZ(double h, double k, double r, double t, double radiusOffset, boolean isStraight) {
        if (isStraight) {
            return new class_243(h * t + k * ((Math.abs(h) >= 0.5 && Math.abs(k) >= 0.5 ? 0.0 : r) + radiusOffset) + 0.5, 0.0, k * t + h * (r - radiusOffset) + 0.5);
        }
        return new class_243(h + (r + radiusOffset) * Math.cos(t / r) + 0.5, 0.0, k + (r + radiusOffset) * Math.sin(t / r) + 0.5);
    }

    private void renderSegment(double h, double k, double r, double tStart, double tEnd, double rawValueOffset, float offsetRadius1, float offsetRadius2, boolean reverseT, boolean isStraight, RenderRail callback) {
        double count = Math.abs(tEnd - tStart);
        double increment = count / (double)Math.round(count);
        for (double i = 0.0; i < count - 0.1; i += increment) {
            double t1 = (double)(reverseT ? -1 : 1) * i + tStart;
            double t2 = (double)(reverseT ? -1 : 1) * (i + increment) + tStart;
            class_243 corner1 = Rail.getPositionXZ(h, k, r, t1, offsetRadius1, isStraight);
            class_243 corner2 = Rail.getPositionXZ(h, k, r, t1, offsetRadius2, isStraight);
            class_243 corner3 = Rail.getPositionXZ(h, k, r, t2, offsetRadius2, isStraight);
            class_243 corner4 = Rail.getPositionXZ(h, k, r, t2, offsetRadius1, isStraight);
            double y1 = this.getPositionY(i + rawValueOffset);
            double y2 = this.getPositionY(i + increment + rawValueOffset);
            callback.renderRail(corner1.field_1352, corner1.field_1350, corner2.field_1352, corner2.field_1350, corner3.field_1352, corner3.field_1350, corner4.field_1352, corner4.field_1350, y1, y2);
        }
    }

    private RailAngle getRailAngle(boolean getEnd) {
        double end;
        double start;
        if (getEnd) {
            start = this.getLength();
            end = start - 1.0E-4;
        } else {
            start = 0.0;
            end = 1.0E-4;
        }
        class_243 pos1 = this.getPosition(start);
        class_243 pos2 = this.getPosition(end);
        return RailAngle.fromAngle((float)Math.toDegrees(Math.atan2(pos2.field_1350 - pos1.field_1350, pos2.field_1352 - pos1.field_1352)));
    }

    private static double getTBounds(double x, double h, double z, double k, double r) {
        return class_3532.method_15349((double)(z - k), (double)(x - h)) * r;
    }

    private static double getTBounds(double x, double h, double z, double k, double r, double tStart, boolean reverse) {
        double t = Rail.getTBounds(x, h, z, k, r);
        if (t < tStart && !reverse) {
            return t + Math.PI * 2 * r;
        }
        if (t > tStart && reverse) {
            return t - Math.PI * 2 * r;
        }
        return t;
    }

    @FunctionalInterface
    public static interface RenderRail {
        public void renderRail(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19);
    }

    public static enum RailActionType {
        BRIDGE("percentage_complete_bridge", "rail_action_bridge", class_3620.field_15993),
        TUNNEL("percentage_complete_tunnel", "rail_action_tunnel", class_3620.field_15977),
        TUNNEL_WALL("percentage_complete_tunnel_wall", "rail_action_tunnel_wall", class_3620.field_15978);

        private final String progressTranslation;
        private final String nameTranslation;
        private final int color;

        private RailActionType(String progressTranslation, String nameTranslation, class_3620 materialColor) {
            this.progressTranslation = progressTranslation;
            this.nameTranslation = nameTranslation;
            this.color = materialColor.field_16011;
        }
    }

    public static class RailActions {
        private double distance;
        public final long id;
        private final class_1937 world;
        private final UUID uuid;
        private final String playerName;
        private final RailActionType railActionType;
        private final Rail rail;
        private final int radius;
        private final int height;
        private final double length;
        private final class_2680 state;
        private final boolean isSlab;
        private final Set<class_2338> blacklistedPos = new HashSet<class_2338>();
        private static final double INCREMENT = 0.01;

        public RailActions(class_1937 world, class_1657 player, RailActionType railActionType, Rail rail, int radius, int height, class_2680 state) {
            this.id = new Random().nextLong();
            this.world = world;
            this.uuid = player.method_5667();
            this.playerName = player.method_5477().getString();
            this.railActionType = railActionType;
            this.rail = rail;
            this.radius = radius;
            this.height = height;
            this.state = state;
            this.isSlab = state != null && state.method_26204() instanceof class_2482;
            this.length = rail.getLength();
            this.distance = 0.0;
        }

        public boolean build() {
            switch (this.railActionType) {
                case BRIDGE: {
                    return this.createBridge();
                }
                case TUNNEL: {
                    return this.createTunnel();
                }
                case TUNNEL_WALL: {
                    return this.createTunnelWall();
                }
            }
            return true;
        }

        public void writePacket(class_2540 packet) {
            packet.writeLong(this.id);
            packet.method_10814(this.playerName);
            packet.writeFloat(RailwayData.round(this.length, 1));
            packet.method_10814(this.state == null ? "" : this.state.method_26204().method_9539());
            packet.method_10814(this.railActionType.nameTranslation);
            packet.writeInt(this.railActionType.color);
        }

        private boolean createTunnel() {
            return this.create(true, editPos -> {
                class_2338 pos = RailwayData.newBlockPos(editPos);
                if (!this.blacklistedPos.contains(pos) && RailActions.canPlace(this.world, pos)) {
                    this.world.method_8501(pos, class_2246.field_10124.method_9564());
                    this.blacklistedPos.add(pos);
                }
            });
        }

        private boolean createTunnelWall() {
            return this.create(false, editPos -> {
                class_2338 pos = RailwayData.newBlockPos(editPos);
                if (!this.blacklistedPos.contains(pos) && RailActions.canPlace(this.world, pos)) {
                    this.world.method_8501(pos, this.state);
                    this.blacklistedPos.add(pos);
                }
            });
        }

        private boolean createBridge() {
            return this.create(false, editPos -> {
                boolean placeHalf;
                class_2680 placeState;
                class_2338 placePos;
                class_2338 pos = RailwayData.newBlockPos(editPos);
                boolean isTopHalf = editPos.field_1351 - Math.floor(editPos.field_1351) >= 0.5;
                this.blacklistedPos.add(RailActions.getHalfPos(pos, isTopHalf));
                if (this.isSlab && isTopHalf) {
                    placePos = pos;
                    placeState = (class_2680)this.state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
                    placeHalf = false;
                } else {
                    placePos = pos.method_10074();
                    placeState = this.isSlab ? (class_2680)this.state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679) : this.state;
                    placeHalf = true;
                }
                if (placePos != pos && RailActions.canPlace(this.world, pos)) {
                    this.world.method_8501(pos, class_2246.field_10124.method_9564());
                }
                if (!this.blacklistedPos.contains(RailActions.getHalfPos(placePos, placeHalf)) && RailActions.canPlace(this.world, placePos)) {
                    this.world.method_8501(placePos, placeState);
                }
            });
        }

        private boolean create(boolean includeMiddle, Consumer<class_243> consumer) {
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < 2L) {
                class_243 pos1 = this.rail.getPosition(this.distance);
                this.distance += 0.01;
                class_243 pos2 = this.rail.getPosition(this.distance);
                class_243 vec3 = new class_243(pos2.field_1352 - pos1.field_1352, 0.0, pos2.field_1350 - pos1.field_1350).method_1029().method_1024(1.5707964f);
                for (double x = (double)(-this.radius); x <= (double)this.radius; x += 0.01) {
                    boolean wholeNumber;
                    class_243 editPos = pos1.method_1019(vec3.method_18805(x, 0.0, x));
                    boolean bl = wholeNumber = Math.floor(editPos.field_1351) == Math.ceil(editPos.field_1351);
                    if (includeMiddle || Math.abs(x) > (double)this.radius - 0.01) {
                        for (int y = 0; y <= this.height; ++y) {
                            if (y >= this.height && wholeNumber) continue;
                            consumer.accept(editPos.method_1031(0.0, (double)y, 0.0));
                        }
                        continue;
                    }
                    consumer.accept(editPos.method_1031(0.0, (double)Math.max(0, wholeNumber ? this.height - 1 : this.height), 0.0));
                }
                if (!(this.length - this.distance < 0.01)) continue;
                this.showProgressMessage(100.0f);
                return true;
            }
            this.showProgressMessage(RailwayData.round(100.0 * this.distance / this.length, 1));
            return false;
        }

        private void showProgressMessage(float percentage) {
            class_1657 player = this.world.method_18470(this.uuid);
            if (player != null) {
                player.method_7353((class_2561)Text.translatable("gui.mtr." + this.railActionType.progressTranslation, Float.valueOf(percentage)), true);
            }
        }

        private static boolean canPlace(class_1937 world, class_2338 pos) {
            return world.method_8321(pos) == null && !(world.method_8320(pos).method_26204() instanceof BlockNode);
        }

        private static class_2338 getHalfPos(class_2338 pos, boolean isTopHalf) {
            return RailwayData.newBlockPos(pos.method_10263(), pos.method_10264() * 2 + (isTopHalf ? 1 : 0), pos.method_10260());
        }
    }
}

