/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mtr.MTR;
import mtr.Registry;
import mtr.block.BlockNode;
import mtr.data.DataCache;
import mtr.data.Depot;
import mtr.data.Lift;
import mtr.data.LiftServer;
import mtr.data.MessagePackHelper;
import mtr.data.Platform;
import mtr.data.Rail;
import mtr.data.RailType;
import mtr.data.RailwayDataCoolDownModule;
import mtr.data.RailwayDataDriveTrainModule;
import mtr.data.RailwayDataFileSaveModule;
import mtr.data.RailwayDataLoggingModule;
import mtr.data.RailwayDataPathGenerationModule;
import mtr.data.RailwayDataRailActionsModule;
import mtr.data.RailwayDataRouteFinderModule;
import mtr.data.Route;
import mtr.data.SavedRailBase;
import mtr.data.ScheduleEntry;
import mtr.data.SerializedDataBase;
import mtr.data.Siding;
import mtr.data.SignalBlocks;
import mtr.data.Station;
import mtr.data.TrainDelay;
import mtr.data.TrainServer;
import mtr.data.TransportMode;
import mtr.data.UpdateNearbyMovingObjects;
import mtr.mappings.PersistentStateMapper;
import mtr.mappings.Utilities;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiServer;
import mtr.packet.UpdateBlueMap;
import mtr.packet.UpdateDynmap;
import mtr.packet.UpdateSquaremap;
import mtr.path.PathData;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;

public class RailwayData
extends PersistentStateMapper
implements IPacket {
    public final Set<Station> stations = new HashSet<Station>();
    public final Set<Platform> platforms = new HashSet<Platform>();
    public final Set<Siding> sidings = new HashSet<Siding>();
    public final Set<Route> routes = new HashSet<Route>();
    public final Set<Depot> depots = new HashSet<Depot>();
    public final Set<LiftServer> lifts = new HashSet<LiftServer>();
    public final DataCache dataCache = new DataCache(this.stations, this.platforms, this.sidings, this.routes, this.depots, this.lifts);
    public final RailwayDataLoggingModule railwayDataLoggingModule;
    public final RailwayDataCoolDownModule railwayDataCoolDownModule;
    public final RailwayDataPathGenerationModule railwayDataPathGenerationModule;
    public final RailwayDataRailActionsModule railwayDataRailActionsModule;
    public final RailwayDataDriveTrainModule railwayDataDriveTrainModule;
    public final RailwayDataRouteFinderModule railwayDataRouteFinderModule;
    private int prevPlatformCount;
    private int prevSidingCount;
    private boolean useTimeAndWindSync;
    private final class_1937 world;
    private final Map<class_2338, Map<class_2338, Rail>> rails = new HashMap<class_2338, Map<class_2338, Rail>>();
    private final SignalBlocks signalBlocks = new SignalBlocks();
    private final RailwayDataFileSaveModule railwayDataFileSaveModule;
    private final List<Map<UUID, Long>> trainPositions = new ArrayList<Map<UUID, Long>>(2);
    private final Map<class_1657, class_2338> playerLastUpdatedPositions = new HashMap<class_1657, class_2338>();
    private final List<class_1657> playersToSyncSchedules = new ArrayList<class_1657>();
    private final UpdateNearbyMovingObjects<TrainServer> updateNearbyTrains;
    private final UpdateNearbyMovingObjects<LiftServer> updateNearbyLifts;
    private final Map<Long, List<ScheduleEntry>> schedulesForPlatform = new HashMap<Long, List<ScheduleEntry>>();
    private final Map<Long, Map<class_2338, TrainDelay>> trainDelays = new HashMap<Long, Map<class_2338, TrainDelay>>();
    private static final int RAIL_UPDATE_DISTANCE = 128;
    private static final int PLAYER_MOVE_UPDATE_THRESHOLD = 16;
    private static final int SCHEDULE_UPDATE_TICKS = 60;
    private static final int DATA_VERSION = 1;
    private static final String NAME = "mtr_train_data";
    private static final String KEY_RAW_MESSAGE_PACK = "raw_message_pack";
    private static final String KEY_DATA_VERSION = "mtr_data_version";
    private static final String KEY_STATIONS = "stations";
    private static final String KEY_PLATFORMS = "platforms";
    private static final String KEY_SIDINGS = "sidings";
    private static final String KEY_ROUTES = "routes";
    private static final String KEY_DEPOTS = "depots";
    private static final String KEY_LIFTS = "lifts";
    private static final String KEY_RAILS = "rails";
    private static final String KEY_SIGNAL_BLOCKS = "signal_blocks";
    private static final String KEY_USE_TIME_AND_WIND_SYNC = "use_time_and_wind_sync";

    public RailwayData(class_1937 world) {
        super(NAME);
        this.world = world;
        this.trainPositions.add(new HashMap());
        this.trainPositions.add(new HashMap());
        class_2960 dimensionLocation = world.method_27983().method_29177();
        Path savePath = ((class_3218)world).method_8503().method_27050(class_5218.field_24188).resolve("mtr").resolve(dimensionLocation.method_12836()).resolve(dimensionLocation.method_12832());
        this.railwayDataFileSaveModule = new RailwayDataFileSaveModule(this, world, this.rails, savePath, this.signalBlocks);
        this.railwayDataLoggingModule = new RailwayDataLoggingModule(this, world, this.rails, savePath);
        this.railwayDataPathGenerationModule = new RailwayDataPathGenerationModule(this, world, this.rails);
        this.railwayDataRailActionsModule = new RailwayDataRailActionsModule(this, world, this.rails);
        this.railwayDataCoolDownModule = new RailwayDataCoolDownModule(this, world, this.rails);
        this.railwayDataDriveTrainModule = new RailwayDataDriveTrainModule(this, world, this.rails);
        this.railwayDataRouteFinderModule = new RailwayDataRouteFinderModule(this, world, this.rails);
        this.updateNearbyTrains = new UpdateNearbyMovingObjects(PACKET_DELETE_TRAINS, PACKET_UPDATE_TRAINS);
        this.updateNearbyLifts = new UpdateNearbyMovingObjects(PACKET_DELETE_LIFTS, PACKET_UPDATE_LIFTS);
    }

    @Override
    public void load(class_2487 compoundTag) {
        if (compoundTag.method_10545(KEY_RAW_MESSAGE_PACK)) {
            try {
                MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker(compoundTag.method_10547(KEY_RAW_MESSAGE_PACK));
                int mapSize = messageUnpacker.unpackMapHeader();
                block33: for (int i = 0; i < mapSize; ++i) {
                    String key = messageUnpacker.unpackString();
                    if (key.equals(KEY_DATA_VERSION)) {
                        if (messageUnpacker.unpackInt() <= 1) continue;
                        throw new IllegalArgumentException("Unsupported data version");
                    }
                    int arraySize = messageUnpacker.unpackArrayHeader();
                    switch (key) {
                        case "stations": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.stations.add(new Station(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block33;
                        }
                        case "platforms": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.platforms.add(new Platform(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block33;
                        }
                        case "sidings": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.sidings.add(new Siding(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block33;
                        }
                        case "routes": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.routes.add(new Route(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block33;
                        }
                        case "depots": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.depots.add(new Depot(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block33;
                        }
                        case "lifts": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.lifts.add(new LiftServer(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block33;
                        }
                        case "rails": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                RailEntry railEntry = new RailEntry(RailwayData.readMessagePackSKMap(messageUnpacker));
                                this.rails.put(railEntry.pos, railEntry.connections);
                            }
                            continue block33;
                        }
                        case "signal_blocks": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.signalBlocks.signalBlocks.add(new SignalBlocks.SignalBlock(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block33;
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                class_2487 tagStations = compoundTag.method_10562(KEY_STATIONS);
                for (Object key : tagStations.method_10541()) {
                    this.stations.add(new Station(tagStations.method_10562((String)key)));
                }
                class_2487 tagNewPlatforms = compoundTag.method_10562(KEY_PLATFORMS);
                for (Object key : tagNewPlatforms.method_10541()) {
                    this.platforms.add(new Platform(tagNewPlatforms.method_10562((String)key)));
                }
                class_2487 tagNewSidings = compoundTag.method_10562(KEY_SIDINGS);
                for (Object key : tagNewSidings.method_10541()) {
                    this.sidings.add(new Siding(tagNewSidings.method_10562((String)key)));
                }
                class_2487 tagNewRoutes = compoundTag.method_10562(KEY_ROUTES);
                for (Object key : tagNewRoutes.method_10541()) {
                    this.routes.add(new Route(tagNewRoutes.method_10562((String)key)));
                }
                class_2487 tagNewDepots = compoundTag.method_10562(KEY_DEPOTS);
                for (Object key : tagNewDepots.method_10541()) {
                    this.depots.add(new Depot(tagNewDepots.method_10562((String)key)));
                }
                class_2487 tagNewRails = compoundTag.method_10562(KEY_RAILS);
                for (String key : tagNewRails.method_10541()) {
                    RailEntry railEntry = new RailEntry(tagNewRails.method_10562(key));
                    this.rails.put(railEntry.pos, railEntry.connections);
                }
                class_2487 tagNewSignalBlocks = compoundTag.method_10562(KEY_SIGNAL_BLOCKS);
                for (String key : tagNewSignalBlocks.method_10541()) {
                    this.signalBlocks.signalBlocks.add(new SignalBlocks.SignalBlock(tagNewSignalBlocks.method_10562(key)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.railwayDataFileSaveModule.load();
        this.validateData();
        this.dataCache.sync();
        this.signalBlocks.writeCache();
        this.useTimeAndWindSync = compoundTag.method_10577(KEY_USE_TIME_AND_WIND_SYNC);
        this.runRealTimeSync();
        try {
            UpdateDynmap.updateDynmap(this.world, this);
        }
        catch (IllegalStateException | NoClassDefFoundError ignored) {
            System.out.println("Dynamp is not loaded");
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            UpdateBlueMap.updateBlueMap(this.world, this);
        }
        catch (IllegalStateException | NoClassDefFoundError ignored) {
            System.out.println("BlueMap is not loaded");
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            UpdateSquaremap.updateSquaremap(this.world, this);
        }
        catch (IllegalStateException | NoClassDefFoundError ignored) {
            System.out.println("Squaremap is not loaded");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void method_17919(File file) {
        MinecraftServer minecraftServer = ((class_3218)this.world).method_8503();
        if (minecraftServer.method_3750() || !minecraftServer.method_3806()) {
            this.railwayDataFileSaveModule.fullSave();
        } else {
            this.railwayDataFileSaveModule.autoSave();
        }
        this.railwayDataLoggingModule.save();
        this.method_80();
        super.method_17919(file);
    }

    public class_2487 method_75(class_2487 compoundTag) {
        compoundTag.method_10556(KEY_USE_TIME_AND_WIND_SYNC, this.useTimeAndWindSync);
        return compoundTag;
    }

    public void simulateTrains() {
        List players = this.world.method_18456();
        players.forEach(player -> {
            class_2338 playerBlockPos = player.method_24515();
            class_243 playerPos = player.method_19538();
            if (!this.playerLastUpdatedPositions.containsKey(player) || this.playerLastUpdatedPositions.get(player).method_19455((class_2382)playerBlockPos) > 16) {
                HashMap<class_2338, Map> railsToAdd = new HashMap<class_2338, Map>();
                this.rails.forEach((startPos, blockPosRailMap) -> blockPosRailMap.forEach((endPos, rail) -> {
                    if (new class_238(startPos, endPos).method_1014(128.0).method_1006(playerPos)) {
                        if (!railsToAdd.containsKey(startPos)) {
                            railsToAdd.put((class_2338)startPos, new HashMap());
                        }
                        ((Map)railsToAdd.get(startPos)).put(endPos, rail);
                    }
                }));
                class_2540 packet = new class_2540(Unpooled.buffer());
                packet.writeInt(railsToAdd.size());
                railsToAdd.forEach((posStart, railMap) -> {
                    packet.method_10807(posStart);
                    packet.writeInt(railMap.size());
                    railMap.forEach((posEnd, rail) -> {
                        packet.method_10807(posEnd);
                        rail.writePacket(packet);
                    });
                });
                if (packet.readableBytes() <= 0x100000) {
                    Registry.sendToPlayer((class_3222)player, PACKET_WRITE_RAILS, packet);
                }
                this.playerLastUpdatedPositions.put((class_1657)player, playerBlockPos);
            }
        });
        this.updateNearbyTrains.startTick();
        this.trainPositions.remove(0);
        this.trainPositions.add(new HashMap());
        this.schedulesForPlatform.clear();
        this.signalBlocks.resetOccupied();
        this.sidings.forEach(siding -> {
            siding.setSidingData(this.world, this.dataCache.sidingIdToDepot.get(siding.id), this.rails);
            siding.simulateTrain(this.dataCache, this.railwayDataDriveTrainModule, this.trainPositions, this.signalBlocks, this.updateNearbyTrains.newDataSetInPlayerRange, this.updateNearbyTrains.dataSetToSync, this.schedulesForPlatform, this.trainDelays);
        });
        this.depots.forEach(depot -> depot.deployTrain(this, this.world));
        this.updateNearbyLifts.startTick();
        this.lifts.forEach(lift -> lift.tickServer(this.world, this.updateNearbyLifts.newDataSetInPlayerRange, this.updateNearbyLifts.dataSetToSync));
        this.railwayDataCoolDownModule.tick();
        this.railwayDataDriveTrainModule.tick();
        this.railwayDataRailActionsModule.tick();
        this.railwayDataRouteFinderModule.tick();
        this.updateNearbyTrains.tick();
        this.updateNearbyLifts.tick();
        if (MTR.isGameTickInterval(60)) {
            players.forEach(player -> {
                if (!this.playersToSyncSchedules.contains(player)) {
                    this.playersToSyncSchedules.add((class_1657)player);
                }
            });
        }
        if (!this.playersToSyncSchedules.isEmpty()) {
            class_1657 player2 = this.playersToSyncSchedules.remove(0);
            class_2338 playerBlockPos = player2.method_24515();
            class_243 playerPos = player2.method_19538();
            Set<Long> platformIds = this.platforms.stream().filter(platform -> {
                if (platform.isCloseToSavedRail(playerBlockPos, 16, 16, 16)) {
                    return true;
                }
                Station station = this.dataCache.platformIdToStation.get(platform.id);
                return station != null && station.inArea(playerBlockPos.method_10263(), playerBlockPos.method_10260());
            }).map(platform -> platform.id).collect(Collectors.toSet());
            HashSet railsToAdd = new HashSet();
            this.rails.forEach((startPos, blockPosRailMap) -> blockPosRailMap.forEach((endPos, rail) -> {
                if (new class_238(startPos, endPos).method_1014(128.0).method_1006(playerPos)) {
                    railsToAdd.add(PathData.getRailProduct(startPos, endPos));
                }
            }));
            HashMap<Long, Boolean> signalBlockStatus = new HashMap<Long, Boolean>();
            HashMap<UUID, Boolean> occupiedRails = new HashMap<UUID, Boolean>();
            railsToAdd.forEach(rail -> {
                this.signalBlocks.getSignalBlockStatus((Map<Long, Boolean>)signalBlockStatus, (UUID)rail);
                occupiedRails.put((UUID)rail, this.trainPositions.get(1).containsKey(rail));
            });
            if (!(platformIds.isEmpty() && signalBlockStatus.isEmpty() && occupiedRails.isEmpty())) {
                class_2540 packet = new class_2540(Unpooled.buffer());
                packet.writeInt(platformIds.size());
                platformIds.forEach(platformId -> {
                    packet.writeLong(platformId.longValue());
                    List<ScheduleEntry> scheduleEntries = this.schedulesForPlatform.get(platformId);
                    if (scheduleEntries == null) {
                        packet.writeInt(0);
                    } else {
                        packet.writeInt(scheduleEntries.size());
                        scheduleEntries.forEach(scheduleEntry -> scheduleEntry.writePacket(packet));
                    }
                });
                packet.writeInt(signalBlockStatus.size());
                signalBlockStatus.forEach((id, occupied) -> {
                    packet.writeLong(id.longValue());
                    packet.writeBoolean(occupied.booleanValue());
                });
                packet.writeInt(occupiedRails.size());
                occupiedRails.forEach((rail, occupied) -> {
                    packet.method_10797(rail);
                    packet.writeBoolean(occupied.booleanValue());
                });
                if (packet.readableBytes() <= 0x100000) {
                    Registry.sendToPlayer((class_3222)player2, PACKET_UPDATE_SCHEDULE, packet);
                }
            }
        }
        if (this.prevPlatformCount != this.platforms.size() || this.prevSidingCount != this.sidings.size()) {
            this.dataCache.sync();
        }
        this.prevPlatformCount = this.platforms.size();
        this.prevSidingCount = this.sidings.size();
        this.railwayDataFileSaveModule.autoSaveTick();
    }

    public void onPlayerJoin(class_3222 serverPlayer) {
        PacketTrainDataGuiServer.sendAllInChunks(serverPlayer, this.stations, this.platforms, this.sidings, this.routes, this.depots, this.lifts, this.signalBlocks);
        this.railwayDataCoolDownModule.onPlayerJoin(serverPlayer);
    }

    public long addRail(class_1657 player, TransportMode transportMode, class_2338 posStart, class_2338 posEnd, Rail rail, boolean validate) {
        long newId = validate ? new Random().nextLong() : 0L;
        RailwayData.addRail(this.rails, this.platforms, this.sidings, transportMode, posStart, posEnd, rail, newId);
        if (validate) {
            Rail backwardsRail = DataCache.tryGet(this.rails, posEnd, posStart);
            if (backwardsRail != null) {
                ArrayList<String> dataList = new ArrayList<String>();
                dataList.add(String.format("type:%s", rail.railType));
                dataList.add(String.format("one_way:%s", backwardsRail.railType == RailType.NONE));
                this.railwayDataLoggingModule.addEvent((class_3222)player, Rail.class, new ArrayList<String>(), dataList, posStart, posEnd);
            }
            this.validateData();
        }
        return newId;
    }

    public long addSignal(class_1657 player, class_1767 color, class_2338 posStart, class_2338 posEnd) {
        this.railwayDataLoggingModule.addEvent((class_3222)player, SignalBlocks.SignalBlock.class, new ArrayList<String>(), Collections.singletonList(String.format("color:%s", color)), posStart, posEnd);
        return this.signalBlocks.add(0L, color, PathData.getRailProduct(posStart, posEnd));
    }

    public void removeNode(class_1657 player, class_2338 pos, TransportMode transportMode) {
        this.railwayDataLoggingModule.addEvent((class_3222)player, BlockNode.class, Collections.singletonList(String.format("type:%s", new Object[]{transportMode})), new ArrayList<String>(), pos);
        RailwayData.removeNode(this.world, this.rails, pos);
        this.validateData();
        class_2540 packet = this.signalBlocks.getValidationPacket(this.rails);
        if (packet != null) {
            this.world.method_18456().forEach(player2 -> Registry.sendToPlayer((class_3222)player2, PACKET_REMOVE_SIGNALS, packet));
        }
    }

    public void removeRailConnection(class_1657 player, class_2338 pos1, class_2338 pos2) {
        Rail rail1 = DataCache.tryGet(this.rails, pos1, pos2);
        Rail rail2 = DataCache.tryGet(this.rails, pos2, pos1);
        if (rail1 != null && rail2 != null) {
            ArrayList<String> dataList = new ArrayList<String>();
            dataList.add(String.format("type:%s", (rail1.railType == RailType.NONE ? rail2 : rail1).railType));
            dataList.add(String.format("one_way:%s", (rail1.railType == RailType.NONE ? rail1 : rail2).railType == RailType.NONE));
            this.railwayDataLoggingModule.addEvent((class_3222)player, Rail.class, dataList, new ArrayList<String>(), pos1, pos2);
        }
        RailwayData.removeRailConnection(this.world, this.rails, pos1, pos2);
        this.validateData();
        class_2540 packet = this.signalBlocks.getValidationPacket(this.rails);
        if (packet != null) {
            this.world.method_18456().forEach(player2 -> Registry.sendToPlayer((class_3222)player2, PACKET_REMOVE_SIGNALS, packet));
        }
    }

    public void removeLiftFloorTrack(class_2338 pos) {
        RailwayData.removeLiftFloorTrack(this.world, this.lifts, pos);
        this.dataCache.sync();
    }

    public boolean hasSavedRail(class_2338 pos) {
        return this.rails.containsKey(pos) && this.rails.get(pos).values().stream().anyMatch(rail -> rail.railType.hasSavedRail);
    }

    public boolean containsRail(class_2338 pos1, class_2338 pos2) {
        return RailwayData.containsRail(this.rails, pos1, pos2);
    }

    public long removeSignal(class_1657 player, class_1767 color, class_2338 posStart, class_2338 posEnd) {
        this.railwayDataLoggingModule.addEvent((class_3222)player, SignalBlocks.SignalBlock.class, Collections.singletonList(String.format("color:%s", color)), new ArrayList<String>(), posStart, posEnd);
        return this.signalBlocks.remove(0L, color, PathData.getRailProduct(posStart, posEnd));
    }

    public void disconnectPlayer(class_1657 player) {
        this.railwayDataCoolDownModule.onPlayerDisconnect(player);
        this.playerLastUpdatedPositions.remove(player);
    }

    public void getSchedulesForStation(Map<Long, List<ScheduleEntry>> schedulesForStation, long stationId) {
        this.schedulesForPlatform.forEach((platformId, schedules) -> {
            Station station = this.dataCache.platformIdToStation.get(platformId);
            if (station != null && station.id == stationId) {
                schedulesForStation.put((Long)platformId, (List<ScheduleEntry>)schedules);
            }
        });
    }

    public List<ScheduleEntry> getSchedulesAtPlatform(long platformId) {
        return this.schedulesForPlatform.get(platformId);
    }

    public Map<Long, Map<class_2338, TrainDelay>> getTrainDelays() {
        return this.trainDelays;
    }

    public void resetTrainDelays(Depot depot) {
        depot.routeIds.forEach(this.trainDelays::remove);
    }

    public boolean getUseTimeAndWindSync() {
        return this.useTimeAndWindSync;
    }

    public void setUseTimeAndWindSync(boolean useTimeAndWindSync) {
        this.useTimeAndWindSync = useTimeAndWindSync;
        this.runRealTimeSync();
    }

    private void validateData() {
        RailwayData.removeSavedRailS2C(this.world, this.platforms, this.rails, PACKET_DELETE_PLATFORM);
        RailwayData.removeSavedRailS2C(this.world, this.sidings, this.rails, PACKET_DELETE_SIDING);
        ArrayList railsToRemove = new ArrayList();
        this.rails.forEach((startPos, railMap) -> railMap.forEach((endPos, rail) -> {
            if (rail.railType.hasSavedRail && SavedRailBase.isInvalidSavedRail(this.rails, endPos, startPos)) {
                railsToRemove.add(startPos);
                railsToRemove.add(endPos);
            }
        }));
        for (int i = 0; i < railsToRemove.size() - 1; i += 2) {
            RailwayData.removeRailConnection(null, this.rails, (class_2338)railsToRemove.get(i), (class_2338)railsToRemove.get(i + 1));
        }
    }

    private void runRealTimeSync() {
        MinecraftServer server;
        if (this.useTimeAndWindSync && (server = this.world.method_8503()) != null) {
            class_2168 commandSourceStack = server.method_3739();
            RailwayData.runCommand(server, commandSourceStack, "/gamerule doDaylightCycle true");
            RailwayData.runCommand(server, commandSourceStack, "/taw set-cycle-length " + this.world.method_27983().method_29177() + " 864000 864000");
            RailwayData.runCommand(server, commandSourceStack, "/taw reload");
            Calendar calendar = Calendar.getInstance();
            long ticks = Math.round((double)((calendar.get(11) + 24 - 6) * 1000) + (double)calendar.get(12) / 0.06 + (double)calendar.get(13) / 3.6) % 24000L;
            RailwayData.runCommand(server, commandSourceStack, "/time set " + ticks);
        }
    }

    public static Platform getPlatformByPos(Set<Platform> platforms, class_2338 pos) {
        try {
            return platforms.stream().filter(platform -> platform.containsPos(pos)).findFirst().orElse(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addRail(Map<class_2338, Map<class_2338, Rail>> rails, Set<Platform> platforms, Set<Siding> sidings, TransportMode transportMode, class_2338 posStart, class_2338 posEnd, Rail rail, long savedRailId) {
        try {
            if (!rails.containsKey(posStart)) {
                rails.put(posStart, new HashMap());
            }
            rails.get(posStart).put(posEnd, rail);
            if (savedRailId != 0L) {
                if (rail.railType == RailType.PLATFORM && platforms.stream().noneMatch(platform -> platform.containsPos(posStart) || platform.containsPos(posEnd))) {
                    platforms.add(new Platform(savedRailId, transportMode, posStart, posEnd));
                } else if (rail.railType == RailType.SIDING && sidings.stream().noneMatch(siding -> siding.containsPos(posStart) || siding.containsPos(posEnd))) {
                    sidings.add(new Siding(savedRailId, transportMode, posStart, posEnd, (int)Math.floor(rail.getLength())));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeNode(class_1937 world, Map<class_2338, Map<class_2338, Rail>> rails, class_2338 pos) {
        try {
            rails.remove(pos);
            rails.forEach((startPos, railMap) -> {
                railMap.remove(pos);
                if (railMap.isEmpty() && world != null) {
                    BlockNode.resetRailNode(world, startPos);
                }
            });
            if (world != null) {
                RailwayData.validateRails(world, rails);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T extends Lift> void removeLiftFloorTrack(class_1937 world, Set<T> lifts, class_2338 pos) {
        lifts.removeIf(lift -> lift.hasFloor(pos));
        if (world != null) {
            RailwayData.validateLifts(world, lifts);
        }
    }

    public static void removeRailConnection(class_1937 world, Map<class_2338, Map<class_2338, Rail>> rails, class_2338 pos1, class_2338 pos2) {
        try {
            if (rails.containsKey(pos1)) {
                rails.get(pos1).remove(pos2);
                if (rails.get(pos1).isEmpty() && world != null) {
                    BlockNode.resetRailNode(world, pos1);
                }
            }
            if (rails.containsKey(pos2)) {
                rails.get(pos2).remove(pos1);
                if (rails.get(pos2).isEmpty() && world != null) {
                    BlockNode.resetRailNode(world, pos2);
                }
            }
            if (world != null) {
                RailwayData.validateRails(world, rails);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean containsRail(Map<class_2338, Map<class_2338, Rail>> rails, class_2338 pos1, class_2338 pos2) {
        return rails.containsKey(pos1) && rails.get(pos1).containsKey(pos2);
    }

    public static Station getStation(Set<Station> stations, DataCache dataCache, class_2338 pos) {
        try {
            if (dataCache.blockPosToStation.containsKey(pos)) {
                return dataCache.blockPosToStation.get(pos);
            }
            return stations.stream().filter(station -> station.inArea(pos.method_10263(), pos.method_10260())).findFirst().orElse(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long getClosePlatformId(Set<Platform> platforms, DataCache dataCache, class_2338 pos) {
        return RailwayData.getClosePlatformId(platforms, dataCache, pos, 5, 0, 4);
    }

    public static long getClosePlatformId(Set<Platform> platforms, DataCache dataCache, class_2338 pos, int radius, int lower, int upper) {
        try {
            long posLong = pos.method_10063();
            if (dataCache.blockPosToPlatformId.containsKey(posLong)) {
                return dataCache.blockPosToPlatformId.get(posLong);
            }
            long platformId = 0L;
            int i = 1;
            while (i <= radius) {
                int searchRadius = i++;
                platformId = platforms.stream().filter(platform -> platform.isCloseToSavedRail(pos, searchRadius, lower, upper)).min(Comparator.comparingInt(platform -> platform.getMidPos().method_19455((class_2382)pos))).map(platform -> platform.id).orElse(0L);
                if (platformId != 0L) break;
            }
            dataCache.blockPosToPlatformId.put(posLong, platformId);
            return platformId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static boolean useRoutesAndStationsFromIndex(int stopIndex, List<Long> routeIds, DataCache dataCache, RouteAndStationsCallback routeAndStationsCallback) {
        if (stopIndex < 0) {
            return false;
        }
        int sum = 0;
        for (int i = 0; i < routeIds.size(); ++i) {
            Route nextRoute;
            Route thisRoute = dataCache.routeIdMap.get(routeIds.get(i));
            Route route = nextRoute = i < routeIds.size() - 1 && !dataCache.routeIdMap.get((Object)routeIds.get((int)(i + 1))).isHidden ? dataCache.routeIdMap.get(routeIds.get(i + 1)) : null;
            if (thisRoute == null) continue;
            int difference = stopIndex - sum;
            sum += thisRoute.platformIds.size();
            if (!thisRoute.platformIds.isEmpty() && nextRoute != null && !nextRoute.platformIds.isEmpty() && thisRoute.getLastPlatformId() == nextRoute.getFirstPlatformId()) {
                --sum;
            }
            if (stopIndex >= sum) continue;
            Station thisStation = dataCache.platformIdToStation.get(thisRoute.platformIds.get((int)difference).platformId);
            Station nextStation = difference < thisRoute.platformIds.size() - 1 ? dataCache.platformIdToStation.get(thisRoute.platformIds.get((int)(difference + 1)).platformId) : null;
            Station lastStation = thisRoute.platformIds.isEmpty() ? null : dataCache.platformIdToStation.get(thisRoute.getLastPlatformId());
            routeAndStationsCallback.routeAndStationsCallback(difference, thisRoute, nextRoute, thisStation, nextStation, lastStation);
            return true;
        }
        return false;
    }

    public static boolean isBetween(double value, double value1, double value2) {
        return RailwayData.isBetween(value, value1, value2, 0.0);
    }

    public static boolean isBetween(double value, double value1, double value2, double padding) {
        return value >= Math.min(value1, value2) - padding && value <= Math.max(value1, value2) + padding;
    }

    public static float round(double value, int decimalPlaces) {
        int factor = 1;
        for (int i = 0; i < decimalPlaces; ++i) {
            factor *= 10;
        }
        return (float)Math.round(value * (double)factor) / (float)factor;
    }

    public static void writeMessagePackDataset(MessagePacker messagePacker, Collection<? extends SerializedDataBase> dataSet, String key) throws IOException {
        messagePacker.packString(key);
        messagePacker.packArrayHeader(dataSet.size());
        for (SerializedDataBase serializedDataBase : dataSet) {
            messagePacker.packMapHeader(serializedDataBase.messagePackLength());
            serializedDataBase.toMessagePack(messagePacker);
        }
    }

    public static Map<String, Value> castMessagePackValueToSKMap(Value value) {
        Map<Object, Object> oldMap = value == null ? new HashMap() : value.asMapValue().map();
        HashMap<String, Value> resultMap = new HashMap<String, Value>(oldMap.size());
        oldMap.forEach((key, newValue) -> resultMap.put(key.asStringValue().asString(), (Value)newValue));
        return resultMap;
    }

    public static boolean hasNoPermission(class_3222 serverPlayer) {
        return !RailwayData.hasPermission(serverPlayer.field_13974.method_14257());
    }

    public static boolean hasPermission(class_1934 gameType) {
        return gameType == class_1934.field_9220 || gameType == class_1934.field_9215;
    }

    public static boolean chunkLoaded(class_1937 world, class_2338 pos) {
        return world.method_8398().method_21730(pos.method_10263() / 16, pos.method_10260() / 16) != null && world.method_8393(pos.method_10263() / 16, pos.method_10260() / 16);
    }

    public static String prettyPrint(JsonElement jsonElement) {
        return new GsonBuilder().setPrettyPrinting().create().toJson(jsonElement);
    }

    public static class_2338 newBlockPos(class_243 vec3) {
        return RailwayData.newBlockPos(vec3.field_1352, vec3.field_1351, vec3.field_1350);
    }

    public static class_2338 newBlockPos(double x, double y, double z) {
        return RailwayData.newBlockPos(class_3532.method_15357((double)x), class_3532.method_15357((double)y), class_3532.method_15357((double)z));
    }

    public static class_2338 newBlockPos(int x, int y, int z) {
        return new class_2338(x, y, z);
    }

    public static class_2338 offsetBlockPos(class_2338 pos, double x, double y, double z) {
        return x == 0.0 && y == 0.0 && z == 0.0 ? pos : RailwayData.newBlockPos((double)pos.method_10263() + x, (double)pos.method_10264() + y, (double)pos.method_10260() + z);
    }

    public static RailwayData getInstance(class_1937 world) {
        return RailwayData.getInstance(world, () -> new RailwayData(world), NAME);
    }

    public static void benchmark(Runnable runnable, float threshold) {
        long nanos = System.nanoTime();
        runnable.run();
        float duration = (float)(System.nanoTime() - nanos) / 1.0E9f;
        if (duration >= threshold) {
            System.out.println(duration);
        }
    }

    private static void validateRails(class_1937 world, Map<class_2338, Map<class_2338, Rail>> rails) {
        HashSet railsToRemove = new HashSet();
        HashSet railsNodesToRemove = new HashSet();
        rails.forEach((startPos, railMap) -> {
            boolean chunkLoaded = RailwayData.chunkLoaded(world, startPos);
            if (chunkLoaded && !(world.method_8320(startPos).method_26204() instanceof BlockNode)) {
                railsNodesToRemove.add(startPos);
            }
            if (railMap.isEmpty()) {
                railsToRemove.add(startPos);
            }
        });
        railsToRemove.forEach(rails::remove);
        railsNodesToRemove.forEach(pos -> RailwayData.removeNode(null, rails, pos));
    }

    private static <T extends Lift> void validateLifts(class_1937 world, Set<T> lifts) {
        lifts.removeIf(lift -> lift.isInvalidLift(world));
    }

    private static void removeSavedRailS2C(class_1937 world, Set<? extends SavedRailBase> savedRailBases, Map<class_2338, Map<class_2338, Rail>> rails, class_2960 packetId) {
        savedRailBases.removeIf(savedRailBase -> {
            boolean delete = savedRailBase.isInvalidSavedRail(rails);
            if (delete) {
                class_2540 packet = new class_2540(Unpooled.buffer());
                packet.writeLong(savedRailBase.id);
                world.method_18456().forEach(player -> Registry.sendToPlayer((class_3222)player, packetId, packet));
            }
            return delete;
        });
    }

    private static void runCommand(MinecraftServer server, class_2168 commandSourceStack, String command) {
        System.out.println("Running command " + command);
        Utilities.sendCommand(server, commandSourceStack, command);
    }

    private static Map<String, Value> readMessagePackSKMap(MessageUnpacker messageUnpacker) throws IOException {
        int size = messageUnpacker.unpackMapHeader();
        HashMap<String, Value> result = new HashMap<String, Value>(size);
        for (int i = 0; i < size; ++i) {
            result.put(messageUnpacker.unpackString(), messageUnpacker.unpackValue());
        }
        return result;
    }

    @Deprecated
    private static class RailEntry
    extends SerializedDataBase {
        public final class_2338 pos;
        public final Map<class_2338, Rail> connections;
        private static final String KEY_NODE_POS = "node_pos";
        private static final String KEY_RAIL_CONNECTIONS = "rail_connections";

        public RailEntry(class_2338 pos, Map<class_2338, Rail> connections) {
            this.pos = pos;
            this.connections = connections;
        }

        public RailEntry(class_2487 compoundTag) {
            this.pos = class_2338.method_10092((long)compoundTag.method_10537(KEY_NODE_POS));
            this.connections = new HashMap<class_2338, Rail>();
            class_2487 tagConnections = compoundTag.method_10562(KEY_RAIL_CONNECTIONS);
            for (String keyConnection : tagConnections.method_10541()) {
                this.connections.put(class_2338.method_10092((long)tagConnections.method_10562(keyConnection).method_10537(KEY_NODE_POS)), new Rail(tagConnections.method_10562(keyConnection)));
            }
        }

        public RailEntry(Map<String, Value> map) {
            MessagePackHelper messagePackHelper = new MessagePackHelper(map);
            this.pos = class_2338.method_10092((long)messagePackHelper.getLong(KEY_NODE_POS));
            this.connections = new HashMap<class_2338, Rail>();
            messagePackHelper.iterateArrayValue(KEY_RAIL_CONNECTIONS, value -> {
                Map<String, Value> mapSK = RailwayData.castMessagePackValueToSKMap(value);
                this.connections.put(class_2338.method_10092((long)new MessagePackHelper(mapSK).getLong(KEY_NODE_POS)), new Rail(mapSK));
            });
        }

        @Override
        public void toMessagePack(MessagePacker messagePacker) throws IOException {
            messagePacker.packString(KEY_NODE_POS).packLong(this.pos.method_10063());
            messagePacker.packString(KEY_RAIL_CONNECTIONS).packArrayHeader(this.connections.size());
            for (Map.Entry<class_2338, Rail> entry : this.connections.entrySet()) {
                class_2338 endNodePos = entry.getKey();
                messagePacker.packMapHeader(entry.getValue().messagePackLength() + 1);
                messagePacker.packString(KEY_NODE_POS).packLong(endNodePos.method_10063());
                entry.getValue().toMessagePack(messagePacker);
            }
        }

        @Override
        public int messagePackLength() {
            return 2;
        }

        @Override
        public void writePacket(class_2540 packet) {
        }
    }

    @FunctionalInterface
    public static interface RouteAndStationsCallback {
        public void routeAndStationsCallback(int var1, Route var2, Route var3, Station var4, Station var5, Station var6);
    }
}

