/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import mtr.Registry;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.RailwayDataModuleBase;
import mtr.data.Route;
import mtr.entity.EntitySeat;
import mtr.mappings.Utilities;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;

public class RailwayDataCoolDownModule
extends RailwayDataModuleBase {
    private final Map<class_1657, Integer> playerRidingCoolDown = new HashMap<class_1657, Integer>();
    private final Map<class_1657, Long> playerRidingRoute = new HashMap<class_1657, Long>();
    private final Map<class_1657, EntitySeat> playerSeats = new HashMap<class_1657, EntitySeat>();
    private final Map<class_1657, Integer> playerSeatCoolDowns = new HashMap<class_1657, Integer>();
    private final Map<class_1657, Integer> playerShiftCoolDowns = new HashMap<class_1657, Integer>();
    public static final int SHIFT_ACTIVATE_TICKS = 30;

    public RailwayDataCoolDownModule(RailwayData railwayData, class_1937 world, Map<class_2338, Map<class_2338, Rail>> rails) {
        super(railwayData, world, rails);
    }

    public void tick() {
        this.world.method_18456().forEach(player -> {
            EntitySeat seat;
            Integer seatCoolDownOld = this.playerSeatCoolDowns.get(player);
            EntitySeat seatOld = this.playerSeats.get(player);
            if (seatCoolDownOld == null || seatCoolDownOld <= 0 || Utilities.entityRemoved(seatOld)) {
                seat = new EntitySeat(this.world, player.method_23317(), player.method_23318(), player.method_23321());
                this.world.method_8649((class_1297)seat);
                seat.initialize((class_1657)player);
                this.playerSeats.put((class_1657)player, seat);
                this.playerSeatCoolDowns.put((class_1657)player, 3);
            } else {
                seat = this.playerSeats.get(player);
                this.playerSeatCoolDowns.put((class_1657)player, this.playerSeatCoolDowns.get(player) - 1);
            }
            seat.updateSeatByRailwayData((class_1657)player);
            int oldShiftCoolDown = this.playerShiftCoolDowns.getOrDefault(player, 0);
            int shiftCoolDown = player.method_5715() ? Math.min(30, oldShiftCoolDown + 1) : 0;
            if (shiftCoolDown != oldShiftCoolDown) {
                this.playerShiftCoolDowns.put((class_1657)player, shiftCoolDown);
            }
        });
        HashSet playersToRemove = new HashSet();
        this.playerRidingCoolDown.forEach((player, coolDown) -> {
            if (coolDown <= 0) {
                this.updatePlayerRiding((class_1657)player, 0L);
                playersToRemove.add(player);
                player.method_5848();
            }
            this.playerRidingCoolDown.put((class_1657)player, coolDown - 1);
        });
        playersToRemove.forEach(player -> {
            this.playerRidingCoolDown.remove(player);
            this.playerRidingRoute.remove(player);
        });
    }

    public void onPlayerJoin(class_3222 serverPlayer) {
        this.playerRidingCoolDown.put((class_1657)serverPlayer, 2);
        this.playerShiftCoolDowns.put((class_1657)serverPlayer, 0);
    }

    public void onPlayerDisconnect(class_1657 player) {
        this.playerSeats.remove(player);
        this.playerSeatCoolDowns.remove(player);
        this.playerShiftCoolDowns.remove(player);
    }

    public void updatePlayerRiding(class_1657 player, long routeId) {
        boolean isRiding = routeId != 0L;
        player.field_6017 = 0.0f;
        player.method_5875(isRiding);
        player.field_5960 = isRiding;
        if (isRiding) {
            Utilities.getAbilities((class_1657)player).field_7478 = true;
            this.playerRidingCoolDown.put(player, 2);
            this.playerRidingRoute.put(player, routeId);
        } else {
            ((class_3222)player).field_13974.method_14257().method_8382(Utilities.getAbilities(player));
        }
        Registry.setInTeleportationState(player, isRiding);
    }

    public void updatePlayerSeatCoolDown(class_1657 player) {
        this.playerSeatCoolDowns.put(player, 3);
    }

    public boolean canRide(class_1657 player) {
        return !this.playerRidingCoolDown.containsKey(player);
    }

    public Route getRidingRoute(class_1657 player) {
        if (this.playerRidingRoute.containsKey(player)) {
            return this.railwayData.dataCache.routeIdMap.get(this.playerRidingRoute.get(player));
        }
        return null;
    }

    public void moveSeat(class_1657 player, double x, double y, double z) {
        EntitySeat entitySeat = this.playerSeats.get(player);
        if (entitySeat != null) {
            player.method_5804((class_1297)entitySeat);
            entitySeat.method_5814(x, y, z);
        }
    }

    public boolean shouldDismount(class_1657 player) {
        return this.playerShiftCoolDowns.getOrDefault(player, 0) == 30;
    }
}

