/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.RailwayDataModuleBase;
import mtr.data.TrainServer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;

public class RailwayDataDriveTrainModule
extends RailwayDataModuleBase {
    private final Set<UUID> acceleratePlayers = new HashSet<UUID>();
    private final Set<UUID> brakePlayers = new HashSet<UUID>();
    private final Set<UUID> doorsPlayers = new HashSet<UUID>();

    public RailwayDataDriveTrainModule(RailwayData railwayData, class_1937 world, Map<class_2338, Map<class_2338, Rail>> rails) {
        super(railwayData, world, rails);
    }

    public void tick() {
        this.acceleratePlayers.clear();
        this.brakePlayers.clear();
        this.doorsPlayers.clear();
    }

    public void drive(class_3222 player, boolean pressingAccelerate, boolean pressingBrake, boolean pressingDoors) {
        if (pressingAccelerate) {
            this.acceleratePlayers.add(player.method_5667());
        }
        if (pressingBrake) {
            this.brakePlayers.add(player.method_5667());
        }
        if (pressingDoors) {
            this.doorsPlayers.add(player.method_5667());
        }
    }

    public boolean drive(TrainServer trainServer) {
        boolean dirty = false;
        for (UUID ridingEntity : trainServer.ridingEntities) {
            if (this.acceleratePlayers.contains(ridingEntity) && trainServer.changeManualSpeed(true)) {
                dirty = true;
            } else if (this.brakePlayers.contains(ridingEntity) && trainServer.changeManualSpeed(false)) {
                dirty = true;
            }
            if (!this.doorsPlayers.contains(ridingEntity) || !trainServer.toggleDoors()) continue;
            dirty = true;
        }
        return dirty;
    }
}

