/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import com.google.gson.JsonParser;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import mtr.data.IGui;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.RailwayDataModuleBase;
import mtr.data.SerializedDataBase;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_3222;

public class RailwayDataLoggingModule
extends RailwayDataModuleBase {
    private final Path logsPath;
    private final Path filePath;
    private final List<String> queuedEvents = new ArrayList<String>();

    public RailwayDataLoggingModule(RailwayData railwayData, class_1937 world, Map<class_2338, Map<class_2338, Rail>> rails, Path savePath) {
        super(railwayData, world, rails);
        this.logsPath = savePath.resolve("logs");
        this.filePath = this.logsPath.resolve(new SimpleDateFormat("yyyyMMdd-HHmmssSSS").format(new Date()) + ".csv");
    }

    public void save() {
        if (!this.queuedEvents.isEmpty()) {
            try {
                if (!Files.exists(this.filePath, new LinkOption[0])) {
                    Files.createDirectories(this.logsPath, new FileAttribute[0]);
                    this.queuedEvents.add(0, String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "Timestamp", "Player Name", "Player UUID", "Class", "ID", "Name", "Position", "Change", "Old Data", "New Data"));
                    Files.write(this.filePath, this.queuedEvents, new OpenOption[0]);
                } else {
                    Files.write(this.filePath, this.queuedEvents, StandardOpenOption.APPEND);
                }
                this.queuedEvents.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addEvent(class_3222 player, Class<?> dataClass, List<String> oldData, List<String> newData, class_2338 ... positions) {
        this.addEvent(player, dataClass, 0L, "", oldData, newData, positions);
    }

    public void addEvent(class_3222 player, Class<?> dataClass, long id, String name, List<String> oldData, List<String> newData, class_2338 ... positions) {
        List<String> newDataDiff;
        List<String> oldDataDiff;
        if (oldData.size() == newData.size()) {
            oldDataDiff = new ArrayList<String>();
            newDataDiff = new ArrayList<String>();
            for (int i = 0; i < oldData.size(); ++i) {
                String newDataString;
                String oldDataString = oldData.get(i);
                if (oldDataString.equals(newDataString = newData.get(i))) continue;
                oldDataDiff.add(oldDataString);
                newDataDiff.add(newDataString);
            }
        } else {
            oldDataDiff = oldData;
            newDataDiff = newData;
        }
        ArrayList<String> positionsList = new ArrayList<String>();
        for (class_2338 pos : positions) {
            if (pos == null) continue;
            positionsList.add(String.format("(%s, %s, %s)", pos.method_10263(), pos.method_10264(), pos.method_10260()));
        }
        Collections.sort(positionsList);
        if (!oldDataDiff.isEmpty() || !newDataDiff.isEmpty()) {
            this.queuedEvents.add(String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", RailwayDataLoggingModule.formatString(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(new Date())), RailwayDataLoggingModule.formatString(player.method_5477().getString()), RailwayDataLoggingModule.formatString(player.method_5667().toString()), RailwayDataLoggingModule.formatString(dataClass.getName()), RailwayDataLoggingModule.formatString(id == 0L ? "" : String.format("[%s]", id)), RailwayDataLoggingModule.formatString(IGui.formatStationName(name)), RailwayDataLoggingModule.formatString(String.join((CharSequence)"\n", positionsList)), RailwayDataLoggingModule.formatString((oldDataDiff.isEmpty() ? LoggingEditType.CREATE : (newDataDiff.isEmpty() ? LoggingEditType.DELETE : LoggingEditType.EDIT)).toString()), RailwayDataLoggingModule.formatString(RailwayData.prettyPrint(new JsonParser().parse(String.format("{%s}", String.join((CharSequence)",", oldDataDiff))))), RailwayDataLoggingModule.formatString(RailwayData.prettyPrint(new JsonParser().parse(String.format("{%s}", String.join((CharSequence)",", newDataDiff)))))));
        }
    }

    /*
     * Exception decompiling
     */
    public static <T extends SerializedDataBase> List<String> getData(T data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> getData(class_2487 compoundTag) {
        ArrayList<String> dataList = new ArrayList<String>();
        compoundTag.method_10541().forEach(key -> {
            String value = RailwayDataLoggingModule.convertTag(compoundTag.method_10580(key));
            if (value != null) {
                dataList.add(String.format("%s:%s", key, value));
            }
        });
        return dataList;
    }

    private static String convertTag(class_2520 tag) {
        if (tag instanceof class_2483) {
            ArrayList valueTags = new ArrayList();
            ((class_2483)tag).forEach(data -> valueTags.add(RailwayDataLoggingModule.convertTag(data)));
            return String.format("[%s]", String.join((CharSequence)",", valueTags));
        }
        if (tag != null) {
            String tempValue = tag.method_10714();
            if (tempValue.equals("0b")) {
                return String.valueOf(false);
            }
            if (tempValue.equals("1b")) {
                return String.valueOf(true);
            }
            if (tag instanceof class_2514) {
                return ((class_2514)tag).method_10702().toString();
            }
            return tempValue.isEmpty() ? "\"\"" : tempValue;
        }
        return null;
    }

    private static String formatString(String text) {
        return String.format("\"%s\"", text.replace("\"", "\"\""));
    }

    private static enum LoggingEditType {
        CREATE,
        EDIT,
        DELETE;

    }
}

