/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.HashMap;
import java.util.Map;
import mtr.data.Depot;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.RailwayDataModuleBase;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.server.MinecraftServer;

public class RailwayDataPathGenerationModule
extends RailwayDataModuleBase {
    private final Map<Long, Thread> generatingPathThreads = new HashMap<Long, Thread>();

    public RailwayDataPathGenerationModule(RailwayData railwayData, class_1937 world, Map<class_2338, Map<class_2338, Rail>> rails) {
        super(railwayData, world, rails);
    }

    public void generatePath(MinecraftServer minecraftServer, long depotId) {
        this.generatingPathThreads.keySet().removeIf(id -> !this.generatingPathThreads.get(id).isAlive());
        Depot depot = this.railwayData.dataCache.depotIdMap.get(depotId);
        if (depot != null) {
            if (this.generatingPathThreads.containsKey(depotId)) {
                this.generatingPathThreads.get(depotId).interrupt();
                System.out.println("Restarting path generation" + (String)(depot.name.isEmpty() ? "" : " for " + depot.name));
            } else {
                System.out.println("Starting path generation" + (String)(depot.name.isEmpty() ? "" : " for " + depot.name));
            }
            depot.generateMainRoute(minecraftServer, this.world, this.railwayData.dataCache, this.rails, this.railwayData.sidings, thread -> this.generatingPathThreads.put(depotId, (Thread)thread));
            this.railwayData.resetTrainDelays(depot);
        } else {
            PacketTrainDataGuiServer.generatePathS2C(this.world, depotId, 0);
            System.out.println("Failed to generate path, depot is null");
        }
    }
}

