/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.RailwayDataModuleBase;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class RailwayDataRailActionsModule
extends RailwayDataModuleBase {
    private final List<Rail.RailActions> railActions = new ArrayList<Rail.RailActions>();

    public RailwayDataRailActionsModule(RailwayData railwayData, class_1937 world, Map<class_2338, Map<class_2338, Rail>> rails) {
        super(railwayData, world, rails);
    }

    public void tick() {
        if (!this.railActions.isEmpty() && this.railActions.get(0).build()) {
            this.railActions.remove(0);
            PacketTrainDataGuiServer.updateRailActionsS2C(this.world, this.railActions);
        }
    }

    public boolean markRailForBridge(class_1657 player, class_2338 pos1, class_2338 pos2, int radius, class_2680 state) {
        if (this.railwayData.containsRail(pos1, pos2)) {
            this.railActions.add(new Rail.RailActions(this.world, player, Rail.RailActionType.BRIDGE, (Rail)((Map)this.rails.get(pos1)).get(pos2), radius, 0, state));
            PacketTrainDataGuiServer.updateRailActionsS2C(this.world, this.railActions);
            return true;
        }
        return false;
    }

    public boolean markRailForTunnel(class_1657 player, class_2338 pos1, class_2338 pos2, int radius, int height) {
        if (this.railwayData.containsRail(pos1, pos2)) {
            this.railActions.add(new Rail.RailActions(this.world, player, Rail.RailActionType.TUNNEL, (Rail)((Map)this.rails.get(pos1)).get(pos2), radius, height, null));
            PacketTrainDataGuiServer.updateRailActionsS2C(this.world, this.railActions);
            return true;
        }
        return false;
    }

    public boolean markRailForTunnelWall(class_1657 player, class_2338 pos1, class_2338 pos2, int radius, int height, class_2680 state) {
        if (this.railwayData.containsRail(pos1, pos2)) {
            this.railActions.add(new Rail.RailActions(this.world, player, Rail.RailActionType.TUNNEL_WALL, (Rail)((Map)this.rails.get(pos1)).get(pos2), radius + 1, height + 1, state));
            PacketTrainDataGuiServer.updateRailActionsS2C(this.world, this.railActions);
            return true;
        }
        return false;
    }

    public void removeRailAction(long id) {
        this.railActions.removeIf(railAction -> railAction.id == id);
        PacketTrainDataGuiServer.updateRailActionsS2C(this.world, this.railActions);
    }
}

