/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import mtr.data.DataCache;
import mtr.data.Depot;
import mtr.data.Platform;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.RailwayDataModuleBase;
import mtr.data.ScheduleEntry;
import mtr.data.Station;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class RailwayDataRouteFinderModule
extends RailwayDataModuleBase {
    private Long2ObjectOpenHashMap<Long2IntOpenHashMap> connectionDensityOld = new Long2ObjectOpenHashMap();
    private Long2ObjectOpenHashMap<Long2IntOpenHashMap> connectionDensity = new Long2ObjectOpenHashMap();
    private class_2338 startPos;
    private class_2338 endPos;
    private RouteFinderRequest currentRouteFinderRequest;
    private int totalTime;
    private int count;
    private long startMillis;
    private TickStage tickStage = TickStage.GET_POS;
    private final RailwayData railwayData;
    private final Long2IntOpenHashMap globalBlacklist = new Long2IntOpenHashMap();
    private final Long2IntOpenHashMap localBlacklist = new Long2IntOpenHashMap();
    private final List<RouteFinderData> tempData = new ArrayList<RouteFinderData>();
    private final LongAVLTreeSet platformPositions = new LongAVLTreeSet();
    private final List<RouteFinderData> data = new ArrayList<RouteFinderData>();
    private final List<RouteFinderRequest> routeFinderQueue = new ArrayList<RouteFinderRequest>();
    private static final int MAX_REQUESTS = 10;
    private static final int WALKING_SPEED_TICKS_PER_METER = 5;
    private static final boolean DEBUG_DISABLE_DENSITY = false;

    public RailwayDataRouteFinderModule(RailwayData railwayData, class_1937 world, Map<class_2338, Map<class_2338, Rail>> rails) {
        super(railwayData, world, rails);
        this.railwayData = railwayData;
    }

    public void tick() {
        int platformCount = this.railwayData.dataCache.platformConnections.size();
        if (platformCount < 4) {
            return;
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)(this.currentRouteFinderRequest == null ? 2 : this.currentRouteFinderRequest.maxTickTime)) {
            switch (this.tickStage) {
                case GET_POS: {
                    if (this.routeFinderQueue.isEmpty()) {
                        Random random = new Random();
                        int shortestDistance = Integer.MAX_VALUE;
                        class_2338 tempStartPos = null;
                        class_2338 tempEndPos = null;
                        this.currentRouteFinderRequest = null;
                        ArrayList platformConnectionKeys = new ArrayList(this.railwayData.dataCache.platformConnections.keySet());
                        for (int i = 0; i <= Math.min(200, platformCount * platformCount / 10000); ++i) {
                            class_2338 tempEndPos2;
                            int endIndex;
                            int startIndex;
                            while ((startIndex = random.nextInt(platformCount)) == (endIndex = random.nextInt(platformCount))) {
                            }
                            class_2338 tempStartPos2 = class_2338.method_10092((long)((Long)platformConnectionKeys.get(startIndex)));
                            int tempDistance = tempStartPos2.method_19455((class_2382)(tempEndPos2 = class_2338.method_10092((long)((Long)platformConnectionKeys.get(endIndex)))));
                            if (tempDistance >= shortestDistance) continue;
                            shortestDistance = tempDistance;
                            tempStartPos = tempStartPos2;
                            tempEndPos = tempEndPos2;
                        }
                        this.startPos = tempStartPos;
                        this.endPos = tempEndPos;
                    } else {
                        this.currentRouteFinderRequest = this.routeFinderQueue.remove(0);
                        this.startPos = this.currentRouteFinderRequest.startPos;
                        this.endPos = this.currentRouteFinderRequest.endPos;
                    }
                    this.globalBlacklist.clear();
                    this.startMillis = System.currentTimeMillis();
                    this.totalTime = Integer.MAX_VALUE;
                    this.tickStage = TickStage.START_FIND_ROUTE;
                    break;
                }
                case START_FIND_ROUTE: {
                    this.tempData.clear();
                    this.platformPositions.clear();
                    this.platformPositions.addAll((LongCollection)this.railwayData.dataCache.platformConnections.keySet());
                    this.platformPositions.add(this.endPos.method_10063());
                    this.localBlacklist.clear();
                    this.tickStage = TickStage.FIND_ROUTE;
                    break;
                }
                case FIND_ROUTE: {
                    if (this.startPos == null || this.endPos == null) {
                        this.tickStage = TickStage.GET_POS;
                        break;
                    }
                    if (!this.findRoutePart()) break;
                    this.tickStage = TickStage.END_FIND_ROUTE;
                    break;
                }
                case END_FIND_ROUTE: {
                    if (this.tempData.isEmpty()) {
                        for (int i = 0; i < this.data.size() - 1; ++i) {
                            DataCache.put2(this.connectionDensity, this.data.get((int)i).pos.method_10063(), this.data.get((int)(i + 1)).pos.method_10063(), oldValue -> oldValue == null ? 1 : oldValue + 1);
                        }
                        ++this.count;
                        if (this.count >= this.getMaxCount()) {
                            this.connectionDensityOld = this.connectionDensity;
                            this.connectionDensity = new Long2ObjectOpenHashMap();
                            this.count = 0;
                        }
                        if (this.currentRouteFinderRequest != null) {
                            ArrayList<RouteFinderData> newDataList = new ArrayList<RouteFinderData>();
                            for (RouteFinderData routeFinderData : this.data) {
                                RouteFinderData.append(newDataList, routeFinderData, this.railwayData);
                            }
                            this.currentRouteFinderRequest.callback.accept(newDataList, (int)(System.currentTimeMillis() - this.startMillis));
                        }
                        this.tickStage = TickStage.GET_POS;
                        break;
                    }
                    int elapsedTime = this.tempData.stream().mapToInt(data -> data.duration).sum();
                    if (elapsedTime > 0 && elapsedTime < this.totalTime) {
                        this.totalTime = elapsedTime;
                        this.data.clear();
                        this.data.addAll(this.tempData);
                    }
                    this.tickStage = TickStage.START_FIND_ROUTE;
                }
            }
        }
    }

    public boolean findRoute(class_2338 posStart, class_2338 posEnd, int maxTickTime, BiConsumer<List<RouteFinderData>, Integer> callback) {
        if (this.routeFinderQueue.size() < 10) {
            this.routeFinderQueue.add(new RouteFinderRequest(posStart, posEnd, maxTickTime, callback));
            this.tickStage = TickStage.GET_POS;
            return true;
        }
        return false;
    }

    public int getConnectionDensity(class_2338 posStart, class_2338 posEnd) {
        return DataCache.tryGet2(this.connectionDensityOld, posStart.method_10063(), posEnd.method_10063(), this.count == 0 ? 0 : DataCache.tryGet2(this.connectionDensity, posStart.method_10063(), posEnd.method_10063(), 0) * this.getMaxCount() / this.count);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean findRoutePart() {
        int elapsedTime = this.tempData.stream().mapToInt(data -> data.duration).sum();
        class_2338 prevPos = this.tempData.isEmpty() ? this.startPos : this.tempData.get((int)(this.tempData.size() - 1)).pos;
        class_2338 bestPosition = null;
        float bestIncrease = -3.4028235E38f;
        int bestDuration = 0;
        long bestRouteId = 0L;
        int bestWaitingTime = 0;
        LongBidirectionalIterator longBidirectionalIterator = this.platformPositions.iterator();
        while (longBidirectionalIterator.hasNext()) {
            List<ScheduleEntry> scheduleEntries;
            long thisPosLong = (Long)longBidirectionalIterator.next();
            ConnectionDetails connectionDetails = DataCache.tryGet(this.railwayData.dataCache.platformConnections, prevPos.method_10063(), thisPosLong);
            class_2338 thisPos = class_2338.method_10092((long)thisPosLong);
            int duration = prevPos.method_19455((class_2382)thisPos) * 5;
            long routeId = 0L;
            int waitingTime = 0;
            if (connectionDetails != null && this.verifyTime(thisPosLong, elapsedTime + connectionDetails.shortestDuration) && (scheduleEntries = this.railwayData.getSchedulesAtPlatform(connectionDetails.platformStart.id)) != null) {
                int lastDeparture = Integer.MIN_VALUE;
                for (ScheduleEntry scheduleEntry : scheduleEntries) {
                    if (!connectionDetails.durationInfo.containsKey(scheduleEntry.routeId)) continue;
                    int delay = (int)((scheduleEntry.arrivalMillis - this.startMillis) / 50L - (long)elapsedTime);
                    int newDuration = connectionDetails.durationInfo.get(scheduleEntry.routeId) + delay;
                    lastDeparture = Math.max(lastDeparture, delay);
                    if (delay <= -100 || newDuration >= duration) continue;
                    duration = newDuration;
                    routeId = scheduleEntry.routeId;
                    waitingTime = Math.max(0, delay);
                    lastDeparture = 0;
                }
                if (lastDeparture > Integer.MIN_VALUE && lastDeparture < 0) {
                    for (Map.Entry entry : connectionDetails.durationInfo.entrySet()) {
                        Depot depot = this.railwayData.dataCache.routeIdToOneDepot.get(entry.getKey());
                        if (depot == null) continue;
                        int delay = depot.getMillisUntilDeploy(1, -lastDeparture * 50 - 100) / 50;
                        int newDuration = (Integer)entry.getValue() + delay;
                        if (delay < 0 || newDuration >= duration) continue;
                        duration = newDuration;
                        routeId = (Long)entry.getKey();
                        waitingTime = Math.max(0, delay - 100);
                    }
                }
            }
            if (!this.verifyTime(thisPosLong, elapsedTime + duration)) continue;
            float increase = (float)(prevPos.method_19455((class_2382)this.endPos) - thisPos.method_19455((class_2382)this.endPos)) / (float)duration;
            this.globalBlacklist.put(thisPosLong, elapsedTime + duration);
            if (!(increase > bestIncrease)) continue;
            bestPosition = thisPos;
            bestIncrease = increase;
            bestDuration = duration;
            bestRouteId = routeId;
            bestWaitingTime = waitingTime;
        }
        if (bestPosition == null || bestDuration == 0) {
            if (this.tempData.isEmpty()) return true;
            this.tempData.remove(this.tempData.size() - 1);
        } else {
            this.localBlacklist.put(bestPosition.method_10063(), elapsedTime + bestDuration);
            this.tempData.add(new RouteFinderData(bestPosition, bestDuration, bestRouteId, bestWaitingTime));
        }
        if (this.tempData.isEmpty()) return false;
        if (!this.tempData.get((int)(this.tempData.size() - 1)).pos.equals((Object)this.endPos)) return false;
        return true;
    }

    private boolean verifyTime(long posLong, int time) {
        return time < this.totalTime && RailwayDataRouteFinderModule.compareBlacklist(this.localBlacklist, posLong, time, false) && RailwayDataRouteFinderModule.compareBlacklist(this.globalBlacklist, posLong, time, true);
    }

    private int getMaxCount() {
        return this.railwayData.dataCache.platformConnections.size() * 100;
    }

    private static boolean compareBlacklist(Long2IntOpenHashMap blacklist, long posLong, int time, boolean lessThanOrEqualTo) {
        return !blacklist.containsKey(posLong) || (lessThanOrEqualTo ? time <= blacklist.get(posLong) : time < blacklist.get(posLong));
    }

    private static enum TickStage {
        GET_POS,
        START_FIND_ROUTE,
        FIND_ROUTE,
        END_FIND_ROUTE;

    }

    private static class RouteFinderRequest {
        private final class_2338 startPos;
        private final class_2338 endPos;
        private final int maxTickTime;
        private final BiConsumer<List<RouteFinderData>, Integer> callback;

        private RouteFinderRequest(class_2338 startPos, class_2338 endPos, int maxTickTime, BiConsumer<List<RouteFinderData>, Integer> callback) {
            this.startPos = startPos;
            this.endPos = endPos;
            this.maxTickTime = Math.max(2, maxTickTime);
            this.callback = callback;
        }
    }

    public static class RouteFinderData {
        public final class_2338 pos;
        public final int duration;
        public final long routeId;
        public final int waitingTime;
        public final List<Long> stationIds = new ArrayList<Long>();

        private RouteFinderData(class_2338 pos, int duration, long routeId, int waitingTime) {
            this.pos = pos;
            this.duration = duration;
            this.routeId = routeId;
            this.waitingTime = waitingTime;
        }

        private static void append(List<RouteFinderData> routeFinderDataList, RouteFinderData newRouteFinderData, RailwayData railwayData) {
            long stationId;
            Station station = RailwayData.getStation(railwayData.stations, railwayData.dataCache, newRouteFinderData.pos);
            long l = stationId = station == null ? 0L : station.id;
            if (routeFinderDataList.isEmpty()) {
                newRouteFinderData.stationIds.add(stationId);
                routeFinderDataList.add(newRouteFinderData);
            } else {
                int lastIndex = routeFinderDataList.size() - 1;
                RouteFinderData lastRouteFinderData = routeFinderDataList.get(lastIndex);
                if (lastRouteFinderData.routeId == newRouteFinderData.routeId) {
                    routeFinderDataList.remove(lastIndex);
                    RouteFinderData routeFinderDataToAdd = new RouteFinderData(newRouteFinderData.pos, lastRouteFinderData.duration + newRouteFinderData.duration, lastRouteFinderData.routeId, lastRouteFinderData.waitingTime);
                    routeFinderDataToAdd.stationIds.addAll(lastRouteFinderData.stationIds);
                    routeFinderDataToAdd.stationIds.add(stationId);
                    routeFinderDataList.add(routeFinderDataToAdd);
                } else {
                    newRouteFinderData.stationIds.add(stationId);
                    routeFinderDataList.add(newRouteFinderData);
                }
            }
        }
    }

    public static class ConnectionDetails {
        private int shortestDuration = Integer.MAX_VALUE;
        private final Platform platformStart;
        private final Map<Long, Integer> durationInfo = new HashMap<Long, Integer>();

        public ConnectionDetails(Platform platformStart) {
            this.platformStart = platformStart;
        }

        public void addDurationInfo(long routeId, int duration) {
            this.durationInfo.put(routeId, duration);
            this.shortestDuration = Math.min(duration, this.shortestDuration);
        }
    }
}

