/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mtr.data.EnumHelper;
import mtr.data.IGui;
import mtr.data.MessagePackHelper;
import mtr.data.NameColorDataBase;
import mtr.data.RouteType;
import mtr.data.TransportMode;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public final class Route
extends NameColorDataBase
implements IGui {
    public RouteType routeType;
    public boolean isLightRailRoute;
    public boolean isHidden;
    public boolean disableNextStationAnnouncements;
    public CircularState circularState;
    public String lightRailRouteNumber;
    public final List<RoutePlatform> platformIds;
    private static final String KEY_PLATFORM_IDS = "platform_ids";
    private static final String KEY_CUSTOM_DESTINATIONS = "custom_destinations";
    private static final String KEY_ROUTE_TYPE = "route_type";
    private static final String KEY_IS_LIGHT_RAIL_ROUTE = "is_light_rail_route";
    private static final String KEY_LIGHT_RAIL_ROUTE_NUMBER = "light_rail_route_number";
    private static final String KEY_IS_ROUTE_HIDDEN = "is_route_hidden";
    private static final String KEY_DISABLE_NEXT_STATION_ANNOUNCEMENTS = "disable_next_station_announcements";
    private static final String KEY_CIRCULAR_STATE = "circular_state";

    public Route(TransportMode transportMode) {
        this(0L, transportMode);
    }

    public Route(long id, TransportMode transportMode) {
        super(id, transportMode);
        this.platformIds = new ArrayList<RoutePlatform>();
        this.routeType = RouteType.NORMAL;
        this.isLightRailRoute = false;
        this.circularState = CircularState.NONE;
        this.lightRailRouteNumber = "";
        this.isHidden = false;
        this.disableNextStationAnnouncements = false;
    }

    public Route(Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.platformIds = new ArrayList<RoutePlatform>();
        messagePackHelper.iterateArrayValue(KEY_PLATFORM_IDS, platformId -> this.platformIds.add(new RoutePlatform(platformId.asIntegerValue().asLong())));
        ArrayList customDestinations = new ArrayList();
        messagePackHelper.iterateArrayValue(KEY_CUSTOM_DESTINATIONS, customDestination -> customDestinations.add(customDestination.asStringValue().asString()));
        for (int i = 0; i < Math.min(this.platformIds.size(), customDestinations.size()); ++i) {
            this.platformIds.get((int)i).customDestination = (String)customDestinations.get(i);
        }
        this.routeType = EnumHelper.valueOf(RouteType.NORMAL, messagePackHelper.getString(KEY_ROUTE_TYPE));
        this.isLightRailRoute = messagePackHelper.getBoolean(KEY_IS_LIGHT_RAIL_ROUTE);
        this.isHidden = messagePackHelper.getBoolean(KEY_IS_ROUTE_HIDDEN);
        this.disableNextStationAnnouncements = messagePackHelper.getBoolean(KEY_DISABLE_NEXT_STATION_ANNOUNCEMENTS);
        this.lightRailRouteNumber = messagePackHelper.getString(KEY_LIGHT_RAIL_ROUTE_NUMBER);
        this.circularState = EnumHelper.valueOf(CircularState.NONE, messagePackHelper.getString(KEY_CIRCULAR_STATE));
    }

    @Deprecated
    public Route(class_2487 compoundTag) {
        super(compoundTag);
        long[] platformIdsArray;
        this.platformIds = new ArrayList<RoutePlatform>();
        for (long platformId : platformIdsArray = compoundTag.method_10565(KEY_PLATFORM_IDS)) {
            this.platformIds.add(new RoutePlatform(platformId));
        }
        this.routeType = EnumHelper.valueOf(RouteType.NORMAL, compoundTag.method_10558(KEY_ROUTE_TYPE));
        this.isLightRailRoute = compoundTag.method_10577(KEY_IS_LIGHT_RAIL_ROUTE);
        this.isHidden = compoundTag.method_10577(KEY_IS_ROUTE_HIDDEN);
        this.disableNextStationAnnouncements = compoundTag.method_10577(KEY_DISABLE_NEXT_STATION_ANNOUNCEMENTS);
        this.lightRailRouteNumber = compoundTag.method_10558(KEY_LIGHT_RAIL_ROUTE_NUMBER);
        this.circularState = EnumHelper.valueOf(CircularState.NONE, compoundTag.method_10558(KEY_CIRCULAR_STATE));
    }

    public Route(class_2540 packet) {
        super(packet);
        this.platformIds = new ArrayList<RoutePlatform>();
        int platformCount = packet.readInt();
        for (int i = 0; i < platformCount; ++i) {
            RoutePlatform routePlatform = new RoutePlatform(packet.readLong());
            routePlatform.customDestination = packet.method_10800(Short.MAX_VALUE);
            this.platformIds.add(routePlatform);
        }
        this.routeType = EnumHelper.valueOf(RouteType.NORMAL, packet.method_10800(Short.MAX_VALUE));
        this.isLightRailRoute = packet.readBoolean();
        this.isHidden = packet.readBoolean();
        this.disableNextStationAnnouncements = packet.readBoolean();
        this.lightRailRouteNumber = packet.method_10800(Short.MAX_VALUE);
        this.circularState = EnumHelper.valueOf(CircularState.NONE, packet.method_10800(Short.MAX_VALUE));
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_PLATFORM_IDS).packArrayHeader(this.platformIds.size());
        for (RoutePlatform routePlatform : this.platformIds) {
            messagePacker.packLong(routePlatform.platformId);
        }
        messagePacker.packString(KEY_CUSTOM_DESTINATIONS).packArrayHeader(this.platformIds.size());
        for (RoutePlatform routePlatform : this.platformIds) {
            messagePacker.packString(routePlatform.customDestination);
        }
        messagePacker.packString(KEY_ROUTE_TYPE).packString(this.routeType.toString());
        messagePacker.packString(KEY_IS_LIGHT_RAIL_ROUTE).packBoolean(this.isLightRailRoute);
        messagePacker.packString(KEY_IS_ROUTE_HIDDEN).packBoolean(this.isHidden);
        messagePacker.packString(KEY_DISABLE_NEXT_STATION_ANNOUNCEMENTS).packBoolean(this.disableNextStationAnnouncements);
        messagePacker.packString(KEY_LIGHT_RAIL_ROUTE_NUMBER).packString(this.lightRailRouteNumber);
        messagePacker.packString(KEY_CIRCULAR_STATE).packString(this.circularState.toString());
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 8;
    }

    @Override
    public void writePacket(class_2540 packet) {
        super.writePacket(packet);
        packet.writeInt(this.platformIds.size());
        this.platformIds.forEach(routePlatform -> {
            packet.writeLong(routePlatform.platformId);
            packet.method_10814(routePlatform.customDestination);
        });
        packet.method_10814(this.routeType.toString());
        packet.writeBoolean(this.isLightRailRoute);
        packet.writeBoolean(this.isHidden);
        packet.writeBoolean(this.disableNextStationAnnouncements);
        packet.method_10814(this.lightRailRouteNumber);
        packet.method_10814(this.circularState.toString());
    }

    @Override
    public void update(String key, class_2540 packet) {
        switch (key) {
            case "platform_ids": {
                this.platformIds.clear();
                int platformCount = packet.readInt();
                for (int i = 0; i < platformCount; ++i) {
                    RoutePlatform routePlatform = new RoutePlatform(packet.readLong());
                    routePlatform.customDestination = packet.method_10800(Short.MAX_VALUE);
                    this.platformIds.add(routePlatform);
                }
                break;
            }
            case "is_light_rail_route": {
                this.name = packet.method_10800(Short.MAX_VALUE);
                this.color = packet.readInt();
                this.routeType = EnumHelper.valueOf(RouteType.NORMAL, packet.method_10800(Short.MAX_VALUE));
                this.isLightRailRoute = packet.readBoolean();
                this.lightRailRouteNumber = packet.method_10800(Short.MAX_VALUE);
                this.isHidden = packet.readBoolean();
                this.disableNextStationAnnouncements = packet.readBoolean();
                this.circularState = EnumHelper.valueOf(CircularState.NONE, packet.method_10800(Short.MAX_VALUE));
                break;
            }
            default: {
                super.update(key, packet);
            }
        }
    }

    @Override
    protected boolean hasTransportMode() {
        return true;
    }

    public void setPlatformIds(Consumer<class_2540> sendPacket) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.method_10814(this.transportMode.toString());
        packet.method_10814(KEY_PLATFORM_IDS);
        packet.writeInt(this.platformIds.size());
        this.platformIds.forEach(routePlatform -> {
            packet.writeLong(routePlatform.platformId);
            packet.method_10814(routePlatform.customDestination);
        });
        sendPacket.accept(packet);
    }

    public void setExtraData(Consumer<class_2540> sendPacket) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.method_10814(this.transportMode.toString());
        packet.method_10814(KEY_IS_LIGHT_RAIL_ROUTE);
        packet.method_10814(this.name);
        packet.writeInt(this.color);
        packet.method_10814(this.routeType.toString());
        packet.writeBoolean(this.isLightRailRoute);
        packet.method_10814(this.lightRailRouteNumber);
        packet.writeBoolean(this.isHidden);
        packet.writeBoolean(this.disableNextStationAnnouncements);
        packet.method_10814(this.circularState.toString());
        sendPacket.accept(packet);
    }

    public int getPlatformIdIndex(long platformId) {
        for (int i = 0; i < this.platformIds.size(); ++i) {
            if (this.platformIds.get((int)i).platformId != platformId) continue;
            return i;
        }
        return -1;
    }

    public boolean containsPlatformId(long platformId) {
        return this.getPlatformIdIndex(platformId) >= 0;
    }

    public long getFirstPlatformId() {
        return this.platformIds.isEmpty() ? 0L : this.platformIds.get((int)0).platformId;
    }

    public long getLastPlatformId() {
        return this.platformIds.isEmpty() ? 0L : this.platformIds.get((int)(this.platformIds.size() - 1)).platformId;
    }

    public String getDestination(int index) {
        for (int i = Math.min(this.platformIds.size() - 1, index); i >= 0; --i) {
            String customDestination = this.platformIds.get((int)i).customDestination;
            if (Route.destinationIsReset(customDestination)) {
                return null;
            }
            if (customDestination.isEmpty()) continue;
            return customDestination;
        }
        return null;
    }

    public static boolean destinationIsReset(String destination) {
        return destination.equals("\\r") || destination.equals("\\reset");
    }

    public static enum CircularState {
        NONE,
        CLOCKWISE,
        ANTICLOCKWISE;

    }

    public static class RoutePlatform {
        public String customDestination;
        public final long platformId;

        public RoutePlatform(long platformId) {
            this.platformId = platformId;
            this.customDestination = "";
        }
    }
}

