/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mtr.data.MessagePackHelper;
import mtr.data.NameColorDataBase;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import org.apache.commons.lang3.math.NumberUtils;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public abstract class SavedRailBase
extends NameColorDataBase {
    protected int dwellTime;
    private final Set<class_2338> positions;
    public static final int MAX_DWELL_TIME = 1200;
    private static final int DEFAULT_DWELL_TIME = 20;
    private static final String KEY_POS_1 = "pos_1";
    private static final String KEY_POS_2 = "pos_2";
    private static final String KEY_DWELL_TIME = "dwell_time";

    public SavedRailBase(long id, TransportMode transportMode, class_2338 pos1, class_2338 pos2) {
        super(id, transportMode);
        this.name = "1";
        this.positions = new HashSet<class_2338>(2);
        this.positions.add(pos1);
        this.positions.add(pos2);
        this.dwellTime = transportMode.continuousMovement ? 1 : 20;
    }

    public SavedRailBase(TransportMode transportMode, class_2338 pos1, class_2338 pos2) {
        super(transportMode);
        this.name = "1";
        this.positions = new HashSet<class_2338>(2);
        this.positions.add(pos1);
        this.positions.add(pos2);
        this.dwellTime = transportMode.continuousMovement ? 1 : 20;
    }

    public SavedRailBase(Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.positions = new HashSet<class_2338>(2);
        this.positions.add(class_2338.method_10092((long)messagePackHelper.getLong(KEY_POS_1)));
        this.positions.add(class_2338.method_10092((long)messagePackHelper.getLong(KEY_POS_2)));
        this.dwellTime = this.transportMode.continuousMovement ? 1 : messagePackHelper.getInt(KEY_DWELL_TIME);
    }

    @Deprecated
    public SavedRailBase(class_2487 compoundTag) {
        super(compoundTag);
        this.positions = new HashSet<class_2338>(2);
        this.positions.add(class_2338.method_10092((long)compoundTag.method_10537(KEY_POS_1)));
        this.positions.add(class_2338.method_10092((long)compoundTag.method_10537(KEY_POS_2)));
        this.dwellTime = this.transportMode.continuousMovement ? 1 : compoundTag.method_10550(KEY_DWELL_TIME);
    }

    public SavedRailBase(class_2540 packet) {
        super(packet);
        this.positions = new HashSet<class_2338>(2);
        this.positions.add(packet.method_10811());
        this.positions.add(packet.method_10811());
        this.dwellTime = packet.readInt();
        this.dwellTime = this.transportMode.continuousMovement ? 1 : this.dwellTime;
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_POS_1).packLong(this.getPosition(0).method_10063());
        messagePacker.packString(KEY_POS_2).packLong(this.getPosition(1).method_10063());
        messagePacker.packString(KEY_DWELL_TIME).packInt(this.dwellTime);
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 3;
    }

    @Override
    public void writePacket(class_2540 packet) {
        super.writePacket(packet);
        packet.method_10807(this.getPosition(0));
        packet.method_10807(this.getPosition(1));
        packet.writeInt(this.dwellTime);
    }

    @Override
    protected final boolean hasTransportMode() {
        return true;
    }

    public boolean containsPos(class_2338 pos) {
        return this.positions.contains(pos);
    }

    public class_2338 getMidPos() {
        return this.getMidPos(false);
    }

    public class_2338 getMidPos(boolean zeroY) {
        class_2338 pos = this.getPosition(0).method_10081((class_2382)this.getPosition(1));
        return RailwayData.newBlockPos(pos.method_10263() / 2, zeroY ? 0 : pos.method_10264() / 2, pos.method_10260() / 2);
    }

    public class_2350.class_2351 getAxis() {
        class_2338 difference = this.getPosition(0).method_10059((class_2382)this.getPosition(1));
        return Math.abs(difference.method_10263()) > Math.abs(difference.method_10260()) ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051;
    }

    public boolean isInvalidSavedRail(Map<class_2338, Map<class_2338, Rail>> rails) {
        class_2338 pos2;
        class_2338 pos1 = this.getPosition(0);
        return SavedRailBase.isInvalidSavedRail(rails, pos1, pos2 = this.getPosition(1)) || SavedRailBase.isInvalidSavedRail(rails, pos2, pos1);
    }

    public boolean isCloseToSavedRail(class_2338 pos, int radius, int lower, int upper) {
        class_2338 pos1 = this.getPosition(0);
        class_2338 pos2 = this.getPosition(1);
        int x1 = Math.min(pos1.method_10263(), pos2.method_10263());
        int y1 = Math.min(pos1.method_10264(), pos2.method_10264());
        int z1 = Math.min(pos1.method_10260(), pos2.method_10260());
        int x2 = Math.max(pos1.method_10263(), pos2.method_10263());
        int y2 = Math.max(pos1.method_10264(), pos2.method_10264());
        int z2 = Math.max(pos1.method_10260(), pos2.method_10260());
        return new class_238((double)(x1 - radius), (double)(y1 - lower), (double)(z1 - radius), (double)(x2 + radius + 1), (double)(y2 + upper + 1), (double)(z2 + radius + 1)).method_1008((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public List<class_2338> getOrderedPositions(class_2338 pos, boolean reverse) {
        class_2338 pos1 = this.getPosition(0);
        class_2338 pos2 = this.getPosition(1);
        double d1 = pos1.method_10262((class_2382)pos);
        double d2 = pos2.method_10262((class_2382)pos);
        ArrayList<class_2338> orderedPositions = new ArrayList<class_2338>();
        if (d2 > d1 == reverse) {
            orderedPositions.add(pos2);
            orderedPositions.add(pos1);
        } else {
            orderedPositions.add(pos1);
            orderedPositions.add(pos2);
        }
        return orderedPositions;
    }

    public class_2338 getOtherPosition(class_2338 pos) {
        class_2338 pos1 = this.getPosition(0);
        class_2338 pos2 = this.getPosition(1);
        return pos.equals((Object)pos1) ? pos2 : pos1;
    }

    public int getDwellTime() {
        if (this.dwellTime <= 0 || this.dwellTime > 1200) {
            this.dwellTime = 20;
        }
        return this.transportMode.continuousMovement ? 1 : this.dwellTime;
    }

    protected void writeDwellTimePacket(class_2540 packet, int newDwellTime) {
        this.dwellTime = this.transportMode.continuousMovement ? 1 : (newDwellTime <= 0 || newDwellTime > 1200 ? 20 : newDwellTime);
        packet.writeInt(this.dwellTime);
    }

    private class_2338 getPosition(int index) {
        return this.positions.size() > index ? new ArrayList<class_2338>(this.positions).get(index) : RailwayData.newBlockPos(0, 0, 0);
    }

    public static boolean isInvalidSavedRail(Map<class_2338, Map<class_2338, Rail>> rails, class_2338 pos1, class_2338 pos2) {
        return !RailwayData.containsRail(rails, pos1, pos2) || !rails.get((Object)pos1).get((Object)pos2).railType.hasSavedRail;
    }

    @Override
    public int compareTo(NameColorDataBase compare) {
        boolean thisIsNumber = NumberUtils.isParsable((String)this.name);
        boolean compareIsNumber = NumberUtils.isParsable((String)compare.name);
        if (thisIsNumber && compareIsNumber) {
            int floatCompare = Float.compare(Float.parseFloat(this.name), Float.parseFloat(compare.name));
            return floatCompare == 0 ? super.compareTo(compare) : floatCompare;
        }
        if (thisIsNumber) {
            return -1;
        }
        if (compareIsNumber) {
            return 1;
        }
        return super.compareTo(compare);
    }
}

