/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mtr.data.AreaBase;
import mtr.data.MessagePackHelper;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public final class Station
extends AreaBase {
    public int zone;
    public final Map<String, List<String>> exits = new HashMap<String, List<String>>();
    private static final String KEY_ZONE = "zone";
    private static final String KEY_EXITS = "exits";
    private static final String KEY_EXIT_EDIT_PARENT = "exit_edit_parent";
    private static final String KEY_EXIT_DELETE_PARENT = "exit_delete_parent";
    private static final String KEY_EXIT_DESTINATIONS = "exit_destinations";

    public Station() {
    }

    public Station(long id) {
        super(id);
    }

    public Station(Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.zone = messagePackHelper.getInt(KEY_ZONE);
        messagePackHelper.iterateMapValue(KEY_EXITS, entry -> {
            ArrayList<String> destinations = new ArrayList<String>(((Value)entry.getValue()).asArrayValue().size());
            for (Value destination : ((Value)entry.getValue()).asArrayValue()) {
                destinations.add(destination.asStringValue().asString());
            }
            this.exits.put(((Value)entry.getKey()).asStringValue().asString(), destinations);
        });
    }

    @Deprecated
    public Station(class_2487 compoundTag) {
        super(compoundTag);
        this.zone = compoundTag.method_10550(KEY_ZONE);
        class_2487 tagExits = compoundTag.method_10562(KEY_EXITS);
        for (String keyParent : tagExits.method_10541()) {
            ArrayList<String> destinations = new ArrayList<String>();
            class_2487 tagDestinations = tagExits.method_10562(keyParent);
            for (String keyDestination : tagDestinations.method_10541()) {
                destinations.add(tagDestinations.method_10558(keyDestination));
            }
            this.exits.put(keyParent, destinations);
        }
    }

    public Station(class_2540 packet) {
        super(packet);
        this.zone = packet.readInt();
        int exitCount = packet.readInt();
        for (int i = 0; i < exitCount; ++i) {
            String parent = packet.method_10800(Short.MAX_VALUE);
            ArrayList<String> destinations = new ArrayList<String>();
            int destinationCount = packet.readInt();
            for (int j = 0; j < destinationCount; ++j) {
                destinations.add(packet.method_10800(Short.MAX_VALUE));
            }
            this.exits.put(parent, destinations);
        }
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_ZONE).packInt(this.zone);
        messagePacker.packString(KEY_EXITS);
        messagePacker.packMapHeader(this.exits.size());
        for (Map.Entry<String, List<String>> entry : this.exits.entrySet()) {
            String key = entry.getKey();
            List<String> destinations = entry.getValue();
            messagePacker.packString(key);
            messagePacker.packArrayHeader(destinations.size());
            for (String destination : destinations) {
                messagePacker.packString(destination);
            }
        }
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 2;
    }

    @Override
    public void writePacket(class_2540 packet) {
        super.writePacket(packet);
        packet.writeInt(this.zone);
        packet.writeInt(this.exits.size());
        this.exits.forEach((parent, destinations) -> {
            packet.method_10814(parent);
            packet.writeInt(destinations.size());
            destinations.forEach(arg_0 -> ((class_2540)packet).method_10814(arg_0));
        });
    }

    @Override
    public void update(String key, class_2540 packet) {
        switch (key) {
            case "exit_edit_parent": {
                String oldParent = packet.method_10800(Short.MAX_VALUE);
                String newParent = packet.method_10800(Short.MAX_VALUE);
                this.setExitParent(oldParent, newParent);
                break;
            }
            case "exit_delete_parent": {
                this.exits.remove(packet.method_10800(Short.MAX_VALUE));
                break;
            }
            case "exit_destinations": {
                String parent = packet.method_10800(Short.MAX_VALUE);
                if (!this.parentExists(parent)) break;
                this.exits.get(parent).clear();
                int destinationCount = packet.readInt();
                for (int i = 0; i < destinationCount; ++i) {
                    this.exits.get(parent).add(packet.method_10800(Short.MAX_VALUE));
                }
                break;
            }
            case "zone": {
                this.name = packet.method_10800(Short.MAX_VALUE);
                this.color = packet.readInt();
                this.zone = packet.readInt();
                break;
            }
            default: {
                super.update(key, packet);
            }
        }
    }

    @Override
    protected boolean hasTransportMode() {
        return false;
    }

    public void setZone(Consumer<class_2540> sendPacket) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.method_10814(this.transportMode.toString());
        packet.method_10814(KEY_ZONE);
        packet.method_10814(this.name);
        packet.writeInt(this.color);
        packet.writeInt(this.zone);
        sendPacket.accept(packet);
    }

    public void setExitParent(String oldParent, String newParent, Consumer<class_2540> sendPacket) {
        this.setExitParent(oldParent, newParent);
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.method_10814(this.transportMode.toString());
        packet.method_10814(KEY_EXIT_EDIT_PARENT);
        packet.method_10814(oldParent);
        packet.method_10814(newParent);
        sendPacket.accept(packet);
    }

    public void deleteExitParent(String parent, Consumer<class_2540> sendPacket) {
        this.exits.remove(parent);
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.method_10814(this.transportMode.toString());
        packet.method_10814(KEY_EXIT_DELETE_PARENT);
        packet.method_10814(parent);
        sendPacket.accept(packet);
    }

    public void setExitDestinations(String parent, Consumer<class_2540> sendPacket) {
        if (this.parentExists(parent)) {
            class_2540 packet = new class_2540(Unpooled.buffer());
            packet.writeLong(this.id);
            packet.method_10814(this.transportMode.toString());
            packet.method_10814(KEY_EXIT_DESTINATIONS);
            packet.method_10814(parent);
            packet.writeInt(this.exits.get(parent).size());
            this.exits.get(parent).forEach(arg_0 -> ((class_2540)packet).method_10814(arg_0));
            sendPacket.accept(packet);
        }
    }

    public Map<String, List<String>> getGeneratedExits() {
        ArrayList<String> exitParents = new ArrayList<String>(this.exits.keySet());
        exitParents.sort(String::compareTo);
        HashMap<String, List<String>> generatedExits = new HashMap<String, List<String>>();
        exitParents.forEach(parent -> {
            String exitLetter = parent.substring(0, 1);
            if (!generatedExits.containsKey(exitLetter)) {
                generatedExits.put(exitLetter, new ArrayList());
            }
            ((List)generatedExits.get(exitLetter)).addAll((Collection)this.exits.get(parent));
            generatedExits.put((String)parent, this.exits.get(parent));
        });
        return generatedExits;
    }

    private void setExitParent(String oldParent, String newParent) {
        if (this.parentExists(oldParent)) {
            ArrayList existingDestinations = this.exits.get(oldParent);
            this.exits.remove(oldParent);
            this.exits.put(newParent, existingDestinations == null ? new ArrayList() : existingDestinations);
        } else {
            this.exits.put(newParent, new ArrayList());
        }
    }

    private boolean parentExists(String parent) {
        return parent != null && this.exits.containsKey(parent);
    }

    public static long serializeExit(String exit) {
        char[] characters = exit.toCharArray();
        long code = 0L;
        for (char character : characters) {
            code <<= 8;
            code += (long)character;
        }
        return code;
    }

    public static String deserializeExit(long code) {
        StringBuilder exit = new StringBuilder();
        for (long charCodes = code; charCodes > 0L; charCodes >>= 8) {
            exit.insert(0, (char)(charCodes & 0xFFL));
        }
        return exit.toString();
    }
}

