/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.Text;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_267;
import net.minecraft.class_274;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3542;

public class TicketSystem {
    public static final String BALANCE_OBJECTIVE = "mtr_balance";
    private static final String ENTRY_ZONE_OBJECTIVE = "mtr_entry_zone";
    private static final int BASE_FARE = 2;
    private static final int ZONE_FARE = 1;
    private static final int EVASION_FINE = 500;

    public static EnumTicketBarrierOpen passThrough(class_1937 world, class_2338 pos, class_1657 player, boolean isEntrance, boolean isExit, class_3414 entrySound, class_3414 entrySoundConcessionary, class_3414 exitSound, class_3414 exitSoundConcessionary, class_3414 failSound, boolean remindIfNoRecord) {
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData == null) {
            return EnumTicketBarrierOpen.CLOSED;
        }
        Station station = RailwayData.getStation(railwayData.stations, railwayData.dataCache, pos);
        if (station == null) {
            return EnumTicketBarrierOpen.CLOSED;
        }
        TicketSystem.addObjectivesIfMissing(world);
        class_267 balanceScore = TicketSystem.getPlayerScore(world, player, BALANCE_OBJECTIVE);
        class_267 entryZoneScore = TicketSystem.getPlayerScore(world, player, ENTRY_ZONE_OBJECTIVE);
        boolean isEntering = isEntrance && isExit ? entryZoneScore.method_1126() == 0 : isEntrance;
        boolean canOpen = isEntering ? TicketSystem.onEnter(station, player, balanceScore, entryZoneScore, remindIfNoRecord) : TicketSystem.onExit(station, player, balanceScore, entryZoneScore, remindIfNoRecord);
        if (canOpen) {
            world.method_8396(null, pos, TicketSystem.isConcessionary(player) ? (isEntering ? entrySoundConcessionary : exitSoundConcessionary) : (isEntering ? entrySound : exitSound), class_3419.field_15245, 1.0f, 1.0f);
        } else if (failSound != null) {
            world.method_8396(null, pos, failSound, class_3419.field_15245, 1.0f, 1.0f);
        }
        return canOpen ? (TicketSystem.isConcessionary(player) ? EnumTicketBarrierOpen.OPEN_CONCESSIONARY : EnumTicketBarrierOpen.OPEN) : EnumTicketBarrierOpen.CLOSED;
    }

    public static void addObjectivesIfMissing(class_1937 world) {
        try {
            world.method_8428().method_1168(BALANCE_OBJECTIVE, class_274.field_1468, (class_2561)Text.literal("Balance"), class_274.class_275.field_1472);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            world.method_8428().method_1168(ENTRY_ZONE_OBJECTIVE, class_274.field_1468, (class_2561)Text.literal("Entry Zone"), class_274.class_275.field_1472);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class_267 getPlayerScore(class_1937 world, class_1657 player, String objectiveName) {
        return world.method_8428().method_1180(player.method_7334().getName(), world.method_8428().method_1170(objectiveName));
    }

    private static boolean onEnter(Station station, class_1657 player, class_267 balanceScore, class_267 entryZoneScore, boolean remindIfNoRecord) {
        int entryZone = entryZoneScore.method_1126();
        if (entryZone != 0) {
            if (remindIfNoRecord) {
                player.method_7353((class_2561)Text.translatable("gui.mtr.already_entered", new Object[0]), true);
                return false;
            }
            entryZoneScore.method_1128(0);
            balanceScore.method_1124(-500);
        }
        if (balanceScore.method_1126() >= 0) {
            entryZoneScore.method_1128(TicketSystem.encodeZone(station.zone));
            player.method_7353((class_2561)Text.translatable("gui.mtr.enter_barrier", String.format("%s (%s)", station.name.replace('|', ' '), station.zone), balanceScore.method_1126()), true);
            return true;
        }
        player.method_7353((class_2561)Text.translatable("gui.mtr.insufficient_balance", balanceScore.method_1126()), true);
        return false;
    }

    private static boolean onExit(Station station, class_1657 player, class_267 balanceScore, class_267 entryZoneScore, boolean remindIfNoRecord) {
        int finalFare;
        int entryZone = entryZoneScore.method_1126();
        int fare = 2 + 1 * Math.abs(station.zone - TicketSystem.decodeZone(entryZone));
        int n = entryZone != 0 ? (TicketSystem.isConcessionary(player) ? (int)Math.ceil((float)fare / 2.0f) : fare) : (finalFare = 500);
        if (entryZone == 0 && remindIfNoRecord) {
            player.method_7353((class_2561)Text.translatable("gui.mtr.already_exited", new Object[0]), true);
            return false;
        }
        entryZoneScore.method_1128(0);
        balanceScore.method_1124(-finalFare);
        player.method_7353((class_2561)Text.translatable("gui.mtr.exit_barrier", String.format("%s (%s)", station.name.replace('|', ' '), station.zone), finalFare, balanceScore.method_1126()), true);
        return true;
    }

    private static boolean isConcessionary(class_1657 player) {
        return player.method_7337();
    }

    private static int encodeZone(int zone) {
        return zone >= 0 ? zone + 1 : zone;
    }

    private static int decodeZone(int zone) {
        return zone > 0 ? zone - 1 : zone;
    }

    public static enum EnumTicketBarrierOpen implements class_3542
    {
        CLOSED("closed"),
        OPEN("open"),
        OPEN_CONCESSIONARY("open_concessionary");

        private final String name;

        private EnumTicketBarrierOpen(String nameIn) {
            this.name = nameIn;
        }

        public String method_15434() {
            return this.name;
        }

        public boolean isOpen() {
            return this != CLOSED;
        }
    }
}

