/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mtr.Items;
import mtr.Keys;
import mtr.block.BlockPSDAPGBase;
import mtr.block.BlockPlatform;
import mtr.data.Depot;
import mtr.data.MessagePackHelper;
import mtr.data.NameColorDataBase;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.TrainType;
import mtr.data.TransportMode;
import mtr.packet.IPacket;
import mtr.path.PathData;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2540;
import net.minecraft.class_3532;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public abstract class Train
extends NameColorDataBase
implements IPacket {
    protected float speed;
    protected double railProgress;
    protected boolean doorTarget;
    protected float doorValue;
    protected float elapsedDwellTicks;
    protected int nextStoppingIndex;
    protected int nextPlatformIndex;
    protected boolean reversed;
    protected boolean isOnRoute = false;
    protected boolean isCurrentlyManual;
    protected int manualNotch;
    public final long sidingId;
    public final String trainId;
    public final String baseTrainType;
    public final TransportMode transportMode;
    public final int spacing;
    public final int width;
    public final int trainCars;
    public final float accelerationConstant;
    public final boolean isManualAllowed;
    public final int maxManualSpeed;
    public final int manualToAutomaticTime;
    public final List<PathData> path;
    protected final List<Double> distances;
    protected final int repeatIndex1;
    protected final int repeatIndex2;
    protected final Set<UUID> ridingEntities = new HashSet<UUID>();
    protected final class_1277 inventory;
    private final float railLength;
    public static final float ACCELERATION_DEFAULT = 0.01f;
    public static final float MAX_ACCELERATION = 0.05f;
    public static final float MIN_ACCELERATION = 0.001f;
    public static final int DOOR_MOVE_TIME = 64;
    protected static final int MAX_CHECK_DISTANCE = 32;
    protected static final int DOOR_DELAY = 20;
    private static final String KEY_SPEED = "speed";
    private static final String KEY_RAIL_PROGRESS = "rail_progress";
    private static final String KEY_ELAPSED_DWELL_TICKS = "stop_counter";
    private static final String KEY_NEXT_STOPPING_INDEX = "next_stopping_index";
    private static final String KEY_NEXT_PLATFORM_INDEX = "next_platform_index";
    private static final String KEY_REVERSED = "reversed";
    private static final String KEY_IS_CURRENTLY_MANUAL = "is_currently_manual";
    private static final String KEY_IS_ON_ROUTE = "is_on_route";
    private static final String KEY_TRAIN_TYPE = "train_type";
    private static final String KEY_TRAIN_CUSTOM_ID = "train_custom_id";
    private static final String KEY_RIDING_ENTITIES = "riding_entities";
    private static final String KEY_CARGO = "cargo";

    public Train(long id, long sidingId, float railLength, String trainId, String baseTrainType, int trainCars, List<PathData> path, List<Double> distances, int repeatIndex1, int repeatIndex2, float accelerationConstant, boolean isManualAllowed, int maxManualSpeed, int manualToAutomaticTime) {
        super(id);
        this.sidingId = sidingId;
        this.railLength = RailwayData.round(railLength, 3);
        this.trainId = trainId;
        this.baseTrainType = baseTrainType = baseTrainType.startsWith("base_") ? baseTrainType.replace("base_", "train_") : baseTrainType;
        this.transportMode = TrainType.getTransportMode(baseTrainType);
        this.spacing = TrainType.getSpacing(baseTrainType);
        this.width = TrainType.getWidth(baseTrainType);
        this.trainCars = trainCars;
        this.isManualAllowed = isManualAllowed;
        this.isCurrentlyManual = isManualAllowed;
        this.maxManualSpeed = maxManualSpeed;
        this.manualToAutomaticTime = manualToAutomaticTime;
        this.path = path;
        this.distances = distances;
        this.repeatIndex1 = repeatIndex1;
        this.repeatIndex2 = repeatIndex2;
        float tempAccelerationConstant = RailwayData.round(accelerationConstant, 3);
        this.accelerationConstant = tempAccelerationConstant <= 0.0f ? 0.01f : tempAccelerationConstant;
        this.inventory = new class_1277(trainCars);
    }

    public Train(long sidingId, float railLength, List<PathData> path, List<Double> distances, int repeatIndex1, int repeatIndex2, float accelerationConstant, boolean isManualAllowed, int maxManualSpeed, int manualToAutomaticTime, Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.sidingId = sidingId;
        this.railLength = RailwayData.round(railLength, 3);
        this.path = path;
        this.distances = distances;
        this.repeatIndex1 = repeatIndex1;
        this.repeatIndex2 = repeatIndex2;
        this.accelerationConstant = accelerationConstant;
        this.isManualAllowed = isManualAllowed;
        this.maxManualSpeed = maxManualSpeed;
        this.manualToAutomaticTime = manualToAutomaticTime;
        this.speed = messagePackHelper.getFloat(KEY_SPEED);
        this.railProgress = messagePackHelper.getDouble(KEY_RAIL_PROGRESS);
        this.elapsedDwellTicks = messagePackHelper.getFloat(KEY_ELAPSED_DWELL_TICKS);
        this.nextStoppingIndex = messagePackHelper.getInt(KEY_NEXT_STOPPING_INDEX);
        this.nextPlatformIndex = messagePackHelper.getInt(KEY_NEXT_PLATFORM_INDEX);
        this.reversed = messagePackHelper.getBoolean(KEY_REVERSED);
        String tempTrainId = messagePackHelper.getString(KEY_TRAIN_CUSTOM_ID).toLowerCase(Locale.ENGLISH);
        String tempBaseTrainType = messagePackHelper.getString(KEY_TRAIN_TYPE).toLowerCase(Locale.ENGLISH);
        this.baseTrainType = tempBaseTrainType.startsWith("base_") ? tempBaseTrainType.replace("base_", "train_") : tempBaseTrainType;
        this.trainId = tempTrainId.isEmpty() ? this.baseTrainType : tempTrainId;
        this.transportMode = TrainType.getTransportMode(this.baseTrainType);
        this.spacing = TrainType.getSpacing(this.baseTrainType);
        this.width = TrainType.getWidth(this.baseTrainType);
        this.trainCars = Math.min(this.transportMode.maxLength, (int)Math.floor(railLength / (float)this.spacing));
        this.isCurrentlyManual = messagePackHelper.getBoolean(KEY_IS_CURRENTLY_MANUAL);
        this.isOnRoute = messagePackHelper.getBoolean(KEY_IS_ON_ROUTE);
        messagePackHelper.iterateArrayValue(KEY_RIDING_ENTITIES, value -> this.ridingEntities.add(UUID.fromString(value.asStringValue().asString())));
        class_1277 inventory1 = new class_1277(this.trainCars);
        if (map.containsKey(KEY_CARGO) && !map.get(KEY_CARGO).isNilValue()) {
            byte[] rawNbt = map.get(KEY_CARGO).asBinaryValue().asByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(rawNbt);
            try {
                class_2487 compoundTag = class_2507.method_10627((DataInput)new DataInputStream(inputStream));
                class_2371 stacks = class_2371.method_10213((int)this.trainCars, (Object)class_1799.field_8037);
                class_1262.method_5429((class_2487)compoundTag.method_10562(KEY_CARGO), (class_2371)stacks);
                inventory1 = new class_1277((class_1799[])stacks.toArray((Object[])new class_1799[0]));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.inventory = inventory1;
    }

    @Deprecated
    public Train(long sidingId, float railLength, List<PathData> path, List<Double> distances, int repeatIndex1, int repeatIndex2, float accelerationConstant, boolean isManualAllowed, int maxManualSpeed, int manualToAutomaticTime, class_2487 compoundTag) {
        super(compoundTag);
        this.sidingId = sidingId;
        this.railLength = RailwayData.round(railLength, 3);
        this.path = path;
        this.distances = distances;
        this.repeatIndex1 = repeatIndex1;
        this.repeatIndex2 = repeatIndex2;
        this.accelerationConstant = accelerationConstant;
        this.isManualAllowed = isManualAllowed;
        this.maxManualSpeed = maxManualSpeed;
        this.manualToAutomaticTime = manualToAutomaticTime;
        this.speed = compoundTag.method_10583(KEY_SPEED);
        this.railProgress = compoundTag.method_10574(KEY_RAIL_PROGRESS);
        this.elapsedDwellTicks = compoundTag.method_10583(KEY_ELAPSED_DWELL_TICKS);
        this.nextStoppingIndex = compoundTag.method_10550(KEY_NEXT_STOPPING_INDEX);
        this.nextPlatformIndex = compoundTag.method_10550(KEY_NEXT_PLATFORM_INDEX);
        this.reversed = compoundTag.method_10577(KEY_REVERSED);
        this.trainId = compoundTag.method_10558(KEY_TRAIN_CUSTOM_ID);
        this.baseTrainType = compoundTag.method_10558(KEY_TRAIN_TYPE);
        this.transportMode = TrainType.getTransportMode(this.baseTrainType);
        this.spacing = TrainType.getSpacing(this.baseTrainType);
        this.width = TrainType.getWidth(this.baseTrainType);
        this.trainCars = Math.min(this.transportMode.maxLength, (int)Math.floor(railLength / (float)this.spacing));
        this.isCurrentlyManual = compoundTag.method_10577(KEY_IS_CURRENTLY_MANUAL);
        this.isOnRoute = compoundTag.method_10577(KEY_IS_ON_ROUTE);
        class_2487 tagRidingEntities = compoundTag.method_10562(KEY_RIDING_ENTITIES);
        tagRidingEntities.method_10541().forEach(key -> this.ridingEntities.add(tagRidingEntities.method_25926(key)));
        class_2371 stacks = class_2371.method_10213((int)this.trainCars, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)compoundTag.method_10562(KEY_CARGO), (class_2371)stacks);
        this.inventory = new class_1277((class_1799[])stacks.toArray((Object[])new class_1799[0]));
    }

    public Train(class_2540 packet) {
        super(packet);
        this.path = new ArrayList<PathData>();
        this.distances = new ArrayList<Double>();
        int pathSize = packet.readInt();
        for (int i = 0; i < pathSize; ++i) {
            this.path.add(new PathData(packet));
            this.distances.add(packet.readDouble());
        }
        this.repeatIndex1 = packet.readInt();
        this.repeatIndex2 = packet.readInt();
        this.sidingId = packet.readLong();
        this.railLength = RailwayData.round(packet.readFloat(), 3);
        this.speed = packet.readFloat();
        float tempAccelerationConstant = RailwayData.round(packet.readFloat(), 3);
        this.accelerationConstant = tempAccelerationConstant <= 0.0f ? 0.01f : tempAccelerationConstant;
        this.railProgress = packet.readDouble();
        this.elapsedDwellTicks = packet.readFloat();
        this.nextStoppingIndex = packet.readInt();
        this.nextPlatformIndex = packet.readInt();
        this.reversed = packet.readBoolean();
        this.trainId = packet.method_10800(Short.MAX_VALUE);
        this.baseTrainType = packet.method_10800(Short.MAX_VALUE);
        this.transportMode = TrainType.getTransportMode(this.baseTrainType);
        this.spacing = TrainType.getSpacing(this.baseTrainType);
        this.width = TrainType.getWidth(this.baseTrainType);
        this.trainCars = Math.min(this.transportMode.maxLength, (int)Math.floor(this.railLength / (float)this.spacing));
        this.isManualAllowed = packet.readBoolean();
        this.isCurrentlyManual = packet.readBoolean();
        this.maxManualSpeed = packet.readInt();
        this.manualToAutomaticTime = packet.readInt();
        this.isOnRoute = packet.readBoolean();
        this.manualNotch = packet.readInt();
        this.doorTarget = packet.readBoolean();
        int ridingEntitiesCount = packet.readInt();
        for (int i = 0; i < ridingEntitiesCount; ++i) {
            this.ridingEntities.add(packet.method_10790());
        }
        this.inventory = null;
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_SPEED).packFloat(this.speed);
        messagePacker.packString(KEY_RAIL_PROGRESS).packDouble(this.railProgress);
        messagePacker.packString(KEY_ELAPSED_DWELL_TICKS).packFloat(this.elapsedDwellTicks);
        messagePacker.packString(KEY_NEXT_STOPPING_INDEX).packLong(this.nextStoppingIndex);
        messagePacker.packString(KEY_NEXT_PLATFORM_INDEX).packLong(this.nextPlatformIndex);
        messagePacker.packString(KEY_REVERSED).packBoolean(this.reversed);
        messagePacker.packString(KEY_TRAIN_CUSTOM_ID).packString(this.trainId);
        messagePacker.packString(KEY_TRAIN_TYPE).packString(this.baseTrainType);
        messagePacker.packString(KEY_IS_CURRENTLY_MANUAL).packBoolean(this.isCurrentlyManual);
        messagePacker.packString(KEY_IS_ON_ROUTE).packBoolean(this.isOnRoute);
        messagePacker.packString(KEY_RIDING_ENTITIES).packArrayHeader(this.ridingEntities.size());
        for (UUID uuid : this.ridingEntities) {
            messagePacker.packString(uuid.toString());
        }
        messagePacker.packString(KEY_CARGO);
        if (this.inventory != null) {
            class_2371 stacks = class_2371.method_10213((int)this.inventory.method_5439(), (Object)class_1799.field_8037);
            int totalCount = 0;
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                stacks.set(i, (Object)this.inventory.method_5438(i));
                totalCount += this.inventory.method_5438(i).method_7947();
            }
            if (totalCount > 0) {
                class_2487 tag = class_1262.method_5426((class_2487)new class_2487(), (class_2371)stacks);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                class_2507.method_10628((class_2487)tag, (DataOutput)new DataOutputStream(outputStream));
                messagePacker.packBinaryHeader(outputStream.size());
                messagePacker.writePayload(outputStream.toByteArray());
            } else {
                messagePacker.packNil();
            }
        } else {
            messagePacker.packNil();
        }
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 12;
    }

    @Override
    public void writePacket(class_2540 packet) {
        super.writePacket(packet);
        int pathSize = Math.min(this.path.size(), this.distances.size());
        packet.writeInt(pathSize);
        for (int i = 0; i < pathSize; ++i) {
            this.path.get(i).writePacket(packet);
            packet.writeDouble(this.distances.get(i).doubleValue());
        }
        packet.writeInt(this.repeatIndex1);
        packet.writeInt(this.repeatIndex2);
        packet.writeLong(this.sidingId);
        packet.writeFloat(this.railLength);
        packet.writeFloat(this.speed);
        packet.writeFloat(this.accelerationConstant);
        packet.writeDouble(this.railProgress);
        packet.writeFloat(this.elapsedDwellTicks);
        packet.writeInt(this.nextStoppingIndex);
        packet.writeInt(this.nextPlatformIndex);
        packet.writeBoolean(this.reversed);
        packet.method_10814(this.trainId);
        packet.method_10814(this.baseTrainType);
        packet.writeBoolean(this.isManualAllowed);
        packet.writeBoolean(this.isCurrentlyManual);
        packet.writeInt(this.maxManualSpeed);
        packet.writeInt(this.manualToAutomaticTime);
        packet.writeBoolean(this.isOnRoute);
        packet.writeInt(this.manualNotch);
        packet.writeBoolean(this.doorTarget);
        packet.writeInt(this.ridingEntities.size());
        this.ridingEntities.forEach(arg_0 -> ((class_2540)packet).method_10797(arg_0));
    }

    @Override
    protected final boolean hasTransportMode() {
        return false;
    }

    public final boolean getIsOnRoute() {
        return this.isOnRoute;
    }

    public final double getRailProgress() {
        return this.railProgress;
    }

    public final boolean closeToDepot(int trainDistance) {
        return !this.isOnRoute || this.railProgress < (double)((float)trainDistance + this.railLength);
    }

    public final boolean isCurrentlyManual() {
        return this.isCurrentlyManual;
    }

    public boolean changeManualSpeed(boolean isAccelerate) {
        if (this.doorValue == 0.0f && isAccelerate && this.manualNotch >= -2 && this.manualNotch < 2) {
            ++this.manualNotch;
            return true;
        }
        if (!isAccelerate && this.manualNotch > -2) {
            --this.manualNotch;
            return true;
        }
        return false;
    }

    public boolean toggleDoors() {
        if (this.speed == 0.0f) {
            this.doorTarget = !this.doorTarget;
            this.manualNotch = -2;
            return true;
        }
        this.doorTarget = false;
        return false;
    }

    public final int getIndex(int car, int trainSpacing, boolean roundDown) {
        return this.getIndex(this.getRailProgress(car, trainSpacing), roundDown);
    }

    public final int getIndex(double tempRailProgress, boolean roundDown) {
        for (int i = 0; i < this.path.size(); ++i) {
            double tempDistance = this.distances.get(i);
            if (!(tempRailProgress < tempDistance) && (!roundDown || tempRailProgress != tempDistance)) continue;
            return i;
        }
        return this.path.size() - 1;
    }

    public final float getRailSpeed(int railIndex) {
        float railSpeed;
        RailType thisRail = this.path.get((int)railIndex).rail.railType;
        if (thisRail.canAccelerate) {
            railSpeed = thisRail.maxBlocksPerTick;
        } else {
            RailType lastRail = railIndex > 0 ? this.path.get((int)(railIndex - 1)).rail.railType : thisRail;
            railSpeed = Math.max(lastRail.canAccelerate ? lastRail.maxBlocksPerTick : RailType.getDefaultMaxBlocksPerTick(this.transportMode), this.speed);
        }
        return railSpeed;
    }

    public final boolean isPlayerRiding(class_1657 player) {
        return this.ridingEntities.contains(player.method_5667());
    }

    public final float getSpeed() {
        return this.speed;
    }

    public final float getDoorValue() {
        return this.doorValue;
    }

    public final float getElapsedDwellTicks() {
        return this.elapsedDwellTicks;
    }

    public final boolean isReversed() {
        return this.reversed;
    }

    public final boolean isOnRoute() {
        return this.isOnRoute;
    }

    public int getTotalDwellTicks() {
        return this.path.get((int)this.nextStoppingIndex).dwellTime * 10;
    }

    protected final void simulateTrain(class_1937 world, float ticksElapsed, Depot depot) {
        if (world == null) {
            return;
        }
        try {
            float tempDoorValue;
            boolean tempDoorOpen;
            if (this.nextStoppingIndex >= this.path.size()) {
                return;
            }
            int totalDwellTicks = this.getTotalDwellTicks();
            if (!this.isOnRoute) {
                this.railProgress = (this.railLength + (float)(this.trainCars * this.spacing)) / 2.0f;
                this.reversed = false;
                tempDoorOpen = false;
                tempDoorValue = 0.0f;
                this.speed = 0.0f;
                this.nextStoppingIndex = 0;
                if (!this.isCurrentlyManual && this.canDeploy(depot) || this.isCurrentlyManual && this.manualNotch > 0) {
                    this.startUp(world, this.trainCars, this.spacing, this.isOppositeRail());
                }
            } else {
                float newAcceleration = this.accelerationConstant * ticksElapsed;
                if (this.railProgress >= this.distances.get(this.distances.size() - 1) - (double)((this.railLength - (float)(this.trainCars * this.spacing)) / 2.0f)) {
                    this.isOnRoute = false;
                    this.manualNotch = -2;
                    this.ridingEntities.clear();
                    tempDoorOpen = false;
                    tempDoorValue = 0.0f;
                } else {
                    if (this.speed <= 0.0f) {
                        this.speed = 0.0f;
                        boolean isOppositeRail = this.isOppositeRail();
                        boolean railBlocked = this.isRailBlocked(this.getIndex(0, this.spacing, true) + (isOppositeRail ? 2 : 1));
                        if (totalDwellTicks == 0) {
                            tempDoorOpen = false;
                        } else {
                            if (this.elapsedDwellTicks == 0.0f && this.isRepeat() && this.getIndex(this.railProgress, false) >= this.repeatIndex2 && this.distances.size() > this.repeatIndex1) {
                                if (this.path.get(this.repeatIndex2).isOppositeRail(this.path.get(this.repeatIndex1))) {
                                    this.railProgress = this.distances.get(this.repeatIndex1 - 1) + (double)(this.trainCars * this.spacing);
                                    this.reversed = !this.reversed;
                                } else {
                                    this.railProgress = this.distances.get(this.repeatIndex1);
                                }
                            }
                            if (this.elapsedDwellTicks < (float)(totalDwellTicks - 64 - 20) - ticksElapsed || !railBlocked) {
                                this.elapsedDwellTicks += ticksElapsed;
                            }
                            tempDoorOpen = this.openDoors();
                        }
                        if (!(world.method_8608() || !this.isCurrentlyManual && !(this.elapsedDwellTicks >= (float)totalDwellTicks) || railBlocked || this.isCurrentlyManual && this.manualNotch <= 0)) {
                            this.startUp(world, this.trainCars, this.spacing, isOppositeRail);
                        }
                    } else {
                        if (!world.method_8608()) {
                            int checkIndex = this.getIndex(0, this.spacing, true) + 1;
                            if (this.isRailBlocked(checkIndex)) {
                                this.nextStoppingIndex = checkIndex - 1;
                            } else if (this.nextPlatformIndex > 0 && this.nextPlatformIndex < this.path.size()) {
                                this.nextStoppingIndex = this.nextPlatformIndex;
                                if (this.manualNotch < -2) {
                                    this.manualNotch = 0;
                                }
                            }
                        }
                        double stoppingDistance = this.distances.get(this.nextStoppingIndex) - this.railProgress;
                        if (!this.transportMode.continuousMovement && stoppingDistance < 0.5 * (double)this.speed * (double)this.speed / (double)this.accelerationConstant) {
                            this.speed = stoppingDistance <= 0.0 ? 0.01f : (float)Math.max((double)this.speed - 0.5 * (double)this.speed * (double)this.speed / stoppingDistance * (double)ticksElapsed, (double)0.01f);
                            this.manualNotch = -3;
                        } else if (this.isCurrentlyManual) {
                            if (this.manualNotch >= -2) {
                                RailType railType = Train.convertMaxManualSpeed(this.maxManualSpeed);
                                this.speed = class_3532.method_15363((float)(this.speed + (float)this.manualNotch * newAcceleration / 2.0f), (float)0.0f, (float)(railType == null ? RailType.IRON.maxBlocksPerTick : railType.maxBlocksPerTick));
                            }
                        } else {
                            float railSpeed = this.getRailSpeed(this.getIndex(0, this.spacing, false));
                            if (this.speed < railSpeed) {
                                this.speed = Math.min(this.speed + newAcceleration, railSpeed);
                                this.manualNotch = 2;
                            } else if (this.speed > railSpeed) {
                                this.speed = Math.max(this.speed - newAcceleration, railSpeed);
                                this.manualNotch = -2;
                            } else {
                                this.manualNotch = 0;
                            }
                        }
                        tempDoorOpen = this.transportMode.continuousMovement && this.openDoors();
                    }
                    this.railProgress += (double)(this.speed * ticksElapsed);
                    if (!this.transportMode.continuousMovement && this.railProgress > this.distances.get(this.nextStoppingIndex)) {
                        this.railProgress = this.distances.get(this.nextStoppingIndex);
                        this.speed = 0.0f;
                        this.manualNotch = -2;
                    }
                    tempDoorValue = class_3532.method_15363((float)(this.doorValue + ticksElapsed * (float)(this.doorTarget ? 1 : -1) / 64.0f), (float)0.0f, (float)1.0f);
                }
            }
            this.doorTarget = tempDoorOpen;
            this.doorValue = tempDoorValue;
            if (this.doorTarget || this.doorValue != 0.0f) {
                this.manualNotch = -2;
            }
            if (!this.path.isEmpty()) {
                class_243[] positions = new class_243[this.trainCars + 1];
                for (int i = 0; i <= this.trainCars; ++i) {
                    positions[i] = this.getRoutePosition(this.reversed ? this.trainCars - i : i, this.spacing);
                }
                if (this.handlePositions(world, positions, ticksElapsed)) {
                    double[] prevX = new double[]{0.0};
                    double[] prevY = new double[]{0.0};
                    double[] prevZ = new double[]{0.0};
                    float[] prevYaw = new float[]{0.0f};
                    float[] prevPitch = new float[]{0.0f};
                    for (int i = 0; i < this.trainCars; ++i) {
                        int ridingCar = i;
                        this.calculateCar(world, positions, i, totalDwellTicks, (x, y, z, yaw, pitch, realSpacing, doorLeftOpen, doorRightOpen) -> {
                            this.simulateCar(world, ridingCar, ticksElapsed, x, y, z, yaw, pitch, prevX[0], prevY[0], prevZ[0], prevYaw[0], prevPitch[0], doorLeftOpen, doorRightOpen, realSpacing);
                            prevX[0] = x;
                            prevY[0] = y;
                            prevZ[0] = z;
                            prevYaw[0] = yaw;
                            prevPitch[0] = pitch;
                        });
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected final void calculateCar(class_1937 world, class_243[] positions, int index, int dwellTicks, CalculateCarCallback calculateCarCallback) {
        class_243 pos1 = positions[index];
        class_243 pos2 = positions[index + 1];
        if (pos1 != null && pos2 != null) {
            double x = Train.getAverage(pos1.field_1352, pos2.field_1352);
            double y = Train.getAverage(pos1.field_1351, pos2.field_1351) + 1.0;
            double z = Train.getAverage(pos1.field_1350, pos2.field_1350);
            double realSpacing = pos2.method_1022(pos1);
            float yaw = (float)class_3532.method_15349((double)(pos2.field_1352 - pos1.field_1352), (double)(pos2.field_1350 - pos1.field_1350));
            float pitch = realSpacing == 0.0 ? 0.0f : (float)this.asin((pos2.field_1351 - pos1.field_1351) / realSpacing);
            boolean doorLeftOpen = this.scanDoors(world, x, y, z, (float)Math.PI + yaw, pitch, realSpacing / 2.0, dwellTicks) && this.doorValue > 0.0f;
            boolean doorRightOpen = this.scanDoors(world, x, y, z, yaw, pitch, realSpacing / 2.0, dwellTicks) && this.doorValue > 0.0f;
            calculateCarCallback.calculateCarCallback(x, y, z, yaw, pitch, realSpacing, doorLeftOpen, doorRightOpen);
        }
    }

    protected void startUp(class_1937 world, int trainCars, int trainSpacing, boolean isOppositeRail) {
        this.doorTarget = false;
        this.doorValue = 0.0f;
        this.nextPlatformIndex = this.nextStoppingIndex;
    }

    protected boolean openDoors() {
        return this.doorTarget;
    }

    protected float getModelZOffset() {
        return 0.0f;
    }

    protected boolean isRepeat() {
        return this.repeatIndex1 > 0 && this.repeatIndex2 > 0;
    }

    protected abstract void simulateCar(class_1937 var1, int var2, float var3, double var4, double var6, double var8, float var10, float var11, double var12, double var14, double var16, float var18, float var19, boolean var20, boolean var21, double var22);

    protected abstract boolean handlePositions(class_1937 var1, class_243[] var2, float var3);

    protected abstract boolean canDeploy(Depot var1);

    protected abstract boolean isRailBlocked(int var1);

    protected abstract boolean skipScanBlocks(class_1937 var1, double var2, double var4, double var6);

    protected abstract boolean openDoors(class_1937 var1, class_2248 var2, class_2338 var3, int var4);

    protected abstract double asin(double var1);

    private boolean isOppositeRail() {
        return this.path.size() > this.nextStoppingIndex + 1 && this.railProgress == this.distances.get(this.nextStoppingIndex) && this.path.get(this.nextStoppingIndex).isOppositeRail(this.path.get(this.nextStoppingIndex + 1));
    }

    private double getRailProgress(int car, int trainSpacing) {
        return this.railProgress - (double)(car * trainSpacing);
    }

    private class_243 getRoutePosition(int car, int trainSpacing) {
        double tempRailProgress = Math.max(this.getRailProgress(car, trainSpacing) - (double)this.getModelZOffset(), 0.0);
        int index = this.getIndex(tempRailProgress, false);
        return this.path.get((int)index).rail.getPosition(tempRailProgress - (index == 0 ? 0.0 : this.distances.get(index - 1))).method_1031(0.0, (double)this.transportMode.railOffset, 0.0);
    }

    private boolean scanDoors(class_1937 world, double trainX, double trainY, double trainZ, float checkYaw, float pitch, double halfSpacing, int dwellTicks) {
        if (this.skipScanBlocks(world, trainX, trainY, trainZ)) {
            return false;
        }
        boolean hasPlatform = false;
        class_243 offsetVec = new class_243(1.0, 0.0, 0.0).method_1024(checkYaw).method_1037(pitch);
        class_243 traverseVec = new class_243(0.0, 0.0, 1.0).method_1024(checkYaw).method_1037(pitch);
        for (int checkX = 1; checkX <= 3; ++checkX) {
            for (int checkY = -2; checkY <= 3; ++checkY) {
                for (double checkZ = -halfSpacing; checkZ <= halfSpacing; checkZ += 1.0) {
                    class_2338 checkPos = RailwayData.newBlockPos(trainX + offsetVec.field_1352 * (double)checkX + traverseVec.field_1352 * checkZ, trainY + (double)checkY, trainZ + offsetVec.field_1350 * (double)checkX + traverseVec.field_1350 * checkZ);
                    class_2248 block = world.method_8320(checkPos).method_26204();
                    if (!(block instanceof BlockPlatform) && !(block instanceof BlockPSDAPGBase)) continue;
                    if (this.openDoors(world, block, checkPos, dwellTicks)) {
                        return true;
                    }
                    hasPlatform = true;
                }
            }
        }
        return hasPlatform;
    }

    public static boolean isHoldingKey(class_1657 player) {
        return player != null && !Keys.LIFTS_ONLY && player.method_24518(Items.DRIVER_KEY.get());
    }

    public static double getAverage(double a, double b) {
        return (a + b) / 2.0;
    }

    public static RailType convertMaxManualSpeed(int maxManualSpeed) {
        if (maxManualSpeed >= 0 && maxManualSpeed <= RailType.DIAMOND.ordinal()) {
            return RailType.values()[maxManualSpeed];
        }
        return null;
    }

    @FunctionalInterface
    protected static interface CalculateCarCallback {
        public void calculateCarCallback(double var1, double var3, double var5, float var7, float var8, double var9, boolean var11, boolean var12);
    }
}

