/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mtr.MTRClient;
import mtr.client.ClientData;
import mtr.client.Config;
import mtr.client.ScrollingText;
import mtr.client.TrainClientRegistry;
import mtr.client.TrainProperties;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.Siding;
import mtr.data.Station;
import mtr.data.Train;
import mtr.data.VehicleRidingClient;
import mtr.path.PathData;
import mtr.render.RenderDrivingOverlay;
import mtr.render.TrainRendererBase;
import mtr.sound.TrainSoundBase;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_746;

public class TrainClient
extends Train
implements IGui {
    public boolean isRemoved = false;
    private boolean justMounted;
    private float oldSpeed;
    private double oldRailProgress;
    private float oldDoorValue;
    private boolean doorOpening;
    private boolean isSitting;
    private boolean previousShifting;
    private int currentStationIndex;
    private Route thisRoute;
    private Route nextRoute;
    private Station thisStation;
    private Station nextStation;
    private Station lastStation;
    private SpeedCallback speedCallback;
    private AnnouncementCallback announcementCallback;
    private AnnouncementCallback lightRailAnnouncementCallback;
    private Depot depot;
    private List<Long> routeIds = new ArrayList<Long>();
    public final TrainRendererBase trainRenderer;
    public final TrainSoundBase trainSound;
    public final VehicleRidingClient vehicleRidingClient = new VehicleRidingClient(this.ridingEntities, PACKET_UPDATE_TRAIN_PASSENGER_POSITION);
    public final List<ScrollingText> scrollingTexts = new ArrayList<ScrollingText>();
    private final Set<Runnable> trainTranslucentRenders = new HashSet<Runnable>();
    private static final float CONNECTION_HEIGHT = 2.25f;
    private static final float CONNECTION_Z_OFFSET = 0.5f;
    private static final float CONNECTION_X_OFFSET = 0.25f;

    public TrainClient(class_2540 packet) {
        super(packet);
        TrainProperties trainProperties = TrainClientRegistry.getTrainProperties(this.trainId);
        this.trainRenderer = trainProperties.renderer.createTrainInstance(this);
        this.trainSound = trainProperties.sound.createTrainInstance(this);
    }

    @Override
    protected void simulateCar(class_1937 world, int ridingCar, float ticksElapsed, double carX, double carY, double carZ, float carYaw, float carPitch, double prevCarX, double prevCarY, double prevCarZ, float prevCarYaw, float prevCarPitch, boolean doorLeftOpen, boolean doorRightOpen, double realSpacing) {
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (clientPlayer == null) {
            return;
        }
        class_2338 soundPos = RailwayData.newBlockPos(carX, carY, carZ);
        this.trainSound.playAllCars(world, soundPos, ridingCar);
        if (doorLeftOpen || doorRightOpen) {
            this.trainSound.playAllCarsDoorOpening(world, soundPos, ridingCar);
        }
        class_243 offset = this.vehicleRidingClient.renderPlayerAndGetOffset();
        double newX = carX - offset.field_1352;
        double newY = carY - offset.field_1351;
        double newZ = carZ - offset.field_1350;
        this.doorOpening = this.doorValue > this.oldDoorValue;
        this.trainRenderer.renderCar(ridingCar, newX, newY, newZ, carYaw, carPitch, doorLeftOpen, doorRightOpen);
        this.trainTranslucentRenders.add(() -> this.trainRenderer.renderCar(ridingCar, newX, newY, newZ, carYaw, carPitch, doorLeftOpen, doorRightOpen));
        if (ridingCar > 0) {
            double newPrevCarX = prevCarX - offset.field_1352;
            double newPrevCarY = prevCarY - offset.field_1351;
            double newPrevCarZ = prevCarZ - offset.field_1350;
            class_243 prevPos0 = new class_243(0.0, 0.0, (double)this.spacing / 2.0 - 1.0).method_1037(prevCarPitch).method_1024(prevCarYaw).method_1031(newPrevCarX, newPrevCarY, newPrevCarZ);
            class_243 thisPos0 = new class_243(0.0, 0.0, -((double)this.spacing / 2.0 - 1.0)).method_1037(carPitch).method_1024(carYaw).method_1031(newX, newY, newZ);
            class_243 connectPos = prevPos0.method_1019(thisPos0).method_1021(0.5);
            float connectYaw = (float)class_3532.method_15349((double)(thisPos0.field_1352 - prevPos0.field_1352), (double)(thisPos0.field_1350 - prevPos0.field_1350));
            float connectPitch = realSpacing == 0.0 ? 0.0f : (float)this.asin((thisPos0.field_1351 - prevPos0.field_1351) / realSpacing);
            for (int i = 0; i < 2; ++i) {
                double xStart = (double)this.width / 2.0 + (i == 0 ? -1.0 : 0.5) * 0.25;
                double zStart = (double)this.spacing / 2.0 - (double)((float)(i == 0 ? 1 : 2) * 0.5f);
                class_243 prevPos1 = new class_243(xStart, (double)0.003125f, zStart).method_1037(prevCarPitch).method_1024(prevCarYaw).method_1031(newPrevCarX, newPrevCarY, newPrevCarZ);
                class_243 prevPos2 = new class_243(xStart, 2.253124952316284, zStart).method_1037(prevCarPitch).method_1024(prevCarYaw).method_1031(newPrevCarX, newPrevCarY, newPrevCarZ);
                class_243 prevPos3 = new class_243(-xStart, 2.253124952316284, zStart).method_1037(prevCarPitch).method_1024(prevCarYaw).method_1031(newPrevCarX, newPrevCarY, newPrevCarZ);
                class_243 prevPos4 = new class_243(-xStart, (double)0.003125f, zStart).method_1037(prevCarPitch).method_1024(prevCarYaw).method_1031(newPrevCarX, newPrevCarY, newPrevCarZ);
                class_243 thisPos1 = new class_243(-xStart, (double)0.003125f, -zStart).method_1037(carPitch).method_1024(carYaw).method_1031(newX, newY, newZ);
                class_243 thisPos2 = new class_243(-xStart, 2.253124952316284, -zStart).method_1037(carPitch).method_1024(carYaw).method_1031(newX, newY, newZ);
                class_243 thisPos3 = new class_243(xStart, 2.253124952316284, -zStart).method_1037(carPitch).method_1024(carYaw).method_1031(newX, newY, newZ);
                class_243 thisPos4 = new class_243(xStart, (double)0.003125f, -zStart).method_1037(carPitch).method_1024(carYaw).method_1031(newX, newY, newZ);
                if (i == 0) {
                    this.trainRenderer.renderConnection(prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, connectPos.field_1352, connectPos.field_1351, connectPos.field_1350, connectYaw, connectPitch);
                    continue;
                }
                this.trainRenderer.renderBarrier(prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, connectPos.field_1352, connectPos.field_1351, connectPos.field_1350, connectYaw, connectPitch);
            }
        }
    }

    @Override
    protected boolean handlePositions(class_1937 world, class_243[] positions, float ticksElapsed) {
        class_310 client = class_310.method_1551();
        class_746 clientPlayer = client.field_1724;
        if (clientPlayer == null) {
            return false;
        }
        this.vehicleRidingClient.begin();
        if (ticksElapsed > 0.0f) {
            if (this.isPlayerRiding((class_1657)clientPlayer)) {
                double targetProgress;
                int headIndex = this.getIndex(0, this.spacing, false);
                int stopIndex = ((PathData)this.path.get((int)headIndex)).stopIndex - 1;
                if (this.speedCallback != null) {
                    this.speedCallback.speedCallback(this.speed * 20.0f, stopIndex, this.routeIds);
                }
                if (this.announcementCallback != null && this.oldRailProgress < (targetProgress = (Double)this.distances.get(this.getPreviousStoppingIndex(headIndex)) + (double)((this.trainCars + 1) * this.spacing)) && this.railProgress >= targetProgress) {
                    this.announcementCallback.announcementCallback(stopIndex, this.routeIds);
                }
                if (this.lightRailAnnouncementCallback != null && (this.justOpening() || this.justMounted)) {
                    this.lightRailAnnouncementCallback.announcementCallback(stopIndex, this.routeIds);
                }
            }
            TrainProperties trainProperties = TrainClientRegistry.getTrainProperties(this.trainId);
            this.vehicleRidingClient.movePlayer(uuid -> {
                Train.CalculateCarCallback calculateCarCallback = (x, y, z, yaw, pitch, realSpacingRender, doorLeftOpenRender, doorRightOpenRender) -> this.vehicleRidingClient.setOffsets((UUID)uuid, x, y, z, yaw, pitch, this.transportMode.maxLength == 1 ? (double)this.spacing : realSpacingRender, this.width, doorLeftOpenRender, doorRightOpenRender, this.transportMode.hasPitchAscending, this.transportMode.hasPitchDescending, trainProperties.riderOffset, trainProperties.riderOffsetDismounting, this.speed > 0.0f, this.doorValue == 0.0f, () -> {
                    boolean isShifting = clientPlayer.method_5715();
                    if (Config.shiftToToggleSitting() && !MTRClient.isVivecraft()) {
                        if (isShifting && !this.previousShifting) {
                            this.isSitting = !this.isSitting;
                        }
                        clientPlayer.method_18380(this.isSitting && !client.field_1773.method_19418().method_19333() ? class_4050.field_18081 : class_4050.field_18076);
                    }
                    this.previousShifting = isShifting;
                });
                int currentRidingCar = class_3532.method_15340((int)((int)Math.floor(this.vehicleRidingClient.getPercentageZ((UUID)uuid))), (int)0, (int)(positions.length - 2));
                this.calculateCar(world, positions, currentRidingCar, 0, (x, y, z, yaw, pitch, realSpacingRender, doorLeftOpenRender, doorRightOpenRender) -> {
                    this.vehicleRidingClient.moveSelf(this.id, (UUID)uuid, realSpacingRender, this.width, yaw, currentRidingCar, this.trainCars, doorLeftOpenRender, doorRightOpenRender, !trainProperties.hasGangwayConnection, ticksElapsed);
                    int newRidingCar = class_3532.method_15340((int)((int)Math.floor(this.vehicleRidingClient.getPercentageZ((UUID)uuid))), (int)0, (int)(positions.length - 2));
                    if (currentRidingCar == newRidingCar) {
                        calculateCarCallback.calculateCarCallback(x, y, z, yaw, pitch, realSpacingRender, doorLeftOpenRender, doorRightOpenRender);
                    } else {
                        this.calculateCar(world, positions, newRidingCar, 0, calculateCarCallback);
                    }
                });
            });
        }
        this.vehicleRidingClient.end();
        this.justMounted = false;
        class_1297 camera = client.field_1719;
        class_243 cameraPos = camera == null ? class_243.field_1353 : camera.method_19538();
        double nearestDistance = Double.POSITIVE_INFINITY;
        int nearestCar = 0;
        for (int i = 0; i < this.trainCars; ++i) {
            double checkDistance = cameraPos.method_1025(positions[i]);
            if (!(checkDistance < nearestDistance)) continue;
            nearestCar = i;
            nearestDistance = checkDistance;
        }
        class_2338 soundPos = RailwayData.newBlockPos(positions[nearestCar].field_1352, positions[nearestCar].field_1351, positions[nearestCar].field_1350);
        this.trainSound.playNearestCar(world, soundPos, nearestCar);
        return true;
    }

    @Override
    protected boolean canDeploy(Depot depot) {
        return false;
    }

    @Override
    protected boolean isRailBlocked(int checkIndex) {
        return false;
    }

    @Override
    protected boolean skipScanBlocks(class_1937 world, double trainX, double trainY, double trainZ) {
        return false;
    }

    @Override
    protected boolean openDoors(class_1937 world, class_2248 block, class_2338 checkPos, int dwellTicks) {
        return true;
    }

    @Override
    protected float getModelZOffset() {
        return this.baseTrainType.startsWith("london_underground_199") || this.trainId.startsWith("london_underground_199") || this.baseTrainType.equals("mpl_85") || this.trainId.equals("mpl_85") || this.baseTrainType.equals("br_423") || this.trainId.equals("br_423") ? (this.reversed ? -0.5f : 0.5f) : 0.0f;
    }

    @Override
    protected double asin(double value) {
        return Math.asin(value);
    }

    public void simulateTrain(class_1937 world, float ticksElapsed, SpeedCallback speedCallback, AnnouncementCallback announcementCallback, AnnouncementCallback lightRailAnnouncementCallback) {
        int stopIndex;
        this.trainTranslucentRenders.clear();
        this.speedCallback = speedCallback;
        this.announcementCallback = announcementCallback;
        this.lightRailAnnouncementCallback = lightRailAnnouncementCallback;
        this.oldSpeed = this.speed;
        this.oldRailProgress = this.railProgress;
        this.oldDoorValue = this.doorValue;
        if (ticksElapsed != 0.0f && !RailwayData.useRoutesAndStationsFromIndex(stopIndex = ((PathData)this.path.get((int)this.getIndex((int)0, (int)this.spacing, (boolean)false))).stopIndex - 1, this.routeIds, ClientData.DATA_CACHE, (currentStationIndex, thisRoute1, nextRoute1, thisStation1, nextStation1, lastStation1) -> {
            this.currentStationIndex = currentStationIndex;
            this.thisRoute = thisRoute1;
            this.nextRoute = nextRoute1;
            this.thisStation = thisStation1;
            this.nextStation = nextStation1;
            this.lastStation = lastStation1;
        })) {
            this.currentStationIndex = 0;
            this.thisRoute = null;
            this.nextRoute = null;
            this.thisStation = null;
            this.nextStation = null;
            this.lastStation = null;
        }
        this.simulateTrain(world, ticksElapsed, null);
        if (this.depot == null || this.routeIds.isEmpty()) {
            Siding siding = (Siding)ClientData.DATA_CACHE.sidingIdMap.get(this.sidingId);
            this.depot = siding == null ? null : (Depot)ClientData.DATA_CACHE.sidingIdToDepot.get(siding.id);
            List<Object> list = this.routeIds = this.depot == null ? new ArrayList() : this.depot.routeIds;
            if (this.depot != null) {
                this.depot.lastDeployedMillis = System.currentTimeMillis();
            }
        }
        class_746 player = class_310.method_1551().field_1724;
        if (this.isManualAllowed && Train.isHoldingKey((class_1657)player) && this.isPlayerRiding((class_1657)player)) {
            RenderDrivingOverlay.setData(this.manualNotch, this);
        }
    }

    public void renderTranslucent() {
        this.trainTranslucentRenders.forEach(Runnable::run);
        this.trainTranslucentRenders.clear();
    }

    public class_243 getViewOffset() {
        return this.vehicleRidingClient.getViewOffset();
    }

    public int getCurrentStationIndex() {
        return this.currentStationIndex;
    }

    public Route getThisRoute() {
        return this.thisRoute;
    }

    public Route getNextRoute() {
        return this.nextRoute;
    }

    public Station getThisStation() {
        return this.thisStation;
    }

    public Station getNextStation() {
        return this.nextStation;
    }

    public Station getLastStation() {
        return this.lastStation;
    }

    public void startRidingClient(UUID uuid, float percentageX, float percentageZ) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.method_5667().equals(uuid)) {
            this.justMounted = true;
            this.isSitting = false;
        }
        this.vehicleRidingClient.startRiding(uuid, percentageX, percentageZ);
    }

    public void updateRiderPercentages(UUID uuid, float percentageX, float percentageZ) {
        this.vehicleRidingClient.updateRiderPercentages(uuid, percentageX, percentageZ);
    }

    public void copyFromTrain(Train train) {
        this.path.clear();
        this.distances.clear();
        this.ridingEntities.clear();
        this.path.addAll(train.path);
        this.distances.addAll(train.distances);
        this.ridingEntities.addAll(train.ridingEntities);
        this.speed = train.speed;
        this.railProgress = train.railProgress;
        this.doorTarget = train.doorTarget;
        this.elapsedDwellTicks = train.elapsedDwellTicks;
        this.nextStoppingIndex = train.nextStoppingIndex;
        this.nextPlatformIndex = train.nextPlatformIndex;
        this.reversed = train.reversed;
        this.isOnRoute = train.isOnRoute;
        this.isCurrentlyManual = train.isCurrentlyManual;
        this.manualNotch = train.manualNotch;
    }

    public final float speedChange() {
        return this.speed - this.oldSpeed;
    }

    public boolean justOpening() {
        return this.oldDoorValue == 0.0f && this.doorValue > 0.0f;
    }

    public boolean justClosing(float doorCloseTime) {
        return this.oldDoorValue >= doorCloseTime && this.doorValue < doorCloseTime;
    }

    public final boolean isDoorOpening() {
        return this.doorOpening;
    }

    public final List<Long> getRouteIds() {
        return this.routeIds;
    }

    private int getPreviousStoppingIndex(int headIndex) {
        for (int i = headIndex; i >= 0; --i) {
            if (((PathData)this.path.get((int)i)).dwellTime <= 0 || ((PathData)this.path.get((int)i)).rail.railType != RailType.PLATFORM) continue;
            return i;
        }
        return 0;
    }

    @FunctionalInterface
    public static interface SpeedCallback {
        public void speedCallback(float var1, int var2, List<Long> var3);
    }

    @FunctionalInterface
    public static interface AnnouncementCallback {
        public void announcementCallback(int var1, List<Long> var2);
    }
}

