/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import mtr.MTRClient;
import mtr.RegistryClient;
import mtr.client.ClientData;
import mtr.entity.EntitySeat;
import mtr.mappings.Utilities;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.render.TrainRendererBase;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;

public class VehicleRidingClient {
    private float clientPrevYaw;
    private float oldPercentageX;
    private float oldPercentageZ;
    private double lastSentX;
    private double lastSentY;
    private double lastSentZ;
    private float lastSentTicks;
    private int interval;
    private int previousInterval;
    private final List<Double> offset = new ArrayList<Double>();
    private final Map<UUID, Float> percentagesX = new HashMap<UUID, Float>();
    private final Map<UUID, Float> percentagesZ = new HashMap<UUID, Float>();
    private final Map<UUID, Float> newPercentagesX = new HashMap<UUID, Float>();
    private final Map<UUID, Float> newPercentagesZ = new HashMap<UUID, Float>();
    private final Map<UUID, class_243> riderPositions = new HashMap<UUID, class_243>();
    private final Set<UUID> ridingEntities;
    private final class_2960 packetId;
    private static final float VEHICLE_WALKING_SPEED_MULTIPLIER = 0.25f;
    private static final int VEHICLE_PERCENTAGE_UPDATE_INTERVAL = 20;
    private static final boolean DEBUG_SKIP_RENDER_TRAIN_AND_PLAYERS = false;

    public VehicleRidingClient(Set<UUID> ridingEntities, class_2960 packetId) {
        this.ridingEntities = ridingEntities;
        this.packetId = packetId;
    }

    public class_243 renderPlayerAndGetOffset() {
        boolean noOffset = this.offset.isEmpty();
        this.riderPositions.forEach((uuid, position) -> {
            if (noOffset) {
                TrainRendererBase.renderRidingPlayer(this.getViewOffset(), uuid, position);
            } else {
                TrainRendererBase.renderRidingPlayer(this.getViewOffset(), uuid, position.method_1023(this.offset.get(0).doubleValue(), this.offset.get(1).doubleValue(), this.offset.get(2).doubleValue()));
            }
        });
        if (noOffset) {
            return class_243.field_1353;
        }
        return new class_243(this.offset.get(0).doubleValue(), this.offset.get(1).doubleValue(), this.offset.get(2).doubleValue());
    }

    public void movePlayer(Consumer<UUID> ridingEntityCallback) {
        this.offset.clear();
        this.riderPositions.clear();
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (clientPlayer == null) {
            return;
        }
        this.ridingEntities.forEach(uuid -> {
            if (!this.percentagesX.containsKey(uuid) || !this.newPercentagesX.containsKey(uuid)) {
                this.percentagesX.put((UUID)uuid, Float.valueOf(0.5f));
                this.newPercentagesX.put((UUID)uuid, Float.valueOf(0.5f));
            }
            if (!this.percentagesZ.containsKey(uuid) || !this.newPercentagesZ.containsKey(uuid)) {
                this.percentagesZ.put((UUID)uuid, Float.valueOf(0.5f));
                this.newPercentagesZ.put((UUID)uuid, Float.valueOf(0.5f));
            }
            ridingEntityCallback.accept((UUID)uuid);
        });
    }

    public void setOffsets(UUID uuid, double x, double y, double z, float yaw, float pitch, double length, int width, boolean doorLeftOpen, boolean doorRightOpen, boolean hasPitchAscending, boolean hasPitchDescending, float riderOffset, float riderOffsetDismounting, boolean shouldSetOffset, boolean shouldSetYaw, Runnable clientPlayerCallback) {
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (clientPlayer == null) {
            return;
        }
        boolean isClientPlayer = uuid.equals(clientPlayer.method_5667());
        double percentageX = VehicleRidingClient.getValueFromPercentage(this.percentagesX.get(uuid).floatValue(), width);
        float riderOffsetNew = doorLeftOpen && percentageX < 0.0 || doorRightOpen && percentageX > 1.0 ? riderOffsetDismounting : riderOffset;
        class_243 playerOffset = new class_243(percentageX, (double)riderOffsetNew, VehicleRidingClient.getValueFromPercentage(class_3532.method_22450((float)this.percentagesZ.get(uuid).floatValue()), length)).method_1037((pitch < 0.0f ? hasPitchAscending : hasPitchDescending) ? pitch : 0.0f).method_1024(yaw);
        ClientData.updatePlayerRidingOffset(uuid);
        this.riderPositions.put(uuid, playerOffset.method_1031(x, y, z));
        if (isClientPlayer) {
            boolean movePlayer;
            double moveX = x + playerOffset.field_1352;
            double moveY = y + playerOffset.field_1351;
            double moveZ = z + playerOffset.field_1350;
            if (MTRClient.isVivecraft()) {
                boolean movedFar;
                class_1297 vehicle = clientPlayer.method_5854();
                if (vehicle instanceof EntitySeat) {
                    ((EntitySeat)vehicle).setPosByTrain(moveX, moveY, moveZ);
                    movePlayer = false;
                } else {
                    movePlayer = true;
                }
                float tempPercentageX = this.percentagesX.get(uuid).floatValue();
                boolean doorOpen = doorLeftOpen && tempPercentageX < 0.0f || doorRightOpen && tempPercentageX > 1.0f;
                boolean bl = movedFar = Math.abs(this.lastSentX - moveX) > 2.0 || Math.abs(this.lastSentY - moveY) > 2.0 || Math.abs(this.lastSentZ - moveZ) > 2.0;
                if (doorOpen || MTRClient.getGameTick() - this.lastSentTicks > 60.0f && movedFar) {
                    PacketTrainDataGuiClient.sendUpdateEntitySeatPassengerPosition(moveX, moveY, moveZ);
                    this.lastSentX = moveX;
                    this.lastSentY = moveY;
                    this.lastSentZ = moveZ;
                    this.lastSentTicks = MTRClient.getGameTick();
                }
            } else {
                movePlayer = true;
            }
            if (movePlayer) {
                clientPlayer.field_6017 = 0.0f;
                clientPlayer.method_18800(0.0, 0.0, 0.0);
                clientPlayer.method_6125(0.0f);
                if (MTRClient.getGameTick() > 40.0f) {
                    clientPlayer.method_30634(moveX, moveY, moveZ);
                }
            }
            clientPlayerCallback.run();
            if (shouldSetOffset) {
                if (shouldSetYaw) {
                    float angleDifference = (float)Math.toDegrees(this.clientPrevYaw - yaw);
                    if (angleDifference > 180.0f) {
                        angleDifference -= 360.0f;
                    } else if (angleDifference < -180.0f) {
                        angleDifference += 360.0f;
                    }
                    Utilities.incrementYaw((class_1297)clientPlayer, angleDifference);
                }
                this.offset.add(x);
                this.offset.add(y);
                this.offset.add(z);
                this.offset.add(playerOffset.field_1352);
                this.offset.add(playerOffset.field_1351 + (double)(MTRClient.isVivecraft() ? 0.0f : clientPlayer.method_5751()));
                this.offset.add(playerOffset.field_1350);
            }
            this.clientPrevYaw = yaw;
        }
    }

    public void moveSelf(long id, UUID uuid, double length, int width, float yaw, int percentageOffset, int maxPercentage, boolean doorLeftOpen, boolean doorRightOpen, boolean noGangwayConnection, float ticksElapsed) {
        float newPercentageZ;
        float newPercentageX;
        float speedMultiplier = ticksElapsed * 0.25f;
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (clientPlayer == null) {
            return;
        }
        if (uuid.equals(clientPlayer.method_5667())) {
            class_243 movement = new class_243((double)Math.abs(clientPlayer.field_6212) > 0.5 ? (double)Math.copySign(speedMultiplier, clientPlayer.field_6212) : 0.0, 0.0, (double)Math.abs(clientPlayer.field_6250) > 0.5 ? (double)Math.copySign(speedMultiplier, clientPlayer.field_6250) : 0.0).method_1024((float)(-Math.toRadians(Utilities.getYaw((class_1297)clientPlayer))) - yaw);
            float tempPercentageX = this.percentagesX.get(uuid).floatValue() + (float)movement.field_1352 / (float)width;
            float tempPercentageZ = this.percentagesZ.get(uuid).floatValue() + (length == 0.0 ? 0.0f : (float)movement.field_1350 / (float)length);
            newPercentageX = class_3532.method_15363((float)tempPercentageX, (float)(doorLeftOpen ? -3.0f : 0.0f), (float)(doorRightOpen ? 4.0f : 1.0f));
            newPercentageZ = class_3532.method_15363((float)tempPercentageZ, (float)((noGangwayConnection ? (float)percentageOffset + 0.05f : 0.0f) + 0.01f), (float)((noGangwayConnection ? (float)percentageOffset + 0.95f : (float)maxPercentage) - 0.01f));
            if (this.previousInterval != this.interval && (newPercentageX != this.oldPercentageX || newPercentageZ != this.oldPercentageZ)) {
                class_2540 packet = new class_2540(Unpooled.buffer());
                packet.writeLong(id);
                packet.writeFloat(newPercentageX);
                packet.writeFloat(newPercentageZ);
                packet.method_10797(uuid);
                RegistryClient.sendToServer(this.packetId, packet);
                this.oldPercentageX = newPercentageX;
                this.oldPercentageZ = newPercentageZ;
            }
        } else {
            double distanceZ;
            double distanceX = VehicleRidingClient.getValueFromPercentage(this.newPercentagesX.get(uuid).floatValue(), width) - VehicleRidingClient.getValueFromPercentage(this.percentagesX.get(uuid).floatValue(), width);
            double manhattanDistance = Math.abs(distanceX + (distanceZ = VehicleRidingClient.getValueFromPercentage(this.newPercentagesZ.get(uuid).floatValue(), length) - VehicleRidingClient.getValueFromPercentage(this.percentagesZ.get(uuid).floatValue(), length)));
            if (manhattanDistance == 0.0 || distanceX * distanceX + distanceZ * distanceZ < (double)(speedMultiplier * speedMultiplier)) {
                newPercentageX = this.newPercentagesX.get(uuid).floatValue();
                newPercentageZ = this.newPercentagesZ.get(uuid).floatValue();
            } else {
                newPercentageX = this.percentagesX.get(uuid).floatValue() + (float)(distanceX / manhattanDistance * (double)speedMultiplier / (double)width);
                newPercentageZ = this.percentagesZ.get(uuid).floatValue() + (float)(length == 0.0 ? 0.0 : distanceZ / manhattanDistance * (double)speedMultiplier / length);
            }
        }
        this.percentagesX.put(uuid, Float.valueOf(newPercentageX));
        this.percentagesZ.put(uuid, Float.valueOf(newPercentageZ));
    }

    public void begin() {
        this.interval = (int)Math.floor(MTRClient.getGameTick() / 20.0f);
    }

    public void end() {
        this.previousInterval = this.interval;
    }

    public void startRiding(UUID uuid, float percentageX, float percentageZ) {
        this.ridingEntities.add(uuid);
        this.percentagesX.put(uuid, Float.valueOf(percentageX));
        this.percentagesZ.put(uuid, Float.valueOf(percentageZ));
        this.newPercentagesX.put(uuid, Float.valueOf(percentageX));
        this.newPercentagesZ.put(uuid, Float.valueOf(percentageZ));
    }

    public void updateRiderPercentages(UUID uuid, float percentageX, float percentageZ) {
        this.newPercentagesX.put(uuid, Float.valueOf(percentageX));
        this.newPercentagesZ.put(uuid, Float.valueOf(percentageZ));
    }

    public float getPercentageZ(UUID uuid) {
        return this.percentagesZ.get(uuid).floatValue();
    }

    public class_243 getVehicleOffset() {
        return this.offset.isEmpty() ? null : new class_243(this.offset.get(0).doubleValue(), this.offset.get(1).doubleValue(), this.offset.get(2).doubleValue());
    }

    public class_243 getViewOffset() {
        return this.offset.isEmpty() ? null : new class_243(this.offset.get(3).doubleValue(), this.offset.get(4).doubleValue(), this.offset.get(5).doubleValue());
    }

    private static double getValueFromPercentage(double percentage, double total) {
        return (percentage - 0.5) * total;
    }
}

