/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import mtr.Registry;
import mtr.data.RailwayData;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class VehicleRidingServer {
    private static final float INNER_PADDING = 0.5f;
    private static final int BOX_PADDING = 3;

    public static void mountRider(class_1937 world, Set<UUID> ridingEntities, long id, long routeId, double carX, double carY, double carZ, double length, double width, float carYaw, float carPitch, boolean doorOpen, boolean canMount, int percentageOffset, class_2960 packetId, Function<class_1657, Boolean> canRide, Consumer<class_1657> ridingCallback) {
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData == null) {
            return;
        }
        double halfLength = length / 2.0;
        double halfWidth = width / 2.0;
        if (canMount) {
            double margin = halfLength + 3.0;
            world.method_8390(class_1657.class, new class_238(carX + margin, carY + margin, carZ + margin, carX - margin, carY - margin, carZ - margin), player -> !player.method_7325() && !ridingEntities.contains(player.method_5667()) && railwayData.railwayDataCoolDownModule.canRide((class_1657)player) && (Boolean)canRide.apply((class_1657)player) != false).forEach(player -> {
                class_243 positionRotated = player.method_19538().method_1023(carX, carY, carZ).method_1024(-carYaw).method_1037(-carPitch);
                if (Math.abs(positionRotated.field_1352) < halfWidth + 0.5 && Math.abs(positionRotated.field_1351) < 2.5 && Math.abs(positionRotated.field_1350) <= halfLength && !railwayData.railwayDataCoolDownModule.shouldDismount((class_1657)player)) {
                    ridingEntities.add(player.method_5667());
                    float percentageX = (float)(positionRotated.field_1352 / width + 0.5);
                    float percentageZ = (float)(length == 0.0 ? 0.0 : positionRotated.field_1350 / length + 0.5) + (float)percentageOffset;
                    class_2540 packet = new class_2540(Unpooled.buffer());
                    packet.writeLong(id);
                    packet.writeFloat(percentageX);
                    packet.writeFloat(percentageZ);
                    packet.method_10797(player.method_5667());
                    world.method_18456().forEach(worldPlayer -> Registry.sendToPlayer((class_3222)worldPlayer, packetId, packet));
                }
            });
        }
        HashSet ridersToRemove = new HashSet();
        ridingEntities.forEach(uuid -> {
            class_1657 player = world.method_18470(uuid);
            if (player != null) {
                boolean remove;
                if (player.method_7325() || railwayData.railwayDataCoolDownModule.shouldDismount(player)) {
                    remove = true;
                } else if (doorOpen) {
                    class_243 positionRotated = player.method_19538().method_1023(carX, carY, carZ).method_1024(-carYaw).method_1037(-carPitch);
                    remove = Math.abs(positionRotated.field_1350) <= halfLength && (Math.abs(positionRotated.field_1352) > halfWidth + 0.5 || Math.abs(positionRotated.field_1351) > 10.0);
                } else {
                    remove = false;
                }
                if (remove) {
                    ridersToRemove.add(uuid);
                }
                railwayData.railwayDataCoolDownModule.updatePlayerRiding(player, routeId);
                ridingCallback.accept(player);
            }
        });
        if (!ridersToRemove.isEmpty()) {
            ridersToRemove.forEach(ridingEntities::remove);
        }
    }
}

