/*
 * Decompiled with CFR 0.152.
 */
package mtr.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mtr.CreativeModeTabs;
import mtr.block.BlockLiftTrack;
import mtr.block.BlockLiftTrackFloor;
import mtr.block.IBlock;
import mtr.data.LiftServer;
import mtr.data.RailwayData;
import mtr.item.ItemWithCreativeTabBase;
import mtr.mappings.Text;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public class ItemLiftRefresher
extends ItemWithCreativeTabBase {
    public ItemLiftRefresher() {
        super(CreativeModeTabs.ESCALATORS_LIFTS, properties -> properties.method_7889(1));
    }

    public class_1269 method_7884(class_1838 context) {
        if (!context.method_8045().field_9236) {
            return ItemLiftRefresher.refreshLift(context.method_8045(), context.method_8037(), context.method_8036(), 0, 0, 2, 2, false, null);
        }
        return super.method_7884(context);
    }

    public static void refreshLift(class_1937 world, class_2338 clickedPos, int offsetX, int offsetZ, int width, int depth, boolean isDoubleSided, class_2350 forceFacing) {
        ItemLiftRefresher.refreshLift(world, clickedPos, null, offsetX, offsetZ, width, depth, isDoubleSided, forceFacing);
    }

    private static class_1269 refreshLift(class_1937 world, class_2338 clickedPos, class_1657 player, int offsetX, int offsetZ, int width, int depth, boolean isDoubleSided, class_2350 forceFacing) {
        RailwayData railwayData = RailwayData.getInstance(world);
        if (world.method_8320(clickedPos).method_26204() instanceof BlockLiftTrack && railwayData != null) {
            class_1269 result;
            ArrayList<class_2338> floors = new ArrayList<class_2338>();
            HashSet liftsToModify = new HashSet();
            int i = 0;
            boolean scanForFloors = false;
            class_2338 firstFloor = null;
            class_2350 facing = null;
            railwayData.lifts.removeIf(lift -> lift.isInvalidLift(world));
            while (true) {
                class_2338 checkPos;
                class_2248 checkBlock;
                if (!((checkBlock = world.method_8320(checkPos = clickedPos.method_10087(i)).method_26204()) instanceof BlockLiftTrack)) {
                    if (scanForFloors) break;
                    scanForFloors = true;
                }
                if (scanForFloors && checkBlock instanceof BlockLiftTrackFloor) {
                    class_2586 blockEntity = world.method_8321(checkPos);
                    if (blockEntity instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor) {
                        floors.add(checkPos);
                        if (firstFloor == null || facing == null) {
                            firstFloor = checkPos;
                            facing = (class_2350)IBlock.getStatePropertySafe((class_1922)world, checkPos, class_2383.field_11177);
                        }
                    }
                    railwayData.lifts.forEach(lift -> {
                        if (lift.hasFloor(checkPos)) {
                            liftsToModify.add(lift);
                        }
                    });
                }
                i += scanForFloors ? -1 : 1;
            }
            if (floors.isEmpty() || firstFloor == null || facing == null) {
                if (player != null) {
                    player.method_7353((class_2561)Text.translatable("gui.mtr.no_lift_tracks_floor_found", new Object[0]), true);
                }
                result = class_1269.field_5814;
            } else {
                boolean hasSetFloors = false;
                long liftId = 0L;
                for (LiftServer lift2 : liftsToModify) {
                    if (hasSetFloors) {
                        railwayData.lifts.remove(lift2);
                        continue;
                    }
                    liftId = ItemLiftRefresher.setLiftData(lift2, floors, offsetX, offsetZ, width, depth, isDoubleSided);
                    hasSetFloors = true;
                }
                if (!hasSetFloors) {
                    LiftServer newLift = new LiftServer(firstFloor, forceFacing == null ? facing : forceFacing);
                    liftId = ItemLiftRefresher.setLiftData(newLift, floors, offsetX, offsetZ, width, depth, isDoubleSided);
                    railwayData.lifts.add(newLift);
                }
                if (player != null) {
                    PacketTrainDataGuiServer.openLiftCustomizationScreenS2C((class_3222)player, liftId);
                }
                result = class_1269.field_5812;
            }
            railwayData.dataCache.sync();
            return result;
        }
        if (player != null) {
            player.method_7353((class_2561)Text.translatable("gui.mtr.lift_track_required", new Object[0]), true);
        }
        return class_1269.field_5814;
    }

    private static long setLiftData(LiftServer lift, List<class_2338> floors, int offsetX, int offsetZ, int width, int depth, boolean isDoubleSided) {
        lift.setFloors(floors);
        lift.liftOffsetX = offsetX;
        lift.liftOffsetZ = offsetZ;
        lift.liftWidth = width;
        lift.liftDepth = depth;
        lift.isDoubleSided = isDoubleSided;
        return lift.id;
    }
}

