/*
 * Decompiled with CFR 0.152.
 */
package mtr.item;

import java.util.List;
import mtr.CreativeModeTabs;
import mtr.block.BlockNode;
import mtr.data.RailAngle;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import mtr.item.ItemBlockClickingBase;
import mtr.mappings.Text;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;

public abstract class ItemNodeModifierBase
extends ItemBlockClickingBase {
    public final boolean forNonContinuousMovementNode;
    public final boolean forContinuousMovementNode;
    public final boolean forAirplaneNode;
    protected final boolean isConnector;
    public static final String TAG_POS = "pos";
    private static final String TAG_TRANSPORT_MODE = "transport_mode";

    public ItemNodeModifierBase(boolean forNonContinuousMovementNode, boolean forContinuousMovementNode, boolean forAirplaneNode, boolean isConnector) {
        super(CreativeModeTabs.CORE, properties -> properties.method_7889(1));
        this.forNonContinuousMovementNode = forNonContinuousMovementNode;
        this.forContinuousMovementNode = forContinuousMovementNode;
        this.forAirplaneNode = forAirplaneNode;
        this.isConnector = isConnector;
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> tooltip, class_1836 tooltipFlag) {
        class_2487 compoundTag = stack.method_7948();
        long posLong = compoundTag.method_10537(TAG_POS);
        if (posLong != 0L) {
            tooltip.add((class_2561)Text.translatable("tooltip.mtr.selected_block", class_2338.method_10092((long)posLong).method_23854()).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)));
        }
    }

    @Override
    protected void onStartClick(class_1838 context, class_2487 compoundTag) {
        compoundTag.method_10582(TAG_TRANSPORT_MODE, ((BlockNode)context.method_8045().method_8320((class_2338)context.method_8037()).method_26204()).transportMode.toString());
    }

    @Override
    protected void onEndClick(class_1838 context, class_2338 posEnd, class_2487 compoundTag) {
        class_1937 world = context.method_8045();
        RailwayData railwayData = RailwayData.getInstance(world);
        class_2338 posStart = context.method_8037();
        class_2680 stateStart = world.method_8320(posStart);
        class_2248 blockStart = stateStart.method_26204();
        class_2680 stateEnd = world.method_8320(posEnd);
        if (railwayData != null && stateEnd.method_26204() instanceof BlockNode && ((BlockNode)blockStart).transportMode.toString().equals(compoundTag.method_10558(TAG_TRANSPORT_MODE))) {
            class_1657 player = context.method_8036();
            if (this.isConnector) {
                if (!posStart.equals((Object)posEnd)) {
                    float angle1 = BlockNode.getAngle(stateStart);
                    float angle2 = BlockNode.getAngle(stateEnd);
                    float angleDifference = (float)Math.toDegrees(Math.atan2(posEnd.method_10260() - posStart.method_10260(), posEnd.method_10263() - posStart.method_10263()));
                    RailAngle railAngleStart = RailAngle.fromAngle(angle1 + (float)(RailAngle.similarFacing(angleDifference, angle1) ? 0 : 180));
                    RailAngle railAngleEnd = RailAngle.fromAngle(angle2 + (float)(RailAngle.similarFacing(angleDifference, angle2) ? 180 : 0));
                    this.onConnect(world, context.method_8041(), ((BlockNode)blockStart).transportMode, stateStart, stateEnd, posStart, posEnd, railAngleStart, railAngleEnd, player, railwayData);
                }
            } else {
                this.onRemove(world, posStart, posEnd, player, railwayData);
            }
        }
        compoundTag.method_10551(TAG_TRANSPORT_MODE);
    }

    @Override
    protected boolean clickCondition(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2248 blockStart = world.method_8320(context.method_8037()).method_26204();
        if (blockStart instanceof BlockNode) {
            BlockNode blockNode = (BlockNode)blockStart;
            if (blockNode.transportMode == TransportMode.AIRPLANE) {
                return this.forAirplaneNode;
            }
            return blockNode.transportMode.continuousMovement ? this.forContinuousMovementNode : this.forNonContinuousMovementNode;
        }
        return false;
    }

    protected abstract void onConnect(class_1937 var1, class_1799 var2, TransportMode var3, class_2680 var4, class_2680 var5, class_2338 var6, class_2338 var7, RailAngle var8, RailAngle var9, class_1657 var10, RailwayData var11);

    protected abstract void onRemove(class_1937 var1, class_2338 var2, class_2338 var3, class_1657 var4, RailwayData var5);
}

