/*
 * Decompiled with CFR 0.152.
 */
package mtr.item;

import java.util.List;
import mtr.Blocks;
import mtr.block.BlockNode;
import mtr.data.RailAngle;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import mtr.item.ItemNodeModifierBase;
import mtr.mappings.Text;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_310;

public abstract class ItemNodeModifierSelectableBlockBase
extends ItemNodeModifierBase {
    private final boolean canSaveBlock;
    private final int height;
    private final int width;
    private final int radius;
    private static final String TAG_BLOCK_ID = "block_id";

    public ItemNodeModifierSelectableBlockBase(boolean canSaveBlock, int height, int width) {
        super(true, false, false, true);
        this.canSaveBlock = canSaveBlock;
        this.height = height;
        this.width = width;
        this.radius = width / 2;
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        if (this.canSaveBlock) {
            class_1657 player;
            class_1937 world = context.method_8045();
            if (!world.field_9236 && (player = context.method_8036()) != null && player.method_5715()) {
                class_2680 state = world.method_8320(context.method_8037());
                class_2680 newState = state.method_26204() instanceof BlockNode ? class_2246.field_10124.method_9564() : state;
                player.method_7353((class_2561)Text.translatable("tooltip.mtr.selected_material", Text.translatable(newState.method_26204().method_9539(), new Object[0])), true);
                class_2487 compoundTag = context.method_8041().method_7948();
                compoundTag.method_10569(TAG_BLOCK_ID, class_2248.method_9507((class_2680)newState));
                return class_1269.field_5812;
            }
        }
        return super.method_7884(context);
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> tooltip, class_1836 tooltipFlag) {
        if (this.height > 0) {
            tooltip.add((class_2561)Text.translatable("tooltip.mtr.rail_action_height", this.height).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
        }
        tooltip.add((class_2561)Text.translatable("tooltip.mtr.rail_action_width", this.width).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
        if (this.canSaveBlock) {
            String[] textSplit;
            class_2680 state = this.getSavedState(stack);
            for (String text : textSplit = Text.translatable(state.method_26215() ? "tooltip.mtr.shift_right_click_to_select_material" : "tooltip.mtr.shift_right_click_to_clear", class_310.method_1551().field_1690.field_1832.method_16007(), Text.translatable(Blocks.RAIL_NODE.get().method_9539(), new Object[0])).getString().split("\\|")) {
                tooltip.add((class_2561)Text.literal(text).method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_27706(class_124.field_1056)));
            }
            tooltip.add((class_2561)Text.translatable("tooltip.mtr.selected_material", Text.translatable(state.method_26204().method_9539(), new Object[0])).method_10862(class_2583.field_24360.method_10977(class_124.field_1060)));
        }
        super.method_7851(stack, level, tooltip, tooltipFlag);
    }

    @Override
    protected final void onConnect(class_1937 world, class_1799 stack, TransportMode transportMode, class_2680 stateStart, class_2680 stateEnd, class_2338 posStart, class_2338 posEnd, RailAngle facingStart, RailAngle facingEnd, class_1657 player, RailwayData railwayData) {
        if (player != null && !this.onConnect(player, stack, railwayData, posStart, posEnd, this.radius, this.height)) {
            player.method_7353((class_2561)Text.translatable("gui.mtr.rail_not_found_action", new Object[0]), true);
        }
    }

    @Override
    protected final void onRemove(class_1937 world, class_2338 posStart, class_2338 posEnd, class_1657 player, RailwayData railwayData) {
    }

    protected class_2680 getSavedState(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (tag.method_10545(TAG_BLOCK_ID)) {
            return class_2248.method_9531((int)tag.method_10550(TAG_BLOCK_ID));
        }
        return class_2246.field_10124.method_9564();
    }

    protected abstract boolean onConnect(class_1657 var1, class_1799 var2, RailwayData var3, class_2338 var4, class_2338 var5, int var6, int var7);
}

