/*
 * Decompiled with CFR 0.152.
 */
package mtr.item;

import java.util.List;
import mtr.block.BlockNode;
import mtr.data.Rail;
import mtr.data.RailAngle;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import mtr.item.ItemNodeModifierBase;
import mtr.mappings.Text;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class ItemRailModifier
extends ItemNodeModifierBase {
    private final boolean isOneWay;
    private final RailType railType;

    public ItemRailModifier() {
        super(true, true, true, false);
        this.isOneWay = false;
        this.railType = null;
    }

    public ItemRailModifier(boolean forNonContinuousMovementNode, boolean forContinuousMovementNode, boolean forAirplaneNode, boolean isOneWay, RailType railType) {
        super(forNonContinuousMovementNode, forContinuousMovementNode, forAirplaneNode, true);
        this.isOneWay = isOneWay;
        this.railType = railType;
    }

    @Override
    public void method_7851(class_1799 itemStack, class_1937 level, List<class_2561> tooltip, class_1836 tooltipFlag) {
        if (this.isConnector && this.railType != null && this.railType.canAccelerate) {
            tooltip.add((class_2561)Text.translatable("tooltip.mtr.rail_speed_limit", this.railType.speedLimit).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
        }
        super.method_7851(itemStack, level, tooltip, tooltipFlag);
    }

    @Override
    protected void onConnect(class_1937 world, class_1799 stack, TransportMode transportMode, class_2680 stateStart, class_2680 stateEnd, class_2338 posStart, class_2338 posEnd, RailAngle facingStart, RailAngle facingEnd, class_1657 player, RailwayData railwayData) {
        if (this.railType.hasSavedRail && (railwayData.hasSavedRail(posStart) || railwayData.hasSavedRail(posEnd))) {
            if (player != null) {
                player.method_7353((class_2561)Text.translatable("gui.mtr.platform_or_siding_exists", new Object[0]), true);
            }
        } else {
            boolean isValid;
            RailType newRailType;
            boolean isValidContinuousMovement;
            if (transportMode.continuousMovement) {
                class_2248 blockStart = stateStart.method_26204();
                class_2248 blockEnd = stateEnd.method_26204();
                if (blockStart instanceof BlockNode.BlockContinuousMovementNode && blockEnd instanceof BlockNode.BlockContinuousMovementNode) {
                    if (((BlockNode.BlockContinuousMovementNode)blockStart).isStation && ((BlockNode.BlockContinuousMovementNode)blockEnd).isStation) {
                        isValidContinuousMovement = true;
                        newRailType = this.railType.hasSavedRail ? this.railType : RailType.CABLE_CAR_STATION;
                    } else {
                        int differenceX = posEnd.method_10263() - posStart.method_10263();
                        int differenceZ = posEnd.method_10260() - posStart.method_10260();
                        isValidContinuousMovement = !this.railType.hasSavedRail && facingStart.isParallel(facingEnd) && ((facingStart == RailAngle.N || facingStart == RailAngle.S) && differenceX == 0 || (facingStart == RailAngle.E || facingStart == RailAngle.W) && differenceZ == 0 || (facingStart == RailAngle.NE || facingStart == RailAngle.SW) && differenceX == -differenceZ || (facingStart == RailAngle.SE || facingStart == RailAngle.NW) && differenceX == differenceZ);
                        newRailType = RailType.CABLE_CAR;
                    }
                } else {
                    isValidContinuousMovement = false;
                    newRailType = this.railType;
                }
            } else {
                isValidContinuousMovement = true;
                newRailType = this.railType;
            }
            Rail rail1 = new Rail(posStart, facingStart, posEnd, facingEnd, this.isOneWay ? RailType.NONE : newRailType, transportMode);
            Rail rail2 = new Rail(posEnd, facingEnd, posStart, facingStart, newRailType, transportMode);
            boolean goodRadius = rail1.goodRadius() && rail2.goodRadius();
            boolean bl = isValid = rail1.isValid() && rail2.isValid();
            if (goodRadius && isValid && isValidContinuousMovement) {
                railwayData.addRail(player, transportMode, posStart, posEnd, rail1, false);
                long newId = railwayData.addRail(player, transportMode, posEnd, posStart, rail2, true);
                world.method_8501(posStart, (class_2680)stateStart.method_11657((class_2769)BlockNode.IS_CONNECTED, (Comparable)Boolean.valueOf(true)));
                world.method_8501(posEnd, (class_2680)stateEnd.method_11657((class_2769)BlockNode.IS_CONNECTED, (Comparable)Boolean.valueOf(true)));
                PacketTrainDataGuiServer.createRailS2C(world, transportMode, posStart, posEnd, rail1, rail2, newId);
            } else if (player != null) {
                player.method_7353((class_2561)Text.translatable(isValidContinuousMovement ? (goodRadius ? "gui.mtr.invalid_orientation" : "gui.mtr.radius_too_small") : "gui.mtr.cable_car_invalid_orientation", new Object[0]), true);
            }
        }
    }

    @Override
    protected void onRemove(class_1937 world, class_2338 posStart, class_2338 posEnd, class_1657 player, RailwayData railwayData) {
        railwayData.removeRailConnection(player, posStart, posEnd);
        PacketTrainDataGuiServer.removeRailConnectionS2C(world, posStart, posEnd);
    }
}

