/*
 * Decompiled with CFR 0.152.
 */
package mtr.libraries.org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.nio.ByteBuffer;
import mtr.libraries.javax.servlet.ServletException;
import mtr.libraries.javax.servlet.http.HttpServletRequest;
import mtr.libraries.javax.servlet.http.HttpServletResponse;
import mtr.libraries.javax.servlet.http.HttpServletResponseWrapper;
import mtr.libraries.org.eclipse.jetty.http.BadMessageException;
import mtr.libraries.org.eclipse.jetty.http.HttpHeader;
import mtr.libraries.org.eclipse.jetty.server.HttpInput;
import mtr.libraries.org.eclipse.jetty.server.HttpOutput;
import mtr.libraries.org.eclipse.jetty.server.Request;
import mtr.libraries.org.eclipse.jetty.server.handler.HandlerWrapper;
import mtr.libraries.org.eclipse.jetty.util.Callback;
import mtr.libraries.org.eclipse.jetty.util.log.Log;
import mtr.libraries.org.eclipse.jetty.util.log.Logger;

public class SizeLimitHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(SizeLimitHandler.class);
    private final long _requestLimit;
    private final long _responseLimit;

    public SizeLimitHandler(long requestLimit, long responseLimit) {
        this._requestLimit = requestLimit;
        this._responseLimit = responseLimit;
    }

    protected void checkRequestLimit(long size) {
        if (this._requestLimit >= 0L && size > this._requestLimit) {
            throw new BadMessageException(413, "Request body is too large: " + size + ">" + this._requestLimit);
        }
    }

    protected void checkResponseLimit(long size) {
        if (this._responseLimit >= 0L && size > this._responseLimit) {
            throw new BadMessageException(500, "Response body is too large: " + size + ">" + this._responseLimit);
        }
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._requestLimit >= 0L || this._responseLimit >= 0L) {
            HttpOutput httpOutput = baseRequest.getResponse().getHttpOutput();
            HttpOutput.Interceptor interceptor = httpOutput.getInterceptor();
            LimitInterceptor limit = new LimitInterceptor(interceptor);
            if (this._requestLimit >= 0L) {
                long contentLength = baseRequest.getContentLengthLong();
                this.checkRequestLimit(contentLength);
                if (contentLength < 0L) {
                    baseRequest.getHttpInput().addInterceptor(limit);
                }
            }
            if (this._responseLimit > 0L) {
                httpOutput.setInterceptor(limit);
                response = new LimitResponse(response);
            }
        }
        super.handle(target, baseRequest, request, response);
    }

    private class LimitResponse
    extends HttpServletResponseWrapper {
        public LimitResponse(HttpServletResponse response) {
            super(response);
        }

        @Override
        public void setContentLength(int len) {
            SizeLimitHandler.this.checkResponseLimit(len);
            super.setContentLength(len);
        }

        @Override
        public void setContentLengthLong(long len) {
            SizeLimitHandler.this.checkResponseLimit(len);
            super.setContentLengthLong(len);
        }

        @Override
        public void setHeader(String name, String value) {
            if (HttpHeader.CONTENT_LENGTH.is(name)) {
                SizeLimitHandler.this.checkResponseLimit(Long.parseLong(value));
            }
            super.setHeader(name, value);
        }

        @Override
        public void addHeader(String name, String value) {
            if (HttpHeader.CONTENT_LENGTH.is(name)) {
                SizeLimitHandler.this.checkResponseLimit(Long.parseLong(value));
            }
            super.addHeader(name, value);
        }

        @Override
        public void setIntHeader(String name, int value) {
            if (HttpHeader.CONTENT_LENGTH.is(name)) {
                SizeLimitHandler.this.checkResponseLimit(value);
            }
            super.setIntHeader(name, value);
        }

        @Override
        public void addIntHeader(String name, int value) {
            if (HttpHeader.CONTENT_LENGTH.is(name)) {
                SizeLimitHandler.this.checkResponseLimit(value);
            }
            super.addIntHeader(name, value);
        }
    }

    private class LimitInterceptor
    implements HttpOutput.Interceptor,
    HttpInput.Interceptor {
        private final HttpOutput.Interceptor _nextOutput;
        long _read;
        long _written;

        public LimitInterceptor(HttpOutput.Interceptor nextOutput) {
            this._nextOutput = nextOutput;
        }

        @Override
        public HttpOutput.Interceptor getNextInterceptor() {
            return this._nextOutput;
        }

        @Override
        public boolean isOptimizedForDirectBuffers() {
            return this._nextOutput.isOptimizedForDirectBuffers();
        }

        @Override
        public HttpInput.Content readFrom(HttpInput.Content content) {
            if (content == null) {
                return null;
            }
            if (content.hasContent()) {
                this._read += (long)content.remaining();
                SizeLimitHandler.this.checkResponseLimit(this._read);
            }
            return content;
        }

        @Override
        public void write(ByteBuffer content, boolean last, Callback callback) {
            if (content.hasRemaining()) {
                this._written += (long)content.remaining();
                try {
                    SizeLimitHandler.this.checkResponseLimit(this._written);
                }
                catch (Throwable t) {
                    callback.failed(t);
                    return;
                }
            }
            this.getNextInterceptor().write(content, last, callback);
        }

        @Override
        public void resetBuffer() {
            this._written = 0L;
            this.getNextInterceptor().resetBuffer();
        }
    }
}

