/*
 * Decompiled with CFR 0.152.
 */
package mtr.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import mtr.MTRClient;
import mtr.client.DoorAnimationType;
import mtr.client.ScrollingText;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.data.Route;
import mtr.data.Station;
import mtr.data.TrainClient;
import mtr.mappings.ModelMapper;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_583;

public abstract class ModelTrainBase
extends class_583<class_1297>
implements IGui {
    public final DoorAnimationType doorAnimationType;
    public final boolean renderDoorOverlay;
    private final List<ScrollingText> tempScrollingTexts = new ArrayList<ScrollingText>();

    public ModelTrainBase(DoorAnimationType doorAnimationType, boolean renderDoorOverlay) {
        this.doorAnimationType = doorAnimationType;
        this.renderDoorOverlay = renderDoorOverlay;
    }

    public void method_2819(class_1297 entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
    }

    public final void method_2828(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
    }

    public final void render(class_4587 matrices, class_4597 vertexConsumers, NameColorDataBase data, class_2960 texture, int light, float doorLeftValue, float doorRightValue, boolean opening, int currentCar, int trainCars, boolean head1IsFront, boolean lightsOn, boolean isTranslucent, boolean renderDetails, boolean atPlatform) {
        float doorLeftX = DoorAnimationType.getDoorAnimationX(this.doorAnimationType, doorLeftValue);
        float doorRightX = DoorAnimationType.getDoorAnimationX(this.doorAnimationType, doorRightValue);
        float doorLeftZ = DoorAnimationType.getDoorAnimationZ(this.doorAnimationType, this.getDoorMax(), this.getDoorDuration(), doorLeftValue, opening);
        float doorRightZ = DoorAnimationType.getDoorAnimationZ(this.doorAnimationType, this.getDoorMax(), this.getDoorDuration(), doorRightValue, opening);
        int lightOnInteriorLevel = lightsOn ? 0xF000B0 : light;
        int lightOnGlowingLevel = lightsOn ? 0xF000F0 : light;
        matrices.method_22903();
        this.baseTransform(matrices);
        if (isTranslucent) {
            if (renderDetails) {
                class_1921 renderLayerInteriorTranslucent = lightsOn ? MoreRenderLayers.getInteriorTranslucent(texture) : MoreRenderLayers.getExteriorTranslucent(texture);
                this.render(matrices, vertexConsumers.getBuffer(renderLayerInteriorTranslucent), RenderStage.INTERIOR_TRANSLUCENT, lightOnInteriorLevel, doorLeftX, doorRightX, doorLeftZ, doorRightZ, currentCar, trainCars, head1IsFront, true);
            }
        } else {
            class_1921 renderLayerLight = lightsOn ? MoreRenderLayers.getLight(texture, false) : MoreRenderLayers.getExterior(texture);
            class_1921 renderLayerInterior = lightsOn ? MoreRenderLayers.getInterior(texture) : MoreRenderLayers.getExterior(texture);
            this.render(matrices, vertexConsumers.getBuffer(renderLayerLight), RenderStage.LIGHTS, lightOnGlowingLevel, doorLeftX, doorRightX, doorLeftZ, doorRightZ, currentCar, trainCars, head1IsFront, renderDetails);
            this.render(matrices, vertexConsumers.getBuffer(renderLayerInterior), RenderStage.INTERIOR, lightOnInteriorLevel, doorLeftX, doorRightX, doorLeftZ, doorRightZ, currentCar, trainCars, head1IsFront, renderDetails);
            if (renderDetails) {
                this.renderExtraDetails(matrices, vertexConsumers, light, lightOnInteriorLevel, lightsOn, doorLeftX, doorRightX, doorLeftZ, doorRightZ);
            }
            this.render(matrices, vertexConsumers.getBuffer(MoreRenderLayers.getExterior(texture)), RenderStage.EXTERIOR, light, doorLeftX, doorRightX, doorLeftZ, doorRightZ, currentCar, trainCars, head1IsFront, renderDetails);
            this.render(matrices, vertexConsumers.getBuffer(MoreRenderLayers.getLight(texture, true)), RenderStage.ALWAYS_ON_LIGHTS, 0xF000F0, doorLeftX, doorRightX, doorLeftZ, doorRightZ, currentCar, trainCars, head1IsFront, renderDetails);
            if (renderDetails) {
                TrainClient train = data instanceof TrainClient ? (TrainClient)data : null;
                class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
                Route thisRoute = train == null ? null : train.getThisRoute();
                Route nextRoute = train == null ? null : train.getNextRoute();
                Station thisStation = train == null ? null : train.getThisStation();
                Station nextStation = train == null ? null : train.getNextStation();
                Station lastStation = train == null ? null : train.getLastStation();
                this.renderTextDisplays(matrices, vertexConsumers, class_310.method_1551().field_1772, immediate, thisRoute, nextRoute, thisStation, nextStation, lastStation, thisRoute == null ? null : thisRoute.getDestination(train.getCurrentStationIndex()), currentCar, trainCars, atPlatform, train == null ? this.tempScrollingTexts : train.scrollingTexts);
                immediate.method_22993();
            }
        }
        matrices.method_22909();
    }

    protected void renderExtraDetails(class_4587 matrices, class_4597 vertexConsumers, int light, int lightOnInteriorLevel, boolean lightsOn, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ) {
    }

    protected void renderTextDisplays(class_4587 matrices, class_4597 vertexConsumers, class_327 font, class_4597.class_4598 immediate, Route thisRoute, Route nextRoute, Station thisStation, Station nextStation, Station lastStation, String customDestination, int car, int totalCars, boolean atPlatform, List<ScrollingText> scrollingTexts) {
    }

    protected float getDoorDuration() {
        return 0.5f;
    }

    protected void baseTransform(class_4587 matrices) {
    }

    protected abstract void render(class_4587 var1, class_4588 var2, RenderStage var3, int var4, float var5, float var6, float var7, float var8, int var9, int var10, boolean var11, boolean var12);

    protected abstract int getDoorMax();

    protected String getDestinationString(Station station, String customDestination, TextSpacingType textSpacingType, boolean toUpperCase) {
        String finalResult;
        String text;
        String string = customDestination == null ? (station == null ? this.defaultDestinationString() : station.name) : (text = customDestination);
        if (textSpacingType == TextSpacingType.NORMAL) {
            finalResult = text;
        } else {
            String[] textSplit = text.split("\\|");
            ArrayList<Object> result = new ArrayList<Object>();
            boolean hasCjk = false;
            for (String textPart : textSplit) {
                StringBuilder stringBuilder;
                int i;
                boolean isCjk = IGui.isCjk(textPart);
                if (textSpacingType == TextSpacingType.SPACE_CJK || textSpacingType == TextSpacingType.SPACE_CJK_FLIPPED) {
                    result.add(textSpacingType == TextSpacingType.SPACE_CJK ? result.size() : 0, isCjk && textPart.length() == 2 ? textPart.charAt(0) + " " + textPart.charAt(1) : textPart);
                    continue;
                }
                if (textSpacingType == TextSpacingType.SPACE_CJK_LARGE) {
                    if (isCjk) {
                        StringBuilder cjkResult = new StringBuilder();
                        for (i = 0; i < textPart.length(); ++i) {
                            cjkResult.append(textPart.charAt(i));
                            for (int j = 0; j < (textPart.length() == 2 ? 3 : 1); ++j) {
                                cjkResult.append("   ");
                            }
                        }
                        result.add(cjkResult.toString().trim());
                        continue;
                    }
                    result.add(textPart);
                    continue;
                }
                if (textSpacingType != TextSpacingType.MLR_SPACING) continue;
                if (isCjk) {
                    stringBuilder = new StringBuilder(textPart);
                    for (i = textPart.length(); i < 3; ++i) {
                        stringBuilder.append(" ");
                    }
                    hasCjk = true;
                } else {
                    stringBuilder = new StringBuilder();
                    for (i = textPart.length(); i < 9; ++i) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(textPart);
                }
                result.add(stringBuilder.toString());
            }
            if (!hasCjk && textSpacingType == TextSpacingType.MLR_SPACING) {
                result.add(0, " ");
                result.add(0, " ");
            }
            finalResult = String.join((CharSequence)"|", result);
        }
        return toUpperCase ? finalResult.toUpperCase(Locale.ENGLISH) : finalResult;
    }

    protected String defaultDestinationString() {
        return "";
    }

    protected static void setRotationAngle(ModelMapper bone, float x, float y, float z) {
        bone.setRotationAngle(x, y, z);
    }

    protected static void renderMirror(ModelMapper bone, class_4587 matrices, class_4588 vertices, int light, float position) {
        ModelTrainBase.renderOnce(bone, matrices, vertices, light, position);
        ModelTrainBase.renderOnceFlipped(bone, matrices, vertices, light, position);
    }

    protected static void renderOnce(ModelMapper bone, class_4587 matrices, class_4588 vertices, int light, float position) {
        bone.render(matrices, vertices, 0.0f, position, 0.0f, light, class_4608.field_21444);
    }

    protected static void renderOnce(ModelMapper bone, class_4587 matrices, class_4588 vertices, int light, float positionX, float positionZ) {
        bone.render(matrices, vertices, positionX, positionZ, 0.0f, light, class_4608.field_21444);
    }

    protected static void renderOnce(ModelMapper bone, class_4587 matrices, class_4588 vertices, int light, float positionX, float positionY, float positionZ) {
        bone.render(matrices, vertices, positionX, positionY, positionZ, 0.0f, light, class_4608.field_21444);
    }

    protected static void renderOnceFlipped(ModelMapper bone, class_4587 matrices, class_4588 vertices, int light, float position) {
        bone.render(matrices, vertices, 0.0f, position, (float)Math.PI, light, class_4608.field_21444);
    }

    protected static void renderOnceFlipped(ModelMapper bone, class_4587 matrices, class_4588 vertices, int light, float positionX, float positionZ) {
        bone.render(matrices, vertices, -positionX, positionZ, (float)Math.PI, light, class_4608.field_21444);
    }

    protected static void renderOnceFlipped(ModelMapper bone, class_4587 matrices, class_4588 vertices, int light, float positionX, float positionY, float positionZ) {
        bone.render(matrices, vertices, -positionX, positionY, positionZ, (float)Math.PI, light, class_4608.field_21444);
    }

    protected static boolean isIndex(int index, int value, int[] array) {
        int finalIndex = index < 0 ? array.length + index : index;
        return finalIndex < array.length && finalIndex >= 0 && array[finalIndex] == value;
    }

    protected static String getAlternatingString(String text) {
        String[] textSplit = text.split("\\|");
        return textSplit[(int)Math.floor(MTRClient.getGameTick() / 30.0f) % textSplit.length];
    }

    protected static String getHongKongNextStationString(Station thisStation, Station nextStation, boolean atPlatform, boolean isKcr) {
        if (atPlatform && thisStation != null) {
            return thisStation.name;
        }
        if (!atPlatform && nextStation != null) {
            return IGui.insertTranslation(isKcr ? "gui.mtr.next_station_cjk" : "gui.mtr.next_station_announcement_cjk", isKcr ? "gui.mtr.next_station" : "gui.mtr.next_station_announcement", 1, IGui.textOrUntitled(nextStation.name));
        }
        return "";
    }

    protected static String getLondonNextStationString(Route thisRoute, Route nextRoute, Station thisStation, Station nextStation, Station lastStation, String destinationString, boolean atPlatform) {
        boolean isTerminating;
        Station station;
        Station station2 = station = atPlatform ? thisStation : nextStation;
        if (station == null || thisRoute == null) {
            return "";
        }
        ArrayList<String> messages = new ArrayList<String>();
        boolean bl = isTerminating = lastStation != null && station.id == lastStation.id && nextRoute == null;
        if (!isTerminating) {
            messages.add(IGui.insertTranslation("gui.mtr.london_train_route_announcement_cjk", "gui.mtr.london_train_route_announcement", 2, IGui.textOrUntitled(thisRoute.name), IGui.textOrUntitled(destinationString)));
        }
        if (atPlatform) {
            messages.add(IGui.insertTranslation("gui.mtr.london_train_this_station_announcement_cjk", "gui.mtr.london_train_this_station_announcement", 1, IGui.textOrUntitled(station.name)));
        } else {
            messages.add(IGui.insertTranslation("gui.mtr.london_train_next_station_announcement_cjk", "gui.mtr.london_train_next_station_announcement", 1, IGui.textOrUntitled(station.name)));
        }
        String mergedInterchangeRoutes = RenderTrains.getInterchangeRouteNames(station, thisRoute, nextRoute);
        if (!mergedInterchangeRoutes.isEmpty()) {
            messages.add(IGui.insertTranslation("gui.mtr.london_train_interchange_announcement_cjk", "gui.mtr.london_train_interchange_announcement", 1, mergedInterchangeRoutes));
        }
        if (isTerminating) {
            messages.add(IGui.insertTranslation("gui.mtr.london_train_terminating_announcement_cjk", "gui.mtr.london_train_terminating_announcement", 1, IGui.textOrUntitled(station.name)));
        }
        return IGui.formatStationName(IGui.mergeStations(messages, "", " "));
    }

    public static enum RenderStage {
        LIGHTS,
        ALWAYS_ON_LIGHTS,
        INTERIOR,
        INTERIOR_TRANSLUCENT,
        EXTERIOR;

    }

    protected static enum TextSpacingType {
        NORMAL,
        SPACE_CJK,
        SPACE_CJK_FLIPPED,
        SPACE_CJK_LARGE,
        MLR_SPACING;

    }
}

