/*
 * Decompiled with CFR 0.152.
 */
package mtr.packet;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.function.Consumer;
import mtr.MTR;
import mtr.data.AreaBase;
import mtr.data.IGui;
import net.minecraft.class_2338;
import net.minecraft.class_3545;

public interface IUpdateWebMap {
    public static final String MARKER_SET_STATIONS_ID = "mtr_stations";
    public static final String MARKER_SET_STATION_AREAS_ID = "mtr_station_areas";
    public static final String MARKER_SET_STATIONS_TITLE = "Stations";
    public static final String MARKER_SET_STATION_AREAS_TITLE = "Station Areas";
    public static final String MARKER_SET_DEPOTS_ID = "mtr_depots";
    public static final String MARKER_SET_DEPOT_AREAS_ID = "mtr_depot_areas";
    public static final String MARKER_SET_DEPOTS_TITLE = "Depots";
    public static final String MARKER_SET_DEPOT_AREAS_TITLE = "Depot Areas";
    public static final String STATION_ICON_PATH = "/assets/mtr/textures/block/sign/logo.png";
    public static final String DEPOT_ICON_PATH = "/assets/mtr/textures/block/sign/logo_grayscale.png";
    public static final String STATION_ICON_KEY = "mtr_station";
    public static final String DEPOT_ICON_KEY = "mtr_depot";
    public static final int ICON_SIZE = 24;

    public static void readResource(String path, Consumer<InputStream> callback) {
        InputStream inputStream = MTR.class.getResourceAsStream(path);
        if (inputStream != null) {
            callback.accept(inputStream);
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T extends AreaBase> void iterateAreas(Set<T> areas, AreaCallback areaCallback) {
        areas.forEach(area -> {
            class_3545<Integer, Integer> corner1 = area.corner1;
            class_3545<Integer, Integer> corner2 = area.corner2;
            class_2338 areaPos = area.getCenter();
            if (corner1 != null && corner2 != null && areaPos != null) {
                areaCallback.areaCallback(area.id + "_" + System.currentTimeMillis(), IGui.formatStationName(area.name), new Color(area.color), (Integer)corner1.method_15442(), (Integer)corner1.method_15441(), (Integer)corner2.method_15442(), (Integer)corner2.method_15441(), areaPos.method_10263(), areaPos.method_10260());
            }
        });
    }

    @FunctionalInterface
    public static interface AreaCallback {
        public void areaCallback(String var1, String var2, Color var3, int var4, int var5, int var6, int var7, int var8, int var9);
    }
}

