/*
 * Decompiled with CFR 0.152.
 */
package mtr.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import mtr.RegistryClient;
import mtr.block.BlockTrainAnnouncer;
import mtr.block.BlockTrainScheduleSensor;
import mtr.block.BlockTrainSensorBase;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.Depot;
import mtr.data.EnumHelper;
import mtr.data.LiftClient;
import mtr.data.NameColorDataBase;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.Siding;
import mtr.data.Train;
import mtr.data.TransportMode;
import mtr.mappings.RegistryUtilities;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.PacketTrainDataBase;
import mtr.screen.ArrivalProjectorConfigScreen;
import mtr.screen.DashboardScreen;
import mtr.screen.LiftCustomizationScreen;
import mtr.screen.LiftTrackFloorScreen;
import mtr.screen.PIDSConfigScreen;
import mtr.screen.RailwaySignScreen;
import mtr.screen.ResourcePackCreatorScreen;
import mtr.screen.TicketMachineScreen;
import mtr.screen.TrainAnnouncerScreen;
import mtr.screen.TrainBasicSensorScreen;
import mtr.screen.TrainScheduleSensorScreen;
import mtr.screen.TrainSensorScreenBase;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_5348;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class PacketTrainDataGuiClient
extends PacketTrainDataBase {
    private static final Map<Integer, ByteBuf> TEMP_PACKETS_RECEIVER = new HashMap<Integer, ByteBuf>();
    private static long tempPacketId = 0L;
    private static int expectedSize = 0;

    public static void openVersionCheckS2C(class_310 minecraftClient, class_2540 packet) {
        String version = packet.method_19772();
        minecraftClient.execute(() -> {
            class_634 connection;
            if (!"1.19.4-3.2.2-hotfix-1".split("-hotfix-")[0].equals(version) && (connection = minecraftClient.method_1562()) != null) {
                int i;
                int widthDifference1 = minecraftClient.field_1772.method_27525((class_5348)Text.translatable("gui.mtr.mismatched_versions_your_version", new Object[0])) - minecraftClient.field_1772.method_27525((class_5348)Text.translatable("gui.mtr.mismatched_versions_server_version", new Object[0]));
                int widthDifference2 = minecraftClient.field_1772.method_1727("1.19.4-3.2.2-hotfix-1") - minecraftClient.field_1772.method_1727(version);
                int spaceWidth = minecraftClient.field_1772.method_1727(" ");
                StringBuilder text = new StringBuilder();
                for (i = 0; i < -widthDifference1 / spaceWidth; ++i) {
                    text.append(" ");
                }
                text.append(Text.translatable("gui.mtr.mismatched_versions_your_version", "1.19.4-3.2.2-hotfix-1").getString());
                for (i = 0; i < -widthDifference2 / spaceWidth; ++i) {
                    text.append(" ");
                }
                text.append("\n");
                for (i = 0; i < widthDifference1 / spaceWidth; ++i) {
                    text.append(" ");
                }
                text.append(Text.translatable("gui.mtr.mismatched_versions_server_version", version).getString());
                for (i = 0; i < widthDifference2 / spaceWidth; ++i) {
                    text.append(" ");
                }
                text.append("\n\n");
                connection.method_48296().method_10747((class_2561)Text.literal(text.toString()).method_10852((class_2561)Text.translatable("gui.mtr.mismatched_versions", new Object[0])));
            }
        });
    }

    public static void openDashboardScreenS2C(class_310 minecraftClient, class_2540 packet) {
        TransportMode transportMode = EnumHelper.valueOf(TransportMode.TRAIN, packet.method_19772());
        boolean useTimeAndWindSync = packet.readBoolean();
        minecraftClient.execute(() -> {
            if (!(minecraftClient.field_1755 instanceof DashboardScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new DashboardScreen(transportMode, useTimeAndWindSync));
            }
        });
    }

    public static void openRailwaySignScreenS2C(class_310 minecraftClient, class_2540 packet) {
        class_2338 pos = packet.method_10811();
        minecraftClient.execute(() -> {
            if (!(minecraftClient.field_1755 instanceof RailwaySignScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new RailwaySignScreen(pos));
            }
        });
    }

    public static void openTrainSensorScreenS2C(class_310 minecraftClient, class_2540 packet) {
        class_2338 pos = packet.method_10811();
        minecraftClient.execute(() -> {
            if (minecraftClient.field_1687 != null && !(minecraftClient.field_1755 instanceof TrainSensorScreenBase)) {
                class_2586 entity = minecraftClient.field_1687.method_8321(pos);
                if (entity instanceof BlockTrainAnnouncer.TileEntityTrainAnnouncer) {
                    UtilitiesClient.setScreen(minecraftClient, new TrainAnnouncerScreen(pos));
                } else if (entity instanceof BlockTrainScheduleSensor.TileEntityTrainScheduleSensor) {
                    UtilitiesClient.setScreen(minecraftClient, new TrainScheduleSensorScreen(pos));
                } else if (entity instanceof BlockTrainSensorBase.TileEntityTrainSensorBase) {
                    UtilitiesClient.setScreen(minecraftClient, new TrainBasicSensorScreen(pos));
                }
            }
        });
    }

    public static void openLiftTrackFloorS2C(class_310 minecraftClient, class_2540 packet) {
        class_2338 pos = packet.method_10811();
        minecraftClient.execute(() -> {
            if (!(minecraftClient.field_1755 instanceof LiftTrackFloorScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new LiftTrackFloorScreen(pos));
            }
        });
    }

    public static void openLiftCustomizationS2C(class_310 minecraftClient, class_2540 packet) {
        long id = packet.readLong();
        minecraftClient.execute(() -> {
            LiftClient lift = ClientData.DATA_CACHE.liftsClientIdMap.get(id);
            if (!(minecraftClient.field_1755 instanceof LiftCustomizationScreen) && lift != null) {
                UtilitiesClient.setScreen(minecraftClient, new LiftCustomizationScreen(lift));
            }
        });
    }

    public static void openTicketMachineScreenS2C(class_310 minecraftClient, class_2540 packet) {
        int balance = packet.readInt();
        minecraftClient.execute(() -> {
            if (!(minecraftClient.field_1755 instanceof TicketMachineScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new TicketMachineScreen(balance));
            }
        });
    }

    public static void openPIDSConfigScreenS2C(class_310 minecraftClient, class_2540 packet) {
        class_2338 pos1 = packet.method_10811();
        class_2338 pos2 = packet.method_10811();
        int maxArrivals = packet.readInt();
        int linesPerArrival = packet.readInt();
        minecraftClient.execute(() -> {
            if (!(minecraftClient.field_1755 instanceof PIDSConfigScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new PIDSConfigScreen(pos1, pos2, maxArrivals, linesPerArrival));
            }
        });
    }

    public static void openArrivalProjectorConfigScreenS2C(class_310 minecraftClient, class_2540 packet) {
        class_2338 pos = packet.method_10811();
        minecraftClient.execute(() -> {
            if (!(minecraftClient.field_1755 instanceof ArrivalProjectorConfigScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new ArrivalProjectorConfigScreen(pos));
            }
        });
    }

    public static void openResourcePackCreatorScreen(class_310 minecraftClient) {
        minecraftClient.execute(() -> {
            if (!(minecraftClient.field_1755 instanceof ResourcePackCreatorScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new ResourcePackCreatorScreen());
            }
        });
    }

    public static void announceS2C(class_310 minecraftClient, class_2540 packet) {
        String message = packet.method_19772();
        String soundIdString = packet.method_19772();
        minecraftClient.execute(() -> {
            IDrawing.narrateOrAnnounce(message);
            class_638 world = minecraftClient.field_1687;
            class_746 player = minecraftClient.field_1724;
            if (!soundIdString.isEmpty() && world != null && player != null) {
                world.method_45446(player.method_24515(), RegistryUtilities.createSoundEvent(new class_2960(soundIdString)), class_3419.field_15245, 1000000.0f, 1.0f, false);
            }
        });
    }

    public static void createRailS2C(class_310 minecraftClient, class_2540 packet) {
        TransportMode transportMode = EnumHelper.valueOf(TransportMode.TRAIN, packet.method_19772());
        class_2338 pos1 = packet.method_10811();
        class_2338 pos2 = packet.method_10811();
        Rail rail1 = new Rail(packet);
        Rail rail2 = new Rail(packet);
        long savedRailId = packet.readLong();
        minecraftClient.execute(() -> {
            RailwayData.addRail(ClientData.RAILS, ClientData.PLATFORMS, ClientData.SIDINGS, transportMode, pos1, pos2, rail1, 0L);
            RailwayData.addRail(ClientData.RAILS, ClientData.PLATFORMS, ClientData.SIDINGS, transportMode, pos2, pos1, rail2, savedRailId);
        });
    }

    public static void createSignalS2C(class_310 minecraftClient, class_2540 packet) {
        long id = packet.readLong();
        class_1767 dyeColor = class_1767.values()[packet.readInt()];
        UUID rail = packet.method_10790();
        minecraftClient.execute(() -> ClientData.SIGNAL_BLOCKS.add(id, dyeColor, rail));
    }

    public static void removeNodeS2C(class_310 minecraftClient, class_2540 packet) {
        class_2338 pos = packet.method_10811();
        minecraftClient.execute(() -> RailwayData.removeNode(null, ClientData.RAILS, pos));
    }

    public static void removeLiftFloorTrackS2C(class_310 minecraftClient, class_2540 packet) {
        class_2338 pos = packet.method_10811();
        minecraftClient.execute(() -> RailwayData.removeLiftFloorTrack(null, ClientData.LIFTS, pos));
    }

    public static void removeRailConnectionS2C(class_310 minecraftClient, class_2540 packet) {
        class_2338 pos1 = packet.method_10811();
        class_2338 pos2 = packet.method_10811();
        minecraftClient.execute(() -> RailwayData.removeRailConnection(null, ClientData.RAILS, pos1, pos2));
    }

    public static void removeSignalsS2C(class_310 minecraftClient, class_2540 packet) {
        long removeCount = packet.readInt();
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<class_1767> colors = new ArrayList<class_1767>();
        ArrayList<UUID> rails = new ArrayList<UUID>();
        int i = 0;
        while ((long)i < removeCount) {
            ids.add(packet.readLong());
            colors.add(class_1767.values()[packet.readInt()]);
            rails.add(packet.method_10790());
            ++i;
        }
        minecraftClient.execute(() -> {
            int i = 0;
            while ((long)i < removeCount) {
                ClientData.SIGNAL_BLOCKS.remove((Long)ids.get(i), (class_1767)colors.get(i), (UUID)rails.get(i));
                ++i;
            }
        });
    }

    public static void receiveChunk(class_310 minecraftClient, class_2540 packet) {
        long id = packet.readLong();
        int chunk = packet.readInt();
        boolean complete = packet.readBoolean();
        if (tempPacketId != id) {
            TEMP_PACKETS_RECEIVER.clear();
            tempPacketId = id;
            expectedSize = Integer.MAX_VALUE;
        }
        if (complete) {
            expectedSize = chunk + 1;
        }
        TEMP_PACKETS_RECEIVER.put(chunk, packet.readBytes(packet.readableBytes()));
        if (TEMP_PACKETS_RECEIVER.size() == expectedSize) {
            class_2540 newPacket = new class_2540(Unpooled.buffer());
            for (int i = 0; i < expectedSize; ++i) {
                newPacket.writeBytes(TEMP_PACKETS_RECEIVER.get(i));
            }
            TEMP_PACKETS_RECEIVER.clear();
            try {
                minecraftClient.execute(() -> ClientData.receivePacket(newPacket));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static <T extends NameColorDataBase> void receiveUpdateOrDeleteS2C(class_310 minecraftClient, class_2540 packet, Set<T> dataSet, Map<Long, T> cacheMap, BiFunction<Long, TransportMode, T> createDataWithId, boolean isDelete) {
        PacketTrainDataBase.PacketCallback packetCallback = (updatePacket, fullPacket) -> {
            ClientData.DATA_CACHE.sync();
            ClientData.DATA_CACHE.refreshDynamicResources();
        };
        if (isDelete) {
            PacketTrainDataGuiClient.deleteData(dataSet, cacheMap, minecraftClient, packet, packetCallback, null);
        } else {
            PacketTrainDataGuiClient.updateData(dataSet, cacheMap, minecraftClient, packet, packetCallback, createDataWithId, null);
        }
    }

    public static void sendUpdate(class_2960 packetId, class_2540 packet) {
        RegistryClient.sendToServer(packetId, packet);
        ClientData.DATA_CACHE.sync();
        ClientData.DATA_CACHE.refreshDynamicResources();
    }

    public static void sendDeleteData(class_2960 packetId, long id) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeLong(id);
        PacketTrainDataGuiClient.sendUpdate(packetId, packet);
    }

    public static void sendTrainSensorC2S(class_2338 pos, Set<Long> filterRouteIds, boolean stoppedOnly, boolean movingOnly, int number, String ... strings) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10807(pos);
        packet.writeInt(filterRouteIds.size());
        filterRouteIds.forEach(arg_0 -> ((class_2540)packet).writeLong(arg_0));
        packet.writeBoolean(stoppedOnly);
        packet.writeBoolean(movingOnly);
        packet.writeInt(number);
        packet.writeInt(strings.length);
        for (String string : strings) {
            packet.method_10814(string);
        }
        RegistryClient.sendToServer(PACKET_UPDATE_TRAIN_SENSOR, packet);
    }

    public static void sendLiftTrackFloorC2S(class_2338 pos, String floorNumber, String floorDescription, boolean shouldDing) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10807(pos);
        packet.method_10814(floorNumber);
        packet.method_10814(floorDescription);
        packet.writeBoolean(shouldDing);
        RegistryClient.sendToServer(PACKET_UPDATE_LIFT_TRACK_FLOOR, packet);
    }

    public static void generatePathS2C(class_310 minecraftClient, class_2540 packet) {
        long depotId = packet.readLong();
        int successfulSegments = packet.readInt();
        minecraftClient.execute(() -> {
            Depot depot = (Depot)ClientData.DATA_CACHE.depotIdMap.get(depotId);
            if (depot != null) {
                depot.clientPathGenerationSuccessfulSegments = successfulSegments;
            }
        });
    }

    public static void generatePathC2S(long sidingId) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeLong(sidingId);
        RegistryClient.sendToServer(PACKET_GENERATE_PATH, packet);
    }

    public static void clearTrainsC2S(long depotId, Collection<Siding> sidings) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeLong(depotId);
        packet.writeInt(sidings.size());
        sidings.forEach(siding -> packet.writeLong(siding.id));
        RegistryClient.sendToServer(PACKET_CLEAR_TRAINS, packet);
    }

    public static void sendUpdateEntitySeatPassengerPosition(double x, double y, double z) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeDouble(x);
        packet.writeDouble(y);
        packet.writeDouble(z);
        RegistryClient.sendToServer(PACKET_UPDATE_ENTITY_SEAT_POSITION, packet);
    }

    public static void sendSignIdsC2S(class_2338 signPos, Set<Long> selectedIds, String[] signIds) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10807(signPos);
        packet.writeInt(selectedIds.size());
        selectedIds.forEach(arg_0 -> ((class_2540)packet).writeLong(arg_0));
        packet.writeInt(signIds.length);
        for (String signType : signIds) {
            packet.method_10814(signType == null ? "" : signType);
        }
        RegistryClient.sendToServer(PACKET_SIGN_TYPES, packet);
    }

    public static void sendDriveTrainC2S(boolean pressingAccelerate, boolean pressingBrake, boolean pressingDoors) {
        if (Train.isHoldingKey((class_1657)class_310.method_1551().field_1724) && (pressingAccelerate || pressingBrake || pressingDoors)) {
            class_2540 packet = new class_2540(Unpooled.buffer());
            packet.writeBoolean(pressingAccelerate);
            packet.writeBoolean(pressingBrake);
            packet.writeBoolean(pressingDoors);
            RegistryClient.sendToServer(PACKET_DRIVE_TRAIN, packet);
        }
    }

    public static void sendPressLiftButtonC2S(long id, int floor) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeLong(id);
        packet.writeInt(floor);
        RegistryClient.sendToServer(PACKET_PRESS_LIFT_BUTTON, packet);
    }

    public static void addBalanceC2S(int addAmount, int emeralds) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeInt(addAmount);
        packet.writeInt(emeralds);
        RegistryClient.sendToServer(PACKET_ADD_BALANCE, packet);
    }

    public static void sendPIDSConfigC2S(class_2338 pos1, class_2338 pos2, String[] messages, boolean[] hideArrival, Set<Long> filterPlatformIds, int displayPage) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10807(pos1);
        packet.method_10807(pos2);
        packet.writeInt(messages.length);
        for (String message : messages) {
            packet.method_10814(message);
        }
        packet.writeInt(hideArrival.length);
        for (boolean b : hideArrival) {
            packet.writeBoolean(b);
        }
        packet.writeInt(filterPlatformIds.size());
        filterPlatformIds.forEach(arg_0 -> ((class_2540)packet).writeLong(arg_0));
        packet.writeInt(displayPage);
        RegistryClient.sendToServer(PACKET_PIDS_UPDATE, packet);
    }

    public static void sendArrivalProjectorConfigC2S(class_2338 pos, Set<Long> filterPlatformIds, int displayPage) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10807(pos);
        packet.writeInt(filterPlatformIds.size());
        filterPlatformIds.forEach(arg_0 -> ((class_2540)packet).writeLong(arg_0));
        packet.writeInt(displayPage);
        RegistryClient.sendToServer(PACKET_ARRIVAL_PROJECTOR_UPDATE, packet);
    }

    public static void sendUseTimeAndWindSyncC2S(boolean useTimeAndWindSync) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeBoolean(useTimeAndWindSync);
        RegistryClient.sendToServer(PACKET_USE_TIME_AND_WIND_SYNC, packet);
    }
}

