/*
 * Decompiled with CFR 0.152.
 */
package mtr.packet;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import mtr.Registry;
import mtr.block.BlockArrivalProjectorBase;
import mtr.block.BlockLiftTrackFloor;
import mtr.block.BlockRailwaySign;
import mtr.block.BlockRouteSignBase;
import mtr.block.BlockTrainSensorBase;
import mtr.data.Depot;
import mtr.data.IPIDS;
import mtr.data.Lift;
import mtr.data.LiftServer;
import mtr.data.NameColorDataBase;
import mtr.data.Platform;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.RailwayDataLoggingModule;
import mtr.data.Route;
import mtr.data.SerializedDataBase;
import mtr.data.Siding;
import mtr.data.SignalBlocks;
import mtr.data.Station;
import mtr.data.TicketSystem;
import mtr.data.TransportMode;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.Utilities;
import mtr.packet.PacketTrainDataBase;
import mtr.packet.UpdateBlueMap;
import mtr.packet.UpdateDynmap;
import mtr.packet.UpdateSquaremap;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_267;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public class PacketTrainDataGuiServer
extends PacketTrainDataBase {
    private static final int PACKET_CHUNK_SIZE = (int)Math.pow(2.0, 14.0);

    public static void versionCheckS2C(class_3222 player) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10814("1.19.4-3.2.2-hotfix-1".split("-hotfix-")[0]);
        Registry.sendToPlayer(player, PACKET_VERSION_CHECK, packet);
    }

    public static void openDashboardScreenS2C(class_3222 player, TransportMode transportMode, boolean useTimeAndWindSync) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10814(transportMode.toString());
        packet.writeBoolean(useTimeAndWindSync);
        Registry.sendToPlayer(player, PACKET_OPEN_DASHBOARD_SCREEN, packet);
    }

    public static void openRailwaySignScreenS2C(class_3222 player, class_2338 signPos) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10807(signPos);
        Registry.sendToPlayer(player, PACKET_OPEN_RAILWAY_SIGN_SCREEN, packet);
    }

    public static void openTicketMachineScreenS2C(class_1937 world, class_3222 player) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeInt(TicketSystem.getPlayerScore(world, (class_1657)player, "mtr_balance").method_1126());
        Registry.sendToPlayer(player, PACKET_OPEN_TICKET_MACHINE_SCREEN, packet);
    }

    public static void openTrainSensorScreenS2C(class_3222 player, class_2338 blockPos) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10807(blockPos);
        Registry.sendToPlayer(player, PACKET_OPEN_TRAIN_SENSOR_SCREEN, packet);
    }

    public static void openLiftTrackFloorScreenS2C(class_3222 player, class_2338 blockPos) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10807(blockPos);
        Registry.sendToPlayer(player, PACKET_OPEN_LIFT_TRACK_FLOOR_SCREEN, packet);
    }

    public static void openLiftCustomizationScreenS2C(class_3222 player, long id) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeLong(id);
        Registry.sendToPlayer(player, PACKET_OPEN_LIFT_CUSTOMIZATION_SCREEN, packet);
    }

    public static void openPIDSConfigScreenS2C(class_3222 player, class_2338 pos1, class_2338 pos2, int maxArrivals, int linesPerArrival) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10807(pos1);
        packet.method_10807(pos2);
        packet.writeInt(maxArrivals);
        packet.writeInt(linesPerArrival);
        Registry.sendToPlayer(player, PACKET_OPEN_PIDS_CONFIG_SCREEN, packet);
    }

    public static void openArrivalProjectorConfigScreenS2C(class_3222 player, class_2338 pos) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10807(pos);
        Registry.sendToPlayer(player, PACKET_OPEN_ARRIVAL_PROJECTOR_CONFIG_SCREEN, packet);
    }

    public static void openResourcePackCreatorScreenS2C(class_3222 player) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        Registry.sendToPlayer(player, PACKET_OPEN_RESOURCE_PACK_CREATOR_SCREEN, packet);
    }

    public static void announceS2C(class_3222 player, String message, class_2960 soundId) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10814(message);
        packet.method_10814(soundId == null ? "" : soundId.toString());
        Registry.sendToPlayer(player, PACKET_ANNOUNCE, packet);
    }

    public static void createRailS2C(class_1937 world, TransportMode transportMode, class_2338 pos1, class_2338 pos2, Rail rail1, Rail rail2, long savedRailId) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10814(transportMode.toString());
        packet.method_10807(pos1);
        packet.method_10807(pos2);
        rail1.writePacket(packet);
        rail2.writePacket(packet);
        packet.writeLong(savedRailId);
        world.method_18456().forEach(worldPlayer -> Registry.sendToPlayer((class_3222)worldPlayer, PACKET_CREATE_RAIL, packet));
    }

    public static void createSignalS2C(class_1937 world, long id, class_1767 dyeColor, UUID rail) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeLong(id);
        packet.writeInt(dyeColor.ordinal());
        packet.method_10797(rail);
        world.method_18456().forEach(worldPlayer -> Registry.sendToPlayer((class_3222)worldPlayer, PACKET_CREATE_SIGNAL, packet));
    }

    public static void updateRailActionsS2C(class_1937 world, List<Rail.RailActions> railActions) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeInt(railActions.size());
        railActions.forEach(railAction -> railAction.writePacket(packet));
        world.method_18456().forEach(worldPlayer -> Registry.sendToPlayer((class_3222)worldPlayer, PACKET_UPDATE_RAIL_ACTIONS, packet));
    }

    public static void removeNodeS2C(class_1937 world, class_2338 pos) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10807(pos);
        world.method_18456().forEach(worldPlayer -> Registry.sendToPlayer((class_3222)worldPlayer, PACKET_REMOVE_NODE, packet));
    }

    public static void removeLiftFloorTrackS2C(class_1937 world, class_2338 pos) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10807(pos);
        world.method_18456().forEach(worldPlayer -> Registry.sendToPlayer((class_3222)worldPlayer, PACKET_REMOVE_LIFT_FLOOR_TRACK, packet));
    }

    public static void removeRailConnectionS2C(class_1937 world, class_2338 pos1, class_2338 pos2) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10807(pos1);
        packet.method_10807(pos2);
        world.method_18456().forEach(worldPlayer -> Registry.sendToPlayer((class_3222)worldPlayer, PACKET_REMOVE_RAIL, packet));
    }

    public static void removeSignalS2C(class_1937 world, long id, class_1767 dyeColor, UUID rail) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeInt(1);
        packet.writeLong(id);
        packet.writeInt(dyeColor.ordinal());
        packet.method_10797(rail);
        world.method_18456().forEach(worldPlayer -> Registry.sendToPlayer((class_3222)worldPlayer, PACKET_REMOVE_SIGNALS, packet));
    }

    public static void sendAllInChunks(class_3222 player, Set<Station> stations, Set<Platform> platforms, Set<Siding> sidings, Set<Route> routes, Set<Depot> depots, Set<LiftServer> lifts, SignalBlocks signalBlocks) {
        long tempPacketId = new Random().nextLong();
        class_2540 packet = new class_2540(Unpooled.buffer());
        PacketTrainDataGuiServer.serializeData(packet, stations);
        PacketTrainDataGuiServer.serializeData(packet, platforms);
        PacketTrainDataGuiServer.serializeData(packet, sidings);
        PacketTrainDataGuiServer.serializeData(packet, routes);
        PacketTrainDataGuiServer.serializeData(packet, depots);
        PacketTrainDataGuiServer.serializeData(packet, lifts);
        PacketTrainDataGuiServer.serializeData(packet, signalBlocks.signalBlocks);
        int i = 0;
        while (!PacketTrainDataGuiServer.sendChunk(player, packet, tempPacketId, i)) {
            ++i;
        }
    }

    public static <T extends NameColorDataBase> void receiveUpdateOrDeleteC2S(MinecraftServer minecraftServer, class_3222 player, class_2540 packet, class_2960 packetId, Function<RailwayData, Set<T>> dataSet, Function<RailwayData, Map<Long, T>> cacheMap, BiFunction<Long, TransportMode, T> createDataWithId, boolean isDelete) {
        if (RailwayData.hasNoPermission(player)) {
            return;
        }
        class_1937 world = player.field_6002;
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData == null) {
            return;
        }
        PacketTrainDataBase.PacketCallback packetCallback = (updatePacket, fullPacket) -> {
            world.method_18456().forEach(worldPlayer -> {
                if (!worldPlayer.method_5667().equals(player.method_5667())) {
                    Registry.sendToPlayer((class_3222)worldPlayer, packetId, fullPacket);
                }
                railwayData.dataCache.sync();
            });
            if (packetId.equals((Object)PACKET_UPDATE_STATION) || packetId.equals((Object)PACKET_DELETE_STATION) || packetId.equals((Object)PACKET_UPDATE_DEPOT) || packetId.equals((Object)PACKET_DELETE_DEPOT)) {
                try {
                    UpdateDynmap.updateDynmap(world, railwayData);
                }
                catch (Exception | NoClassDefFoundError throwable) {
                    // empty catch block
                }
                try {
                    UpdateBlueMap.updateBlueMap(world, railwayData);
                }
                catch (Exception | NoClassDefFoundError throwable) {
                    // empty catch block
                }
                try {
                    UpdateSquaremap.updateSquaremap(world, railwayData);
                }
                catch (Exception | NoClassDefFoundError throwable) {
                    // empty catch block
                }
            }
        };
        if (isDelete) {
            PacketTrainDataGuiServer.deleteData(dataSet.apply(railwayData), cacheMap.apply(railwayData), minecraftServer, packet, packetCallback, data -> railwayData.railwayDataLoggingModule.addEvent(player, data.getClass(), data.id, data.name, RailwayDataLoggingModule.getData(data), new ArrayList<String>(), new class_2338[0]));
        } else {
            PacketTrainDataGuiServer.updateData(dataSet.apply(railwayData), cacheMap.apply(railwayData), minecraftServer, packet, packetCallback, createDataWithId, (data, oldData) -> railwayData.railwayDataLoggingModule.addEvent(player, data.getClass(), data.id, data.name, (List<String>)oldData, RailwayDataLoggingModule.getData(data), new class_2338[0]));
        }
    }

    public static void generatePathS2C(class_1937 world, long depotId, int successfulSegments) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeLong(depotId);
        packet.writeInt(successfulSegments);
        world.method_18456().forEach(player -> Registry.sendToPlayer((class_3222)player, PACKET_GENERATE_PATH, packet));
    }

    public static void generatePathC2S(MinecraftServer minecraftServer, class_3222 player, class_2540 packet) {
        class_1937 world = player.field_6002;
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData != null) {
            long depotId = packet.readLong();
            minecraftServer.execute(() -> railwayData.railwayDataPathGenerationModule.generatePath(minecraftServer, depotId));
        }
    }

    public static void clearTrainsC2S(MinecraftServer minecraftServer, class_3222 player, class_2540 packet) {
        if (RailwayData.hasNoPermission(player)) {
            return;
        }
        class_1937 world = player.field_6002;
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData != null) {
            long depotId = packet.readLong();
            int sidingCount = packet.readInt();
            HashSet<Long> sidingIds = new HashSet<Long>();
            for (int i = 0; i < sidingCount; ++i) {
                sidingIds.add(packet.readLong());
            }
            minecraftServer.execute(() -> {
                Depot depot = railwayData.dataCache.depotIdMap.get(depotId);
                if (depot != null) {
                    railwayData.resetTrainDelays(depot);
                }
                sidingIds.forEach(sidingId -> {
                    Siding siding = railwayData.dataCache.sidingIdMap.get(sidingId);
                    if (siding != null) {
                        siding.clearTrains();
                    }
                });
            });
        }
    }

    public static void receiveTrainSensorC2S(MinecraftServer minecraftServer, class_3222 player, class_2540 packet) {
        class_2338 pos = packet.method_10811();
        HashSet<Long> filterIds = new HashSet<Long>();
        int filterLength = packet.readInt();
        for (int i = 0; i < filterLength; ++i) {
            filterIds.add(packet.readLong());
        }
        boolean stoppedOnly = packet.readBoolean();
        boolean movingOnly = packet.readBoolean();
        int number = packet.readInt();
        int stringCount = packet.readInt();
        String[] strings = new String[stringCount];
        for (int i = 0; i < stringCount; ++i) {
            strings[i] = packet.method_10800(Short.MAX_VALUE);
        }
        minecraftServer.execute(() -> {
            class_2586 entity = player.field_6002.method_8321(pos);
            if (entity instanceof BlockTrainSensorBase.TileEntityTrainSensorBase) {
                PacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((class_3222)player, (T entity2) -> entity2.setData(filterIds, stoppedOnly, movingOnly, number, strings), (BlockEntityMapper[])new BlockTrainSensorBase.TileEntityTrainSensorBase[]{(BlockTrainSensorBase.TileEntityTrainSensorBase)entity});
            }
        });
    }

    public static void receiveLiftTrackFloorC2S(MinecraftServer minecraftServer, class_3222 player, class_2540 packet) {
        class_2338 pos = packet.method_10811();
        String floorNumber = packet.method_10800(Short.MAX_VALUE);
        String floorDescription = packet.method_10800(Short.MAX_VALUE);
        boolean shouldDing = packet.readBoolean();
        minecraftServer.execute(() -> {
            class_2586 entity = player.field_6002.method_8321(pos);
            if (entity instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor) {
                PacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((class_3222)player, (T entity2) -> entity2.setData(floorNumber, floorDescription, shouldDing), (BlockEntityMapper[])new BlockLiftTrackFloor.TileEntityLiftTrackFloor[]{(BlockLiftTrackFloor.TileEntityLiftTrackFloor)entity});
            }
        });
    }

    public static void receiveSignIdsC2S(MinecraftServer minecraftServer, class_3222 player, class_2540 packet) {
        class_2338 signPos = packet.method_10811();
        int selectedIdsLength = packet.readInt();
        HashSet<Long> selectedIds = new HashSet<Long>();
        for (int i = 0; i < selectedIdsLength; ++i) {
            selectedIds.add(packet.readLong());
        }
        int signLength = packet.readInt();
        String[] signIds = new String[signLength];
        for (int i = 0; i < signLength; ++i) {
            String signId = packet.method_10800(Short.MAX_VALUE);
            signIds[i] = signId.isEmpty() ? null : signId;
        }
        minecraftServer.execute(() -> {
            class_2586 entity = player.field_6002.method_8321(signPos);
            if (entity instanceof BlockRailwaySign.TileEntityRailwaySign) {
                PacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((class_3222)player, (T entity2) -> entity2.setData(selectedIds, signIds), (BlockEntityMapper[])new BlockRailwaySign.TileEntityRailwaySign[]{(BlockRailwaySign.TileEntityRailwaySign)entity});
            } else if (entity instanceof BlockRouteSignBase.TileEntityRouteSignBase) {
                long platformId = selectedIds.isEmpty() ? 0L : (Long)selectedIds.toArray()[0];
                class_2586 entityAbove = player.field_6002.method_8321(signPos.method_10084());
                if (entityAbove instanceof BlockRouteSignBase.TileEntityRouteSignBase) {
                    PacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((class_3222)player, (T entity2) -> entity2.setPlatformId(platformId), (BlockEntityMapper[])new BlockRouteSignBase.TileEntityRouteSignBase[]{(BlockRouteSignBase.TileEntityRouteSignBase)entityAbove, (BlockRouteSignBase.TileEntityRouteSignBase)entity});
                } else {
                    PacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((class_3222)player, (T entity2) -> entity2.setPlatformId(platformId), (BlockEntityMapper[])new BlockRouteSignBase.TileEntityRouteSignBase[]{(BlockRouteSignBase.TileEntityRouteSignBase)entity});
                }
            }
        });
    }

    public static void receiveDriveTrainC2S(MinecraftServer minecraftServer, class_3222 player, class_2540 packet) {
        RailwayData railwayData = RailwayData.getInstance(player.field_6002);
        if (railwayData != null) {
            boolean pressingAccelerate = packet.readBoolean();
            boolean pressingBrake = packet.readBoolean();
            boolean pressingDoors = packet.readBoolean();
            minecraftServer.execute(() -> railwayData.railwayDataDriveTrainModule.drive(player, pressingAccelerate, pressingBrake, pressingDoors));
        }
    }

    public static void receivePressLiftButtonC2S(MinecraftServer minecraftServer, class_3222 player, class_2540 packet) {
        RailwayData railwayData = RailwayData.getInstance(player.field_6002);
        if (railwayData != null) {
            long id = packet.readLong();
            int floor = packet.readInt();
            minecraftServer.execute(() -> {
                Lift lift = railwayData.dataCache.liftsServerIdMap.get(id);
                if (lift != null) {
                    lift.pressButton(floor);
                }
            });
        }
    }

    public static void receiveAddBalanceC2S(MinecraftServer minecraftServer, class_3222 player, class_2540 packet) {
        int addAmount = packet.readInt();
        int emeralds = packet.readInt();
        minecraftServer.execute(() -> {
            class_1937 world = player.field_6002;
            TicketSystem.addObjectivesIfMissing(world);
            class_267 balanceScore = TicketSystem.getPlayerScore(world, (class_1657)player, "mtr_balance");
            balanceScore.method_1128(balanceScore.method_1126() + addAmount);
            class_1262.method_29234((class_1263)Utilities.getInventory((class_1657)player), itemStack -> itemStack.method_7909() == class_1802.field_8687, (int)emeralds, (boolean)false);
            world.method_8396(null, player.method_24515(), class_3417.field_14627, class_3419.field_15245, 1.0f, 1.0f);
        });
    }

    public static void receivePIDSMessageC2S(MinecraftServer minecraftServer, class_3222 player, class_2540 packet) {
        class_2338 pos1 = packet.method_10811();
        class_2338 pos2 = packet.method_10811();
        int maxMessages = packet.readInt();
        String[] messages = new String[maxMessages];
        for (int i = 0; i < maxMessages; ++i) {
            messages[i] = packet.method_10800(Short.MAX_VALUE);
        }
        int maxArrivals = packet.readInt();
        boolean[] hideArrivals = new boolean[maxArrivals];
        for (int i = 0; i < maxArrivals; ++i) {
            hideArrivals[i] = packet.readBoolean();
        }
        int platformIdCount = packet.readInt();
        HashSet<Long> platformIds = new HashSet<Long>();
        for (int i = 0; i < platformIdCount; ++i) {
            platformIds.add(packet.readLong());
        }
        int arrivalPage = packet.readInt();
        minecraftServer.execute(() -> {
            class_2586 entity2;
            ArrayList<IPIDS.TileEntityPIDS> entities = new ArrayList<IPIDS.TileEntityPIDS>();
            class_2586 entity1 = player.field_6002.method_8321(pos1);
            if (entity1 instanceof IPIDS.TileEntityPIDS) {
                entities.add((IPIDS.TileEntityPIDS)entity1);
            }
            if ((entity2 = player.field_6002.method_8321(pos2)) instanceof IPIDS.TileEntityPIDS) {
                entities.add((IPIDS.TileEntityPIDS)entity2);
            }
            PacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((class_3222)player, (T entity) -> entity.setData(messages, hideArrivals, platformIds, arrivalPage), (BlockEntityMapper[])entities.toArray(new IPIDS.TileEntityPIDS[0]));
        });
    }

    public static void receiveArrivalProjectorMessageC2S(MinecraftServer minecraftServer, class_3222 player, class_2540 packet) {
        class_2338 pos = packet.method_10811();
        int platformIdCount = packet.readInt();
        HashSet<Long> platformIds = new HashSet<Long>();
        for (int i = 0; i < platformIdCount; ++i) {
            platformIds.add(packet.readLong());
        }
        int displayPage = packet.readInt();
        minecraftServer.execute(() -> {
            class_2586 entity = player.field_6002.method_8321(pos);
            if (entity instanceof BlockArrivalProjectorBase.TileEntityArrivalProjectorBase) {
                PacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((class_3222)player, (T entity2) -> entity2.setData(platformIds, displayPage), (BlockEntityMapper[])new BlockArrivalProjectorBase.TileEntityArrivalProjectorBase[]{(BlockArrivalProjectorBase.TileEntityArrivalProjectorBase)entity});
            }
        });
    }

    public static void receiveUseTimeAndWindSyncC2S(MinecraftServer minecraftServer, class_3222 player, class_2540 packet) {
        if (RailwayData.hasNoPermission(player) || !player.method_5687(1)) {
            return;
        }
        class_1937 world = player.field_6002;
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData != null) {
            boolean useTimeAndWindSync = packet.readBoolean();
            minecraftServer.execute(() -> {
                boolean useTimeAndWindSyncOld = railwayData.getUseTimeAndWindSync();
                railwayData.setUseTimeAndWindSync(useTimeAndWindSync);
                String key = "\"use_time_and_wind_sync\":";
                railwayData.railwayDataLoggingModule.addEvent(player, RailwayData.class, Collections.singletonList("\"use_time_and_wind_sync\":" + useTimeAndWindSyncOld), Collections.singletonList("\"use_time_and_wind_sync\":" + useTimeAndWindSync), new class_2338[0]);
            });
        }
    }

    public static void receiveRemoveRailAction(MinecraftServer minecraftServer, class_1657 player, class_2540 packet) {
        class_1937 world = player.field_6002;
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData != null) {
            long id = packet.readLong();
            minecraftServer.execute(() -> railwayData.railwayDataRailActionsModule.removeRailAction(id));
        }
    }

    public static void receiveUpdateTrainPassengerPosition(MinecraftServer minecraftServer, class_1657 player, class_2540 packet) {
        class_2540 packetFullCopy = new class_2540(packet.copy());
        minecraftServer.execute(() -> player.field_6002.method_18456().forEach(sendPlayer -> {
            if (sendPlayer != player) {
                Registry.sendToPlayer((class_3222)sendPlayer, PACKET_UPDATE_TRAIN_PASSENGER_POSITION, packetFullCopy);
            }
        }));
    }

    public static void receiveUpdateLiftPassengerPosition(MinecraftServer minecraftServer, class_1657 player, class_2540 packet) {
        class_2540 packetFullCopy = new class_2540(packet.copy());
        minecraftServer.execute(() -> player.field_6002.method_18456().forEach(sendPlayer -> {
            if (sendPlayer != player) {
                Registry.sendToPlayer((class_3222)sendPlayer, PACKET_UPDATE_LIFT_PASSENGER_POSITION, packetFullCopy);
            }
        }));
    }

    public static void receiveUpdateEntitySeatPassengerPosition(MinecraftServer minecraftServer, class_1657 player, class_2540 packet) {
        RailwayData railwayData = RailwayData.getInstance(player.field_6002);
        if (railwayData != null) {
            double x = packet.readDouble();
            double y = packet.readDouble();
            double z = packet.readDouble();
            minecraftServer.execute(() -> railwayData.railwayDataCoolDownModule.moveSeat(player, x, y, z));
        }
    }

    private static <T extends SerializedDataBase> void serializeData(class_2540 packet, Collection<T> objects) {
        packet.writeInt(objects.size());
        objects.forEach(object -> object.writePacket(packet));
    }

    private static boolean sendChunk(class_3222 player, class_2540 packet, long tempPacketId, int chunk) {
        class_2540 packetChunk = new class_2540(Unpooled.buffer());
        packetChunk.writeLong(tempPacketId);
        packetChunk.writeInt(chunk);
        boolean success = chunk * PACKET_CHUNK_SIZE > packet.readableBytes();
        packetChunk.writeBoolean(success);
        if (!success) {
            packetChunk.writeBytes(packet.copy(chunk * PACKET_CHUNK_SIZE, Math.min(PACKET_CHUNK_SIZE, packet.readableBytes() - chunk * PACKET_CHUNK_SIZE)));
        }
        try {
            Registry.sendToPlayer(player, PACKET_CHUNK_S2C, packetChunk);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }

    @SafeVarargs
    private static <T extends BlockEntityMapper> void setTileEntityDataAndWriteUpdate(class_3222 player, Consumer<T> setData, T ... entities) {
        RailwayData railwayData = RailwayData.getInstance(player.field_6002);
        if (railwayData != null && entities.length > 0) {
            class_2487 compoundTagOld = new class_2487();
            ((BlockEntityMapper)((Object)entities[0])).writeCompoundTag(compoundTagOld);
            class_2338 blockPos = null;
            long posLong = 0L;
            for (T entity : entities) {
                setData.accept(entity);
                class_2338 entityPos = entity.method_11016();
                if (blockPos != null && entityPos.method_10063() <= posLong) continue;
                blockPos = entityPos;
                posLong = entityPos.method_10063();
            }
            class_2487 compoundTagNew = new class_2487();
            ((BlockEntityMapper)((Object)entities[0])).writeCompoundTag(compoundTagNew);
            railwayData.railwayDataLoggingModule.addEvent(player, entities[0].getClass(), RailwayDataLoggingModule.getData(compoundTagOld), RailwayDataLoggingModule.getData(compoundTagNew), blockPos);
        }
    }
}

