/*
 * Decompiled with CFR 0.152.
 */
package mtr.packet;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.POIMarker;
import de.bluecolored.bluemap.api.markers.ShapeMarker;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import java.util.Set;
import mtr.data.AreaBase;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.packet.IUpdateWebMap;
import net.minecraft.class_1937;

public class UpdateBlueMap
implements IGui,
IUpdateWebMap {
    public static void updateBlueMap(class_1937 world, RailwayData railwayData) {
        try {
            UpdateBlueMap.updateBlueMap(world, railwayData.stations, "mtr_stations", "Stations", "mtr_station_areas", "Station Areas", "/assets/mtr/textures/block/sign/logo.png");
            UpdateBlueMap.updateBlueMap(world, railwayData.depots, "mtr_depots", "Depots", "mtr_depot_areas", "Depot Areas", "/assets/mtr/textures/block/sign/logo_grayscale.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static <T extends AreaBase> void updateBlueMap(class_1937 world, Set<T> areas, String areasId, String areasTitle, String areaAreasId, String areaAreasTitle, String iconKey) {
        BlueMapAPI api = BlueMapAPI.getInstance().orElse(null);
        if (api == null) {
            return;
        }
        String worldId = world.method_27983().method_29177().method_12832();
        BlueMapMap map = api.getMaps().stream().filter(map1 -> worldId.contains(map1.getId())).findFirst().orElse(null);
        if (map == null) {
            return;
        }
        int areaY = world.method_8615();
        MarkerSet markerSetAreas = MarkerSet.builder().label(areasTitle).build();
        markerSetAreas.getMarkers().clear();
        map.getMarkerSets().put(areasId, markerSetAreas);
        MarkerSet markerSetAreaAreas = MarkerSet.builder().label(areaAreasTitle).defaultHidden(Boolean.valueOf(true)).build();
        markerSetAreaAreas.getMarkers().clear();
        map.getMarkerSets().put(areaAreasId, markerSetAreaAreas);
        IUpdateWebMap.iterateAreas(areas, (id, name, color, areaCorner1X, areaCorner1Z, areaCorner2X, areaCorner2Z, areaX, areaZ) -> {
            POIMarker markerArea = ((POIMarker.Builder)((POIMarker.Builder)POIMarker.toBuilder().position(areaX, areaY, areaZ)).label(name)).icon(iconKey, 12, 12).build();
            markerSetAreas.getMarkers().put("1_" + worldId + id, markerArea);
            ShapeMarker markerAreaArea = ((ShapeMarker.Builder)((ShapeMarker.Builder)ShapeMarker.builder().position(areaX, areaY, areaZ)).shape(Shape.createRect((double)areaCorner1X, (double)areaCorner1Z, (double)areaCorner2X, (double)areaCorner2Z), (float)areaY).label(name)).fillColor(new Color(color.getRGB() & 0xFFFFFF, 0.5f)).lineColor(new Color(color.darker().getRGB())).build();
            markerSetAreas.getMarkers().put("2_" + worldId + id, markerAreaArea);
        });
    }
}

