/*
 * Decompiled with CFR 0.152.
 */
package mtr.path;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import mtr.data.DataCache;
import mtr.data.Platform;
import mtr.data.Rail;
import mtr.data.RailAngle;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.SavedRailBase;
import mtr.data.TransportMode;
import mtr.path.PathData;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public class PathFinder {
    private static final int MAX_AIRPLANE_TURN_ARC = 128;

    public static int findPath(List<PathData> path, Map<class_2338, Map<class_2338, Rail>> rails, List<SavedRailBase> savedRailBases, int stopIndexOffset, int cruisingAltitude, boolean useFastSpeed) {
        path.clear();
        if (savedRailBases.size() < 2) {
            return 0;
        }
        for (int i = 0; i < savedRailBases.size() - 1; ++i) {
            List<PathData> partialPath;
            SavedRailBase savedRailBaseStart = savedRailBases.get(i);
            SavedRailBase savedRailBaseEnd = savedRailBases.get(i + 1);
            HashSet<class_2338> runways = new HashSet<class_2338>();
            if (savedRailBaseStart.transportMode == TransportMode.AIRPLANE) {
                rails.forEach((startPos, railMap) -> {
                    if (railMap.size() == 1 && railMap.values().stream().allMatch(rail -> rail.railType == RailType.RUNWAY)) {
                        runways.add((class_2338)startPos);
                    }
                });
            }
            if ((partialPath = PathFinder.findPath(rails, runways, savedRailBaseStart, savedRailBaseEnd, i + stopIndexOffset, cruisingAltitude, useFastSpeed)).isEmpty()) {
                path.clear();
                return i + 1;
            }
            PathFinder.appendPath(path, partialPath);
        }
        return savedRailBases.size();
    }

    public static void appendPath(List<PathData> path, List<PathData> partialPath) {
        if (partialPath.isEmpty()) {
            path.clear();
        } else {
            boolean sameFirstRail = !path.isEmpty() && path.get(path.size() - 1).isSameRail(partialPath.get(0));
            for (int j = 0; j < partialPath.size(); ++j) {
                if (j == 0 && sameFirstRail) continue;
                path.add(partialPath.get(j));
            }
        }
    }

    private static List<PathData> findPath(Map<class_2338, Map<class_2338, Rail>> rails, Set<class_2338> runways, SavedRailBase savedRailBaseStart, SavedRailBase savedRailBaseEnd, int stopIndex, int cruisingAltitude, boolean useFastSpeed) {
        class_2338 savedRailBaseEndMidPos = savedRailBaseEnd.getMidPos();
        Function<Map<class_2338, Rail>, Comparator<class_2338>> comparator = newConnections -> (pos1, pos2) -> {
            if (pos1 == pos2) {
                return 0;
            }
            Rail connection1 = (Rail)newConnections.get(pos1);
            Rail connection2 = (Rail)newConnections.get(pos2);
            if (connection1 == null || connection2 == null || connection1.railType.speedLimit == connection2.railType.speedLimit) {
                return pos1.method_10262((class_2382)savedRailBaseEndMidPos) > pos2.method_10262((class_2382)savedRailBaseEndMidPos) ? 1 : -1;
            }
            return connection2.railType.speedLimit - connection1.railType.speedLimit;
        };
        for (int i = 0; i < 2; ++i) {
            ArrayList<PathPart> path = new ArrayList<PathPart>();
            HashSet<class_2338> turnBacks = new HashSet<class_2338>();
            List<class_2338> startPositions = savedRailBaseStart.getOrderedPositions(savedRailBaseEndMidPos, i == 0);
            path.add(new PathPart(null, startPositions.get(0), new ArrayList<class_2338>()));
            PathFinder.addPathPart(rails, runways, startPositions.get(1), startPositions.get(0), path, turnBacks, comparator);
            while (path.size() >= 2) {
                PathPart lastPathPart = (PathPart)path.get(path.size() - 1);
                if (lastPathPart.otherOptions.isEmpty()) {
                    path.remove(lastPathPart);
                    continue;
                }
                class_2338 newPos = lastPathPart.otherOptions.remove(0);
                PathFinder.addPathPart(rails, runways, newPos, lastPathPart.pos, path, turnBacks, comparator);
                if (!savedRailBaseEnd.containsPos(newPos)) continue;
                ArrayList<PathData> railPath = new ArrayList<PathData>();
                for (int j = 0; j < path.size() - 1; ++j) {
                    PathPart pathPart1 = (PathPart)path.get(j);
                    PathPart pathPart2 = (PathPart)path.get(j + 1);
                    class_2338 pos1 = pathPart1.pos;
                    class_2338 pos2 = pathPart2.pos;
                    Rail rail = DataCache.tryGet(rails, pos1, pos2);
                    if (rail == null) {
                        if (runways.isEmpty()) {
                            return new ArrayList<PathData>();
                        }
                        int heightDifference1 = cruisingAltitude - pos1.method_10264();
                        int heightDifference2 = cruisingAltitude - pos2.method_10264();
                        class_2338 cruisingPos1 = RailwayData.offsetBlockPos(pos1, pathPart1.direction.cos * (double)Math.abs(heightDifference1) * 4.0, heightDifference1, pathPart1.direction.sin * (double)Math.abs(heightDifference1) * 4.0);
                        class_2338 cruisingPos4 = RailwayData.offsetBlockPos(pos2, -pathPart2.direction.cos * (double)Math.abs(heightDifference2) * 4.0, heightDifference2, -pathPart2.direction.sin * (double)Math.abs(heightDifference2) * 4.0);
                        int turnArc = Math.min(128, cruisingPos1.method_19455((class_2382)cruisingPos4) / 8);
                        RailType dummyRailType = useFastSpeed ? RailType.AIRPLANE_DUMMY : RailType.RUNWAY;
                        railPath.add(new PathData(new Rail(pos1, pathPart1.direction, cruisingPos1, pathPart1.direction.getOpposite(), dummyRailType, TransportMode.AIRPLANE), 0L, 0, pos1, cruisingPos1, stopIndex));
                        RailAngle expectedAngle = RailAngle.fromAngle((float)Math.toDegrees(Math.atan2(cruisingPos4.method_10260() - cruisingPos1.method_10260(), cruisingPos4.method_10263() - cruisingPos1.method_10263())));
                        class_2338 cruisingPos2 = PathFinder.addAirplanePath(pathPart1.direction, cruisingPos1, expectedAngle, turnArc, railPath, dummyRailType, stopIndex, false);
                        ArrayList<PathData> tempRailData = new ArrayList<PathData>();
                        class_2338 cruisingPos3 = PathFinder.addAirplanePath(pathPart2.direction.getOpposite(), cruisingPos4, expectedAngle.getOpposite(), turnArc, tempRailData, dummyRailType, stopIndex, true);
                        railPath.add(new PathData(new Rail(cruisingPos2, expectedAngle, cruisingPos3, expectedAngle.getOpposite(), dummyRailType, TransportMode.AIRPLANE), 0L, 0, cruisingPos2, cruisingPos3, stopIndex));
                        railPath.addAll(tempRailData);
                        railPath.add(new PathData(new Rail(cruisingPos4, pathPart2.direction, pos2, pathPart2.direction.getOpposite(), dummyRailType, TransportMode.AIRPLANE), 0L, 0, cruisingPos4, pos2, stopIndex));
                        continue;
                    }
                    boolean turningBack = rail.railType == RailType.TURN_BACK && j < path.size() - 2 && ((PathPart)path.get((int)(j + 2))).pos.equals((Object)pos1);
                    railPath.add(new PathData(rail, j == 0 ? savedRailBaseStart.id : 0L, turningBack ? 1 : 0, pos1, pos2, stopIndex));
                }
                class_2338 endPos = savedRailBaseEnd.getOtherPosition(newPos);
                Rail rail = DataCache.tryGet(rails, newPos, endPos);
                if (rail == null) {
                    return new ArrayList<PathData>();
                }
                railPath.add(new PathData(rail, savedRailBaseEnd.id, savedRailBaseEnd instanceof Platform ? savedRailBaseEnd.getDwellTime() : 0, newPos, endPos, stopIndex + 1));
                return railPath;
            }
        }
        return new ArrayList<PathData>();
    }

    private static void addPathPart(Map<class_2338, Map<class_2338, Rail>> rails, Set<class_2338> runways, class_2338 newPos, class_2338 lastPos, List<PathPart> path, Set<class_2338> turnBacks, Function<Map<class_2338, Rail>, Comparator<class_2338>> comparator) {
        Map<class_2338, Rail> newConnections = rails.get(newPos);
        Rail oldRail = rails.get(lastPos).get(newPos);
        if (oldRail == null && runways.isEmpty()) {
            return;
        }
        RailAngle newDirection = oldRail == null ? newConnections.values().stream().map(rail -> rail.facingStart).findFirst().orElse(RailAngle.E) : oldRail.facingEnd.getOpposite();
        ArrayList<class_2338> otherOptions = new ArrayList<class_2338>();
        if (newConnections != null) {
            boolean canTurnBack;
            boolean bl = canTurnBack = oldRail != null && oldRail.railType == RailType.TURN_BACK && !turnBacks.contains(newPos);
            if (oldRail != null && oldRail.railType == RailType.RUNWAY && newConnections.size() <= 1) {
                otherOptions.addAll(runways);
            } else {
                newConnections.forEach((connectedPos, rail) -> {
                    if (canTurnBack || rail.railType != RailType.NONE && rail.facingStart != newDirection.getOpposite() && path.stream().noneMatch(pathPart -> pathPart.isSame(newPos, newDirection))) {
                        otherOptions.add((class_2338)connectedPos);
                        if (canTurnBack) {
                            turnBacks.add(newPos);
                        }
                    }
                });
            }
        }
        if (!otherOptions.isEmpty()) {
            otherOptions.sort(comparator.apply(newConnections));
            path.add(new PathPart(newDirection, newPos, otherOptions));
        }
    }

    private static class_2338 addAirplanePath(RailAngle startAngle, class_2338 startPos, RailAngle expectedAngle, int turnArc, List<PathData> tempRailPath, RailType railType, int stopIndex, boolean reverse) {
        RailAngle angleDifference = expectedAngle.sub(startAngle);
        boolean turnRight = angleDifference.angleRadians > 0.0;
        RailAngle tempAngle = startAngle;
        class_2338 tempPos = startPos;
        for (int i = 0; i < RailAngle.values().length && tempAngle != expectedAngle; ++i) {
            RailAngle oldTempAngle = tempAngle;
            class_2338 oldTempPos = tempPos;
            RailAngle rotateAngle = turnRight ? RailAngle.SEE : RailAngle.NEE;
            tempAngle = tempAngle.add(rotateAngle);
            class_243 posOffset = new class_243((double)turnArc, 0.0, 0.0).method_1024((float)(-oldTempAngle.angleRadians) - (float)rotateAngle.angleRadians / 2.0f);
            tempPos = RailwayData.offsetBlockPos(oldTempPos, posOffset.field_1352, posOffset.field_1351, posOffset.field_1350);
            if (reverse) {
                tempRailPath.add(0, new PathData(new Rail(tempPos, tempAngle.getOpposite(), oldTempPos, oldTempAngle, railType, TransportMode.AIRPLANE), 0L, 0, tempPos, oldTempPos, stopIndex));
                continue;
            }
            tempRailPath.add(new PathData(new Rail(oldTempPos, oldTempAngle, tempPos, tempAngle.getOpposite(), railType, TransportMode.AIRPLANE), 0L, 0, oldTempPos, tempPos, stopIndex));
        }
        return tempPos;
    }

    private static class PathPart {
        private final RailAngle direction;
        private final class_2338 pos;
        private final List<class_2338> otherOptions;

        private PathPart(RailAngle direction, class_2338 pos, List<class_2338> otherOptions) {
            this.direction = direction;
            this.pos = pos;
            this.otherOptions = otherOptions;
        }

        private boolean isSame(class_2338 newPos, RailAngle newDirection) {
            return newPos.equals((Object)this.pos) && newDirection == this.direction;
        }
    }
}

