/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import mtr.MTRClient;
import mtr.client.IDrawing;
import mtr.client.TrainClientRegistry;
import mtr.client.TrainProperties;
import mtr.data.IGui;
import mtr.data.TrainClient;
import mtr.data.TransportMode;
import mtr.mappings.UtilitiesClient;
import mtr.model.ModelBogie;
import mtr.model.ModelCableCarGrip;
import mtr.model.ModelTrainBase;
import mtr.path.PathData;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import mtr.render.TrainRendererBase;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_583;
import net.minecraft.class_765;
import org.apache.commons.lang3.StringUtils;

public class JonModelTrainRenderer
extends TrainRendererBase
implements IGui {
    private final TrainClient train;
    public final ModelTrainBase model;
    public final String textureId;
    public final String gangwayConnectionId;
    public final String trainBarrierId;
    private static final class_583<class_1695> MODEL_MINECART = UtilitiesClient.getMinecartModel();
    private static final class_583<class_1690> MODEL_BOAT = UtilitiesClient.getBoatModel();
    private static final Map<Long, FakeBoat> BOATS = new HashMap<Long, FakeBoat>();
    private static final ModelCableCarGrip MODEL_CABLE_CAR_GRIP = new ModelCableCarGrip();
    private static final ModelBogie MODEL_BOGIE = new ModelBogie();

    private JonModelTrainRenderer(ModelTrainBase model, String textureId, String gangwayConnectionId, String trainBarrierId, TrainClient train) {
        this.model = model;
        this.textureId = JonModelTrainRenderer.resolvePath(textureId);
        this.gangwayConnectionId = JonModelTrainRenderer.resolvePath(gangwayConnectionId);
        this.trainBarrierId = JonModelTrainRenderer.resolvePath(trainBarrierId);
        this.train = train;
    }

    public JonModelTrainRenderer(ModelTrainBase model, String textureId, String gangwayConnectionId, String trainBarrierId) {
        this(model, textureId, gangwayConnectionId, trainBarrierId, null);
    }

    @Override
    public TrainRendererBase createTrainInstance(TrainClient train) {
        return new JonModelTrainRenderer(this.model, this.textureId, this.gangwayConnectionId, this.trainBarrierId, train);
    }

    @Override
    public void renderCar(int carIndex, double x, double y, double z, float yaw, float pitch, boolean doorLeftOpen, boolean doorRightOpen) {
        float doorLeftValue = doorLeftOpen ? this.train.getDoorValue() : 0.0f;
        float doorRightValue = doorRightOpen ? this.train.getDoorValue() : 0.0f;
        boolean atPlatform = ((PathData)this.train.path.get((int)this.train.getIndex((int)0, (int)this.train.spacing, (boolean)true))).dwellTime > 0;
        boolean hasPitch = pitch < 0.0f ? this.train.transportMode.hasPitchAscending : this.train.transportMode.hasPitchDescending;
        String trainId = this.train.trainId;
        TrainProperties trainProperties = TrainClientRegistry.getTrainProperties(trainId);
        if (this.model == null && isTranslucentBatch) {
            return;
        }
        class_2338 posAverage = JonModelTrainRenderer.applyAverageTransform(this.train.getViewOffset(), x, y, z);
        if (posAverage == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904(x, y, z);
        UtilitiesClient.rotateY(matrices, (float)Math.PI + yaw);
        UtilitiesClient.rotateX(matrices, (float)Math.PI + (hasPitch ? pitch : 0.0f));
        int light = class_765.method_23687((int)world.method_8314(class_1944.field_9282, posAverage), (int)world.method_8314(class_1944.field_9284, posAverage));
        if (this.model == null || this.textureId == null) {
            boolean isBoat = this.train.transportMode == TransportMode.BOAT;
            matrices.method_22904(0.0, isBoat ? 0.875 : 0.5, 0.0);
            UtilitiesClient.rotateYDegrees(matrices, 90.0f);
            class_583<class_1690> model = isBoat ? MODEL_BOAT : MODEL_MINECART;
            class_4588 vertexConsumer = vertexConsumers.getBuffer(model.method_23500(this.resolveTexture(this.textureId, textureId -> textureId + ".png")));
            if (isBoat) {
                if (!BOATS.containsKey(this.train.id)) {
                    BOATS.put(this.train.id, new FakeBoat());
                }
                MODEL_BOAT.method_2819((class_1297)BOATS.get(this.train.id), (this.train.getSpeed() + 0.01f) * (doorLeftValue == 0.0f && doorRightValue == 0.0f ? lastFrameDuration : 0.0f), 0.0f, -0.1f, 0.0f, 0.0f);
            } else {
                model.method_2819(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
            }
            model.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (!this.textureId.isEmpty()) {
            boolean renderDetails = MTRClient.isReplayMod() || posAverage.method_10262((class_2382)camera.method_19328()) <= 1024.0;
            this.model.render(matrices, vertexConsumers, this.train, this.resolveTexture(this.textureId, textureId -> textureId + ".png"), light, doorLeftValue, doorRightValue, this.train.isDoorOpening(), carIndex, this.train.trainCars, !this.train.isReversed(), this.train.getIsOnRoute(), isTranslucentBatch, renderDetails, atPlatform);
            if (trainProperties.bogiePosition != 0.0f && !isTranslucentBatch) {
                if (trainProperties.isJacobsBogie) {
                    if (carIndex == 0) {
                        MODEL_BOGIE.render(matrices, vertexConsumers, light, this.train.trainCars == 1 ? 0 : -((int)(trainProperties.bogiePosition * 16.0f)));
                    } else if (carIndex == this.train.trainCars - 1) {
                        MODEL_BOGIE.render(matrices, vertexConsumers, light, (int)(trainProperties.bogiePosition * 16.0f));
                    }
                } else {
                    MODEL_BOGIE.render(matrices, vertexConsumers, light, (int)(trainProperties.bogiePosition * 16.0f));
                    MODEL_BOGIE.render(matrices, vertexConsumers, light, -((int)(trainProperties.bogiePosition * 16.0f)));
                }
            }
        }
        if (this.train.transportMode == TransportMode.CABLE_CAR && !isTranslucentBatch) {
            matrices.method_22904(0.0, (double)TransportMode.CABLE_CAR.railOffset + 0.5, 0.0);
            if (!hasPitch) {
                UtilitiesClient.rotateX(matrices, pitch);
            }
            if (trainId.endsWith("_rht")) {
                UtilitiesClient.rotateYDegrees(matrices, 180.0f);
            }
            MODEL_CABLE_CAR_GRIP.render(matrices, vertexConsumers, light);
        }
        matrices.method_22909();
        matrices.method_22909();
    }

    @Override
    public void renderConnection(class_243 prevPos1, class_243 prevPos2, class_243 prevPos3, class_243 prevPos4, class_243 thisPos1, class_243 thisPos2, class_243 thisPos3, class_243 thisPos4, double x, double y, double z, float yaw, float pitch) {
        class_2338 posAverage = JonModelTrainRenderer.applyAverageTransform(this.train.getViewOffset(), x, y, z);
        if (posAverage == null) {
            return;
        }
        String trainId = this.train.trainId;
        TrainProperties trainProperties = TrainClientRegistry.getTrainProperties(trainId);
        int light = class_765.method_23687((int)world.method_8314(class_1944.field_9282, posAverage), (int)world.method_8314(class_1944.field_9284, posAverage));
        if (!this.gangwayConnectionId.isEmpty()) {
            class_4588 vertexConsumerExterior = vertexConsumers.getBuffer(MoreRenderLayers.getExterior(this.getConnectorTextureString(true, "exterior")));
            JonModelTrainRenderer.drawTexture(matrices, vertexConsumerExterior, thisPos2, prevPos3, prevPos4, thisPos1, light);
            JonModelTrainRenderer.drawTexture(matrices, vertexConsumerExterior, prevPos2, thisPos3, thisPos4, prevPos1, light);
            JonModelTrainRenderer.drawTexture(matrices, vertexConsumerExterior, prevPos3, thisPos2, thisPos3, prevPos2, light);
            JonModelTrainRenderer.drawTexture(matrices, vertexConsumerExterior, prevPos1, thisPos4, thisPos1, prevPos4, light);
            int lightOnLevel = this.train.getIsOnRoute() ? 0xF000B0 : light;
            class_4588 vertexConsumerSide = vertexConsumers.getBuffer(MoreRenderLayers.getInterior(this.getConnectorTextureString(true, "side")));
            JonModelTrainRenderer.drawTexture(matrices, vertexConsumerSide, thisPos3, prevPos2, prevPos1, thisPos4, lightOnLevel);
            JonModelTrainRenderer.drawTexture(matrices, vertexConsumerSide, prevPos3, thisPos2, thisPos1, prevPos4, lightOnLevel);
            JonModelTrainRenderer.drawTexture(matrices, vertexConsumers.getBuffer(MoreRenderLayers.getInterior(this.getConnectorTextureString(true, "roof"))), prevPos2, thisPos3, thisPos2, prevPos3, lightOnLevel);
            JonModelTrainRenderer.drawTexture(matrices, vertexConsumers.getBuffer(MoreRenderLayers.getInterior(this.getConnectorTextureString(true, "floor"))), prevPos4, thisPos1, thisPos4, prevPos1, lightOnLevel);
        }
        if (trainProperties.isJacobsBogie) {
            matrices.method_22903();
            matrices.method_22904(x, y, z);
            UtilitiesClient.rotateY(matrices, (float)Math.PI + yaw);
            UtilitiesClient.rotateX(matrices, (float)Math.PI + ((pitch < 0.0f ? this.train.transportMode.hasPitchAscending : this.train.transportMode.hasPitchDescending) ? pitch : 0.0f));
            MODEL_BOGIE.render(matrices, vertexConsumers, light, 0);
            matrices.method_22909();
        }
        matrices.method_22909();
    }

    @Override
    public void renderBarrier(class_243 prevPos1, class_243 prevPos2, class_243 prevPos3, class_243 prevPos4, class_243 thisPos1, class_243 thisPos2, class_243 thisPos3, class_243 thisPos4, double x, double y, double z, float yaw, float pitch) {
        if (StringUtils.isEmpty((CharSequence)this.trainBarrierId)) {
            return;
        }
        class_2338 posAverage = JonModelTrainRenderer.applyAverageTransform(this.train.getViewOffset(), x, y, z);
        if (posAverage == null) {
            return;
        }
        int light = class_765.method_23687((int)world.method_8314(class_1944.field_9282, posAverage), (int)world.method_8314(class_1944.field_9284, posAverage));
        class_4588 vertexConsumerExterior = vertexConsumers.getBuffer(MoreRenderLayers.getExterior(this.getConnectorTextureString(false, "exterior")));
        JonModelTrainRenderer.drawTexture(matrices, vertexConsumerExterior, thisPos2, prevPos3, prevPos4, thisPos1, light);
        JonModelTrainRenderer.drawTexture(matrices, vertexConsumerExterior, prevPos2, thisPos3, thisPos4, prevPos1, light);
        JonModelTrainRenderer.drawTexture(matrices, vertexConsumerExterior, thisPos3, prevPos2, prevPos1, thisPos4, light);
        JonModelTrainRenderer.drawTexture(matrices, vertexConsumerExterior, prevPos3, thisPos2, thisPos1, prevPos4, light);
        matrices.method_22909();
    }

    public class_2960 resolveTexture(String textureId, Function<String, String> formatter) {
        boolean available;
        String textureString = formatter.apply(textureId);
        class_2960 id = new class_2960(textureString);
        if (!RenderTrains.AVAILABLE_TEXTURES.contains(textureString) && !RenderTrains.UNAVAILABLE_TEXTURES.contains(textureString)) {
            available = UtilitiesClient.hasResource(id);
            (available ? RenderTrains.AVAILABLE_TEXTURES : RenderTrains.UNAVAILABLE_TEXTURES).add(textureString);
            if (!available) {
                System.out.println("Texture " + textureString + " not found, using default");
            }
        } else {
            available = RenderTrains.AVAILABLE_TEXTURES.contains(textureString);
        }
        if (available) {
            return id;
        }
        TrainRendererBase baseRenderer = TrainClientRegistry.getTrainProperties((String)this.train.baseTrainType).renderer;
        return new class_2960(!(baseRenderer instanceof JonModelTrainRenderer) ? "mtr:textures/block/transparent.png" : formatter.apply(((JonModelTrainRenderer)baseRenderer).textureId));
    }

    private class_2960 getConnectorTextureString(boolean isConnector, String partName) {
        return this.resolveTexture(isConnector ? this.gangwayConnectionId : this.trainBarrierId, textureId -> String.format("%s_%s_%s.png", textureId, isConnector ? "connector" : "barrier", partName));
    }

    private static void drawTexture(class_4587 matrices, class_4588 vertexConsumer, class_243 pos1, class_243 pos2, class_243 pos3, class_243 pos4, int light) {
        IDrawing.drawTexture(matrices, vertexConsumer, (float)pos1.field_1352, (float)pos1.field_1351, (float)pos1.field_1350, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, (float)pos3.field_1352, (float)pos3.field_1351, (float)pos3.field_1350, (float)pos4.field_1352, (float)pos4.field_1351, (float)pos4.field_1350, 0.0f, 0.0f, 1.0f, 1.0f, class_2350.field_11036, -1, light);
    }

    private static String resolvePath(String path) {
        return path == null ? null : path.toLowerCase(Locale.ENGLISH).split("\\.png")[0];
    }

    private static class FakeBoat
    extends class_1690 {
        private float progress;

        public FakeBoat() {
            super(class_1299.field_6121, null);
        }

        public float method_7551(int paddle, float newProgress) {
            this.progress += newProgress;
            return this.progress;
        }
    }
}

