/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.systems.RenderSystem;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.Station;
import mtr.data.TrainClient;
import mtr.mappings.UtilitiesClient;
import net.minecraft.class_1041;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_746;

public class RenderDrivingOverlay
implements IGui {
    private static int accelerationSign;
    private static float doorValue;
    private static float speed;
    private static String thisStation;
    private static String nextStation;
    private static String thisRoute;
    private static String lastStation;
    private static int coolDown;
    private static final int HOT_BAR_WIDTH = 182;
    private static final int HOT_BAR_HEIGHT = 22;

    public static void render(Object matrices) {
        RenderDrivingOverlay.render((class_4587)matrices);
    }

    public static void render(class_4587 matrices) {
        if (coolDown > 0) {
            --coolDown;
        } else {
            return;
        }
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        class_1041 window = client.method_22683();
        if (window == null || player == null) {
            return;
        }
        matrices.method_22903();
        RenderSystem.enableBlend();
        UtilitiesClient.beginDrawingTexture(new class_2960("textures/gui/widgets.png"));
        int startX = (window.method_4486() - 182) / 2;
        int startY = window.method_4502() - (player.method_7337() ? 47 : 63);
        class_332.method_25291((class_4587)matrices, (int)startX, (int)startY, (int)0, (float)0.0f, (float)0.0f, (int)61, (int)22, (int)256, (int)256);
        class_332.method_25291((class_4587)matrices, (int)(startX + 61), (int)startY, (int)0, (float)141.0f, (float)0.0f, (int)41, (int)22, (int)256, (int)256);
        class_332.method_25291((class_4587)matrices, (int)(startX + 120), (int)startY, (int)0, (float)0.0f, (float)0.0f, (int)21, (int)22, (int)256, (int)256);
        class_332.method_25291((class_4587)matrices, (int)(startX + 141), (int)startY, (int)0, (float)141.0f, (float)0.0f, (int)41, (int)22, (int)256, (int)256);
        class_332.method_25291((class_4587)matrices, (int)(startX + 39 + Math.max(accelerationSign, -2) * 20), (int)(startY - 1), (int)0, (float)0.0f, (float)22.0f, (int)24, (int)24, (int)256, (int)256);
        class_332.method_25291((class_4587)matrices, (int)(startX + (doorValue > 0.0f ? (doorValue < 1.0f ? 139 : 159) : 119)), (int)(startY - 1), (int)0, (float)0.0f, (float)22.0f, (int)24, (int)24, (int)256, (int)256);
        client.field_1772.method_1720(matrices, "B2", (float)startX + 5.5f, (float)startY + 7.5f, doorValue == 0.0f && accelerationSign == -2 ? -1 : -10066330);
        client.field_1772.method_1720(matrices, "B1", (float)startX + 25.5f, (float)startY + 7.5f, doorValue == 0.0f && accelerationSign == -1 ? -1 : -10066330);
        client.field_1772.method_1720(matrices, "N", (float)startX + 48.5f, (float)startY + 7.5f, doorValue == 0.0f && accelerationSign == 0 ? -1 : -10066330);
        client.field_1772.method_1720(matrices, "P1", (float)startX + 65.5f, (float)startY + 7.5f, doorValue == 0.0f && accelerationSign == 1 ? -1 : -10066330);
        client.field_1772.method_1720(matrices, "P2", (float)startX + 85.5f, (float)startY + 7.5f, doorValue == 0.0f && accelerationSign == 2 ? -1 : -10066330);
        client.field_1772.method_1720(matrices, "DC", (float)startX + 125.5f, (float)startY + 7.5f, speed == 0.0f && doorValue == 0.0f ? -1 : -10066330);
        client.field_1772.method_1720(matrices, String.valueOf((float)Math.round(doorValue * 10.0f) / 10.0f), (float)startX + 144.5f, (float)startY + 7.5f, doorValue > 0.0f && doorValue < 1.0f ? -1 : -10066330);
        client.field_1772.method_1720(matrices, "DO", (float)startX + 165.5f, (float)startY + 7.5f, speed == 0.0f && doorValue == 1.0f ? -1 : -10066330);
        String speedText = RailwayData.round(speed * 3.6f, 1) + " km/h";
        client.field_1772.method_1720(matrices, speedText, (float)(startX - client.field_1772.method_1727(speedText) - 6), (float)window.method_4502() - 14.5f, -1);
        if (thisStation != null) {
            client.field_1772.method_1720(matrices, thisStation, (float)(startX + 182 + 6), (float)window.method_4502() - 44.5f, -1);
        }
        if (nextStation != null) {
            client.field_1772.method_1720(matrices, "> " + nextStation, (float)(startX + 182 + 6), (float)window.method_4502() - 34.5f, -1);
        }
        if (thisRoute != null) {
            client.field_1772.method_1720(matrices, thisRoute, (float)(startX + 182 + 6), (float)window.method_4502() - 19.5f, -1);
        }
        if (lastStation != null) {
            client.field_1772.method_1720(matrices, "> " + lastStation, (float)(startX + 182 + 6), (float)window.method_4502() - 9.5f, -1);
        }
        RenderSystem.disableBlend();
        matrices.method_22909();
    }

    public static void setData(int accelerationSign, TrainClient trainClient) {
        RenderDrivingOverlay.accelerationSign = accelerationSign;
        doorValue = trainClient.getDoorValue();
        coolDown = 2;
        speed = trainClient.getSpeed() * 20.0f;
        Route thisRoute = trainClient.getThisRoute();
        Route nextRoute = trainClient.getNextRoute();
        Station thisStation = trainClient.getThisStation();
        Station nextStation = trainClient.getNextStation();
        Station lastStation = trainClient.getLastStation();
        String string = RenderDrivingOverlay.thisStation = thisStation == null ? null : IGui.formatStationName(thisStation.name);
        RenderDrivingOverlay.nextStation = nextStation == null ? (nextRoute == null ? null : IGui.formatStationName(nextRoute.name)) : IGui.formatStationName(nextStation.name);
        RenderDrivingOverlay.thisRoute = thisRoute == null ? null : IGui.formatStationName(thisRoute.name);
        RenderDrivingOverlay.lastStation = lastStation == null ? null : IGui.formatStationName(lastStation.name);
    }
}

