/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import mtr.block.BlockLiftButtons;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.Lift;
import mtr.data.RailwayData;
import mtr.item.ItemLiftButtonsLinkModifier;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_824;

public class RenderLiftButtons
extends BlockEntityRendererMapper<BlockLiftButtons.TileEntityLiftButtons>
implements IGui,
IBlock {
    private static final int HOVER_COLOR = -21846;
    private static final class_2960 BUTTON_TEXTURE = new class_2960("mtr:textures/block/lift_button.png");

    public RenderLiftButtons(class_824 dispatcher) {
        super(dispatcher);
    }

    public void render(BlockLiftButtons.TileEntityLiftButtons entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_4588 vertexConsumer;
        boolean lookingAtBottomHalf;
        boolean lookingAtTopHalf;
        class_1937 world = entity.method_10997();
        if (world == null) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_2338 pos = entity.method_11016();
        if (RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, null)) {
            return;
        }
        class_2680 state = world.method_8320(pos);
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe(state, class_2383.field_11177);
        boolean holdingLinker = Utilities.isHolding((class_1657)player, item -> item instanceof ItemLiftButtonsLinkModifier || class_2248.method_9503((class_1792)item) instanceof BlockLiftButtons);
        matrices.method_22903();
        matrices.method_22904(0.5, 0.0, 0.5);
        boolean[] buttonStates = new boolean[]{false, false, false, false};
        HashMap liftDisplays = new HashMap();
        ArrayList<class_2338> liftPositions = new ArrayList<class_2338>();
        entity.forEachTrackPosition(world, (trackPosition, trackFloorTileEntity) -> {
            RenderLiftButtons.renderLiftObjectLink(matrices, vertexConsumers, world, pos, trackPosition, facing, holdingLinker);
            ClientData.LIFTS.forEach(lift -> {
                if (lift.hasFloor((class_2338)trackPosition)) {
                    lift.hasUpDownButtonForFloor(trackPosition.method_10264(), buttonStates);
                    if (lift.liftInstructions.containsInstruction(trackPosition.method_10264(), true)) {
                        buttonStates[2] = true;
                    }
                    if (lift.liftInstructions.containsInstruction(trackPosition.method_10264(), false)) {
                        buttonStates[3] = true;
                    }
                    class_2338 liftPos = RailwayData.newBlockPos(lift.getPositionX(), 0.0, lift.getPositionZ());
                    liftPositions.add(liftPos);
                    liftDisplays.put(liftPos, new class_3545((Object)ClientData.DATA_CACHE.requestLiftFloorText(lift.getCurrentFloorBlockPos())[0], (Object)lift.getLiftDirection()));
                }
            });
        });
        liftPositions.sort(Comparator.comparingInt(checkPos -> facing.method_10148() * (checkPos.method_10260() - pos.method_10260()) - facing.method_10165() * (checkPos.method_10263() - pos.method_10263())));
        class_239 hitResult = class_310.method_1551().field_1765;
        if (hitResult == null || !((Boolean)IBlock.getStatePropertySafe(state, BlockLiftButtons.UNLOCKED)).booleanValue()) {
            lookingAtTopHalf = false;
            lookingAtBottomHalf = false;
        } else {
            class_243 hitLocation = hitResult.method_17784();
            double hitX = hitLocation.field_1352 - Math.floor(hitLocation.field_1352);
            double hitY = hitLocation.field_1351 - Math.floor(hitLocation.field_1351);
            double hitZ = hitLocation.field_1350 - Math.floor(hitLocation.field_1350);
            boolean inBlock = hitX > 0.0 && hitY > 0.0 && hitZ > 0.0 && RailwayData.newBlockPos(hitLocation).equals((Object)pos);
            lookingAtTopHalf = inBlock && (!buttonStates[1] || hitY > 0.25 && hitY < 0.5);
            lookingAtBottomHalf = inBlock && (!buttonStates[0] || hitY < 0.25);
        }
        UtilitiesClient.rotateYDegrees(matrices, -facing.method_10144());
        matrices.method_22904(0.0, 0.0, 0.43437499995343387);
        if (buttonStates[0]) {
            vertexConsumer = vertexConsumers.getBuffer(buttonStates[2] || lookingAtTopHalf ? MoreRenderLayers.getLight(BUTTON_TEXTURE, true) : MoreRenderLayers.getExterior(BUTTON_TEXTURE));
            IDrawing.drawTexture(matrices, vertexConsumer, -0.09375f, (buttonStates[1] ? 4.5f : 2.5f) / 16.0f, 0.1875f, 0.1875f, 0.0f, 1.0f, 1.0f, 0.0f, facing, buttonStates[2] ? -65536 : (lookingAtTopHalf ? -21846 : -10066330), light);
        }
        if (buttonStates[1]) {
            vertexConsumer = vertexConsumers.getBuffer(buttonStates[3] || lookingAtBottomHalf ? MoreRenderLayers.getLight(BUTTON_TEXTURE, true) : MoreRenderLayers.getExterior(BUTTON_TEXTURE));
            IDrawing.drawTexture(matrices, vertexConsumer, -0.09375f, (buttonStates[0] ? 0.5f : 2.5f) / 16.0f, 0.1875f, 0.1875f, 0.0f, 0.0f, 1.0f, 1.0f, facing, buttonStates[3] ? -65536 : (lookingAtBottomHalf ? -21846 : -10066330), light);
        }
        float maxWidth = Math.min(0.25f, 0.375f / (float)liftPositions.size());
        UtilitiesClient.rotateZDegrees(matrices, 180.0f);
        matrices.method_22904((double)maxWidth * (0.5 - (double)((float)liftPositions.size() / 2.0f)), 0.0, 0.0);
        IDrawing.drawTexture(matrices, vertexConsumers.getBuffer(MoreRenderLayers.getExterior(new class_2960("mtr:textures/block/black.png"))), -maxWidth / 2.0f, -0.9375f, maxWidth * (float)liftPositions.size(), 0.40625f, class_2350.field_11036, light);
        matrices.method_22904(0.0, -0.875, (double)-0.003125f);
        liftPositions.forEach(liftPosition -> {
            class_3545 liftDisplay = (class_3545)liftDisplays.get(liftPosition);
            if (liftDisplay != null) {
                RenderTrains.renderLiftDisplay(matrices, vertexConsumers, pos, (String)liftDisplay.method_15442(), (Lift.LiftDirection)((Object)((Object)liftDisplay.method_15441())), maxWidth, 0.3125f);
            }
            matrices.method_46416(maxWidth, 0.0f, 0.0f);
        });
        matrices.method_22909();
    }

    public static void renderLiftObjectLink(class_4587 matrices, class_4597 vertexConsumers, class_1937 world, class_2338 pos, class_2338 trackPosition, class_2350 facing, boolean holdingLinker) {
        if (holdingLinker) {
            class_2350 trackFacing = (class_2350)IBlock.getStatePropertySafe((class_1922)world, trackPosition, class_2383.field_11177);
            IDrawing.drawLine(matrices, vertexConsumers, (float)(trackPosition.method_10263() - pos.method_10263()) + (float)trackFacing.method_10148() / 2.0f, (float)(trackPosition.method_10264() - pos.method_10264()) + 0.5f, (float)(trackPosition.method_10260() - pos.method_10260()) + (float)trackFacing.method_10165() / 2.0f, (float)facing.method_10148() / 2.0f, 0.25f, (float)facing.method_10165() / 2.0f, 255, 255, 255);
        }
    }
}

