/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import mtr.MTRClient;
import mtr.block.BlockLiftPanelBase;
import mtr.block.BlockLiftTrackFloor;
import mtr.block.IBlock;
import mtr.block.ITripleBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.Lift;
import mtr.item.ItemLiftButtonsLinkModifier;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderLiftButtons;
import mtr.render.RenderTrains;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_824;

public class RenderLiftPanel<T extends BlockLiftPanelBase.TileEntityLiftPanel1Base>
extends BlockEntityRendererMapper<T> {
    private final boolean isOdd;
    private final boolean isFlat;
    private static final class_2960 ARROW_TEXTURE = new class_2960("mtr:textures/block/lift_arrow.png");
    private static final float ARROW_SPEED = 0.04f;
    private static final int SLIDE_TIME = 5;
    private static final int SLIDE_INTERVAL = 50;
    private static final float PANEL_WIDTH = 1.125f;

    public RenderLiftPanel(class_824 dispatcher, boolean isOdd, boolean isFlat) {
        super(dispatcher);
        this.isOdd = isOdd;
        this.isFlat = isFlat;
    }

    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int combinedOverlay) {
        class_1937 world = entity.method_10997();
        if (world == null) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_2338 pos = entity.method_11016();
        if (RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, null)) {
            return;
        }
        class_2680 state = world.method_8320(pos);
        if (!this.isOdd && IBlock.getStatePropertySafe(state, IBlock.SIDE) == IBlock.EnumSide.RIGHT || this.isOdd && !((Boolean)IBlock.getStatePropertySafe(state, ITripleBlock.ODD)).booleanValue()) {
            return;
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (textRenderer == null) {
            return;
        }
        class_2338 trackPosition = ((BlockLiftPanelBase.TileEntityLiftPanel1Base)entity).getTrackPosition(world);
        if (trackPosition == null) {
            return;
        }
        BlockLiftTrackFloor.TileEntityLiftTrackFloor trackFloorTileEntity = (BlockLiftTrackFloor.TileEntityLiftTrackFloor)world.method_8321(trackPosition);
        if (trackFloorTileEntity == null) {
            return;
        }
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe(state, class_2383.field_11177);
        boolean holdingLinker = Utilities.isHolding((class_1657)player, item -> item instanceof ItemLiftButtonsLinkModifier || class_2248.method_9503((class_1792)item) instanceof BlockLiftPanelBase);
        matrices.method_22903();
        matrices.method_22904(0.5, 0.0, 0.5);
        RenderLiftButtons.renderLiftObjectLink(matrices, vertexConsumers, world, pos, trackPosition, facing, holdingLinker);
        Lift lift = null;
        for (Lift lift2 : ClientData.LIFTS) {
            if (!lift2.hasFloor(trackPosition)) continue;
            lift = lift2;
            break;
        }
        if (lift != null) {
            String[] text = ClientData.DATA_CACHE.requestLiftFloorText(lift.getCurrentFloorBlockPos());
            UtilitiesClient.rotateYDegrees(matrices, -facing.method_10144());
            UtilitiesClient.rotateZDegrees(matrices, 180.0f);
            matrices.method_22904(this.isOdd ? 0.0 : 0.5, 0.0, 0.0);
            matrices.method_22903();
            matrices.method_46416(0.0f, 0.0f, (this.isFlat ? 0.4375f : 0.25f) - 0.00625f);
            class_4597.class_4598 class_45982 = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            IDrawing.drawStringWithFont(matrices, textRenderer, class_45982, ClientData.DATA_CACHE.requestLiftFloorText(trackPosition)[0], IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0.0f, -0.47f, 0.1875f, 0.1875f, 1.0f, -16777216, false, 0xF000F0, null);
            class_45982.method_22993();
            matrices.method_22909();
            this.renderLiftDisplay(matrices, vertexConsumers, this.isFlat ? 0.4375f : 0.25f, text[0], text[1], lift.getLiftDirection());
        }
        matrices.method_22909();
    }

    private void renderLiftDisplay(class_4587 matrices, class_4597 vertexConsumers, float zOffset, String floorNumber, String floorDisplay, Lift.LiftDirection liftDirection) {
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, zOffset - 0.00625f);
        boolean noFloorNumber = floorNumber.isEmpty();
        boolean noFloorDisplay = floorDisplay.isEmpty();
        int lineCount = (noFloorNumber ? 0 : floorNumber.split("\\|").length) + (noFloorDisplay ? 0 : floorDisplay.split("\\|").length);
        float lineHeight = 1.0f / (float)lineCount;
        float gameTick = MTRClient.getGameTick();
        boolean goingUp = liftDirection == Lift.LiftDirection.UP;
        float arrowSize = 0.1875f;
        float y = -0.3125f;
        if (liftDirection != Lift.LiftDirection.NONE) {
            float uv = gameTick * 0.04f % 1.0f;
            int color = goingUp ? -16711936 : -65536;
            IDrawing.drawTexture(matrices, vertexConsumers.getBuffer(MoreRenderLayers.getLight(ARROW_TEXTURE, false)), -0.75f, -0.3125f, 0.1875f, 0.1875f, 0.0f, (float)(!goingUp ? 1 : 0) + uv, 1.0f, (float)(goingUp ? 1 : 0) + uv, class_2350.field_11036, color, 0xF000F0);
            IDrawing.drawTexture(matrices, vertexConsumers.getBuffer(MoreRenderLayers.getLight(ARROW_TEXTURE, false)), 0.5625f, -0.3125f, 0.1875f, 0.1875f, 0.0f, (float)(!goingUp ? 1 : 0) + uv, 1.0f, (float)(goingUp ? 1 : 0) + uv, class_2350.field_11036, color, 0xF000F0);
        }
        if (!noFloorNumber || !noFloorDisplay) {
            float uvOffset = 0.0f;
            if (lineCount > 1) {
                uvOffset = (float)Math.floor(gameTick % (float)(50 * lineCount) / 50.0f) * lineHeight;
                if (gameTick % 50.0f > 45.0f) {
                    uvOffset += lineHeight * (gameTick % 50.0f - 50.0f + 5.0f) / 5.0f;
                }
            }
            float uv = (float)(goingUp ? -1 : 1) * uvOffset;
            String text = String.format("%s%s%s", floorNumber, noFloorNumber || noFloorDisplay ? "" : "|", floorDisplay);
            IDrawing.drawTexture(matrices, vertexConsumers.getBuffer(MoreRenderLayers.getLight(ClientData.DATA_CACHE.getLiftPanelDisplay((String)text, (int)0xFFAA00).resourceLocation, false)), -0.5625f, -0.3125f, 1.125f, 0.1875f, 0.0f, uv, 1.0f, lineHeight + uv, class_2350.field_11036, -1, 0xF000F0);
        }
        matrices.method_22909();
    }
}

