/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mtr.MTRClient;
import mtr.block.BlockArrivalProjectorBase;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.data.IGui;
import mtr.data.IPIDS;
import mtr.data.IPIDSRenderChild;
import mtr.data.PIDSType;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.ScheduleEntry;
import mtr.data.Station;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.render.MatrixStackHolder;
import mtr.render.RenderTrains;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2756;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_824;

public class RenderPIDS<T extends BlockEntityMapper>
extends BlockEntityRendererMapper<T>
implements IGui {
    private final float scale;
    private final float totalScaledWidth;
    private final float destinationStart;
    private final float destinationMaxWidth;
    private final float platformMaxWidth;
    private final float arrivalMaxWidth;
    private final float callingAtMaxWidth;
    private final float callingAtStationMaxWidth;
    private final int maxArrivals;
    private final int linesPerArrival;
    private final float maxHeight;
    private final float startX;
    private final float startY;
    private final float startZ;
    private final boolean rotate90;
    private final boolean renderArrivalNumber;
    private final PIDSType renderType;
    private final int textColor;
    private final int firstTrainColor;
    private final boolean appendDotAfterMin;
    public static final int MAX_VIEW_DISTANCE = 16;
    private static final int SWITCH_LANGUAGE_TICKS = 60;
    private static final int CAR_TEXT_COLOR = 0xFF0000;
    private static final int STATIONS_PER_PAGE = 10;
    private static final int SWITCH_PAGE_TICKS = 120;

    public RenderPIDS(class_824 dispatcher, int maxArrivals, int linesPerArrival, float startX, float startY, float startZ, float maxHeight, int maxWidth, boolean rotate90, boolean renderArrivalNumber, PIDSType renderType, int textColor, int firstTrainColor, float textPadding, boolean appendDotAfterMin) {
        super(dispatcher);
        this.scale = (float)(160 * (maxArrivals * linesPerArrival)) / maxHeight * textPadding;
        this.totalScaledWidth = this.scale * (float)maxWidth / 16.0f;
        this.destinationStart = renderArrivalNumber ? this.scale * 2.0f / 16.0f : 0.0f;
        switch (renderType) {
            case PIDS_VERTICAL: {
                this.destinationMaxWidth = this.totalScaledWidth;
                this.platformMaxWidth = 0.0f;
                this.arrivalMaxWidth = this.totalScaledWidth * 8.0f / 16.0f;
                break;
            }
            case PIDS_SINGLE_ARRIVAL: {
                this.destinationMaxWidth = this.totalScaledWidth;
                this.platformMaxWidth = this.totalScaledWidth * 8.0f / 16.0f;
                this.arrivalMaxWidth = this.totalScaledWidth * 7.0f / 16.0f;
                break;
            }
            default: {
                this.destinationMaxWidth = this.totalScaledWidth * 0.7f;
                this.platformMaxWidth = renderType.showPlatformNumber ? this.scale * 2.0f / 16.0f : 0.0f;
                this.arrivalMaxWidth = this.totalScaledWidth - this.destinationStart - this.destinationMaxWidth - this.platformMaxWidth;
            }
        }
        this.callingAtMaxWidth = this.totalScaledWidth;
        this.callingAtStationMaxWidth = this.totalScaledWidth;
        this.maxArrivals = maxArrivals;
        this.linesPerArrival = linesPerArrival;
        this.maxHeight = maxHeight;
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.rotate90 = rotate90;
        this.renderArrivalNumber = renderArrivalNumber;
        this.renderType = renderType;
        this.textColor = textColor;
        this.firstTrainColor = firstTrainColor;
        this.appendDotAfterMin = appendDotAfterMin;
    }

    public RenderPIDS(class_824 dispatcher, int maxArrivals, int linesPerArrival, float startX, float startY, float startZ, float maxHeight, int maxWidth, boolean rotate90, boolean renderArrivalNumber, PIDSType renderType, int textColor, int firstTrainColor) {
        this(dispatcher, maxArrivals, linesPerArrival, startX, startY, startZ, maxHeight, maxWidth, rotate90, renderArrivalNumber, renderType, textColor, firstTrainColor, 1.0f, false);
    }

    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        int i;
        class_1937 world = entity.method_10997();
        if (world == null) {
            return;
        }
        class_2338 pos = entity.method_11016();
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe((class_1922)world, pos, class_2383.field_11177);
        if (RenderTrains.shouldNotRender(pos, Math.min(16, RenderTrains.maxTrainRenderDistance), this.rotate90 ? null : facing)) {
            return;
        }
        if (IBlock.getStatePropertySafe(entity.method_11010(), IBlock.HALF) == class_2756.field_12607) {
            return;
        }
        String[] customMessages = new String[this.maxArrivals * this.linesPerArrival];
        boolean[] hideArrival = new boolean[this.maxArrivals];
        for (i = 0; i < this.maxArrivals * this.linesPerArrival; ++i) {
            customMessages[i] = entity instanceof IPIDS.TileEntityPIDS ? ((IPIDS.TileEntityPIDS)entity).getMessage(i) : "";
        }
        for (i = 0; i < this.maxArrivals; ++i) {
            if (!(entity instanceof IPIDS.TileEntityPIDS)) continue;
            hideArrival[i] = ((IPIDS.TileEntityPIDS)entity).getHideArrival(i);
        }
        MatrixStackHolder matrixStackHolder = new MatrixStackHolder(matrices);
        try {
            float carLengthMaxWidth;
            boolean showCarLength;
            boolean renderSingle;
            HashMap<Long, String> platformIdToName = new HashMap<Long, String>();
            List<ScheduleEntry> scheduleList = this.getSchedules(entity, pos, platformIdToName);
            boolean renderClassic = this.renderType == PIDSType.PIDS || this.renderType == PIDSType.ARRIVAL_PROJECTOR;
            boolean renderVertical = this.renderType == PIDSType.PIDS_VERTICAL;
            boolean bl = renderSingle = this.renderType == PIDSType.PIDS_SINGLE_ARRIVAL;
            if (this.renderType.showCarCount) {
                int maxCars = 0;
                int minCars = Integer.MAX_VALUE;
                for (ScheduleEntry scheduleEntry : scheduleList) {
                    int trainCars = scheduleEntry.trainCars;
                    if (trainCars > maxCars) {
                        maxCars = trainCars;
                    }
                    if (trainCars >= minCars) continue;
                    minCars = trainCars;
                }
                showCarLength = minCars != maxCars || renderSingle;
                carLengthMaxWidth = showCarLength ? this.scale * 6.0f / 16.0f : 0.0f;
            } else {
                showCarLength = false;
                carLengthMaxWidth = 0.0f;
            }
            int displayPageOffset = entity instanceof IPIDSRenderChild ? ((IPIDSRenderChild)entity).getDisplayPage() * this.maxArrivals : 0;
            for (int j = 0; j < this.maxArrivals; ++j) {
                boolean isCJK;
                Route route;
                int languageTicks = (int)Math.floor(MTRClient.getGameTick()) / 60;
                ScheduleEntry currentSchedule = j + displayPageOffset < scheduleList.size() ? scheduleList.get(j + displayPageOffset) : null;
                Route route2 = route = currentSchedule == null ? null : (Route)ClientData.DATA_CACHE.routeIdMap.get(currentSchedule.routeId);
                if (j < scheduleList.size() && !hideArrival[j] && route != null) {
                    Object checkString;
                    String[] destinationSplit = ClientData.DATA_CACHE.getFormattedRouteDestination(route, currentSchedule.currentStationIndex, "").split("\\|");
                    boolean isLightRailRoute = route.isLightRailRoute;
                    String[] routeNumberSplit = route.lightRailRouteNumber.split("\\|");
                    if (customMessages[j * this.linesPerArrival].isEmpty()) {
                        checkString = (String)(isLightRailRoute ? routeNumberSplit[languageTicks % routeNumberSplit.length] + " " : "") + IGui.textOrUntitled(destinationSplit[languageTicks % destinationSplit.length]);
                    } else {
                        String[] customMessageSplit = customMessages[j * this.linesPerArrival].split("\\|");
                        int destinationMaxIndex = Math.max(routeNumberSplit.length, destinationSplit.length);
                        int indexToUse = languageTicks % (destinationMaxIndex + customMessageSplit.length);
                        checkString = indexToUse < destinationMaxIndex ? (String)(isLightRailRoute ? routeNumberSplit[languageTicks % routeNumberSplit.length] + " " : "") + IGui.textOrUntitled(destinationSplit[languageTicks % destinationSplit.length]) : customMessageSplit[indexToUse - destinationMaxIndex];
                    }
                    isCJK = IGui.isCjk((String)checkString);
                } else {
                    isCJK = false;
                }
                for (int k = 0; k < this.linesPerArrival; ++k) {
                    boolean useCustomMessage;
                    Object destinationString;
                    int callingAtPage;
                    int i2 = j * this.linesPerArrival + k;
                    int arrivalLine = i2 % this.linesPerArrival;
                    int arrivalNum = (int)Math.floor((float)i2 / (float)this.linesPerArrival);
                    List<Route.RoutePlatform> stations = route == null ? null : route.platformIds.subList(currentSchedule.currentStationIndex + 1, route.platformIds.size());
                    int callingAtMaxPages = stations == null || !renderSingle ? 1 : (int)Math.max(Math.ceil((float)stations.size() / 10.0f), 1.0);
                    int n = callingAtPage = callingAtMaxPages == 1 ? 0 : (int)Math.floor(MTRClient.getGameTick() / 120.0f) % callingAtMaxPages;
                    if (arrivalNum < scheduleList.size() && !hideArrival[arrivalNum] && route != null) {
                        destinationSplit = ClientData.DATA_CACHE.getFormattedRouteDestination(route, currentSchedule.currentStationIndex, "").split("\\|");
                        boolean isLightRailRoute = route.isLightRailRoute;
                        String[] routeNumberSplit = route.lightRailRouteNumber.split("\\|");
                        if (customMessages[i2].isEmpty()) {
                            destinationString = arrivalLine == 0 && !renderSingle || arrivalLine == 1 && renderSingle ? (String)(isLightRailRoute ? routeNumberSplit[languageTicks % routeNumberSplit.length] + " " : "") + IGui.textOrUntitled(destinationSplit[languageTicks % destinationSplit.length]) : "";
                            useCustomMessage = false;
                        } else {
                            String[] customMessageSplit = customMessages[i2].split("\\|");
                            int destinationMaxIndex = Math.max(routeNumberSplit.length, destinationSplit.length);
                            int indexToUse = languageTicks % (destinationMaxIndex + customMessageSplit.length);
                            if (indexToUse < destinationMaxIndex) {
                                destinationString = arrivalLine == 0 && !renderSingle || arrivalLine == 1 && renderSingle ? (String)(isLightRailRoute ? routeNumberSplit[languageTicks % routeNumberSplit.length] + " " : "") + IGui.textOrUntitled(destinationSplit[languageTicks % destinationSplit.length]) : "";
                                useCustomMessage = false;
                            } else {
                                destinationString = customMessageSplit[indexToUse - destinationMaxIndex];
                                useCustomMessage = true;
                            }
                        }
                    } else {
                        destinationSplit = customMessages[i2].split("\\|");
                        destinationString = destinationSplit[languageTicks % destinationSplit.length];
                        useCustomMessage = true;
                    }
                    matrixStackHolder.push();
                    matrices.method_22904(0.5, 0.0, 0.5);
                    UtilitiesClient.rotateYDegrees(matrices, (float)(this.rotate90 ? 90 : 0) - facing.method_10144());
                    UtilitiesClient.rotateZDegrees(matrices, 180.0f);
                    matrices.method_46416((this.startX - 8.0f) / 16.0f, -this.startY / 16.0f + (float)i2 / (float)this.linesPerArrival * this.maxHeight / (float)this.maxArrivals / 16.0f, (this.startZ - 8.0f) / 16.0f - 0.00625f);
                    matrices.method_22905(1.0f / this.scale, 1.0f / this.scale, 1.0f / this.scale);
                    class_327 textRenderer = class_310.method_1551().field_1772;
                    if (useCustomMessage) {
                        int destinationWidth = textRenderer.method_1727((String)destinationString);
                        if ((float)destinationWidth > this.totalScaledWidth) {
                            matrices.method_22905(this.totalScaledWidth / (float)destinationWidth, 1.0f, 1.0f);
                        }
                        textRenderer.method_1729(matrices, (String)destinationString, 0.0f, 0.0f, this.textColor);
                    } else {
                        String callingAtStationText;
                        int seconds = (int)((currentSchedule.arrivalMillis - System.currentTimeMillis()) / 1000L);
                        class_5250 arrivalText = seconds >= 60 ? (arrivalLine == 1 && renderVertical || arrivalLine == 0 && renderSingle || renderClassic ? Text.translatable(isCJK ? "gui.mtr.arrival_min_cjk" : "gui.mtr.arrival_min", seconds / 60).method_27693(this.appendDotAfterMin && !isCJK ? "." : "") : Text.literal("")) : (arrivalLine == 1 && renderVertical || arrivalLine == 0 && renderSingle || renderClassic ? (seconds > 0 ? Text.translatable(isCJK ? "gui.mtr.arrival_sec_cjk" : "gui.mtr.arrival_sec", seconds).method_27693(this.appendDotAfterMin && !isCJK ? "." : "") : null) : Text.literal(""));
                        class_5250 carText = arrivalLine == 1 && renderVertical || arrivalLine == 15 && renderSingle || renderClassic ? Text.translatable(isCJK ? "gui.mtr.arrival_car_cjk" : "gui.mtr.arrival_car", currentSchedule.trainCars) : Text.literal("");
                        class_5250 callingAtText = renderSingle && arrivalLine == 3 ? (stations.size() > 0 ? Text.translatable(isCJK ? "gui.mtr.calling_at_cjk" : "gui.mtr.calling_at", callingAtPage + 1, callingAtMaxPages) : Text.translatable(isCJK ? "gui.mtr.terminates_here_cjk" : "gui.mtr.terminates_here_1", new Object[0])) : Text.literal("");
                        int callingAtStationNumber = arrivalLine - 4 + callingAtPage * 10;
                        if (renderSingle && arrivalLine >= 4 && arrivalLine < 14 && callingAtStationNumber < stations.size()) {
                            String[] stringArray;
                            Station station = (Station)ClientData.DATA_CACHE.platformIdToStation.get(stations.get((int)callingAtStationNumber).platformId);
                            if (station == null) {
                                String[] stringArray2 = new String[1];
                                stringArray = stringArray2;
                                stringArray2[0] = "";
                            } else {
                                stringArray = station.name.split("\\|");
                            }
                            String[] callingAtStationTextSplit = stringArray;
                            int indexToUse = languageTicks % callingAtStationTextSplit.length;
                            callingAtStationText = callingAtStationTextSplit[indexToUse];
                        } else {
                            callingAtStationText = renderSingle && stations.size() == 0 && !isCJK && arrivalLine == 4 ? Text.translatable("gui.mtr.terminates_here_2", new Object[0]).getString() : (renderSingle && stations.size() == 0 && !isCJK && arrivalLine == 5 ? Text.translatable("gui.mtr.terminates_here_3", new Object[0]).getString() : "");
                        }
                        if (this.renderArrivalNumber) {
                            textRenderer.method_1729(matrices, String.valueOf(i2 + 1), 0.0f, 0.0f, seconds > 0 ? this.textColor : this.firstTrainColor);
                        }
                        float newDestinationMaxWidth = this.destinationMaxWidth - (!renderClassic ? 0.0f : carLengthMaxWidth);
                        if (this.renderType.showPlatformNumber && (arrivalLine == 0 && renderSingle || renderClassic)) {
                            matrixStackHolder.push();
                            String platformName = (String)platformIdToName.get(route.platformIds.get((int)currentSchedule.currentStationIndex).platformId);
                            class_5250 platformNameComponent = platformName == null ? Text.literal("") : (renderSingle ? Text.translatable(isCJK ? "gui.mtr.platform_abbreviated_cjk" : "gui.mtr.platform_abbreviated", platformName) : Text.literal(platformName));
                            int platformWidth = textRenderer.method_27525((class_5348)platformNameComponent);
                            if (renderClassic) {
                                matrices.method_46416(this.destinationStart + newDestinationMaxWidth, 0.0f, 0.0f);
                            } else if ((float)platformWidth > this.platformMaxWidth) {
                                matrices.method_46416(this.totalScaledWidth - this.platformMaxWidth, 0.0f, 0.0f);
                                matrices.method_22905(this.platformMaxWidth / (float)platformWidth, 1.0f, 1.0f);
                            } else {
                                matrices.method_46416(this.totalScaledWidth - (float)platformWidth, 0.0f, 0.0f);
                            }
                            textRenderer.method_30883(matrices, (class_2561)platformNameComponent, 0.0f, 0.0f, seconds > 0 ? this.textColor : this.firstTrainColor);
                            matrixStackHolder.pop();
                        }
                        if (renderSingle && arrivalLine == 3) {
                            matrixStackHolder.push();
                            int callingAtWidth = textRenderer.method_27525((class_5348)callingAtText);
                            if (stations.size() != 0) {
                                matrices.method_46416(this.destinationStart, 0.0f, 0.0f);
                            }
                            if ((float)callingAtWidth > this.callingAtMaxWidth) {
                                if (stations.size() == 0) {
                                    matrices.method_46416(this.totalScaledWidth / 2.0f - this.callingAtMaxWidth / 2.0f, 0.0f, 0.0f);
                                }
                                matrices.method_22905(this.callingAtMaxWidth / (float)callingAtWidth, 1.0f, 1.0f);
                            } else if (stations.size() == 0) {
                                matrices.method_46416(this.totalScaledWidth / 2.0f - (float)callingAtWidth / 2.0f, 0.0f, 0.0f);
                            }
                            textRenderer.method_30883(matrices, (class_2561)callingAtText, 0.0f, 0.0f, seconds > 0 ? this.textColor : this.firstTrainColor);
                            matrixStackHolder.pop();
                        }
                        if (renderSingle && arrivalLine >= 4 && arrivalLine < 14) {
                            matrixStackHolder.push();
                            int callingAtStationWidth = textRenderer.method_1727(callingAtStationText);
                            if (stations.size() != 0) {
                                matrices.method_46416(this.destinationStart, 0.0f, 0.0f);
                            }
                            if ((float)callingAtStationWidth > this.callingAtStationMaxWidth) {
                                if (stations.size() == 0) {
                                    matrices.method_46416(this.totalScaledWidth / 2.0f - this.callingAtStationMaxWidth / 2.0f, 0.0f, 0.0f);
                                }
                                matrices.method_22905(this.callingAtStationMaxWidth / (float)callingAtStationWidth, 1.0f, 1.0f);
                            } else if (stations.size() == 0) {
                                matrices.method_46416(this.totalScaledWidth / 2.0f - (float)callingAtStationWidth / 2.0f, 0.0f, 0.0f);
                            }
                            textRenderer.method_1729(matrices, callingAtStationText, 0.0f, 0.0f, seconds > 0 ? this.textColor : this.firstTrainColor);
                            matrixStackHolder.pop();
                        }
                        if (showCarLength) {
                            int carTextWidth;
                            matrixStackHolder.push();
                            if (!renderSingle) {
                                matrices.method_46416(renderVertical ? this.destinationStart : this.destinationStart + newDestinationMaxWidth + this.platformMaxWidth, 0.0f, 0.0f);
                            }
                            if ((float)(carTextWidth = textRenderer.method_27525((class_5348)carText)) > carLengthMaxWidth) {
                                if (renderSingle) {
                                    matrices.method_46416(this.totalScaledWidth - carLengthMaxWidth, 0.0f, 0.0f);
                                }
                                matrices.method_22905(carLengthMaxWidth / (float)carTextWidth, 1.0f, 1.0f);
                            } else if (renderSingle) {
                                matrices.method_46416(this.totalScaledWidth - (float)carTextWidth, 0.0f, 0.0f);
                            }
                            textRenderer.method_30883(matrices, (class_2561)carText, 0.0f, 0.0f, 0xFF0000);
                            matrixStackHolder.pop();
                        }
                        matrixStackHolder.push();
                        matrices.method_46416(this.destinationStart, 0.0f, 0.0f);
                        int destinationWidth = textRenderer.method_1727((String)destinationString);
                        if ((float)destinationWidth > newDestinationMaxWidth) {
                            matrices.method_22905(newDestinationMaxWidth / (float)destinationWidth, 1.0f, 1.0f);
                        }
                        textRenderer.method_1729(matrices, (String)destinationString, 0.0f, 0.0f, seconds > 0 ? this.textColor : this.firstTrainColor);
                        matrixStackHolder.pop();
                        if (arrivalText != null) {
                            matrixStackHolder.push();
                            int arrivalWidth = textRenderer.method_27525((class_5348)arrivalText);
                            if (renderSingle) {
                                matrices.method_46416(this.destinationStart, 0.0f, 0.0f);
                            }
                            if ((float)arrivalWidth > this.arrivalMaxWidth) {
                                if (!renderSingle) {
                                    matrices.method_46416(this.totalScaledWidth - this.arrivalMaxWidth, 0.0f, 0.0f);
                                }
                                matrices.method_22905(this.arrivalMaxWidth / (float)arrivalWidth, 1.0f, 1.0f);
                            } else if (!renderSingle) {
                                matrices.method_46416(this.totalScaledWidth - (float)arrivalWidth, 0.0f, 0.0f);
                            }
                            textRenderer.method_30883(matrices, (class_2561)arrivalText, 0.0f, 0.0f, this.textColor);
                            matrixStackHolder.pop();
                        }
                    }
                    matrixStackHolder.pop();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrixStackHolder.popAll();
    }

    public List<ScheduleEntry> getSchedules(T entity, class_2338 pos, Map<Long, String> platformIdToName) {
        Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
        if (station == null) {
            return new ArrayList<ScheduleEntry>();
        }
        Map<Long, Platform> platforms = ClientData.DATA_CACHE.requestStationIdToPlatforms(station.id);
        if (platforms.isEmpty()) {
            return new ArrayList<ScheduleEntry>();
        }
        Set<Object> platformIds = switch (this.renderType) {
            case PIDSType.ARRIVAL_PROJECTOR -> {
                if (entity instanceof BlockArrivalProjectorBase.TileEntityArrivalProjectorBase) {
                    yield ((BlockArrivalProjectorBase.TileEntityArrivalProjectorBase)entity).getPlatformIds();
                }
                yield new HashSet();
            }
            case PIDSType.PIDS_SINGLE_ARRIVAL -> {
                if (entity instanceof IPIDS.TileEntityPIDS) {
                    yield ((IPIDS.TileEntityPIDS)entity).getPlatformIds();
                }
                yield new HashSet();
            }
            case PIDSType.PIDS_VERTICAL, PIDSType.PIDS -> {
                Set<Long> tempPlatformIds = entity instanceof IPIDS.TileEntityPIDS ? ((IPIDS.TileEntityPIDS)entity).getPlatformIds() : new HashSet<Long>();
                yield tempPlatformIds.isEmpty() ? Collections.singleton(entity instanceof IPIDS.TileEntityPIDS ? ((IPIDS.TileEntityPIDS)entity).getPlatformId(ClientData.PLATFORMS, ClientData.DATA_CACHE) : 0L) : tempPlatformIds;
            }
            default -> new HashSet();
        };
        HashSet schedules = new HashSet();
        platforms.values().forEach(platform -> {
            Set<ScheduleEntry> scheduleForPlatform;
            if ((platformIds.isEmpty() || platformIds.contains(platform.id)) && (scheduleForPlatform = ClientData.SCHEDULES_FOR_PLATFORM.get(platform.id)) != null) {
                scheduleForPlatform.forEach(scheduleEntry -> {
                    Route route = (Route)ClientData.DATA_CACHE.routeIdMap.get(scheduleEntry.routeId);
                    if (route != null && (this.renderType.showTerminatingPlatforms || scheduleEntry.currentStationIndex < route.platformIds.size() - 1)) {
                        schedules.add(scheduleEntry);
                        platformIdToName.put(platform.id, platform.name);
                    }
                });
            }
        });
        ArrayList<ScheduleEntry> scheduleList = new ArrayList<ScheduleEntry>(schedules);
        Collections.sort(scheduleList);
        return scheduleList;
    }
}

