/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import mtr.MTRClient;
import mtr.block.BlockAPGGlass;
import mtr.block.BlockAPGGlassEnd;
import mtr.block.BlockPSDAPGDoorBase;
import mtr.block.IBlock;
import mtr.block.ITripleBlock;
import mtr.data.IGui;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.ModelDataWrapper;
import mtr.mappings.ModelMapper;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import mtr.render.StoredMatrixTransformations;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2756;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_824;

public class RenderPSDAPGDoor<T extends BlockPSDAPGDoorBase.TileEntityPSDAPGDoorBase>
extends BlockEntityRendererMapper<T>
implements IGui,
IBlock {
    private final int type;
    private static final ModelSingleCube MODEL_PSD = new ModelSingleCube(36, 18, 0, 0, 0, 16, 16, 2);
    private static final ModelSingleCube MODEL_PSD_END_LEFT_1 = new ModelSingleCube(20, 18, 0, 0, 0, 8, 16, 2);
    private static final ModelSingleCube MODEL_PSD_END_RIGHT_1 = new ModelSingleCube(20, 18, 8, 0, 0, 8, 16, 2);
    private static final ModelSingleCube MODEL_PSD_END_LEFT_2 = new ModelSingleCube(20, 18, 8, 0, 2, 8, 16, 2);
    private static final ModelSingleCube MODEL_PSD_END_RIGHT_2 = new ModelSingleCube(20, 18, 0, 0, 2, 8, 16, 2);
    private static final ModelSingleCube MODEL_PSD_LIGHT_LEFT = new ModelSingleCube(16, 16, 0, -1, 5, 1, 1, 1);
    private static final ModelSingleCube MODEL_PSD_LIGHT_RIGHT = new ModelSingleCube(16, 16, 15, -1, 5, 1, 1, 1);
    private static final ModelSingleCube MODEL_APG_TOP = new ModelSingleCube(34, 9, 0, 8, 1, 16, 8, 1);
    private static final ModelAPGDoorBottom MODEL_APG_BOTTOM = new ModelAPGDoorBottom();
    private static final ModelAPGDoorLight MODEL_APG_LIGHT = new ModelAPGDoorLight();
    private static final ModelSingleCube MODEL_APG_DOOR_LOCKED = new ModelSingleCube(6, 6, 5, 10, 1, 6, 6, 0);
    private static final ModelSingleCube MODEL_PSD_DOOR_LOCKED = new ModelSingleCube(6, 6, 5, 6, 1, 6, 6, 0);
    private static final ModelSingleCube MODEL_LIFT_LEFT = new ModelSingleCube(28, 18, 0, 0, 0, 12, 16, 2);
    private static final ModelSingleCube MODEL_LIFT_RIGHT = new ModelSingleCube(28, 18, 4, 0, 0, 12, 16, 2);

    public RenderPSDAPGDoor(class_824 dispatcher, int type) {
        super(dispatcher);
        this.type = type;
    }

    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 world = entity.method_10997();
        if (world == null) {
            return;
        }
        class_2338 pos = entity.method_11016();
        if (((Boolean)IBlock.getStatePropertySafe((class_1922)world, pos, BlockPSDAPGDoorBase.TEMP)).booleanValue()) {
            return;
        }
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe((class_1922)world, pos, BlockPSDAPGDoorBase.field_11177);
        boolean side = IBlock.getStatePropertySafe((class_1922)world, pos, BlockPSDAPGDoorBase.SIDE) == IBlock.EnumSide.RIGHT;
        boolean half = IBlock.getStatePropertySafe((class_1922)world, pos, BlockPSDAPGDoorBase.HALF) == class_2756.field_12609;
        boolean end = (Boolean)IBlock.getStatePropertySafe((class_1922)world, pos, BlockPSDAPGDoorBase.END);
        boolean unlocked = (Boolean)IBlock.getStatePropertySafe((class_1922)world, pos, BlockPSDAPGDoorBase.UNLOCKED);
        float open = Math.min(((BlockPSDAPGDoorBase.TileEntityPSDAPGDoorBase)entity).getOpen(MTRClient.getLastFrameDuration()), this.type >= 3 ? 0.75f : 1.0f);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations();
        storedMatrixTransformations.add(matricesNew -> {
            matricesNew.method_22904(0.5 + (double)entity.method_11016().method_10263(), (double)entity.method_11016().method_10264(), 0.5 + (double)entity.method_11016().method_10260());
            UtilitiesClient.rotateYDegrees(matricesNew, -facing.method_10144());
            UtilitiesClient.rotateXDegrees(matricesNew, 180.0f);
        });
        StoredMatrixTransformations storedMatrixTransformationsLight = storedMatrixTransformations.copy();
        switch (this.type) {
            case 0: 
            case 1: {
                if (half) {
                    RenderTrains.scheduleRender(new class_2960(String.format("mtr:textures/block/light_%s.png", open > 0.0f ? "on" : "off")), false, open > 0.0f ? RenderTrains.QueuedRenderLayer.LIGHT : RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                        storedMatrixTransformationsLight.transform((class_4587)matricesNew);
                        (side ? MODEL_PSD_LIGHT_RIGHT : MODEL_PSD_LIGHT_LEFT).method_2828((class_4587)matricesNew, (class_4588)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                        matricesNew.method_22909();
                    });
                }
                if (!end) break;
                RenderTrains.scheduleRender(new class_2960(String.format("mtr:textures/block/psd_door_end_%s_%s_2_%s.png", half ? "top" : "bottom", side ? "right" : "left", this.type == 1 ? "2" : "1")), false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformationsLight.transform((class_4587)matricesNew);
                    matricesNew.method_46416(open / 2.0f * (float)(side ? -1 : 1), 0.0f, 0.0f);
                    (side ? MODEL_PSD_END_RIGHT_2 : MODEL_PSD_END_LEFT_2).method_2828((class_4587)matricesNew, (class_4588)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    matricesNew.method_22909();
                });
                break;
            }
            case 2: {
                class_2248 block;
                if (!half || !((block = world.method_8320(pos.method_10093(side ? facing.method_10170() : facing.method_10160())).method_26204()) instanceof BlockAPGGlass) && !(block instanceof BlockAPGGlassEnd)) break;
                RenderTrains.scheduleRender(new class_2960(String.format("mtr:textures/block/apg_door_light_%s.png", open > 0.0f ? "on" : "off")), false, open > 0.0f ? RenderTrains.QueuedRenderLayer.LIGHT_TRANSLUCENT : RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformationsLight.transform((class_4587)matricesNew);
                    matricesNew.method_22904(side ? -0.515625 : 0.515625, 0.0, 0.0);
                    matricesNew.method_22905(0.5f, 1.0f, 1.0f);
                    MODEL_APG_LIGHT.method_2828((class_4587)matricesNew, (class_4588)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    matricesNew.method_22909();
                });
            }
        }
        storedMatrixTransformations.add(matricesNew -> matricesNew.method_46416(open * (float)(side ? -1 : 1), 0.0f, 0.0f));
        switch (this.type) {
            case 0: 
            case 1: {
                if (end) {
                    RenderTrains.scheduleRender(new class_2960(String.format("mtr:textures/block/psd_door_end_%s_%s_1_%s.png", half ? "top" : "bottom", side ? "right" : "left", this.type == 1 ? "2" : "1")), false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                        storedMatrixTransformations.transform((class_4587)matricesNew);
                        (side ? MODEL_PSD_END_RIGHT_1 : MODEL_PSD_END_LEFT_1).method_2828((class_4587)matricesNew, (class_4588)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                        matricesNew.method_22909();
                    });
                } else {
                    RenderTrains.scheduleRender(new class_2960(String.format("mtr:textures/block/psd_door_%s_%s_%s.png", half ? "top" : "bottom", side ? "right" : "left", this.type == 1 ? "2" : "1")), false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                        storedMatrixTransformations.transform((class_4587)matricesNew);
                        MODEL_PSD.method_2828((class_4587)matricesNew, (class_4588)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                        matricesNew.method_22909();
                    });
                }
                if (!half || unlocked) break;
                RenderTrains.scheduleRender(new class_2960("mtr:textures/block/sign/door_not_in_use.png"), false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformations.transform((class_4587)matricesNew);
                    if (end) {
                        matricesNew.method_22904(side ? 0.25 : -0.25, 0.0, 0.0);
                    }
                    MODEL_PSD_DOOR_LOCKED.method_2828((class_4587)matricesNew, (class_4588)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    matricesNew.method_22909();
                });
                break;
            }
            case 2: {
                RenderTrains.scheduleRender(new class_2960(String.format("mtr:textures/block/apg_door_%s_%s.png", half ? "top" : "bottom", side ? "right" : "left")), false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformations.transform((class_4587)matricesNew);
                    (half ? MODEL_APG_TOP : MODEL_APG_BOTTOM).method_2828(matricesNew, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    matricesNew.method_22909();
                });
                if (!half || unlocked) break;
                RenderTrains.scheduleRender(new class_2960("mtr:textures/block/sign/door_not_in_use.png"), false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformations.transform((class_4587)matricesNew);
                    MODEL_APG_DOOR_LOCKED.method_2828((class_4587)matricesNew, (class_4588)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    matricesNew.method_22909();
                });
                break;
            }
            case 4: {
                if (((Boolean)IBlock.getStatePropertySafe((class_1922)world, pos, ITripleBlock.ODD)).booleanValue()) break;
                storedMatrixTransformations.add(matricesNew -> matricesNew.method_22904(side ? 0.5 : -0.5, 0.0, 0.0));
            }
            case 3: {
                RenderTrains.scheduleRender(new class_2960(String.format("mtr:textures/block/lift_door_%s_%s_1.png", half ? "top" : "bottom", side ? "right" : "left")), false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformations.transform((class_4587)matricesNew);
                    (side ? MODEL_LIFT_RIGHT : MODEL_LIFT_LEFT).method_2828((class_4587)matricesNew, (class_4588)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    matricesNew.method_22909();
                });
                if (!half || unlocked) break;
                RenderTrains.scheduleRender(new class_2960("mtr:textures/block/sign/door_not_in_use.png"), false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformations.transform((class_4587)matricesNew);
                    matricesNew.method_22904(side ? 0.125 : -0.125, 0.0, 0.0);
                    MODEL_PSD_DOOR_LOCKED.method_2828((class_4587)matricesNew, (class_4588)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    matricesNew.method_22909();
                });
            }
        }
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }

    private static class ModelSingleCube
    extends class_583<class_1297> {
        private final ModelMapper cube;

        private ModelSingleCube(int textureWidth, int textureHeight, int x, int y, int z, int length, int height, int depth) {
            ModelDataWrapper modelDataWrapper = new ModelDataWrapper((class_3879)this, textureWidth, textureHeight);
            this.cube = new ModelMapper(modelDataWrapper);
            this.cube.texOffs(0, 0).addBox(x - 8, y - 16, z - 8, length, height, depth, 0.0f, false);
            modelDataWrapper.setModelPart(textureWidth, textureHeight);
            this.cube.setModelPart();
        }

        public void method_2828(class_4587 matrices, class_4588 vertices, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.cube.render(matrices, vertices, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        }

        public void method_2819(class_1297 entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        }
    }

    private static class ModelAPGDoorBottom
    extends class_583<class_1297> {
        private final ModelMapper bone;

        private ModelAPGDoorBottom() {
            int textureWidth = 34;
            int textureHeight = 27;
            ModelDataWrapper modelDataWrapper = new ModelDataWrapper((class_3879)this, 34, 27);
            this.bone = new ModelMapper(modelDataWrapper);
            this.bone.texOffs(0, 0).addBox(-8.0f, -16.0f, -7.0f, 16, 16, 1, 0.0f, false);
            this.bone.texOffs(0, 17).addBox(-8.0f, -6.0f, -8.0f, 16, 6, 1, 0.0f, false);
            ModelMapper cube_r1 = new ModelMapper(modelDataWrapper);
            cube_r1.setPos(0.0f, -6.0f, -8.0f);
            this.bone.addChild(cube_r1);
            cube_r1.setRotationAngle(-0.7854f, 0.0f, 0.0f);
            cube_r1.texOffs(0, 24).addBox(-8.0f, -2.0f, 0.0f, 16, 2, 1, 0.0f, false);
            modelDataWrapper.setModelPart(34, 27);
            this.bone.setModelPart();
        }

        public void method_2828(class_4587 matrices, class_4588 vertices, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.bone.render(matrices, vertices, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        }

        public void method_2819(class_1297 entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        }
    }

    private static class ModelAPGDoorLight
    extends class_583<class_1297> {
        private final ModelMapper bone;

        private ModelAPGDoorLight() {
            int textureWidth = 8;
            int textureHeight = 8;
            ModelDataWrapper modelDataWrapper = new ModelDataWrapper((class_3879)this, 8, 8);
            this.bone = new ModelMapper(modelDataWrapper);
            this.bone.texOffs(0, 4).addBox(-0.5f, -9.0f, -7.0f, 1, 1, 3, 0.05f, false);
            ModelMapper cube_r1 = new ModelMapper(modelDataWrapper);
            cube_r1.setPos(0.0f, -9.05f, -4.95f);
            this.bone.addChild(cube_r1);
            cube_r1.setRotationAngle(0.3927f, 0.0f, 0.0f);
            cube_r1.texOffs(0, 0).addBox(-0.5f, 0.05f, -3.05f, 1, 1, 3, 0.05f, false);
            modelDataWrapper.setModelPart(8, 8);
            this.bone.setModelPart();
        }

        public void method_2828(class_4587 matrices, class_4588 vertices, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.bone.render(matrices, vertices, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        }

        public void method_2819(class_1297 entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        }
    }
}

