/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import mtr.block.BlockPSDTop;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import mtr.render.StoredMatrixTransformations;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public abstract class RenderRouteBase<T extends BlockPSDTop.TileEntityRouteBase>
extends BlockEntityRendererMapper<T>
implements IGui,
IBlock {
    protected final float topPadding;
    protected final float bottomPadding;
    protected final float sidePadding;
    private final float z;
    private final boolean transparentWhite;
    private final class_2769<Integer> arrowDirectionProperty;

    public RenderRouteBase(class_824 dispatcher, float z, float topPadding, float bottomPadding, float sidePadding, boolean transparentWhite, class_2769<Integer> arrowDirectionProperty) {
        super(dispatcher);
        this.z = z / 16.0f;
        this.topPadding = topPadding / 16.0f;
        this.bottomPadding = bottomPadding / 16.0f;
        this.sidePadding = sidePadding / 16.0f;
        this.transparentWhite = transparentWhite;
        this.arrowDirectionProperty = arrowDirectionProperty;
    }

    public final void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        long platformId;
        class_1937 world = entity.method_10997();
        if (world == null) {
            return;
        }
        class_2338 pos = entity.method_11016();
        class_2680 state = world.method_8320(pos);
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe(state, class_2383.field_11177);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations();
        storedMatrixTransformations.add(matricesNew -> {
            matricesNew.method_22904(0.5 + (double)entity.method_11016().method_10263(), (double)entity.method_11016().method_10264(), 0.5 + (double)entity.method_11016().method_10260());
            UtilitiesClient.rotateYDegrees(matricesNew, -facing.method_10144());
        });
        this.renderAdditionalUnmodified(storedMatrixTransformations.copy(), state, facing, light);
        if (!RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, null) && (platformId = ((BlockPSDTop.TileEntityRouteBase)((Object)entity)).getPlatformId(ClientData.PLATFORMS, ClientData.DATA_CACHE)) != 0L) {
            storedMatrixTransformations.add(matricesNew -> {
                matricesNew.method_46416(0.0f, 1.0f, 0.0f);
                UtilitiesClient.rotateZDegrees(matricesNew, 180.0f);
                matricesNew.method_22904(-0.5, (double)(-this.getAdditionalOffset(state)), (double)this.z);
            });
            int leftBlocks = this.getTextureNumber((class_1922)world, pos, facing, true);
            int rightBlocks = this.getTextureNumber((class_1922)world, pos, facing, false);
            int color = RenderRouteBase.getShadingColor(facing, -1);
            RenderType renderType = this.getRenderType((class_1922)world, pos.method_10079(facing.method_10160(), leftBlocks), state);
            if ((renderType == RenderType.ARROW || renderType == RenderType.ROUTE) && IBlock.getStatePropertySafe(state, SIDE_EXTENDED) != IBlock.EnumSide.SINGLE) {
                float width = (float)(leftBlocks + rightBlocks + 1) - this.sidePadding * 2.0f;
                float height = 1.0f - this.topPadding - this.bottomPadding;
                int arrowDirection = IBlock.getStatePropertySafe(state, this.arrowDirectionProperty);
                class_2960 resourceLocation = renderType == RenderType.ARROW ? ClientData.DATA_CACHE.getDirectionArrow((long)platformId, (boolean)((arrowDirection & 1) > 0 ? true : false), (boolean)((arrowDirection & 2) > 0 ? true : false), (IGui.HorizontalAlignment)IGui.HorizontalAlignment.CENTER, (boolean)true, (float)0.25f, (float)(width / height), (int)-1, (int)-16777216, (int)(this.transparentWhite ? -1 : 0)).resourceLocation : ClientData.DATA_CACHE.getRouteMap((long)platformId, (boolean)false, (boolean)(arrowDirection == 2 ? true : false), (float)(width / height), (boolean)this.transparentWhite).resourceLocation;
                RenderTrains.scheduleRender(resourceLocation, false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformations.transform((class_4587)matricesNew);
                    IDrawing.drawTexture(matricesNew, vertexConsumer, leftBlocks == 0 ? this.sidePadding : 0.0f, this.topPadding, 0.0f, 1.0f - (rightBlocks == 0 ? this.sidePadding : 0.0f), 1.0f - this.bottomPadding, 0.0f, ((float)leftBlocks - (leftBlocks == 0 ? 0.0f : this.sidePadding)) / width, 0.0f, (width - (float)rightBlocks + (rightBlocks == 0 ? 0.0f : this.sidePadding)) / width, 1.0f, facing.method_10153(), color, light);
                    matricesNew.method_22909();
                });
            }
            this.renderAdditional(storedMatrixTransformations, platformId, state, leftBlocks, rightBlocks, facing.method_10153(), color, light);
        }
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }

    protected void renderAdditionalUnmodified(StoredMatrixTransformations storedMatrixTransformations, class_2680 state, class_2350 facing, int light) {
    }

    protected float getAdditionalOffset(class_2680 state) {
        return 0.0f;
    }

    protected boolean isLeft(class_2680 state) {
        return IBlock.getStatePropertySafe(state, SIDE_EXTENDED) == IBlock.EnumSide.LEFT;
    }

    protected boolean isRight(class_2680 state) {
        return IBlock.getStatePropertySafe(state, SIDE_EXTENDED) == IBlock.EnumSide.RIGHT;
    }

    protected abstract RenderType getRenderType(class_1922 var1, class_2338 var2, class_2680 var3);

    protected abstract void renderAdditional(StoredMatrixTransformations var1, long var2, class_2680 var4, int var5, int var6, class_2350 var7, int var8, int var9);

    private int getTextureNumber(class_1922 world, class_2338 pos, class_2350 facing, boolean searchLeft) {
        class_2680 state;
        int number = 0;
        class_2248 thisBlock = world.method_8320(pos).method_26204();
        while ((state = world.method_8320(pos.method_10079(searchLeft ? facing.method_10160() : facing.method_10170(), number))).method_26204() == thisBlock) {
            boolean isLeft = this.isLeft(state);
            boolean isRight = this.isRight(state);
            if (number != 0 && !(searchLeft ? !isRight : !isLeft)) break;
            ++number;
            if (!(searchLeft ? isLeft : isRight)) continue;
            break;
        }
        return number - 1;
    }

    public static int getShadingColor(class_2350 facing, int grayscaleColorByte) {
        int colorByte = Math.round((float)(grayscaleColorByte & 0xFF) * (facing.method_10166() == class_2350.class_2351.field_11048 ? 0.75f : 1.0f));
        return 0xFF000000 | (colorByte << 16) + (colorByte << 8) + colorByte;
    }

    protected static enum RenderType {
        ARROW,
        ROUTE,
        NONE;

    }
}

