/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import java.util.Map;
import mtr.block.BlockRouteSignBase;
import mtr.block.BlockStationNameBase;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.UtilitiesClient;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public class RenderRouteSign<T extends BlockRouteSignBase.TileEntityRouteSignBase>
extends BlockEntityRendererMapper<T>
implements IBlock,
IGui {
    private static final float SIDE = 0.15625f;
    private static final float BOTTOM = 0.65625f;
    private static final float MIDDLE = 0.8125f;
    private static final float TOP = 0.96875f;
    private static final float WIDTH = 0.6875f;
    private static final float HEIGHT_BOTTOM = 1.15625f;
    private static final float HEIGHT_TOP = 0.15625f;
    private static final float TEXTURE_BREAK = 0.7027027f;

    public RenderRouteSign(class_824 dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_2680 state;
        class_2350 facing;
        class_1937 world = entity.method_10997();
        if (world == null) {
            return;
        }
        class_2338 pos = entity.method_11016();
        if (RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, facing = (class_2350)IBlock.getStatePropertySafe(state = world.method_8320(pos), BlockStationNameBase.field_11177))) {
            return;
        }
        boolean isTop = IBlock.getStatePropertySafe(state, HALF) == class_2756.field_12609;
        int arrowDirection = (Integer)IBlock.getStatePropertySafe(state, BlockRouteSignBase.ARROW_DIRECTION);
        Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
        if (station == null) {
            return;
        }
        Map<Long, Platform> platformPositions = ClientData.DATA_CACHE.requestStationIdToPlatforms(station.id);
        if (platformPositions == null || platformPositions.isEmpty()) {
            return;
        }
        Platform platform = platformPositions.get(((BlockRouteSignBase.TileEntityRouteSignBase)((Object)entity)).getPlatformId());
        if (platform == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904(0.5, 0.0, 0.5);
        UtilitiesClient.rotateYDegrees(matrices, -facing.method_10144());
        matrices.method_22904(-0.5, 0.0, 0.43124999990686774);
        class_4588 vertexConsumer1 = vertexConsumers.getBuffer(MoreRenderLayers.getExterior(ClientData.DATA_CACHE.getDirectionArrow((long)platform.id, (boolean)((arrowDirection & 1) > 0 ? true : false), (boolean)((arrowDirection & 2) > 0 ? true : false), (IGui.HorizontalAlignment)IGui.HorizontalAlignment.CENTER, (boolean)true, (float)0.2f, (float)4.4f, (int)-16777216, (int)-1, (int)0).resourceLocation));
        IDrawing.drawTexture(matrices, vertexConsumer1, 0.84375f, 0.96875f + (float)(!isTop ? 1 : 0), 0.0f, 0.15625f, 0.8125f + (float)(!isTop ? 1 : 0), 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facing.method_10153(), -1, light);
        class_4588 vertexConsumer2 = vertexConsumers.getBuffer(MoreRenderLayers.getExterior(ClientData.DATA_CACHE.getRouteMap((long)platform.id, (boolean)true, (boolean)false, (float)1.6818181f, (boolean)false).resourceLocation));
        IDrawing.drawTexture(matrices, vertexConsumer2, 0.84375f, 0.8125f + (float)(!isTop ? 1 : 0), 0.0f, 0.84375f, isTop ? 0.0f : 0.65625f, 0.0f, 0.15625f, isTop ? 0.0f : 0.65625f, 0.0f, 0.15625f, 0.8125f + (float)(!isTop ? 1 : 0), 0.0f, 0.0f, 0.0f, isTop ? 0.7027027f : 1.0f, 1.0f, facing.method_10153(), -1, light);
        matrices.method_22909();
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }
}

