/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import java.util.HashMap;
import java.util.Map;
import mtr.block.BlockNode;
import mtr.block.BlockSignalLightBase;
import mtr.block.BlockSignalSemaphoreBase;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.data.IGui;
import mtr.data.Rail;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.UtilitiesClient;
import mtr.path.PathData;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public abstract class RenderSignalBase<T extends BlockEntityMapper>
extends BlockEntityRendererMapper<T>
implements IBlock,
IGui {
    protected final boolean isSingleSided;
    protected final int aspects;

    public RenderSignalBase(class_824 dispatcher, boolean isSingleSided, int aspects) {
        super(dispatcher);
        this.isSingleSided = isSingleSided;
        this.aspects = aspects;
    }

    @Deprecated
    public RenderSignalBase(class_824 dispatcher, boolean isSingleSided) {
        this(dispatcher, isSingleSided, 2);
    }

    public final void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 world = entity.method_10997();
        if (world == null) {
            return;
        }
        class_2338 pos = entity.method_11016();
        class_2680 state = world.method_8320(pos);
        if (!(state.method_26204() instanceof BlockSignalLightBase) && !(state.method_26204() instanceof BlockSignalSemaphoreBase)) {
            return;
        }
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe(state, class_2383.field_11177);
        if (RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, null)) {
            return;
        }
        class_2338 startPos = RenderSignalBase.getNodePos((class_1922)world, pos, facing);
        if (startPos == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904(0.5, 0.0, 0.5);
        for (int i = 0; i < 2; ++i) {
            class_2350 newFacing = i == 1 ? facing.method_10153() : facing;
            int occupiedAspect = this.getOccupiedAspect(startPos, newFacing.method_10144() + 90.0f);
            if (occupiedAspect >= 0) {
                matrices.method_22903();
                UtilitiesClient.rotateYDegrees(matrices, -newFacing.method_10144());
                class_4588 vertexConsumer = vertexConsumers.getBuffer(MoreRenderLayers.getLight(new class_2960("mtr:textures/block/white.png"), false));
                this.render(matrices, vertexConsumers, vertexConsumer, entity, tickDelta, newFacing, occupiedAspect, i == 1);
                this.render(matrices, vertexConsumers, vertexConsumer, entity, tickDelta, newFacing, occupiedAspect == 1, i == 1);
                matrices.method_22909();
            }
            if (this.isSingleSided) break;
        }
        matrices.method_22909();
    }

    protected void render(class_4587 matrices, class_4597 vertexConsumers, class_4588 vertexConsumer, T entity, float tickDelta, class_2350 facing, int occupiedAspect, boolean isBackSide) {
    }

    protected void render(class_4587 matrices, class_4597 vertexConsumers, class_4588 vertexConsumer, T entity, float tickDelta, class_2350 facing, boolean isOccupied, boolean isBackSide) {
    }

    private int getOccupiedAspect(class_2338 startPos, float facing) {
        HashMap<class_2338, Float> nodesToScan = new HashMap<class_2338, Float>();
        nodesToScan.put(startPos, Float.valueOf(facing));
        int occupiedAspect = -1;
        for (int j = 1; j < this.aspects; ++j) {
            HashMap<class_2338, Float> newNodesToScan = new HashMap<class_2338, Float>();
            for (Map.Entry checkNode : nodesToScan.entrySet()) {
                Map<class_2338, Rail> railMap = ClientData.RAILS.get(checkNode.getKey());
                if (railMap == null) continue;
                for (class_2338 endPos : railMap.keySet()) {
                    Rail rail = railMap.get(endPos);
                    if (!rail.facingStart.similarFacing(((Float)checkNode.getValue()).floatValue())) continue;
                    if (ClientData.SIGNAL_BLOCKS.isOccupied(PathData.getRailProduct((class_2338)checkNode.getKey(), endPos))) {
                        return j;
                    }
                    Boolean isOccupied = ClientData.OCCUPIED_RAILS.get(PathData.getRailProduct((class_2338)checkNode.getKey(), endPos));
                    if (isOccupied != null && isOccupied.booleanValue()) {
                        return j;
                    }
                    newNodesToScan.put(endPos, Float.valueOf(rail.facingEnd.getOpposite().angleDegrees));
                    occupiedAspect = 0;
                }
            }
            nodesToScan = newNodesToScan;
        }
        return occupiedAspect;
    }

    private static class_2338 getNodePos(class_1922 world, class_2338 pos, class_2350 facing) {
        int[] checkDistance;
        for (int z : checkDistance = new int[]{0, 1, -1, 2, -2, 3, -3, 4, -4}) {
            for (int x : checkDistance) {
                for (int y = -5; y <= 0; ++y) {
                    class_2338 checkPos = pos.method_10086(y).method_10079(facing.method_10170(), x).method_10079(facing, z);
                    class_2680 checkState = world.method_8320(checkPos);
                    if (!(checkState.method_26204() instanceof BlockNode)) continue;
                    return checkPos;
                }
            }
        }
        return null;
    }
}

