/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import mtr.block.BlockStationNameBase;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderRouteBase;
import mtr.render.StoredMatrixTransformations;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public abstract class RenderStationNameBase<T extends BlockStationNameBase.TileEntityStationNameBase>
extends BlockEntityRendererMapper<T>
implements IGui,
IDrawing {
    public RenderStationNameBase(class_824 dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 world = entity.method_10997();
        if (world == null) {
            return;
        }
        class_2338 pos = entity.method_11016();
        class_2680 state = world.method_8320(pos);
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe(state, BlockStationNameBase.field_11177);
        int color = RenderRouteBase.getShadingColor(facing, ((BlockStationNameBase.TileEntityStationNameBase)entity).getColor(state));
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations();
        storedMatrixTransformations.add(matricesNew -> {
            matricesNew.method_22904(0.5 + (double)entity.method_11016().method_10263(), 0.5 + (double)entity.yOffset + (double)entity.method_11016().method_10264(), 0.5 + (double)entity.method_11016().method_10260());
            UtilitiesClient.rotateYDegrees(matricesNew, -facing.method_10144());
            UtilitiesClient.rotateZDegrees(matricesNew, 180.0f);
        });
        Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
        for (int i = 0; i < (((BlockStationNameBase.TileEntityStationNameBase)entity).isDoubleSided ? 2 : 1); ++i) {
            StoredMatrixTransformations storedMatrixTransformations2 = storedMatrixTransformations.copy();
            boolean shouldFlip = i == 1;
            storedMatrixTransformations2.add(matricesNew -> {
                if (shouldFlip) {
                    UtilitiesClient.rotateYDegrees(matricesNew, 180.0f);
                }
                matricesNew.method_22904(0.0, 0.0, 0.5 - (double)entity.zOffset - (double)0.003125f);
            });
            this.drawStationName((class_1922)world, pos, state, facing, storedMatrixTransformations2, vertexConsumers, station == null ? Text.translatable("gui.mtr.untitled", new Object[0]).getString() : station.name, station == null ? 0 : station.color, color, light);
        }
    }

    protected abstract void drawStationName(class_1922 var1, class_2338 var2, class_2680 var3, class_2350 var4, StoredMatrixTransformations var5, class_4597 var6, String var7, int var8, int var9, int var10);
}

