/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import mtr.block.BlockStationNameBase;
import mtr.block.BlockStationNameEntrance;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.render.RenderStationNameBase;
import mtr.render.RenderTrains;
import mtr.render.StoredMatrixTransformations;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public class RenderStationNameTiled<T extends BlockStationNameBase.TileEntityStationNameBase>
extends RenderStationNameBase<T> {
    private final boolean showLogo;

    public RenderStationNameTiled(class_824 dispatcher, boolean showLogo) {
        super(dispatcher);
        this.showLogo = showLogo;
    }

    @Override
    protected void drawStationName(class_1922 world, class_2338 pos, class_2680 state, class_2350 facing, StoredMatrixTransformations storedMatrixTransformations, class_4597 vertexConsumers, String stationName, int stationColor, int color, int light) {
        int lengthLeft = this.getLength(world, pos, false);
        int lengthRight = this.getLength(world, pos, true);
        int totalLength = lengthLeft + lengthRight - 1;
        if (this.showLogo) {
            int propagateProperty = (Integer)IBlock.getStatePropertySafe(world, pos, BlockStationNameEntrance.STYLE);
            float logoSize = propagateProperty % 2 == 0 ? 0.5f : 1.0f;
            RenderTrains.scheduleRender(ClientData.DATA_CACHE.getStationNameEntrance((int)(propagateProperty < 2 || propagateProperty >= 4 ? -1 : -16777216), (String)IGui.insertTranslation((String)"gui.mtr.station_cjk", (String)"gui.mtr.station", (int)1, (String[])new String[]{stationName}), (float)((float)totalLength / logoSize)).resourceLocation, false, RenderTrains.QueuedRenderLayer.INTERIOR, (matrices, vertexConsumer) -> {
                storedMatrixTransformations.transform((class_4587)matrices);
                IDrawing.drawTexture(matrices, vertexConsumer, -0.5f, -logoSize / 2.0f, 1.0f, logoSize, (float)(lengthLeft - 1) / (float)totalLength, 0.0f, (float)lengthLeft / (float)totalLength, 1.0f, facing, color, light);
                matrices.method_22909();
            });
        } else {
            RenderTrains.scheduleRender(ClientData.DATA_CACHE.getStationName((String)stationName, (float)((float)totalLength)).resourceLocation, false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matrices, vertexConsumer) -> {
                storedMatrixTransformations.transform((class_4587)matrices);
                IDrawing.drawTexture(matrices, vertexConsumer, -0.5f, -0.5f, 1.0f, 1.0f, (float)(lengthLeft - 1) / (float)totalLength, 0.0f, (float)lengthLeft / (float)totalLength, 1.0f, facing, color, light);
                matrices.method_22909();
            });
        }
    }

    private int getLength(class_1922 world, class_2338 pos, boolean lookRight) {
        class_2248 checkBlock;
        if (world == null) {
            return 1;
        }
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe(world, pos, BlockStationNameBase.field_11177);
        class_2248 thisBlock = world.method_8320(pos).method_26204();
        int length = 1;
        while ((checkBlock = world.method_8320(pos.method_10079(lookRight ? facing.method_10170() : facing.method_10160(), length)).method_26204()) instanceof BlockStationNameBase && checkBlock == thisBlock) {
            ++length;
        }
        return length;
    }
}

